<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

$wisemove_sidebar_position = wisemove_get_theme_option('sidebar_position');
if (wisemove_sidebar_present()) {
	ob_start();
	$wisemove_sidebar_name = wisemove_get_theme_option('sidebar_widgets');
	wisemove_storage_set('current_sidebar', 'sidebar');
    if ( is_active_sidebar( $wisemove_sidebar_name ) ) {
        dynamic_sidebar( $wisemove_sidebar_name );
    }
	$wisemove_out = trim(ob_get_contents());
	ob_end_clean();
	if (trim(strip_tags($wisemove_out)) != '') {
		?>
		<div class="sidebar <?php echo esc_attr($wisemove_sidebar_position); ?> widget_area<?php if (!wisemove_is_inherit(wisemove_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(wisemove_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'wisemove_action_before_sidebar' );
				wisemove_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $wisemove_out));
				do_action( 'wisemove_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>