<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('wisemove_mailchimp_theme_setup9')) {
	add_action( 'after_setup_theme', 'wisemove_mailchimp_theme_setup9', 9 );
	function wisemove_mailchimp_theme_setup9() {
		if (wisemove_exists_mailchimp()) {
			add_action( 'wp_enqueue_scripts',							'wisemove_mailchimp_frontend_scripts', 1100 );
			add_filter( 'wisemove_filter_merge_styles',					'wisemove_mailchimp_merge_styles');
			add_filter( 'wisemove_filter_get_css',						'wisemove_mailchimp_get_css', 10, 4);
		}
		if (is_admin()) {
			add_filter( 'wisemove_filter_tgmpa_required_plugins',		'wisemove_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'wisemove_exists_mailchimp' ) ) {
	function wisemove_exists_mailchimp() {
		return function_exists('__mc4wp_load_plugin') || defined('MC4WP_VERSION');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'wisemove_mailchimp_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('wisemove_filter_tgmpa_required_plugins',	'wisemove_mailchimp_tgmpa_required_plugins');
	function wisemove_mailchimp_tgmpa_required_plugins($list=array()) {
		if (in_array('mailchimp-for-wp', wisemove_storage_get('required_plugins')))
			$list[] = array(
				'name' 		=> esc_html__('MailChimp for WP', 'wisemove'),
				'slug' 		=> 'mailchimp-for-wp',
				'required' 	=> false
			);
		return $list;
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue custom styles
if ( !function_exists( 'wisemove_mailchimp_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'wisemove_mailchimp_frontend_scripts', 1100 );
	function wisemove_mailchimp_frontend_scripts() {
		if (wisemove_exists_mailchimp()) {
			if (wisemove_is_on(wisemove_get_theme_option('debug_mode')) && file_exists(wisemove_get_file_dir('plugins/mailchimp-for-wp/mailchimp-for-wp.css')))
				wp_enqueue_style( 'wisemove-mailchimp-for-wp',  wisemove_get_file_url('plugins/mailchimp-for-wp/mailchimp-for-wp.css'), array(), null );
		}
	}
}
	
// Merge custom styles
if ( !function_exists( 'wisemove_mailchimp_merge_styles' ) ) {
	//Handler of the add_filter( 'wisemove_filter_merge_styles', 'wisemove_mailchimp_merge_styles');
	function wisemove_mailchimp_merge_styles($list) {
		$list[] = 'plugins/mailchimp-for-wp/mailchimp-for-wp.css';
		return $list;
	}
}

// Add css styles into global CSS stylesheet
if (!function_exists('wisemove_mailchimp_get_css')) {
	//Handler of the add_filter('wisemove_filter_get_css', 'wisemove_mailchimp_get_css', 10, 4);
	function wisemove_mailchimp_get_css($css, $colors, $fonts, $scheme='') {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

CSS;
		}
		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

.mc4wp-form input[type="email"] {
	background-color: {$colors['alter_bg_hover']};
	border-color: {$colors['alter_bg_hover']};
	color: {$colors['bg_color']};
}
.mc4wp-form input[type="submit"] {
	background-color: {$colors['text_hover']};
	color: {$colors['inverse_text']};
}
.mc4wp-form input[type="submit"]:hover {
	background-color: {$colors['inverse_text']};
	color: {$colors['text_hover']};
}

.mc4wp-form .terms_agree_checkbox{
	color: {$colors['text_dark']};
}


.mc4wp-form input[type="email"]::-webkit-input-placeholder{color: {$colors['text']};};
.mc4wp-form input[type="email"]::-moz-placeholder{color: {$colors['text']};};
.mc4wp-form input[type="email"]:-moz-placeholder{color: {$colors['text']};};
.mc4wp-form input[type="email"]:-ms-input-placeholder{color: {$colors['text']};};



CSS;
		}

		return $css;
	}
}
?>