<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

$wisemove_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$wisemove_post_format = get_post_format();
$wisemove_post_format = empty($wisemove_post_format) ? 'standard' : str_replace('post-format-', '', $wisemove_post_format);
$wisemove_animation = wisemove_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($wisemove_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($wisemove_post_format) ); ?>
	<?php echo (!wisemove_is_off($wisemove_animation) ? ' data-animation="'.esc_attr(wisemove_get_animation_classes($wisemove_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	wisemove_show_post_featured(array(
		'thumb_size' => wisemove_get_thumb_size($wisemove_columns==1 ? 'big' : ($wisemove_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($wisemove_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			wisemove_show_post_meta();
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>