<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

$wisemove_blog_style = explode('_', wisemove_get_theme_option('blog_style'));
$wisemove_columns = empty($wisemove_blog_style[1]) ? 2 : max(2, $wisemove_blog_style[1]);
$wisemove_post_format = get_post_format();
$wisemove_post_format = empty($wisemove_post_format) ? 'standard' : str_replace('post-format-', '', $wisemove_post_format);
$wisemove_animation = wisemove_get_theme_option('blog_animation');
$wisemove_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($wisemove_columns).' post_format_'.esc_attr($wisemove_post_format) ); ?>
	<?php echo (!wisemove_is_off($wisemove_animation) ? ' data-animation="'.esc_attr(wisemove_get_animation_classes($wisemove_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($wisemove_image[1]) && !empty($wisemove_image[2])) echo intval($wisemove_image[1]) .'x' . intval($wisemove_image[2]); ?>"
	data-src="<?php if (!empty($wisemove_image[0])) echo esc_url($wisemove_image[0]); ?>"
	>

	<?php
	$wisemove_image_hover = 'icon';
	if (in_array($wisemove_image_hover, array('icons', 'zoom'))) $wisemove_image_hover = 'dots';
	// Featured image
	wisemove_show_post_featured(array(
		'hover' => $wisemove_image_hover,
		'thumb_size' => wisemove_get_thumb_size( strpos(wisemove_get_theme_option('body_style'), 'full')!==false || $wisemove_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. wisemove_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => false,
									'seo' => false,
									'share' => true,
									'counters' => 'comments',
									'echo' => false
									))
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'wisemove') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>