<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

$wisemove_blog_style = explode('_', wisemove_get_theme_option('blog_style'));
$wisemove_columns = empty($wisemove_blog_style[1]) ? 2 : max(2, $wisemove_blog_style[1]);
$wisemove_expanded = !wisemove_sidebar_present() && wisemove_is_on(wisemove_get_theme_option('expand_content'));
$wisemove_post_format = get_post_format();
$wisemove_post_format = empty($wisemove_post_format) ? 'standard' : str_replace('post-format-', '', $wisemove_post_format);
$wisemove_animation = wisemove_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($wisemove_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_classic post_layout_classic_'.esc_attr($wisemove_columns).' post_format_'.esc_attr($wisemove_post_format) ); ?>
	<?php echo (!wisemove_is_off($wisemove_animation) ? ' data-animation="'.esc_attr(wisemove_get_animation_classes($wisemove_animation)).'"' : ''); ?>
	>

	<?php

	// Featured image
	wisemove_show_post_featured( array( 'thumb_size' => wisemove_get_thumb_size(
													strpos(wisemove_get_theme_option('body_style'), 'full')!==false 
														? ( $wisemove_columns > 2 ? 'big' : 'huge' )
														: (	$wisemove_columns > 2
															? ($wisemove_expanded ? 'med' : 'small')
															: ($wisemove_expanded ? 'big' : 'med')
															)
														)
										) );

	if ( !in_array($wisemove_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('wisemove_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('wisemove_action_before_post_meta'); 

			// Post meta
			wisemove_show_post_meta(array(
				'categories' => true,
				'date' => true,
				'edit' => $wisemove_columns < 3,
				'seo' => false,
				'share' => false,
				'counters' => '',
				)
			);
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$wisemove_show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($wisemove_post_format, array('link', 'aside', 'status', 'quote'))) {
				the_content();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($wisemove_post_format, array('link', 'aside', 'status', 'quote'))) {
			wisemove_show_post_meta(array(
				'share' => false,
				'counters' => 'comments'
				)
			);
		}
		// More button
		if ( $wisemove_show_learn_more ) {
            ?><p><a class="more-link sc_button" data-text="<?php esc_html_e('Read more', 'wisemove'); ?>" href="<?php echo esc_url(get_permalink()); ?>"><span> <?php esc_html_e('Read more', 'wisemove'); ?></span></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>