<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

$wisemove_blog_style = explode('_', wisemove_get_theme_option('blog_style'));
$wisemove_columns = empty($wisemove_blog_style[1]) ? 1 : max(1, $wisemove_blog_style[1]);
$wisemove_expanded = !wisemove_sidebar_present() && wisemove_is_on(wisemove_get_theme_option('expand_content'));
$wisemove_post_format = get_post_format();
$wisemove_post_format = empty($wisemove_post_format) ? 'standard' : str_replace('post-format-', '', $wisemove_post_format);
$wisemove_animation = wisemove_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($wisemove_columns).' post_format_'.esc_attr($wisemove_post_format) ); ?>
	<?php echo (!wisemove_is_off($wisemove_animation) ? ' data-animation="'.esc_attr(wisemove_get_animation_classes($wisemove_animation)).'"' : ''); ?>
	>

	<?php
	// Add anchor
	if ($wisemove_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.esc_attr(get_the_title()).'"]');
	}

	// Featured image
	wisemove_show_post_featured( array(
											'class' => $wisemove_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => wisemove_get_thumb_size(
																	strpos(wisemove_get_theme_option('body_style'), 'full')!==false
																		? ( $wisemove_columns > 1 ? 'huge' : 'original' )
																		: (	$wisemove_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('wisemove_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('wisemove_action_before_post_meta'); 

			// Post meta
			$wisemove_post_meta = wisemove_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => $wisemove_columns == 1,
									'seo' => false,
									'share' => false,
									'counters' => $wisemove_columns < 3 ? '' : '',
									'echo' => false
									)
								);
			wisemove_show_layout($wisemove_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$wisemove_show_learn_more = !in_array($wisemove_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($wisemove_post_format, array('link', 'aside', 'status', 'quote'))) {
					the_content();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($wisemove_post_format, array('link', 'aside', 'status', 'quote'))) {
				wisemove_show_layout($wisemove_post_meta);
			}
			// More button
			if ( $wisemove_show_learn_more ) {
                ?><p><a class="more-link sc_button" data-text="<?php esc_html_e('Read more', 'wisemove'); ?>" href="<?php echo esc_url(get_permalink()); ?>"><span> <?php esc_html_e('Read more', 'wisemove'); ?></span></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>