<?php
/**
 * Default Theme Options and Internal Theme Settings
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

// -----------------------------------------------------------------
// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
// -- Internal theme settings
// -----------------------------------------------------------------
wisemove_storage_set('settings', array(
	
	'custom_sidebars'			=> 8,							// How many custom sidebars will be registered (in addition to theme preset sidebars): 0 - 10

	'ajax_views_counter'		=> true,						// Use AJAX for increment posts counter (if cache plugins used) 
																// or increment posts counter then loading page (without cache plugin)
	'disable_jquery_ui'			=> false,						// Prevent loading custom jQuery UI libraries in the third-party plugins

	'max_load_fonts'			=> 3,							// Max fonts number to load from Google fonts or from uploaded fonts

	'use_mediaelements'			=> true,						// Load script "Media Elements" to play video and audio

	'max_excerpt_length'		=> 40,							// Max words number for the excerpt in the blog style 'Excerpt'.
																// For style 'Classic' - get half from this value
	'message_maxlength'			=> 1000							// Max length of the message from contact form
	
));



// -----------------------------------------------------------------
// -- Theme fonts (Google and/or custom fonts)
// -----------------------------------------------------------------

// Fonts to load when theme start
// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
// For example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
wisemove_storage_set('load_fonts', array(
	// Font-face packed with theme
	array(
		'name'   => 'Metropolis',
		'family' => 'sans-serif'
		)
));

// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
wisemove_storage_set('load_fonts_subset', 'latin,latin-ext');

// Settings of the main tags
wisemove_storage_set('theme_fonts', array(
	'p' => array(
		'title'				=> esc_html__('Main text', 'wisemove'),
		'description'		=> esc_html__('Font settings of the main text of the site', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '1rem',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.6957em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0.3px',
		'margin-top'		=> '0em',
		'margin-bottom'		=> '1.4em'
		),
	'h1' => array(
		'title'				=> esc_html__('Heading 1', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '4.0625rem',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.2em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-1.5px',
		'margin-top'		=> '0.93em',
		'margin-bottom'		=> '0.54em'
		),
	'h2' => array(
		'title'				=> esc_html__('Heading 2', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '3.4375rem',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.175em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-1px',
		'margin-top'		=> '1.464em',
		'margin-bottom'		=> '0.77em'
		),
	'h3' => array(
		'title'				=> esc_html__('Heading 3', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '2.5em',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.2em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-1px',
		'margin-top'		=> '2.047em',
		'margin-bottom'		=> '0.859em'
		),
	'h4' => array(
		'title'				=> esc_html__('Heading 4', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '2em',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.2em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.5px',
		'margin-top'		=> '1.4em',
		'margin-bottom'		=> '0.78em'
		),
	'h5' => array(
		'title'				=> esc_html__('Heading 5', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '1.1875em',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.4em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0px',
		'margin-top'		=> '2.45em',
		'margin-bottom'		=> '1.4em'
		),
	'h6' => array(
		'title'				=> esc_html__('Heading 6', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '1.0625em',
		'font-weight'		=> '600',
		'font-style'		=> 'normal',
		'line-height'		=> '1.55em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.3px',
		'margin-top'		=> '2.7059em',
		'margin-bottom'		=> '1em'
		),
	'logo' => array(
		'title'				=> esc_html__('Logo text', 'wisemove'),
		'description'		=> esc_html__('Font settings of the text case of the logo', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '1.8em',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.25em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'uppercase',
		'letter-spacing'	=> '1px'
		),
	'button' => array(
		'title'				=> esc_html__('Buttons', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '12px',
		'font-weight'		=> '300',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'uppercase',
		'letter-spacing'	=> '0.5px'
		),
	'input' => array(
		'title'				=> esc_html__('Input fields', 'wisemove'),
		'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '1em',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.2em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> ''
		),
	'info' => array(
		'title'				=> esc_html__('Post meta', 'wisemove'),
		'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '16px',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '',
		'margin-top'		=> '1.85em',
		'margin-bottom'		=> ''
		),
	'menu' => array(
		'title'				=> esc_html__('Main menu', 'wisemove'),
		'description'		=> esc_html__('Font settings of the main menu items', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '16px',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0px'
		),
	'submenu' => array(
		'title'				=> esc_html__('Dropdown menu', 'wisemove'),
		'description'		=> esc_html__('Font settings of the dropdown menu items', 'wisemove'),
		'font-family'		=> '"Metropolis", sans-serif',
		'font-size' 		=> '16px',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '0.95em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0px'
		)
));


// -----------------------------------------------------------------
// -- Theme colors for customizer
// -- Attention! Inner scheme must be last in the array below
// -----------------------------------------------------------------
wisemove_storage_set('schemes', array(

	// Color scheme: 'default'
	'default' => array(
		'title'	 => esc_html__('Default', 'wisemove'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#ffffff',//+
			'bd_color'				=> '#e7e6e3',//+

			// Text and links colors
			'text'					=> '#737170',//+
			'text_light'			=> '#d7d3cd',//+
			'text_dark'				=> '#44413e',//+
			'text_link'				=> '#44413e',//+
			'text_hover'			=> '#fb6a05',//+

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#fafaf9',//+
			'alter_bg_hover'		=> '#f5f4f3',//+
			'alter_bd_color'		=> '#d7d3cd',//+
			'alter_bd_hover'		=> '#e6e3e0',//+
			'alter_text'			=> '#ebeede',//+
			'alter_light'			=> '#a4a4a4',//+
			'alter_dark'			=> '#55524f',//+
			'alter_link'			=> '#ff6469',
			'alter_hover'			=> '#33a1e3',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#f1f5f8',
			'input_bg_hover'		=> '#f1f5f8',
			'input_bd_color'		=> '#f1f5f8',
			'input_bd_hover'		=> '#e5ecf1',
			'input_text'			=> '#bac0c3',
			'input_light'			=> '#bac0c3',
			'input_dark'			=> '#1e1d22',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#ffffff',//+
			'inverse_light'			=> '#a5a29f',//+
			'inverse_dark'			=> '#4d4c4b',//+
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#3d3a38',

            'accent2'				=> '#97b628'
		
		)
	),

	// Color scheme: 'dark'
	'dark' => array(
		'title'  => esc_html__('Dark', 'wisemove'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#000000',//+
			'bd_color'				=> '#4d4c4b',//+

			// Text and links colors
			'text'					=> '#a5a29f',//+
			'text_light'			=> '#827f7c',//+
			'text_dark'				=> '#ffffff',//+
			'text_link'				=> '#ffffff',//+
			'text_hover'			=> '#fb6a05',//+

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#272423',//+
			'alter_bg_hover'		=> '#f5f4f3',//+
			'alter_bd_color'		=> '#d7d3cd',//+
			'alter_bd_hover'		=> '#1f254d',
			'alter_text'			=> '#a5a29f',//+
			'alter_light'			=> '#b3b0ad',//+
			'alter_dark'			=> '#44413e',//+
			'alter_link'			=> '#faef81',
			'alter_hover'			=> '#33a1e3',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#7e9724',//+
			'input_bg_hover'		=> '#4e5e13',//+
			'input_bd_color'		=> '#788f22',//+
			'input_bd_hover'		=> '#181e3d',
			'input_text'			=> '#969fa6',
			'input_light'			=> '#ffffff',//+
			'input_dark'			=> '#ffffff',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#ffffff',//+
			'inverse_light'			=> '#bac0c3',
			'inverse_dark'			=> '#3d3a38',
			'inverse_link'			=> '#000000',//+
			'inverse_hover'			=> '#55524f',//+

            'accent2'				=> '#97b628'
		)
	)

));



// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('wisemove_options_create')) {

	function wisemove_options_create() {

		wisemove_storage_set('options', array(
		
			// Section 'Title & Tagline' - add theme options in the standard WP section
			'title_tagline' => array(
				"title" => esc_html__('Title, Tagline & Site icon', 'wisemove'),
				"desc" => wp_kses_data( __('Specify site title and tagline (if need) and upload the site icon', 'wisemove') ),
				"type" => "section"
				),
		
		
			// Section 'Header' - add theme options in the standard WP section
			'header_image' => array(
				"title" => esc_html__('Header', 'wisemove'),
				"desc" => wp_kses_data( __('Select or upload logo images, select header type and widgets set for the header', 'wisemove') ),
				"type" => "section"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'wisemove'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'wisemove') ),
				"override" => array(
					'mode' => 'page, cpt_services',
					'section' => esc_html__('Header', 'wisemove')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_video' => array(
				"title" => esc_html__('Header video', 'wisemove'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'wisemove') ),
				"override" => array(
					'mode' => 'page, cpt_services',
					'section' => esc_html__('Header', 'wisemove')
				),
				"std" => '',
				"type" => "video"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Fullheight Header', 'wisemove'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'wisemove') ),
				"override" => array(
					'mode' => 'page, cpt_services',
					'section' => esc_html__('Header', 'wisemove')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_style' => array(
				"title" => esc_html__('Header style', 'wisemove'),
				"desc" => wp_kses_data( __('Select style to display the site header', 'wisemove') ),
				"override" => array(
					'mode' => 'page, cpt_services',
					'section' => esc_html__('Header', 'wisemove')
				),
				"std" => 'header-default',
				"options" => apply_filters('wisemove_filter_list_header_styles', array(
					'header-default' => esc_html__('Default Header',	'wisemove')
				)),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'wisemove'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'wisemove') ),
				"override" => array(
					'mode' => 'page, cpt_services',
					'section' => esc_html__('Header', 'wisemove')
				),
				"std" => 'default',
				"options" => array(
					'default' => esc_html__('Default','wisemove'),
					'over' => esc_html__('Over',	'wisemove'),
					'under' => esc_html__('Under',	'wisemove')
				),
				"type" => "select"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'wisemove'),
				"desc" => wp_kses_data( __('Select color scheme to decorate header area', 'wisemove') ),
				"override" => array(
					'mode' => 'page, cpt_services',
					'section' => esc_html__('Header', 'wisemove')
				),
				"std" => 'inherit',
				"options" => wisemove_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'wisemove'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'wisemove') ),
				"override" => array(
					'mode' => 'page, cpt_services',
					'section' => esc_html__('Header', 'wisemove')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'wisemove'),
					'left'	=> esc_html__('Left',	'wisemove'),
					'right'	=> esc_html__('Right',	'wisemove')
				),
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Menu Color Scheme', 'wisemove'),
				"desc" => wp_kses_data( __('Select color scheme to decorate main menu area', 'wisemove') ),
				"override" => array(
					'mode' => 'page, cpt_services',
					'section' => esc_html__('Header', 'wisemove')
				),
				"std" => 'inherit',
				"options" => wisemove_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'wisemove'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'wisemove') ),
				"std" => 1,
				"type" => "checkbox"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'wisemove'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'wisemove'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'wisemove') ),
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'wisemove'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'wisemove')
				),
				"dependency" => array(
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => wisemove_get_list_range(0,6),
				"type" => "select"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'wisemove'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'wisemove')
				),
				"std" => 1,
				"type" => "checkbox"
				),
            'header_full_width' => array(
                "title" => esc_html__('Header in content', 'wisemove'),
                "desc" => wp_kses_data( __('Do you want header in content?', 'wisemove') ),
                "std" => 1,
                "type" => "checkbox"
            ),
			'logo' => array(
				"title" => esc_html__('Logo', 'wisemove'),
				"desc" => wp_kses_data( __('Select or upload site logo', 'wisemove') ),
				"std" => '',
				"type" => "image"
				),
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'wisemove'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'wisemove') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse' => array(
				"title" => esc_html__('Logo inverse', 'wisemove'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it on the dark background', 'wisemove') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse_retina' => array(
				"title" => esc_html__('Logo inverse for Retina', 'wisemove'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'wisemove') ),
				"std" => '',
				"type" => "image"
				),
			'logo_text' => array(
				"title" => esc_html__('Logo from Site name', 'wisemove'),
				"desc" => wp_kses_data( __('Do you want use Site name and description as Logo if images above are not selected?', 'wisemove') ),
				"std" => 1,
				"type" => "checkbox"
				),
            'header_title_image' => array(
                "title" => esc_html__('Header title image', 'wisemove'),
                "desc" => wp_kses_data( __('Select image to insert into the Header title', 'wisemove') ),
                "std" => '',
                "override" => array(
                    'mode' => 'page',
                    'section' => esc_html__('Header', 'wisemove')
                ),
                "type" => "image"
            ),
            'show_page_title' => array(
                "title" => esc_html__('Show Page Title', 'wisemove'),
                "desc" => wp_kses_data( __('Do you want to show page title area (page/post/category title and breadcrumbs)?', 'wisemove') ),
                "override" => array(
                    'mode' => 'page',
                    'section' => esc_html__('Header', 'wisemove')
                ),
                "std" => 1,
                "type" => "checkbox"
            ),
            'header_title_text' => array(
                "title" => esc_html__('Header title text', 'wisemove'),
                "desc" => wp_kses_data( __('Put here text to insert into the Header', 'wisemove') ),
                "std" => '',
                "type" => "textarea"
            ),
			
		
		
			// Section 'Content'
			'content' => array(
				"title" => esc_html__('Content', 'wisemove'),
				"desc" => wp_kses_data( __('Options for the content area', 'wisemove') ),
				"type" => "section",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'wisemove'),
				"desc" => wp_kses_data( __('Select width of the body content', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => array(
					'boxed'		=> esc_html__('Boxed',		'wisemove'),
					'wide'		=> esc_html__('Wide',		'wisemove'),
					'fullwide'	=> esc_html__('Fullwide',	'wisemove'),
					'fullscreen'=> esc_html__('Fullscreen',	'wisemove')
				),
				"type" => "select"
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'wisemove'),
				"desc" => wp_kses_data( __('Select color scheme to decorate whole site. Attention! Case "Inherit" can be used only for custom pages, not for root site content in the Appearance - Customize', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"std" => 'default',
				"options" => wisemove_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'wisemove'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'wisemove') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'wisemove')
				),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'wisemove'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'wisemove') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'wisemove')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'wisemove'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'wisemove') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'privacy_text' => array(
				"title" => esc_html__("Text with Privacy Policy link", 'wisemove'),
				"desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'wisemove') ),
				"std"   => wp_kses_post( __( 'I agree that my submitted data is being collected and stored.', 'wisemove') ),
				"type"  => "text"
			),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'wisemove'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'wisemove') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"std" => '',
				"type" => "image"
				),
			'no_image' => array(
				"title" => esc_html__('No image placeholder', 'wisemove'),
				"desc" => wp_kses_data( __('Select or upload image, used as placeholder for the posts without featured image', 'wisemove') ),
				"std" => '',
				"type" => "image"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'wisemove'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'wisemove') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'wisemove')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Color Scheme', 'wisemove'),
				"desc" => wp_kses_data( __('Select color scheme to decorate sidebar', 'wisemove') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'wisemove')
				),
				"std" => 'side',
				"options" => wisemove_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'wisemove'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'wisemove') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'wisemove')
				),
				"refresh" => false,
				"std" => 'right',
				"options" => wisemove_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets above the page', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'wisemove')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'wisemove')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'wisemove')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets below the page', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'wisemove')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
		
		
		
			// Section 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'wisemove'),
				"desc" => wp_kses_data( __('Select set of widgets and columns number for the site footer', 'wisemove') ),
				"type" => "section"
				),
			'footer_style' => array(
				"title" => esc_html__('Footer style', 'wisemove'),
				"desc" => wp_kses_data( __('Select style to display the site footer', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Footer', 'wisemove')
				),
				"std" => 'footer-default',
				"options" => apply_filters('wisemove_filter_list_footer_styles', array(
					'footer-default' => esc_html__('Default Footer',	'wisemove')
				)),
				"type" => "select"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'wisemove'),
				"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'wisemove') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'wisemove')
				),
				"std" => 'dark',
				"options" => wisemove_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'wisemove'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'wisemove') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'wisemove')
				),
				"std" => 'footer_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'wisemove'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'wisemove') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'wisemove')
				),
				"dependency" => array(
					'footer_widgets' => array('^hide')
				),
				"std" => 3,
				"options" => wisemove_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwide', 'wisemove'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'wisemove') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'wisemove')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'wisemove'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'wisemove') ),
				'refresh' => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'wisemove'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'wisemove') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'wisemove'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'wisemove') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'wisemove'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'wisemove') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'wisemove'),
				"desc" => wp_kses_data( __('Copyright text in the footer', 'wisemove') ),
				"std" => esc_html__('ThemeREX &copy; {Y}. All rights reserved', 'wisemove'),
				"refresh" => false,
				"type" => "textarea"
				),
		
		
		
			// Section 'Homepage' - settings for home page
			'homepage' => array(
				"title" => esc_html__('Homepage', 'wisemove'),
				"desc" => wp_kses_data( __('Select blog style and widgets to display on the homepage', 'wisemove') ),
				"type" => "section"
				),
			'expand_content_home' => array(
				"title" => esc_html__('Expand content', 'wisemove'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the Homepage', 'wisemove') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style_home' => array(
				"title" => esc_html__('Blog style', 'wisemove'),
				"desc" => wp_kses_data( __('Select posts style for the homepage', 'wisemove') ),
				"std" => 'excerpt',
				"options" => wisemove_get_list_blog_styles(),
				"type" => "select"
				),
			'first_post_large_home' => array(
				"title" => esc_html__('First post large', 'wisemove'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of the Homepage', 'wisemove') ),
				"dependency" => array(
					'blog_style_home' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_widgets_home' => array(
				"title" => esc_html__('Header widgets', 'wisemove'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the homepage', 'wisemove') ),
				"std" => 'header_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_home' => array(
				"title" => esc_html__('Sidebar widgets', 'wisemove'),
				"desc" => wp_kses_data( __('Select sidebar to show on the homepage', 'wisemove') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_home' => array(
				"title" => esc_html__('Sidebar position', 'wisemove'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the homepage', 'wisemove') ),
				"refresh" => false,
				"std" => 'right',
				"options" => wisemove_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_home' => array(
				"title" => esc_html__('Widgets above the page', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'wisemove') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_home' => array(
				"title" => esc_html__('Widgets above the content', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'wisemove') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_home' => array(
				"title" => esc_html__('Widgets below the content', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'wisemove') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_home' => array(
				"title" => esc_html__('Widgets below the page', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'wisemove') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
			// Section 'Blog archive'
			'blog' => array(
				"title" => esc_html__('Blog archive', 'wisemove'),
				"desc" => wp_kses_data( __('Options for the blog archive', 'wisemove') ),
				"type" => "section",
				),
			'expand_content_blog' => array(
				"title" => esc_html__('Expand content', 'wisemove'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the blog archive', 'wisemove') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style' => array(
				"title" => esc_html__('Blog style', 'wisemove'),
				"desc" => wp_kses_data( __('Select posts style for the blog archive', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
                '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => 'excerpt',
				"options" => wisemove_get_list_blog_styles(),
				"type" => "select"
				),
			'blog_columns' => array(
				"title" => esc_html__('Blog columns', 'wisemove'),
				"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'wisemove') ),
				"std" => 2,
				"options" => wisemove_get_list_range(2,4),
				"type" => "hidden"
				),
			'post_type' => array(
				"title" => esc_html__('Post type', 'wisemove'),
				"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
            '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"linked" => 'parent_cat',
				"refresh" => false,
				"hidden" => true,
				"std" => 'post',
				"options" => wisemove_get_list_posts_types(),
				"type" => "select"
				),
			'parent_cat' => array(
				"title" => esc_html__('Category to show', 'wisemove'),
				"desc" => wp_kses_data( __('Select category to show in the blog archive', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
            '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"refresh" => false,
				"hidden" => true,
				"std" => '0',
				"options" => wisemove_array_merge(array(0 => esc_html__('- Select category -', 'wisemove')), wisemove_get_list_categories()),
				"type" => "select"
				),
			'posts_per_page' => array(
				"title" => esc_html__('Posts per page', 'wisemove'),
				"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
            '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"hidden" => true,
				"std" => '10',
				"type" => "text"
				),
			"blog_pagination" => array( 
				"title" => esc_html__('Pagination style', 'wisemove'),
				"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"std" => "pages",
				"options" => array(
					'pages'	=> esc_html__("Page numbers", 'wisemove'),
					'links'	=> esc_html__("Older/Newest", 'wisemove'),
					'more'	=> esc_html__("Load more", 'wisemove'),
					'infinite' => esc_html__("Infinite scroll", 'wisemove')
				),
				"type" => "select"
				),
			'show_filters' => array(
				"title" => esc_html__('Show filters', 'wisemove'),
				"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
                '.editor-page-attributes__template select' => array( 'blog.php' ),
					'blog_style' => array('portfolio', 'gallery')
				),
				"hidden" => true,
				"std" => 0,
				"type" => "checkbox"
				),
			'first_post_large' => array(
				"title" => esc_html__('First post large', 'wisemove'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of blog archive', 'wisemove') ),
				"dependency" => array(
					'blog_style' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			"blog_content" => array( 
				"title" => esc_html__('Posts content', 'wisemove'),
				"desc" => wp_kses_data( __("Show full post's content in the blog or only post's excerpt", 'wisemove') ),
				"std" => "excerpt",
				"options" => array(
					'excerpt'	=> esc_html__('Excerpt',	'wisemove'),
					'fullpost'	=> esc_html__('Full post',	'wisemove')
				),
				"type" => "select"
				),
			'time_diff_before' => array(
				"title" => esc_html__('Time difference', 'wisemove'),
				"desc" => wp_kses_data( __("How many days show time difference instead post's date", 'wisemove') ),
				"std" => 5,
				"type" => "text"
				),
			'related_posts' => array(
				"title" => esc_html__('Related posts', 'wisemove'),
				"desc" => wp_kses_data( __('How many related posts should be displayed in the single post?', 'wisemove') ),
				"std" => 2,
				"options" => wisemove_get_list_range(2,4),
				"type" => "select"
				),
			"blog_animation" => array( 
				"title" => esc_html__('Animation for the posts', 'wisemove'),
				"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'wisemove') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'wisemove')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
                '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => "none",
				"options" => wisemove_get_list_animations_in(),
				"type" => "select"
				),
			'header_widgets_blog' => array(
				"title" => esc_html__('Header widgets', 'wisemove'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the blog archive', 'wisemove') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_blog' => array(
				"title" => esc_html__('Sidebar widgets', 'wisemove'),
				"desc" => wp_kses_data( __('Select sidebar to show on the blog archive', 'wisemove') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_blog' => array(
				"title" => esc_html__('Sidebar position', 'wisemove'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the blog archive', 'wisemove') ),
				"refresh" => false,
				"std" => 'right',
				"options" => wisemove_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_blog' => array(
				"title" => esc_html__('Widgets above the page', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'wisemove') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_blog' => array(
				"title" => esc_html__('Widgets above the content', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'wisemove') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_blog' => array(
				"title" => esc_html__('Widgets below the content', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'wisemove') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_blog' => array(
				"title" => esc_html__('Widgets below the page', 'wisemove'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'wisemove') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'wisemove')), wisemove_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
		
			// Section 'Colors' - choose color scheme and customize separate colors from it
			'scheme' => array(
				"title" => esc_html__('* Color scheme editor', 'wisemove'),
				"desc" => wp_kses_data( __("<b>Simple settings</b> - you can change only accented color, used for links, buttons and some accented areas.", 'wisemove') )
						. '<br>'
						. wp_kses_data( __("<b>Advanced settings</b> - change all scheme's colors and get full control over the appearance of your site!", 'wisemove') ),
				"priority" => 1000,
				"type" => "section"
				),
		
			'color_settings' => array(
				"title" => esc_html__('Color settings', 'wisemove'),
				"desc" => '',
				"std" => 'simple',
				"options" => array(
					"simple"  => esc_html__("Simple", 'wisemove'),
					"advanced" => esc_html__("Advanced", 'wisemove')
				),
				"refresh" => false,
				"type" => "switch"
				),
		
			'color_scheme_editor' => array(
				"title" => esc_html__('Color Scheme', 'wisemove'),
				"desc" => wp_kses_data( __('Select color scheme to edit colors', 'wisemove') ),
				"std" => 'default',
				"options" => wisemove_get_list_schemes(),
				"refresh" => false,
				"type" => "select"
				),
		
			'scheme_storage' => array(
				"title" => esc_html__('Colors storage', 'wisemove'),
				"desc" => esc_html__('Hidden storage of the all color from the all color shemes (only for internal usage)', 'wisemove'),
				"std" => '',
				"refresh" => false,
				"type" => "hidden"
				),
		
			'scheme_info_single' => array(
				"title" => esc_html__('Colors for single post/page', 'wisemove'),
				"desc" => wp_kses_data( __('Specify colors for single post/page (not for alter blocks)', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
				
			'bg_color' => array(
				"title" => esc_html__('Background color', 'wisemove'),
				"desc" => wp_kses_data( __('Background color of the whole page', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'bd_color' => array(
				"title" => esc_html__('Border color', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the bordered elements, separators, etc.', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'text' => array(
				"title" => esc_html__('Text', 'wisemove'),
				"desc" => wp_kses_data( __('Plain text color on single page/post', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_light' => array(
				"title" => esc_html__('Light text', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the post meta: post date and author, comments number, etc.', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_dark' => array(
				"title" => esc_html__('Dark text', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the headers, strong text, etc.', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_link' => array(
				"title" => esc_html__('Links', 'wisemove'),
				"desc" => wp_kses_data( __('Color of links and accented areas', 'wisemove') ),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_hover' => array(
				"title" => esc_html__('Links hover', 'wisemove'),
				"desc" => wp_kses_data( __('Hover color for links and accented areas', 'wisemove') ),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_alter' => array(
				"title" => esc_html__('Colors for alternative blocks', 'wisemove'),
				"desc" => wp_kses_data( __('Specify colors for alternative blocks - rectangular blocks with its own background color (posts in homepage, blog archive, search results, widgets on sidebar, footer, etc.)', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'alter_bg_color' => array(
				"title" => esc_html__('Alter background color', 'wisemove'),
				"desc" => wp_kses_data( __('Background color of the alternative blocks', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bg_hover' => array(
				"title" => esc_html__('Alter hovered background color', 'wisemove'),
				"desc" => wp_kses_data( __('Background color for the hovered state of the alternative blocks', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_color' => array(
				"title" => esc_html__('Alternative border color', 'wisemove'),
				"desc" => wp_kses_data( __('Border color of the alternative blocks', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_hover' => array(
				"title" => esc_html__('Alternative hovered border color', 'wisemove'),
				"desc" => wp_kses_data( __('Border color for the hovered state of the alter blocks', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_text' => array(
				"title" => esc_html__('Alter text', 'wisemove'),
				"desc" => wp_kses_data( __('Text color of the alternative blocks', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_light' => array(
				"title" => esc_html__('Alter light', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with alternative background', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_dark' => array(
				"title" => esc_html__('Alter dark', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the headers inside block with alternative background', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_link' => array(
				"title" => esc_html__('Alter link', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the links inside block with alternative background', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_hover' => array(
				"title" => esc_html__('Alter hover', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with alternative background', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_input' => array(
				"title" => esc_html__('Colors for the form fields', 'wisemove'),
				"desc" => wp_kses_data( __('Specify colors for the form fields and textareas', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'input_bg_color' => array(
				"title" => esc_html__('Inactive background', 'wisemove'),
				"desc" => wp_kses_data( __('Background color of the inactive form fields', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bg_hover' => array(
				"title" => esc_html__('Active background', 'wisemove'),
				"desc" => wp_kses_data( __('Background color of the focused form fields', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_color' => array(
				"title" => esc_html__('Inactive border', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the border in the inactive form fields', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_hover' => array(
				"title" => esc_html__('Active border', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the border in the focused form fields', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_text' => array(
				"title" => esc_html__('Inactive field', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the text in the inactive fields', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_light' => array(
				"title" => esc_html__('Disabled field', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the disabled field', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_dark' => array(
				"title" => esc_html__('Active field', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the active field', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_inverse' => array(
				"title" => esc_html__('Colors for inverse blocks', 'wisemove'),
				"desc" => wp_kses_data( __('Specify colors for inverse blocks, rectangular blocks with background color equal to the links color or one of accented colors (if used in the current theme)', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'inverse_text' => array(
				"title" => esc_html__('Inverse text', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the text inside block with accented background', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_light' => array(
				"title" => esc_html__('Inverse light', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with accented background', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_dark' => array(
				"title" => esc_html__('Inverse dark', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the headers inside block with accented background', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_link' => array(
				"title" => esc_html__('Inverse link', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the links inside block with accented background', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_hover' => array(
				"title" => esc_html__('Inverse hover', 'wisemove'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with accented background', 'wisemove') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$wisemove_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),


			// Section 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'wisemove'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'wisemove') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'wisemove')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'wisemove'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'wisemove') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'wisemove')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// Panel 'Fonts' - manage fonts loading and set parameters of the base theme elements
			'fonts' => array(
				"title" => esc_html__('* Fonts settings', 'wisemove'),
				"desc" => '',
				"priority" => 1500,
				"type" => "panel"
				),

			// Section 'Load_fonts'
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'wisemove'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'wisemove') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'wisemove') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'wisemove'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'wisemove') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'wisemove') ),
				"refresh" => false,
				"std" => '$wisemove_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=wisemove_get_theme_setting('max_load_fonts'); $i++) {
			$fonts["load_fonts-{$i}-info"] = array(
				"title" => esc_html(sprintf(esc_html__('Font %s', 'wisemove'), $i)),
				"desc" => '',
				"type" => "info",
				);
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'wisemove'),
				"desc" => '',
				"refresh" => false,
				"std" => '$wisemove_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'wisemove'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'wisemove') )
							: '',
				"refresh" => false,
				"std" => '$wisemove_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'wisemove'),
					'serif' => esc_html__('serif', 'wisemove'),
					'sans-serif' => esc_html__('sans-serif', 'wisemove'),
					'monospace' => esc_html__('monospace', 'wisemove'),
					'cursive' => esc_html__('cursive', 'wisemove'),
					'fantasy' => esc_html__('fantasy', 'wisemove')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'wisemove'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'wisemove') )
											. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'wisemove') )
							: '',
				"refresh" => false,
				"std" => '$wisemove_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Sections with font's attributes for each theme element
		$theme_fonts = wisemove_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								: esc_html(sprintf(esc_html__('%s settings', 'wisemove'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								: wp_kses_post( sprintf(__('Font settings of the "%s" tag.', 'wisemove'), $tag) ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = wisemove_get_list_load_fonts(true);
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'wisemove'),
						'100' => esc_html__('100 (Light)', 'wisemove'), 
						'200' => esc_html__('200 (Light)', 'wisemove'), 
						'300' => esc_html__('300 (Thin)',  'wisemove'),
						'400' => esc_html__('400 (Normal)', 'wisemove'),
						'500' => esc_html__('500 (Semibold)', 'wisemove'),
						'600' => esc_html__('600 (Semibold)', 'wisemove'),
						'700' => esc_html__('700 (Bold)', 'wisemove'),
						'800' => esc_html__('800 (Black)', 'wisemove'),
						'900' => esc_html__('900 (Black)', 'wisemove')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'wisemove'),
						'normal' => esc_html__('Normal', 'wisemove'), 
						'italic' => esc_html__('Italic', 'wisemove')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'wisemove'),
						'none' => esc_html__('None', 'wisemove'), 
						'underline' => esc_html__('Underline', 'wisemove'),
						'overline' => esc_html__('Overline', 'wisemove'),
						'line-through' => esc_html__('Line-through', 'wisemove')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'wisemove'),
						'none' => esc_html__('None', 'wisemove'), 
						'uppercase' => esc_html__('Uppercase', 'wisemove'),
						'lowercase' => esc_html__('Lowercase', 'wisemove'),
						'capitalize' => esc_html__('Capitalize', 'wisemove')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"refresh" => false,
					"std" => '$wisemove_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters into Theme Options
		wisemove_storage_merge_array('options', '', $fonts);
	}
}




// -----------------------------------------------------------------
// -- Create and manage Theme Options
// -----------------------------------------------------------------

// Theme init priorities:
// 2 - create Theme Options
if (!function_exists('wisemove_options_theme_setup2')) {
	add_action( 'after_setup_theme', 'wisemove_options_theme_setup2', 2 );
	function wisemove_options_theme_setup2() {
		wisemove_options_create();
	}
}

// Step 1: Load default settings and previously saved mods
if (!function_exists('wisemove_options_theme_setup5')) {
	add_action( 'after_setup_theme', 'wisemove_options_theme_setup5', 5 );
	function wisemove_options_theme_setup5() {
		wisemove_storage_set('options_reloaded', false);
		wisemove_load_theme_options();
	}
}

// Step 2: Load current theme customization mods
if (is_customize_preview()) {
	if (!function_exists('wisemove_load_custom_options')) {
		add_action( 'wp_loaded', 'wisemove_load_custom_options' );
		function wisemove_load_custom_options() {
			if (!wisemove_storage_get('options_reloaded')) {
				wisemove_storage_set('options_reloaded', true);
				wisemove_load_theme_options();
			}
		}
	}
}

// Load current values for each customizable option
if ( !function_exists('wisemove_load_theme_options') ) {
	function wisemove_load_theme_options() {
		$options = wisemove_storage_get('options');
		$reset = (int) get_theme_mod('reset_options', 0);
		foreach ($options as $k=>$v) {
			if (isset($v['std'])) {
				if (strpos($v['std'], '$wisemove_')!==false) {
					$func = substr($v['std'], 1);
					if (function_exists($func)) {
						$v['std'] = $func($k);
					}
				}
				$value = $v['std'];
				if (!$reset) {
					if (isset($_GET[$k]))
						$value = sanitize_text_field($_GET[$k]);
					else {
						$tmp = get_theme_mod($k, -987654321);
						if ($tmp != -987654321) $value = $tmp;
					}
				}
				wisemove_storage_set_array2('options', $k, 'val', $value);
				if ($reset) remove_theme_mod($k);
			}
		}
		if ($reset) {
			// Unset reset flag
			set_theme_mod('reset_options', 0);
			// Regenerate CSS with default colors and fonts
			wisemove_customizer_save_css();
		} else {
			do_action('wisemove_action_load_options');
		}
	}
}

// Override options with stored page/post meta
if ( !function_exists('wisemove_override_theme_options') ) {
	add_action( 'wp', 'wisemove_override_theme_options', 1 );
	function wisemove_override_theme_options($query=null) {
		if (is_page_template('blog.php')) {
			wisemove_storage_set('blog_archive', true);
			wisemove_storage_set('blog_template', get_the_ID());
		}
		wisemove_storage_set('blog_mode', wisemove_detect_blog_mode());
		if (is_singular()) {
			wisemove_storage_set('options_meta', get_post_meta(get_the_ID(), 'wisemove_options', true));
		}
	}
}


// Return customizable option value
if (!function_exists('wisemove_get_theme_option')) {
	function wisemove_get_theme_option($name, $defa='', $strict_mode=false, $post_id=0) {
		$rez = $defa;
		$from_post_meta = false;
		if ($post_id > 0) {
			if (!wisemove_storage_isset('post_options_meta', $post_id))
				wisemove_storage_set_array('post_options_meta', $post_id, get_post_meta($post_id, 'wisemove_options', true));
			if (wisemove_storage_isset('post_options_meta', $post_id, $name)) {
				$tmp = wisemove_storage_get_array('post_options_meta', $post_id, $name);
				if (!wisemove_is_inherit($tmp)) {
					$rez = $tmp;
					$from_post_meta = true;
				}
			}
		}
		if (!$from_post_meta && wisemove_storage_isset('options')) {
			if ( !wisemove_storage_isset('options', $name) ) {
				$rez = $tmp = '_not_exists_';
				if (function_exists('trx_addons_get_option'))
					$rez = trx_addons_get_option($name, $tmp, false);
				if ($rez === $tmp) {
					if ($strict_mode) {
						$s = debug_backtrace();
						$s = array_shift($s);
						echo '<pre>' . sprintf(esc_html__('Undefined option "%s" called from:', 'wisemove'), $name);
						if (function_exists('dco')) dco($s);
						else print_r($s);
						echo '</pre>';
						wp_die();
					} else
						$rez = $defa;
				}
			} else {
				$blog_mode = wisemove_storage_get('blog_mode');
				// Override option from GET or POST for current blog mode
				if (!empty($blog_mode) && isset($_REQUEST[$name . '_' . $blog_mode])) {
					$rez = sanitize_text_field($_REQUEST[$name . '_' . $blog_mode]);
				// Override option from GET
				} else if (isset($_REQUEST[$name])) {
					$rez = sanitize_text_field($_REQUEST[$name]);
				// Override option from current page settings (if exists)
				} else if (wisemove_storage_isset('options_meta', $name) && !wisemove_is_inherit(wisemove_storage_get_array('options_meta', $name))) {
					$rez = wisemove_storage_get_array('options_meta', $name);
				// Override option from current blog mode settings: 'home', 'search', 'page', 'post', 'blog', etc. (if exists)
				} else if (!empty($blog_mode) && wisemove_storage_isset('options', $name . '_' . $blog_mode, 'val') && !wisemove_is_inherit(wisemove_storage_get_array('options', $name . '_' . $blog_mode, 'val'))) {
					$rez = wisemove_storage_get_array('options', $name . '_' . $blog_mode, 'val');
				// Get saved option value
				} else if (wisemove_storage_isset('options', $name, 'val')) {
					$rez = wisemove_storage_get_array('options', $name, 'val');
				// Get ThemeREX Addons option value
				} else if (function_exists('trx_addons_get_option')) {
					$rez = trx_addons_get_option($name, $defa, false);
				}
			}
		}
		return $rez;
	}
}


// Check if customizable option exists
if (!function_exists('wisemove_check_theme_option')) {
	function wisemove_check_theme_option($name) {
		return wisemove_storage_isset('options', $name);
	}
}

// Get dependencies list from the Theme Options
if ( !function_exists('wisemove_get_theme_dependencies') ) {
	function wisemove_get_theme_dependencies() {
		$options = wisemove_storage_get('options');
		$depends = array();
		foreach ($options as $k=>$v) {
			if (isset($v['dependency'])) 
				$depends[$k] = $v['dependency'];
		}
		return $depends;
	}
}

// Return internal theme setting value
if (!function_exists('wisemove_get_theme_setting')) {
	function wisemove_get_theme_setting($name) {
		return wisemove_storage_isset('settings', $name) ? wisemove_storage_get_array('settings', $name) : false;
	}
}


// Set theme setting
if ( !function_exists( 'wisemove_set_theme_setting' ) ) {
	function wisemove_set_theme_setting($option_name, $value) {
		if (wisemove_storage_isset('settings', $option_name))
			wisemove_storage_set_array('settings', $option_name, $value);
	}
}
?>