<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

$wisemove_post_id    = get_the_ID();
$wisemove_post_date  = wisemove_get_date();
$wisemove_post_title = get_the_title();
$wisemove_post_link  = get_permalink();
$wisemove_post_author_id   = get_the_author_meta('ID');
$wisemove_post_author_name = get_the_author_meta('display_name');
$wisemove_post_author_url  = get_author_posts_url($wisemove_post_author_id, '');

$wisemove_args = get_query_var('wisemove_args_widgets_posts');
$wisemove_show_date = isset($wisemove_args['show_date']) ? (int) $wisemove_args['show_date'] : 1;
$wisemove_show_image = isset($wisemove_args['show_image']) ? (int) $wisemove_args['show_image'] : 1;
$wisemove_show_author = isset($wisemove_args['show_author']) ? (int) $wisemove_args['show_author'] : 1;
$wisemove_show_counters = isset($wisemove_args['show_counters']) ? (int) $wisemove_args['show_counters'] : 1;
$wisemove_show_categories = isset($wisemove_args['show_categories']) ? (int) $wisemove_args['show_categories'] : 1;

$wisemove_output = wisemove_storage_get('wisemove_output_widgets_posts');

$wisemove_post_counters_output = '';
if ( $wisemove_show_counters ) {
	$wisemove_post_counters_output = '<span class="post_info_item post_info_counters">'
								. wisemove_get_post_counters('comments')
							. '</span>';
}


$wisemove_output .= '<article class="post_item with_thumb">';

if ($wisemove_show_image) {
	$wisemove_post_thumb = get_the_post_thumbnail($wisemove_post_id, wisemove_get_thumb_size('tiny'), array(
		'alt' => get_the_title()
	));
	if ($wisemove_post_thumb) $wisemove_output .= '<div class="post_thumb">' . ($wisemove_post_link ? '<a href="' . esc_url($wisemove_post_link) . '">' : '') . ($wisemove_post_thumb) . ($wisemove_post_link ? '</a>' : '') . '</div>';
}

$wisemove_output .= '<div class="post_content">'
			. ($wisemove_show_categories 
					? '<div class="post_categories">'
						. wisemove_get_post_categories()
						. $wisemove_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($wisemove_post_link ? '<a href="' . esc_url($wisemove_post_link) . '">' : '') . ($wisemove_post_title) . ($wisemove_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('wisemove_filter_get_post_info', 
								'<div class="post_info">'
									. ($wisemove_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($wisemove_post_link ? '<a href="' . esc_url($wisemove_post_link) . '" class="post_info_date">' : '') 
											. esc_html($wisemove_post_date) 
											. ($wisemove_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($wisemove_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'wisemove') . ' ' 
											. ($wisemove_post_link ? '<a href="' . esc_url($wisemove_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($wisemove_post_author_name) 
											. ($wisemove_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$wisemove_show_categories && $wisemove_post_counters_output
										? $wisemove_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
wisemove_storage_set('wisemove_output_widgets_posts', $wisemove_output);
?>