<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

// Page (category, tag, archive, author) title

$wisemove_top_image = wisemove_get_theme_option('header_title_image');

if ( wisemove_need_page_title() ) {
	set_query_var('wisemove_title_showed', true);
	?>
	<div class="top_panel_title sc_layouts_row scheme_dark <?php  if ($wisemove_top_image!='') echo ' '.esc_attr(wisemove_add_inline_style('background-image: url('.esc_url($wisemove_top_image).');'));  ?>">
		<div class="content_wrap">
			<div class="sc_layouts_column">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title">
						<?php

						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$wisemove_blog_title = wisemove_get_blog_title();
							$wisemove_blog_title_text = $wisemove_blog_title_class = $wisemove_blog_title_link = $wisemove_blog_title_link_text = '';
							if (is_array($wisemove_blog_title)) {
								$wisemove_blog_title_text = $wisemove_blog_title['text'];
								$wisemove_blog_title_class = !empty($wisemove_blog_title['class']) ? ' '.$wisemove_blog_title['class'] : '';
								$wisemove_blog_title_link = !empty($wisemove_blog_title['link']) ? $wisemove_blog_title['link'] : '';
								$wisemove_blog_title_link_text = !empty($wisemove_blog_title['link_text']) ? $wisemove_blog_title['link_text'] : '';
							} else
								$wisemove_blog_title_text = $wisemove_blog_title;
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr($wisemove_blog_title_class); ?>"><?php
								$wisemove_top_icon = wisemove_get_category_icon();
								if (!empty($wisemove_top_icon)) {
									$wisemove_attr = wisemove_getimagesize($wisemove_top_icon);
									?><img src="<?php echo esc_url($wisemove_top_icon); ?>" alt="'.esc_attr__('icon', 'wisemove').'" <?php if (!empty($wisemove_attr[3])) wisemove_show_layout($wisemove_attr[3]);?>><?php
								}
								echo wp_kses_data($wisemove_blog_title_text);
							?></h1>
							<?php
							if (!empty($wisemove_blog_title_link) && !empty($wisemove_blog_title_link_text)) {
								?><a href="<?php echo esc_url($wisemove_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($wisemove_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'wisemove_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>