<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0.10
 */

// Logo
if (wisemove_is_on(wisemove_get_theme_option('logo_in_footer'))) {
	$wisemove_logo_image = '';
	if (wisemove_get_retina_multiplier(2) > 1)
		$wisemove_logo_image = wisemove_get_theme_option( 'logo_footer_retina' );
	if (empty($wisemove_logo_image)) 
		$wisemove_logo_image = wisemove_get_theme_option( 'logo_footer' );
	$wisemove_logo_text   = get_bloginfo( 'name' );
	if (!empty($wisemove_logo_image) || !empty($wisemove_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($wisemove_logo_image)) {
					$wisemove_attr = wisemove_getimagesize($wisemove_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($wisemove_logo_image).'" class="logo_footer_image" alt="'.esc_attr__('logo', 'wisemove').'"'.(!empty($wisemove_attr[3]) ? sprintf(' %s', $wisemove_attr[3]) : '').'></a>' ;
				} else if (!empty($wisemove_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($wisemove_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>