<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0.10
 */

// Copyright area
$wisemove_footer_scheme =  wisemove_is_inherit(wisemove_get_theme_option('footer_scheme')) ? wisemove_get_theme_option('color_scheme') : wisemove_get_theme_option('footer_scheme');
$wisemove_copyright_scheme = wisemove_is_inherit(wisemove_get_theme_option('copyright_scheme')) ? $wisemove_footer_scheme : wisemove_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($wisemove_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php
				$wisemove_copyright = wisemove_prepare_macros(wisemove_get_theme_option('copyright'));
				if (!empty($wisemove_copyright)) {
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $wisemove_copyright, $wisemove_matches)) {
						$wisemove_copyright = str_replace($wisemove_matches[1], date(str_replace(array('{', '}'), '', $wisemove_matches[1])), $wisemove_copyright);
					}
					wisemove_show_layout(nl2br($wisemove_copyright));
				}
			?></div>
		</div>
	</div>
</div>
