<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0.1
 */
?>
<div class="update-nag" id="wisemove_admin_notice">
	<h3 class="wisemove_notice_title"><?php echo sprintf(esc_html__('Welcome to %s', 'wisemove'), wp_get_theme()->name); ?></h3>
	<?php if (!wisemove_exists_trx_addons()) { ?>
	<p><?php echo wp_kses_data(__('<b>Attention!</b> Plugin "ThemeREX Addons is required! Please, install and activate it!', 'wisemove')); ?></p>
	<?php } ?>
	<p>
		<?php if (wisemove_get_value_gp('page')!='tgmpa-install-plugins') { ?>
		<a href="<?php echo esc_url(admin_url().'themes.php?page=tgmpa-install-plugins'); ?>" class="button-primary"><i class="dashicons dashicons-admin-plugins"></i> <?php esc_html_e('Install plugins', 'wisemove'); ?></a>
		<?php } ?>
        <a href="<?php echo esc_url(admin_url().'themes.php?page=trx_importer'); ?>" class="button-primary"><i class="dashicons dashicons-download"></i> <?php esc_html_e('One Click Demo Data', 'wisemove'); ?></a>
        <a href="<?php echo esc_url(admin_url().'customize.php'); ?>" class="button-primary"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Customizer', 'wisemove'); ?></a>
        <a href="#" class="button wisemove_hide_notice"><i class="dashicons dashicons-dismiss"></i> <?php esc_html_e('Hide Notice', 'wisemove'); ?></a>
	</p>
</div>