<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

wisemove_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'classie', wisemove_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'imagesloaded', wisemove_get_file_url('js/theme.gallery/imagesloaded.min.js'), array(), null, true );
wp_enqueue_script( 'masonry', wisemove_get_file_url('js/theme.gallery/masonry.min.js'), array(), null, true );
wp_enqueue_script( 'wisemove-gallery-script', wisemove_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$wisemove_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$wisemove_sticky_out = is_array($wisemove_stickies) && count($wisemove_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$wisemove_cat = wisemove_get_theme_option('parent_cat');
	$wisemove_post_type = wisemove_get_theme_option('post_type');
	$wisemove_taxonomy = wisemove_get_post_type_taxonomy($wisemove_post_type);
	$wisemove_show_filters = wisemove_get_theme_option('show_filters');
	$wisemove_tabs = array();
	if (!wisemove_is_off($wisemove_show_filters)) {
		$wisemove_args = array(
			'type'			=> $wisemove_post_type,
			'child_of'		=> $wisemove_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $wisemove_taxonomy,
			'pad_counts'	=> false
		);
		$wisemove_portfolio_list = get_terms($wisemove_args);
		if (is_array($wisemove_portfolio_list) && count($wisemove_portfolio_list) > 0) {
			$wisemove_tabs[$wisemove_cat] = esc_html__('All', 'wisemove');
			foreach ($wisemove_portfolio_list as $wisemove_term) {
				if (isset($wisemove_term->term_id)) $wisemove_tabs[$wisemove_term->term_id] = $wisemove_term->name;
			}
		}
	}
	if (count($wisemove_tabs) > 0) {
		$wisemove_portfolio_filters_ajax = true;
		$wisemove_portfolio_filters_active = $wisemove_cat;
		$wisemove_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters wisemove_tabs wisemove_tabs_ajax">
			<ul class="portfolio_titles wisemove_tabs_titles">
				<?php
				foreach ($wisemove_tabs as $wisemove_id=>$wisemove_title) {
					?><li><a href="<?php echo esc_url(wisemove_get_hash_link(sprintf('#%s_%s_content', $wisemove_portfolio_filters_id, $wisemove_id))); ?>" data-tab="<?php echo esc_attr($wisemove_id); ?>"><?php echo esc_html($wisemove_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$wisemove_ppp = wisemove_get_theme_option('posts_per_page');
			if (wisemove_is_inherit($wisemove_ppp)) $wisemove_ppp = '';
			foreach ($wisemove_tabs as $wisemove_id=>$wisemove_title) {
				$wisemove_portfolio_need_content = $wisemove_id==$wisemove_portfolio_filters_active || !$wisemove_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $wisemove_portfolio_filters_id, $wisemove_id)); ?>"
					class="portfolio_content wisemove_tabs_content"
					data-blog-template="<?php echo esc_attr(wisemove_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(wisemove_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($wisemove_ppp); ?>"
					data-post-type="<?php echo esc_attr($wisemove_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($wisemove_taxonomy); ?>"
					data-cat="<?php echo esc_attr($wisemove_id); ?>"
					data-parent-cat="<?php echo esc_attr($wisemove_cat); ?>"
					data-need-content="<?php echo (false===$wisemove_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($wisemove_portfolio_need_content) 
						wisemove_show_portfolio_posts(array(
							'cat' => $wisemove_id,
							'parent_cat' => $wisemove_cat,
							'taxonomy' => $wisemove_taxonomy,
							'post_type' => $wisemove_post_type,
							'page' => 1,
							'sticky' => $wisemove_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		wisemove_show_portfolio_posts(array(
			'cat' => $wisemove_cat,
			'parent_cat' => $wisemove_cat,
			'taxonomy' => $wisemove_taxonomy,
			'post_type' => $wisemove_post_type,
			'page' => 1,
			'sticky' => $wisemove_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>