<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

wisemove_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$wisemove_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$wisemove_sticky_out = is_array($wisemove_stickies) && count($wisemove_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($wisemove_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$wisemove_sticky_out) {
		if (wisemove_get_theme_option('first_post_large') && !is_paged() && !in_array(wisemove_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="columns_wrap posts_container"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($wisemove_sticky_out && !is_sticky()) {
			$wisemove_sticky_out = false;
			?></div><div class="columns_wrap posts_container"><?php
		}
		get_template_part( 'content', $wisemove_sticky_out && is_sticky() ? 'sticky' :'classic' );
	}
	
	?></div><?php

	wisemove_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>