<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

$wisemove_blog_style = explode('_', wisemove_get_theme_option('blog_style'));
$wisemove_columns = empty($wisemove_blog_style[1]) ? 2 : max(2, $wisemove_blog_style[1]);
$wisemove_post_format = get_post_format();
$wisemove_post_format = empty($wisemove_post_format) ? 'standard' : str_replace('post-format-', '', $wisemove_post_format);
$wisemove_animation = wisemove_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($wisemove_columns).' post_format_'.esc_attr($wisemove_post_format) ); ?>
	<?php echo (!wisemove_is_off($wisemove_animation) ? ' data-animation="'.esc_attr(wisemove_get_animation_classes($wisemove_animation)).'"' : ''); ?>
	>

	<?php
	$wisemove_image_hover = wisemove_get_theme_option('image_hover');
	// Featured image
	wisemove_show_post_featured(array(
		'thumb_size' => wisemove_get_thumb_size(strpos(wisemove_get_theme_option('body_style'), 'full')!==false || $wisemove_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $wisemove_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $wisemove_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>