<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WPBakery Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$wisemove_content = '';
$wisemove_blog_archive_mask = '%%CONTENT%%';
$wisemove_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $wisemove_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($wisemove_content = apply_filters('the_content', get_the_content())) != '') {
		if (($wisemove_pos = strpos($wisemove_content, $wisemove_blog_archive_mask)) !== false) {
			$wisemove_content = preg_replace('/(\<p\>\s*)?'.$wisemove_blog_archive_mask.'(\s*\<\/p\>)/i', $wisemove_blog_archive_subst, $wisemove_content);
		} else
			$wisemove_content .= $wisemove_blog_archive_subst;
		$wisemove_content = explode($wisemove_blog_archive_mask, $wisemove_content);
	}
}

// Prepare args for a new query
$wisemove_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$wisemove_args = wisemove_query_add_posts_and_cats($wisemove_args, '', wisemove_get_theme_option('post_type'), wisemove_get_theme_option('parent_cat'));
$wisemove_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($wisemove_page_number > 1) {
	$wisemove_args['paged'] = $wisemove_page_number;
	$wisemove_args['ignore_sticky_posts'] = true;
}
$wisemove_ppp = wisemove_get_theme_option('posts_per_page');
if ((int) $wisemove_ppp != 0)
	$wisemove_args['posts_per_page'] = (int) $wisemove_ppp;
// Make a new query
query_posts( $wisemove_args );
// Set a new query as main WP Query
$GLOBALS['wp_the_query'] = $GLOBALS['wp_query'];

// Set query vars in the new query!
if (is_array($wisemove_content) && count($wisemove_content) == 2) {
	set_query_var('blog_archive_start', $wisemove_content[0]);
	set_query_var('blog_archive_end', $wisemove_content[1]);
}

get_template_part('index');
?>