<?php 
$placeholder = '600x500';
$master_class = 'col-md-12';
$thumbnail_class = 'col-md-4';
$post_details_class = 'col-md-8';
$type_class = 'list-view';
$image_size = 'winterzone_about_650x550';

if ( winterzone_redux('mt_blog_display_type') == 'list' ) {
    $master_class = 'col-md-12';
    $thumbnail_class = 'col-md-4';
    $post_details_class = 'col-md-8';
    $type_class = 'list-view';
} else {
    if ( winterzone_redux('mt_blog_grid_columns') == 1 ) {
        $master_class = 'col-md-12';
        $type_class .= ' grid-one-column';
        $placeholder = '900x500';
    }elseif ( winterzone_redux('mt_blog_grid_columns') == 2 ) {
        $master_class = 'col-md-6';
        $type_class .= ' grid-two-columns';
        $placeholder = '900x500';
    }elseif ( winterzone_redux('mt_blog_grid_columns') == 3 ) {
        $master_class = 'col-md-4';
        $type_class .= ' grid-three-columns';
        $placeholder = '600x500';
    }elseif ( winterzone_redux('mt_blog_grid_columns') == 4 ) {
        $master_class = 'col-md-3';
        $type_class .= ' grid-four-columns';
        $placeholder = '600x500';
    }
    $thumbnail_class = 'full-width-part';
    $post_details_class = 'full-width-part';
} 


// THUMBNAIL
$post_img = '';
$thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), $image_size );
if ($thumbnail_src) {
    $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src[0]) . '" alt="'.get_the_title().'" />';
    $post_col = 'col-md-7';
}else{
    $post_col = 'col-md-12 no-featured-image';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('single-post '.esc_attr($master_class).' '.esc_attr($type_class)); ?> > 
    <div class="blog_custom">

        <?php if(winterzone_plugin_active('modeltheme-framework/modeltheme-framework.php')) { ?>


                        <!-- ////////content for LIST View//////// -->
                        <?php if ( winterzone_redux('mt_blog_display_type') == 'list' ) { ?>
                            <?php if ($post_img) { ?>
                                <!-- POST THUMBNAIL -->
                                <?php if ( winterzone_redux('mt_blog_display_type') == 'list' ) { ?>

                                    <div class="col-md-5 post-thumbnail">
                                        <a href="<?php esc_url(the_permalink()); ?>" class="relative">
                                            <?php echo wp_kses_post($post_img); ?>
                                        </a>
                                    </div>

                                    <?php } else { ?>

                                        <div class="col-md-12 post-thumbnail">
                                            <a href="<?php esc_url(the_permalink()); ?>" class="relative">
                                                <?php echo wp_kses_post($post_img); ?>
                                            </a>
                                        </div>

                                    <?php } ?>
                            <?php } ?>

                            <!-- POST DETAILS -->
                            <?php if ( winterzone_redux('mt_blog_display_type') == 'grid' ) { ?>

                            <div class="col-md-12 post-details">

                            <?php } else { ?>

                            <div class="<?php echo esc_attr($post_col); ?> post-details">

                            <?php } ?>

                                <div class="post-details-holder">
                                    <h3 class="post-name row">
                                        <a title="<?php the_title_attribute() ?>" href="<?php esc_url(the_permalink()); ?>">
                                            <?php if(is_sticky()){ ?>
                                                <span class="post-sticky-label">
                                                    <i class="fa fa-bookmark"></i>
                                                </span>
                                            <?php } ?>
                                            <?php the_title() ?>
                                        </a>
                                    </h3>
                                    
                                    <div class="post-category-comment-date row">
                                        <span class="post-date">
                                            <a title="<?php the_title_attribute() ?>" href="<?php esc_url(the_permalink()); ?>">
                                                <i class="icon-calendar"></i>
                                                <?php echo get_the_date(); ?>
                                            </a>
                                        </span>
                                        <span class="post-tags">
                                            <?php echo get_the_term_list( get_the_ID(), 'category', '<i class="icon-tag"></i>', ', ' ); ?>
                                        </span>
                                        <span class="post-author"><i class="icon-user icons"></i><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) )); ?>"><?php echo get_the_author(); ?></a></span>
                                        <span class="post-comments"><i class="icon-bubbles icons"></i><a href="<?php echo esc_url(the_permalink()).'#comments'; ?>"><?php comments_number( '0', '1', '%' ); ?></a></span>  
                                    </div>

                                    <div class="post-excerpt row">
                                        <?php
                                            /* translators: %s: Name of current post */
                                            the_excerpt();
                                        ?>
                                        <div class="clearfix"></div>

                                        <p>
                                            <a href="<?php echo esc_url(get_the_permalink()); ?>" class="more-link">
                                                <?php echo esc_html__( 'Continue Reading', 'winterzone' ); ?> <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                                            </a>
                                        </p>
                                        <div class="clearfix"></div>
                                        <?php
                                            wp_link_pages( array(
                                                'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'winterzone' ),
                                                'after'  => '</div>',
                                            ) );
                                        ?>
                                    </div>
                                </div>
                            </div>


                        <!-- ////////content for GRID View//////// -->
                        <?php } elseif ( winterzone_redux('mt_blog_display_type') == 'grid' ) { ?>

                            <?php if ($post_img) { ?>
                                <!-- POST THUMBNAIL -->
                                <?php if ( winterzone_redux('mt_blog_display_type') == 'list' ) { ?>

                                    <div class="col-md-5 post-thumbnail">
                                        <a href="<?php esc_url(the_permalink()); ?>" class="relative">
                                            <?php echo wp_kses_post($post_img); ?>
                                        </a>
                                    </div>

                                    <?php } else { ?>

                                        <div class="col-md-12 post-thumbnail">
                                            <a href="<?php esc_url(the_permalink()); ?>" class="relative">
                                                <?php echo wp_kses_post($post_img); ?>
                                            </a>
                                        </div>

                                    <?php } ?>
                            <?php } ?>

                            <!-- POST DETAILS -->
                            <?php if ( winterzone_redux('mt_blog_display_type') == 'grid' ) { ?>

                            <div class="col-md-12 post-details">

                            <?php } else { ?>

                            <div class="<?php echo esc_attr($post_col); ?> post-details">

                            <?php } ?>

                                <div class="post-details-holder">
                                    <h3 class="post-name row">
                                        <a title="<?php the_title_attribute( 'echo=0' ); ?>" href="<?php esc_url(the_permalink()); ?>">
                                            <?php if(is_sticky()){ ?>
                                                <span class="post-sticky-label">
                                                    <i class="fa fa-bookmark"></i>
                                                </span>
                                            <?php } ?>
                                            <?php the_title() ?>
                                        </a>
                                    </h3>
                                    
                                    <div class="post-category-comment-date row">
                                        <span class="post-date">
                                            <a title="<?php the_title_attribute( 'echo=0' ); ?>" href="<?php esc_url(the_permalink()); ?>">
                                                <i class="icon-calendar"></i>
                                                <?php echo get_the_date(); ?>
                                            </a>
                                        </span>
                                        <span class="post-tags">
                                            <?php echo get_the_term_list( get_the_ID(), 'category', '<i class="icon-tag"></i>', ', ' ); ?>
                                        </span>
                                        <span class="post-author"><i class="icon-user icons"></i><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) )); ?>"><?php echo get_the_author(); ?></a></span>
                                        <span class="post-comments"><i class="icon-bubbles icons"></i><a href="<?php echo esc_url(the_permalink()).'#comments'; ?>"><?php comments_number( '0', '1', '%' ); ?></a></span>  
                                    </div>

                                    <div class="post-excerpt row">
                                        <?php
                                            /* translators: %s: Name of current post */
                                            the_excerpt();
                                        ?>
                                        <div class="clearfix"></div>

                                        <p>
                                            <a href="<?php echo esc_url(get_the_permalink()); ?>" class="more-link">
                                                <?php echo esc_html__( 'Continue Reading', 'winterzone' ); ?> <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                                            </a>
                                        </p>
                                        <div class="clearfix"></div>
                                        <?php
                                            wp_link_pages( array(
                                                'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'winterzone' ),
                                                'after'  => '</div>',
                                            ) );
                                        ?>
                                    </div>
                                </div>
                            </div>

                    <?php }else{ ?>
                        <!-- POST DETAILS -->
                        <div class="col-md-12 post-details">

                            <div class="post-details-holder">
                                <h3 class="post-name row">
                                    <a title="<?php the_title_attribute(); ?>" href="<?php esc_url(the_permalink()); ?>">
                                        <?php if(is_sticky()){ ?>
                                            <span class="post-sticky-label">
                                                <i class="fa fa-bookmark"></i>
                                            </span>
                                        <?php } ?>
                                        <?php the_title() ?>
                                    </a>
                                </h3>
                                
                                <div class="post-category-comment-date row">
                                    <span class="post-date">
                                        <a title="<?php the_title_attribute(); ?>" href="<?php esc_url(the_permalink()); ?>">
                                            <i class="icon-calendar"></i>
                                            <?php echo get_the_date(); ?>
                                        </a>
                                    </span>
                                    <span class="post-tags">
                                        <?php echo get_the_term_list( get_the_ID(), 'category', '<i class="icon-tag"></i>', ', ' ); ?>
                                    </span>
                                    <span class="post-author"><i class="icon-user icons"></i><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) )); ?>"><?php echo get_the_author(); ?></a></span>
                                    <span class="post-comments"><i class="icon-bubbles icons"></i><a href="<?php echo esc_url(the_permalink()).'#comments'; ?>"><?php comments_number( '0', '1', '%' ); ?></a></span>  
                                </div>

                                <div class="post-excerpt row">
                                    <?php
                                        /* translators: %s: Name of current post */
                                        the_excerpt();
                                    ?>
                                    <div class="clearfix"></div>

                                    <p>
                                        <a href="<?php echo esc_url(get_the_permalink()); ?>" class="more-link">
                                            <?php echo esc_html__( 'Continue Reading', 'winterzone' ); ?> <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                                        </a>
                                    </p>
                                    <div class="clearfix"></div>
                                    <?php
                                        wp_link_pages( array(
                                            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'winterzone' ),
                                            'after'  => '</div>',
                                        ) );
                                    ?>
                                </div>
                            </div>
                        </div>


                        <?php if ($post_img) { ?>
                            <!-- POST THUMBNAIL -->

                            <div class="col-md-5 post-thumbnail">
                                <a href="<?php esc_url(the_permalink()); ?>" class="relative">
                                    <?php echo wp_kses_post($post_img); ?>
                                </a>
                            </div>

                        <?php } ?>
                    <?php } ?>

        <?php } else {


                            if ($post_img) { ?>
                            <!-- POST THUMBNAIL -->

                            <div class="col-md-5 post-thumbnail">
                                <a href="<?php esc_url(the_permalink()); ?>" class="relative">
                                    <?php echo wp_kses_post($post_img); ?>
                                </a>
                            </div>

                            <?php } ?>


                            <!-- POST DETAILS -->
                            <div class="<?php echo esc_attr($post_col); ?> post-details">

                                <div class="post-details-holder">
                                    <h3 class="post-name row">
                                        <a title="<?php the_title_attribute() ?>" href="<?php esc_url(the_permalink()); ?>">
                                            <?php if(is_sticky()){ ?>
                                                <span class="post-sticky-label">
                                                    <i class="fa fa-bookmark"></i>
                                                </span>
                                            <?php } ?>
                                            <?php the_title() ?>
                                        </a>
                                    </h3>
                                    
                                    <div class="post-category-comment-date row">
                                        <span class="post-date">
                                            <a title="<?php the_title_attribute(); ?>" href="<?php esc_url(the_permalink()); ?>">
                                                <i class="icon-calendar"></i>
                                                <?php echo get_the_date(); ?>
                                            </a>
                                        </span>
                                        <span class="post-tags">
                                            <?php echo get_the_term_list( get_the_ID(), 'category', '<i class="icon-tag"></i>', ', ' ); ?>
                                        </span>
                                        <span class="post-author"><i class="icon-user icons"></i><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) )); ?>"><?php echo get_the_author(); ?></a></span>
                                        <span class="post-comments"><i class="icon-bubbles icons"></i><a href="<?php echo esc_url(the_permalink()).'#comments'; ?>"><?php comments_number( '0', '1', '%' ); ?></a></span>  
                                    </div>

                                    <div class="post-excerpt row">
                                        <?php
                                            /* translators: %s: Name of current post */
                                            the_excerpt();
                                        ?>
                                        <div class="clearfix"></div>

                                        <p>
                                            <a href="<?php echo esc_url(get_the_permalink()); ?>" class="more-link">
                                                <?php echo esc_html__( 'Continue Reading', 'winterzone' ); ?> <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                                            </a>
                                        </p>
                                        <div class="clearfix"></div>
                                        <?php
                                            wp_link_pages( array(
                                                'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'winterzone' ),
                                                'after'  => '</div>',
                                            ) );
                                        ?>
                                    </div>
                                </div>
                            </div>


        <?php } ?>

    </div>
</article>