<?php 
/**
* Template for House Listings
* Used in: taxonomy-mt-car-category.php, taxonomy-mt-car-features.php, taxonomy-mt-car-type.php, search.php
**/


// CAR THUMBNAIL
$post_img = '';
$thumbnail_src_featured = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'winterzone_listing_archive_featured_square' );
$thumbnail_src_thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'winterzone_listing_archive_thumbnail' );
$thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ),'winterzone_listing_archive_featured' );

    if ($thumbnail_src) {
    $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src[0]) . '" alt="'.get_the_title().'" />';
    $post_col = 'col-md-12';
    } else {
        $post_col = 'col-md-12 no-featured-image';
        $post_img = '';
    }

?>
<?php 
    $house_location = get_the_term_list( get_the_ID(), 'mt-house-location', '', ' ' );
    $content_post   = get_post(get_the_ID());
    $content        = $content_post->post_content;
    $content        = apply_filters('the_content', $content);
    $content        = str_replace(']]>', ']]&gt;', $content);
    $house_address = get_post_meta( get_the_ID(), 'mt_address', true );
    $house_video_tour = get_post_meta( get_the_ID(), 'mt_video_tour', true );
    $house_scope = get_the_term_list( get_the_ID(), 'mt-house-category', '', ' ' );
    $house_scope = strip_tags( $house_scope );
    $mt_house_price_day = get_post_meta( get_the_ID(), 'mt_house_price_day', true );
    $mt_house_price_for_sale = get_post_meta( get_the_ID(), 'mt_house_price_for_sale', true ); 
    $mt_equipment_size = get_post_meta( get_the_ID(), 'mt_equipment_size', true );
?>
<div class="vc_col-sm-4 vc_col-sm-6 vc_col-xs-12">
    <article class="single-post single-property-listing list-view">
        <div class="blog_custom">
            <div class="col-md-12 post-thumbnail">
                <a class="relative" href="<?php esc_url(the_permalink()); ?>"><?php echo wp_kses_post($post_img); ?></a>
            </div>
            <div class="post-details col-md-12">
                <div class="row">
                    <div class="text-center col-md-12 vc_col-sm-12 vc_col-xs-12">
                        <a href="<?php esc_url(the_permalink()); ?>" class="house_display_posts title-blogpost" title="<?php the_title_attribute(); ?>"><?php echo get_the_title(); ?>
                        </a>
                    </div>
                    <div class="text-center col-md-12 vc_col-sm-12 vc_col-xs-12">
                        <p class="house_display_posts blogpost-descript"><?php echo wp_kses_post($house_scope); 
                            if(!empty($mt_house_price_day)) { ?>
                                <span class="pipe">| </span><?php echo esc_html($mt_house_price_day).esc_html(winterzone_get_currency_symbol()).esc_html__(' per day', 'winterzone');
                            } elseif(empty($mt_house_price_day) and !empty($mt_house_price_for_sale)) { ?>
                                <span class="pipe">| </span><?php echo esc_html($mt_house_price_for_sale).esc_html(winterzone_get_currency_symbol()).esc_html__(' for sell', 'winterzone');
                            }
                            if ($mt_equipment_size) { ?>
                                <span class="pipe">|</span><?php echo esc_html__(' Size ', 'winterzone').esc_html($mt_equipment_size);
                            } ?>
                    </p>
                    </div>
                </div>
            </div>
        </div>
    </article>
</div>