<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.WordPress.org/Template_Hierarchy
 *
 */

get_header(); 

$class_row = "col-md-9";
if ( winterzone_redux('mt_blog_layout') == 'mt_blog_fullwidth' ) {
    $class_row = "col-md-12";
}elseif ( winterzone_redux('mt_blog_layout') == 'mt_blog_right_sidebar' or winterzone_redux('mt_blog_layout') == 'mt_blog_left_sidebar') {
    $class_row = "col-md-9";
}
$sidebar = winterzone_redux('mt_blog_layout_sidebar');

?>

    <!-- HEADER TITLE BREADCRUBS SECTION -->
    <?php echo winterzone_header_title_breadcrumbs(); ?>

    <!-- Page content -->
    <div class="high-padding">
        <!-- Blog content -->
        <div class="container blog-posts">
            <div class="row">

                <?php if ( winterzone_redux('mt_blog_layout') != '' && winterzone_redux('mt_blog_layout') == 'mt_blog_left_sidebar') { ?>
                    <?php if (is_active_sidebar($sidebar)) { ?>
                        <div class="col-md-3 sidebar-content"><?php  dynamic_sidebar( $sidebar ); ?></div>
                    <?php } ?>
                <?php } ?>

                <div class="<?php echo esc_attr($class_row); ?> main-content">
                <?php if ( have_posts() ) : ?>
                    <div class="row">
                        <?php /* Start the Loop */ ?>
                        
                        <?php $j = 0; ?>
                        <?php while ( have_posts() ) : the_post(); ?>
                        <?php
                            $j++;
                            $class = "";

                            if ($j%2 == 0) {
                            $class = "even-post clear_both_class";
                        ?>
                            <div class='<?php echo esc_attr($class); ?>'>
                                <?php get_template_part( 'content', 'right' ); ?>
                                <?php if (winterzone_redux('mt_blog_grid_columns') == 2 AND $j%2 == 0) { ?>
                                    <div class="clearfix"></div>
                                <?php } elseif (winterzone_redux('mt_blog_grid_columns') == 3 AND $j%3 == 0) { ?>
                                    <div class="clearfix"></div>
                                <?php } ?>
                            </div>

                        <?php } else { 
                            $class = "odd-post clear_both_class";
                        ?>
                            <div class='<?php echo esc_attr($class); ?>'>
                                <?php get_template_part( 'content', 'left' ); ?>
                                <?php if (winterzone_redux('mt_blog_grid_columns') == 2 AND $j%2 == 0) { ?>
                                <div class="clearfix"></div>
                            <?php } elseif (winterzone_redux('mt_blog_grid_columns') == 3 AND $j%3 == 0) { ?>
                                <div class="clearfix"></div>
                            <?php } ?>
                            </div>
                        <?php } ?>
                        
                        <?php endwhile; ?>
                        <div class="modeltheme-pagination-holder col-md-12">             
                            <div class="modeltheme-pagination pagination">             
                                <?php winterzone_pagination(); ?>
                            </div>
                        </div>
                    </div>
                <?php else : ?>
                    <?php get_template_part( 'content', 'none' ); ?>
                <?php endif; ?>
                </div>

                <?php if ( class_exists( 'ReduxFrameworkPlugin' ) ) { ?>

                    <?php if ( winterzone_redux('mt_blog_layout') != '' && winterzone_redux('mt_blog_layout') == 'mt_blog_right_sidebar') { ?>
                        <?php if (is_active_sidebar('sidebar-1')) { ?>
                            <div class="col-md-3 sidebar-content"><?php  dynamic_sidebar( 'sidebar-1' ); ?></div>
                        <?php } ?>
                    <?php } ?>

                <?php } else { ?>
                    <?php if (is_active_sidebar('sidebar-1')) { ?>
                        <div class="col-md-3 sidebar-content"><?php  dynamic_sidebar( 'sidebar-1' ); ?></div>
                    <?php } ?>
                <?php } ?>
            </div>
        </div>
    </div>
<?php get_footer(); ?>