<?php
/**
* Content Single
*/
?>


<!-- LISTING FEATURED IMAGE -->

<?php 
$thumbnail_src_featured = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'winterzone_listing_single_featured' );
$thumbnail_src_featured_full = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
$breadcrumbs_on_off             = get_post_meta( get_the_ID(), 'breadcrumbs_on_off',               true );
?>
<div class="clearfix"></div>

<?php 
if (winterzone_plugin_active( 'modeltheme-framework/modeltheme-framework.php' )) {
    if (isset($breadcrumbs_on_off) && $breadcrumbs_on_off == 'yes' || $breadcrumbs_on_off == '') {
        echo winterzone_header_title_breadcrumbs();
    }
}else{
    echo winterzone_header_title_breadcrumbs();
}
?>

<!-- ARTICLE CONTENT -->
<article id="post-<?php the_ID(); ?>" <?php post_class('post high-padding'); ?>>
    <div class="container">
       <div class="row">

            <?php if ( winterzone_redux('mt_single_blog_layout') == 'mt_single_blog_left_sidebar' && is_active_sidebar( winterzone_redux('mt_single_blog_layout_sidebar') )) { ?>
                <div class="col-md-3 sidebar-content">
                    <?php dynamic_sidebar( winterzone_redux('mt_single_blog_layout_sidebar') ); ?>
                </div>
            <?php } ?>


            <?php if ( winterzone_redux('mt_single_blog_layout') == 'mt_single_blog_fullwidth') {
                $cols = 'col-md-12';
            }else{
                $cols = 'col-md-8';
            } ?>

            
            <!-- POST CONTENT -->
            <div class="<?php echo esc_attr($cols); ?> main_stickit main-content">
                <div class="clearfix"></div>
                <?php
                    global  $dynamic_featured_image;
                    $featured_images = $dynamic_featured_image->get_featured_images( get_the_ID() );
                    //Loop through the image to display your image
                    if( !is_null($featured_images) ){
                        $medias = array();
                        foreach($featured_images as $images){
                            $attachment_id = $images['attachment_id'];
                            $medias[] = $attachment_id;
                        }
                        $ids = '';
                        $len = count($medias);
                        $i = 0; ?>
                        <div class="slider-equipment owl-carousel">
                            <?php
                            foreach($medias as $media){
                                $multiple_featured_image1 = wp_get_attachment_url( $media, 'full' );
                                echo '<img src="'.esc_url($multiple_featured_image1).'">'; 
                            }
                            ?>
                        </div>
                    <?php
                    } 
                ?>
<div class="clearfix"></div>
                <?php if(winterzone_plugin_active('modeltheme-framework/modeltheme-framework.php')){ ?>
                    <!-- MAP LOCATION -->
                    <div class="mt_listing_map_location">
                        <?php 
                            $mt_map_coordinates = get_post_meta( get_the_ID(), 'mt_map_coordinates', true );
                            if (isset($mt_map_coordinates) && !empty($mt_map_coordinates)) {
                                $gmap_pin = '';
                                $gmap_pin .= '[sbvcgmap map_width="100" map_height="400" mapstyles="style-55" zoom="18" scrollwheel="no" searchradius="500" sbvcgmap_title="Google Maps"]';
                                
                                    $categories = wp_get_post_terms(get_the_ID(), 'mt-house-type', array("fields" => "all"));
                                    foreach($categories as $category) {
                                        if ($category) {
                                            $image_id = get_term_meta ( $category->term_id, 'category-image-id', true );
                                            $mt_map_coordinates = get_post_meta( get_the_ID(), 'mt_map_coordinates', true );
                                            if (isset($mt_map_coordinates) && !empty($mt_map_coordinates)) {
                                                $gmap_pin .= '[sbvcgmap_marker animation="DROP" address="'.esc_attr($mt_map_coordinates).'" icon="'.esc_attr($image_id).'"]<a href="'.esc_url(get_the_permalink()).'">'.get_the_title().'</a>[/sbvcgmap_marker]';
                                            }
                                        }
                                    }

                                $gmap_pin .= '[/sbvcgmap]';
                            }
                            echo do_shortcode($gmap_pin);
                        ?>
                    </div>
                <?php } ?>

                <!-- HEADER -->
                <div class="article-header">
                    <div class="article-details">
                        <?php if (get_the_tags()) { ?>
                            <div class="single-post-tags">
                                <i class="icon-tag"></i> <?php echo get_the_term_list( get_the_ID(), 'post_tag', '', ' ' ); ?>
                            </div>
                        <?php } ?>
                        <div class="clearfix"></div>
                    </div>
                </div>
                <!-- CONTENT -->
                <div class="article-content">

                    <!-- POST CONTENT -->
                    <?php the_content(); ?>
                    <div class="clearfix"></div>

                    <div class="mt_car--features-group post-specifications">

                        <!-- POST Specifications -->
                        <h4 class="content-car-heading"><?php echo esc_html__('Specifications','winterzone'); ?></h4>
                        <div class="row">
                            <?php 
                            $mt_equipment_color = get_post_meta( get_the_ID(), 'mt_equipment_color', true );
                            $mt_equipment_size = get_post_meta( get_the_ID(), 'mt_equipment_size', true );
                            $mt_fuel_type = get_post_meta( get_the_ID(), 'mt_fuel_type', true );                             

                            if($mt_equipment_color){
                                echo '<div class="col-md-4 features_items"><p>'.esc_html__('Equipment color: ','winterzone').'<strong>'.esc_html($mt_equipment_color).'</strong></p></div>';
                            } 
                            if($mt_equipment_size){
                                echo '<div class="col-md-4 features_items"><p>'.esc_html__('Equipment size: ','winterzone').'<strong>'.esc_html($mt_equipment_size).'</strong></p></div>';
                            }
                            if($mt_fuel_type){
                                echo '<div class="col-md-4 features_items"><p>'.esc_html__('Fuel type: ','winterzone').'<strong>'.esc_html($mt_fuel_type).'</strong></p></div>';
                            }  
                        ?>
                        </div>
                    </div>

                    <?php
                    $house_video_tour = get_post_meta( get_the_ID(), 'mt_video_tour', true );

                    if (!empty($house_video_tour)) { ?>
                        <div class="mt_car--youtube_video">
                            <h4 class="content-car-heading"><?php echo esc_html__('Virtual Tour','winterzone'); ?></h4>
                            <?php echo wp_oembed_get($house_video_tour); ?>
                        </div>

                    <?php } ?>

                    <div class="clearfix"></div>

                    <?php
                        wp_link_pages( array(
                            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'winterzone' ),
                            'after'  => '</div>',
                        ) );
                    ?>
                    <div class="clearfix"></div>

                    <?php if (get_the_tags()) { ?>
                        <div class="single-post-tags">
                            <span><?php echo esc_html__('Tags:','winterzone'); ?></span> <?php echo get_the_term_list( get_the_ID(), 'post_tag', '', ' ' ); ?>
                        </div>
                    <?php } ?>

                    <div class="clearfix"></div>
                                      
                    <!-- COMMENTS -->
                    <?php

                        // If comments are open or we have at least one comment, load up the comment template
                        if ( comments_open() || get_comments_number() ) {
                            comments_template();
                        }
                    ?>
                </div>
            </div>

            <div class="col-md-4 sidebar-content">
                <?php //dynamic_sidebar( winterzone_redux('mt_single_blog_layout_sidebar') ); ?>
                <div class="mt_car--pricings">
                    <div class="">
                        <div class="mt_house--price-container">
                            <?php 
                                $mt_house_price_day = get_post_meta( get_the_ID(), 'mt_house_price_day', true );
                                $mt_house_price_month = get_post_meta( get_the_ID(), 'mt_house_price_month', true );
                                $mt_house_price_for_sale = get_post_meta( get_the_ID(), 'mt_house_price_for_sale', true );

                                // Price per day
                                if(isset($mt_house_price_day) && !empty($mt_house_price_day)){
                                    echo '<div class="mt_car--price-day mt_car--single-price">';
                                        echo '<div class="mt_car--single-price-inner mt_car--single-price-inner-day">';
                                            echo '<span class="priceval">';
                                            if (winterzone_redux('mt_cars_settings_currency_position') == 'left') {
                                                echo winterzone_get_currency_symbol();
                                            }elseif (winterzone_redux('mt_cars_settings_currency_position') == 'left_with_space') {
                                                echo winterzone_get_currency_symbol() . ' ';
                                            }
                                            echo esc_attr($mt_house_price_day) . '</span>' . esc_html__(' Per Day', 'winterzone');
                                            if (winterzone_redux('mt_cars_settings_currency_position') == 'right') {
                                                echo winterzone_get_currency_symbol();
                                            }elseif (winterzone_redux('mt_cars_settings_currency_position') == 'right_with_space') {
                                                echo ' ' . winterzone_get_currency_symbol();
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                }
                                // Price per hour
                                if(isset($mt_house_price_month) && !empty($mt_house_price_month)){
                                    echo '<div class="mt_car--price-hour mt_car--single-price mt_car--single-price-inner-month">';
                                        echo '<div class="mt_car--single-price-inner">';
                                            echo '<span class="priceval">';
                                            if (winterzone_redux('mt_cars_settings_currency_position') == 'left') {
                                                echo winterzone_get_currency_symbol();
                                            }elseif (winterzone_redux('mt_cars_settings_currency_position') == 'left_with_space') {
                                                echo winterzone_get_currency_symbol() . ' ';
                                            }
                                            echo esc_attr($mt_house_price_month) . '</span>' . esc_html__(' Per month', 'winterzone');
                                            if (winterzone_redux('mt_cars_settings_currency_position') == 'right') {
                                                echo winterzone_get_currency_symbol();
                                            }elseif (winterzone_redux('mt_cars_settings_currency_position') == 'right_with_space') {
                                                echo ' ' . winterzone_get_currency_symbol();
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                }
                                // Price per transfer aeroport
                                if(isset($mt_house_price_for_sale) && !empty($mt_house_price_for_sale)){
                                    echo '<div class="mt_car--price-transfer mt_car--single-price mt_car--single-price-inner-sale">';
                                        echo '<div class="mt_car--single-price-inner">';
                                            echo '<span class="priceval">';
                                            if (winterzone_redux('mt_cars_settings_currency_position') == 'left') {
                                                echo winterzone_get_currency_symbol();
                                            }elseif (winterzone_redux('mt_cars_settings_currency_position') == 'left_with_space') {
                                                echo winterzone_get_currency_symbol() . ' ';
                                            }
                                            echo esc_attr($mt_house_price_for_sale) . '</span>' . esc_html__(' For Sale', 'winterzone');
                                            if (winterzone_redux('mt_cars_settings_currency_position') == 'right') {
                                                echo winterzone_get_currency_symbol();
                                            }elseif (winterzone_redux('mt_cars_settings_currency_position') == 'right_with_space') {
                                                echo ' ' . winterzone_get_currency_symbol();
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                }
                            ?>
                        </div>
                    </div>
                </div>

                <!-- Booking Form -->
                <div class="mt_car--booking-form">
                    <?php
                        if(!empty($mt_house_price_day) or !empty($mt_house_price_month) ){
                            echo do_shortcode('[contact-form-7 id="7711" title="Rent Booking Form" html_class="rent_contact_form"]');
                        } else {
                            echo do_shortcode('[contact-form-7 id="7954" title="Sale Booking Form" html_class="sale_contact_form"]');
                        }
                    ?>
                </div>
            </div>
            
        </div>
    </div>
</article>


<div class="row post-details-bottom">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <?php if ( winterzone_redux('mt_enable_related_cars') ) { ?>

                <div class="clearfix"></div>
                <div class="related-posts sticky-posts">
                    <?php
                    global  $post;  
                    $orig_post = $post;  
                    ?>

                    <h2 class="heading-bottom"><?php esc_html_e('Related Equipments', 'winterzone'); ?></h2>
                    <div class="row">
                        <?php 
                        $args=array(  
                            'post__not_in'          => array($post->ID),  
                            'posts_per_page'        => 3, // Number of related posts to display.  
                            'post_type'             => 'mt_house',
                            'post_status'           => 'publish',
                            'ignore_sticky_posts'   => 1  
                        );  

                        $my_query = new wp_query( $args );  

                        while( $my_query->have_posts() ) {  
                            $my_query->the_post(); 
                        
                        ?>  
                            <div class="col-md-4 post">
                                <div class="related_blog_custom">
                                    <?php $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'winterzone_related_post_pic500x300' ); ?>
                                    <?php if($thumbnail_src){ ?>
                                    <a href="<?php esc_url(the_permalink()); ?>" class="relative">
                                        <?php if($thumbnail_src) { ?>
                                            <img src="<?php echo esc_url($thumbnail_src[0]); ?>" class="img-responsive" alt="<?php the_title(); ?>" />
                                        <?php } ?>
                                    </a>
                                    <?php } ?>
                                    <div class="related_blog_details">
                                        <h4 class="post-name"><a href="<?php esc_url(the_permalink()); ?>"><?php the_title(); ?></a></h4>
                                    </div>
                                </div>
                            </div>

                        <?php 
                        } ?>
                    </div>
                </div>
                    <?php 
                    wp_reset_postdata();  
                    ?>  
                <?php } ?>

            </div>
        </div>
    </div>
</div>