<?php
/**
 * The template used for displaying page content in page.php
 *
 */
$post_slug = get_post_field( 'post_name', get_post() );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(esc_attr($post_slug)); ?>>

	<div class="entry-content">
		<?php the_content(); ?>
		
		<div class="clearfix"></div>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'winterzone' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<div class="clearfix"></div>
	<?php edit_post_link( esc_html__( 'Edit', 'winterzone' ), '<span class="edit-link">', '</span>' ); ?>
</article><!-- #post-## -->