<?php
/*-----------------------------------------------------------------------------------*/
/* Start Using Ronby Shortcodes in the Visual Composer */
/*-----------------------------------------------------------------------------------*/
add_action( 'init', 'ronby_vc_shortcodes' );
function ronby_vc_shortcodes() {
//For Woo Products		
$categories_array = array();
if(class_exists( 'WooCommerce' )){
     $product_categories = get_terms(array('taxonomy' => 'product_cat',));
		if($product_categories){
		foreach( $product_categories as $category ) {
			$categories_array[$category->name] = $category->term_id;
		}
		}	 
}
//For blog post	
$blog_categories_array = array();
$get_blog_categories = get_categories();
foreach( $get_blog_categories as $category ){
  $blog_categories_array[$category->name ] = $category->term_id;
}
//create multitple dropdown parameter in vc shortcode	
vc_add_shortcode_param( 'dropdown_multi', 'dropdown_multi_settings_field' );
function dropdown_multi_settings_field( $param, $value ) {
   $param_line = '';
   $param_line .= '<select multiple name="'. esc_attr( $param['param_name'] ).'" class="wpb_vc_param_value wpb-input wpb-select '. esc_attr( $param['param_name'] ).' '. esc_attr($param['type']).'">';
   foreach ( $param['value'] as $text_val => $val ) {
       if ( is_numeric($text_val) && (is_string($val) || is_numeric($val)) ) {
                    $text_val = $val;
                }
                $text_val = __($text_val, "ronby");
                $selected = '';

                if(!is_array($value)) {
                    $param_value_arr = explode(',',$value);
                } else {
                    $param_value_arr = $value;
                }

                if ($value!=='' && in_array($val, $param_value_arr)) {
                    $selected = ' selected="selected"';
                }
                $param_line .= '<option class="'.$val.'" value="'.$val.'"'.$selected.'>'.$text_val.'</option>';
            }
   $param_line .= '</select>';

   return  $param_line;
}
/*****************************
BMI-Weight Calculator Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness BMI-Weight Calculator Section", 'ronby'),
      "base" => "ronby_shortcode_for_bmi_weight_calculator",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows BMI Weight Calculator section.', 'ronby'),
      "params" => array(         
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line One", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line Two", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" => '',
         ),
		 array(
			 "type"        => "checkbox",
			 "heading"     => esc_html__("Enable Animated Headline?"),
			 "param_name"  => "animated_headline",
			 "admin_label" => true,
			 "value"       => array(
							   'Yes'=>'yes',
									), 
			 "description" => ''
		),
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("1st Animated Text", 'ronby'),
            "param_name" => "heading2_anim1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'animated_headline',
				'value' =>'yes',
									
            ),
         ),
		 array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("2nd Animated Text", 'ronby'),
            "param_name" => "heading2_anim2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'animated_headline',
               'value' =>'yes',
            ),
         ),
		 array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("3rd Animated Text", 'ronby'),
            "param_name" => "heading2_anim3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'animated_headline',
               'value' =>'yes',
            ),
         ),
		 array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("4th Animated Text", 'ronby'),
            "param_name" => "heading2_anim4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'animated_headline',
               'value' =>'yes',
            ),
         ),
		 array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("5th Animated Text", 'ronby'),
            "param_name" => "heading2_anim5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'animated_headline',
               'value' =>'yes',
            ),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line Three", 'ronby'),
            "param_name" => "heading3",
            "value" => '',
            "description" => '',
         ),	 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line Three Link URL", 'ronby'),
            "param_name" => "heading3_link",
            "value" => '',
            "description" => '',
         ),		 
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Attach Background Image", 'ronby'),
            "param_name" => "image",
            "value" => '',
            "description" => '',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Overlay Color", 'ronby'),
            "param_name" => "overlay_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Calculator Box Background Color", 'ronby'),
            "param_name" => "calculator_box_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 	 
   )
)
);

/*****************************
Fitness Program Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Program Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_program_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Program Section.', 'ronby'),
      "params" => array(         
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading", 'ronby'),
            "param_name" => "heading",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Which word you want to show in different color from heading?", 'ronby'),
            "param_name" => "heading_dif_colored",
            "value" => '',
            "description" => esc_html__("Use comma(,) for seperate words.", 'ronby'),
         ),
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Description", 'ronby'),
            "param_name" => "desc",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	 
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Attach Image", 'ronby'),
            "param_name" => "image",
            "value" => '',
            "description" => '',
         ),	

		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Feature Box-1 Icon", 'ronby'),
            "param_name" => "feature1_icon",
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),
         ),				
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Feature Box-1 Title", 'ronby'),
            "param_name" => "feature1_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	

		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Feature Box-2 Icon", 'ronby'),
            "param_name" => "feature2_icon",
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),
         ),			
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Feature Box-2 Title", 'ronby'),
            "param_name" => "feature2_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),

		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Feature Box-3 Icon", 'ronby'),
            "param_name" => "feature3_icon",
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),
         ),			
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Feature Box-3 Title", 'ronby'),
            "param_name" => "feature3_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Button Label", 'ronby'),
            "param_name" => "btn_label",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Button URL", 'ronby'),
            "param_name" => "btn_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Icon Color", 'ronby'),
            "param_name" => "icon_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Feature Title Color", 'ronby'),
            "param_name" => "feature_title_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Title Color", 'ronby'),
            "param_name" => "title_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Desc Color", 'ronby'),
            "param_name" => "desc_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Text Color", 'ronby'),
            "param_name" => "btn_text_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Background Color", 'ronby'),
            "param_name" => "btn_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Section Background Color", 'ronby'),
            "param_name" => "bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Section Padding Top", 'ronby'),
            "param_name" => "padding_top",
            "value" => '',
            "description" =>  esc_html__("Example:50px", 'ronby'),
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Section Padding Bottom", 'ronby'),
            "param_name" => "padding_bottom",
            "value" => '',
            "description" =>  esc_html__("Example:50px", 'ronby'),
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Border Animation", 'ronby'),
            "param_name" => "border_animation",
            "value" => array('Yes'=>'yes'),
            "description" =>  esc_html__("", 'ronby'),
            "group" => 'Design-Options',
         ),			 
   )
)
);

/*****************************
Fitness Heading Section- 1
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Heading Section- 1", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_heading_section_one",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Heading Section.', 'ronby'),
      "params" => array(         
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line 1", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Which word you want to show in different color from heading line 1?", 'ronby'),
            "param_name" => "heading1_dif_colored",
            "value" => '',
            "description" => esc_html__("Use comma(,) for seperate words.", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line 2", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Which word you want to show in different color from heading line 2?", 'ronby'),
            "param_name" => "heading2_dif_colored",
            "value" => '',
            "description" => esc_html__("Use comma(,) for seperate words.", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line 3", 'ronby'),
            "param_name" => "heading3",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Description", 'ronby'),
            "param_name" => "desc",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		array(
			 "type"        => "checkbox",
			 "heading"     => esc_html__("Do you want up arrow Icon?"),
			 "param_name"  => "up_arrow_icon",
			 "admin_label" => true,
			 "value"       => array(
							   'Style-1'=>'style1',
							   'Style-2'=>'style2',
							   'Style-3'=>'style3',
							   'Style-4'=>'style4',
									), 
			 "description" => ''
			  ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Padding Top", 'ronby'),
            "param_name" => "padding_top",
            "value" => '',
            "description" =>  esc_html__('Example: 30px', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Padding Bottom", 'ronby'),
            "param_name" => "padding_bottom",
            "value" => '',
            "description" =>  esc_html__('Example: 30px', 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading One Color", 'ronby'),
            "param_name" => "heading1_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading Two Color", 'ronby'),
            "param_name" => "heading2_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading Three Color", 'ronby'),
            "param_name" => "heading3_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),			 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Description Color", 'ronby'),
            "param_name" => "desc_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),			 
   )
)
);

/******************* 
Price Table 3 Section
********************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Price Table- 1", 'ronby'),
      "base" => "ronby_shortcodes_for_price_table_one",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows the Price Table', 'ronby'),
      "params" => array(
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Plan Name", 'ronby'),
            "param_name" => "plan_name",
            "value" => '',
            "description" => ''
         ),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Plan Currency", 'ronby'),
            "param_name" => "plan_currency",
            "value" => '',
            "description" => ''
         ),
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Plan Price", 'ronby'),
            "param_name" => "plan_price",
            "value" => '',
            "description" => ''
         ),
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Plan Duration", 'ronby'),
            "param_name" => "plan_duration",
            "value" => '',
            "description" => 'Enter here Plan Duration(e.g. Monthly or Yearly)'
         ),
		array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Plan Header Background Image", 'ronby'),
            "param_name" => "plan_header_bg_image",
            "value" => '',
            "description" => ''
         ),	
		array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Plan Body Background Image", 'ronby'),
            "param_name" => "plan_body_bg_image",
            "value" => '',
            "description" => ''
         ),			 
		array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Plan Card Image", 'ronby'),
            "param_name" => "plan_card_image",
            "value" => '',
            "description" => ''
         ),			 
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Plan Features", 'ronby'),
            "param_name" => "plan_features",
            "value" => '',
            "description" => 'Enter here per Plan Feature per line.'
         ),  
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Plan Button Name", 'ronby'),
            "param_name" => "plan_btn_name",
            "value" => '',
            "description" => ''
         ),  
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Plan Button URL", 'ronby'),
            "param_name" => "plan_btn_url",
            "value" => '',
            "description" => ''
         ),
 		 
		array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Plan Header Overlay Color", 'ronby'),
            "param_name" => "plan_header_overlay_color",
            "value" => '',
            "description" => ''
         ),	
		array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Plan Currency Color", 'ronby'),
            "param_name" => "plan_currency_color",
            "value" => '',
            "description" => ''
         ),
		array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Plan Price Color", 'ronby'),
            "param_name" => "plan_price_color",
            "value" => '',
            "description" => ''
         ),	
		array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Plan Name Color", 'ronby'),
            "param_name" => "plan_name_color",
            "value" => '',
            "description" => ''
         ),	
	 
		array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Plan Duration Color", 'ronby'),
            "param_name" => "plan_duration_color",
            "value" => '',
            "description" => ''
         ),		 
		array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Plan Button Text Color", 'ronby'),
            "param_name" => "plan_btn_text_color",
            "value" => '',
            "description" => ''
         ),			 
		array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Plan Button Background Color", 'ronby'),
            "param_name" => "plan_btn_bg_color",
            "value" => '',
            "description" => ''
         ),	
		 
   )
)
);

/******************* 
Time Table 
********************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Time Table", 'ronby'),
      "base" => "ronby_shortcode_for_data_table",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows the Time Table', 'ronby'),
      "params" => array(
	  
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Column-1 Title", 'ronby'),
            "param_name" => "column_title_1",
            "value" => '',
            "description" => ''
         ), 
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Column-2 Title", 'ronby'),
            "param_name" => "column_title_2",
            "value" => '',
            "description" => ''
         ), 
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Column-3 Title", 'ronby'),
            "param_name" => "column_title_3",
            "value" => '',
            "description" => ''
         ), 
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Column-4 Title", 'ronby'),
            "param_name" => "column_title_4",
            "value" => '',
            "description" => ''
         ), 
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Column-5 Title", 'ronby'),
            "param_name" => "column_title_5",
            "value" => '',
            "description" => ''
         ), 
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Column-6 Title", 'ronby'),
            "param_name" => "column_title_6",
            "value" => '',
            "description" => ''
         ), 
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Column-7 Title", 'ronby'),
            "param_name" => "column_title_7",
            "value" => '',
            "description" => ''
         ), 	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Column-8 Title", 'ronby'),
            "param_name" => "column_title_8",
            "value" => '',
            "description" => ''
         ), 		 
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Column Title Color", 'ronby'),
            "param_name" => "column_title_color",
            "value" => '',
            "description" => ''
         ), 

       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Column Background Color", 'ronby'),
            "param_name" => "column_bg_color",
            "value" => '',
            "description" => ''
         ), 
		 
		array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__("Number of Rows", 'ronby'),
					"param_name" => "number_of_rows",
					'admin_label' => true,
					"description" => esc_html__("You have to select minimum Two rows to display the prices.", 'ronby'),
					"value" => array(
					   esc_html__('One', 'ronby')=>'1',
					   esc_html__('Two', 'ronby')=>'2',
					   esc_html__('Three', 'ronby')=>'3',
					   esc_html__('Four', 'ronby')=>'4',
					   esc_html__('Five', 'ronby')=>'5',
					   esc_html__('Six', 'ronby')=>'6',
					   esc_html__('Seven', 'ronby')=>'7',
					   esc_html__('Eight', 'ronby')=>'8',
					   esc_html__('Nine', 'ronby')=>'9',
					   esc_html__('Ten', 'ronby')=>'10',
					   esc_html__('Eleven', 'ronby')=>'11',
					   esc_html__('Twelve', 'ronby')=>'12',
					   esc_html__('Thirteen', 'ronby')=>'13',
					   esc_html__('Fourteen', 'ronby')=>'14',
					   esc_html__('Fifteen', 'ronby')=>'15',
					)
				 ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 1 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 2 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 3 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 4 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),		
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 5 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),		
		 array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 6 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),		
		          array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 7 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),		
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 8 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('8',
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),		
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 9 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '9',
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),		
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10  Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 10 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '10',
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),		
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 11 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color11",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '11',
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),		
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 12 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color12",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '12',
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 13 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color13",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '13',
                                '14',
                                '15',
                        )
            )
         ),		 
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '14',
                                '15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( 
                                '14',
                                '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '14',
                                '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 14 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color14",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '14',
                                '15',
                        )
            )
         ),	
		          array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 1 Text", 'ronby'),
            "param_name" => "col1_text15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '15',
                        )
            )
         ),
		 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 1 Text Color", 'ronby'),
            "param_name" => "col1_text_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 1 Background Color", 'ronby'),
            "param_name" => "col1_bg_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '15',
                        )
            )
         ),	
		 		 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 2 Text", 'ronby'),
            "param_name" => "col2_text15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 2 Text Color", 'ronby'),
            "param_name" => "col2_text_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 2 Background Color", 'ronby'),
            "param_name" => "col2_bg_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 3 Text", 'ronby'),
            "param_name" => "col3_text15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 3 Text Color", 'ronby'),
            "param_name" => "col3_text_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 3 Background Color", 'ronby'),
            "param_name" => "col3_bg_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 4 Text", 'ronby'),
            "param_name" => "col4_text15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 4 Text Color", 'ronby'),
            "param_name" => "col4_text_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 4 Background Color", 'ronby'),
            "param_name" => "col4_bg_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '15',
                        )
            )
         ),	
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 5 Text", 'ronby'),
            "param_name" => "col5_text15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 5 Text Color", 'ronby'),
            "param_name" => "col5_text_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array( '15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 5 Background Color", 'ronby'),
            "param_name" => "col5_bg_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 6 Text", 'ronby'),
            "param_name" => "col6_text15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 6 Text Color", 'ronby'),
            "param_name" => "col6_text_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 6 Background Color", 'ronby'),
            "param_name" => "col6_bg_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),			 
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 7 Text", 'ronby'),
            "param_name" => "col7_text15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(  '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 7 Text Color", 'ronby'),
            "param_name" => "col7_text_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 7 Background Color", 'ronby'),
            "param_name" => "col7_bg_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 8 Text", 'ronby'),
            "param_name" => "col8_text15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array(  '15',
                        )
            )
         ),	 

         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 8 Text Color", 'ronby'),
            "param_name" => "col8_text_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Row 15 Column- 8 Background Color", 'ronby'),
            "param_name" => "col8_bg_color15",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_rows',
               'value' => array('15',
                        )
            )
         ),		
 		 
		 
   )
)
);

/*****************************
Fitness Featured class
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Featured Class", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_featured_class",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Featured Class.', 'ronby'),
      "params" => array(         
		 array(
			 "type"        => "checkbox",
			 "heading"     => esc_html__("Section Style", 'ronby'),
			 "param_name"  => "cls_style",
			 "admin_label" => true,
			 "value"       => array(
							   'Style-1 (Default)'=>'style1',
							   'Style-2'=>'style2',
									), 
			 "description" => ''
			  ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Title", 'ronby'),
            "param_name" => "title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Class Details", 'ronby'),
            "param_name" => "cls_details",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Instructor Name", 'ronby'),
            "param_name" => "instructor_name",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Start Date", 'ronby'),
            "param_name" => "start_date",
            "value" => '',
            "description" =>  esc_html__("For Style-1 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Start Time", 'ronby'),
            "param_name" => "start_time",
            "value" => '',
            "description" =>  esc_html__("For Style-1 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Day 1", 'ronby'),
            "param_name" => "day1",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Time 1", 'ronby'),
            "param_name" => "time1",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Day 2", 'ronby'),
            "param_name" => "day2",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Time 2", 'ronby'),
            "param_name" => "time2",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Day 3", 'ronby'),
            "param_name" => "day3",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Time 3", 'ronby'),
            "param_name" => "time3",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Day 4", 'ronby'),
            "param_name" => "day4",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Time 4", 'ronby'),
            "param_name" => "time4",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Day 5", 'ronby'),
            "param_name" => "day5",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Schedule Time 5", 'ronby'),
            "param_name" => "time5",
            "value" => '',
            "description" =>  esc_html__("For Style-2 Only", 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Price", 'ronby'),
            "param_name" => "price",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Duration", 'ronby'),
            "param_name" => "price_duration",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Link to URL", 'ronby'),
            "param_name" => "link_to_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Featured Image", 'ronby'),
            "param_name" => "image",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Instructor Name Color", 'ronby'),
            "param_name" => "instructor_name_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Class Title Color", 'ronby'),
            "param_name" => "class_title_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Class Details Color", 'ronby'),
            "param_name" => "cls_details_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Start Date Color", 'ronby'),
            "param_name" => "start_date_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Start Date Info Color", 'ronby'),
            "param_name" => "start_date_info_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Price Background Color", 'ronby'),
            "param_name" => "price_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Class Info Box Background Color", 'ronby'),
            "param_name" => "class_info_box_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 
   )
)
);

/*****************************
Fitness Counter Box Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Counter Box Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_counter_box_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Counter Box Section.', 'ronby'),
      "params" => array(         

       array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Number of Counter Box", 'ronby'),
            "param_name" => "number_of_counter_box",
            'admin_label' => true,
            "value" => array(
               esc_html__('One', 'ronby')=>'1',
               esc_html__('Two', 'ronby')=>'2',
               esc_html__('Three', 'ronby')=>'3',
               esc_html__('Four', 'ronby')=>'4',
               esc_html__('Five', 'ronby')=>'5',
               esc_html__('Six', 'ronby')=>'6',
               esc_html__('Seven', 'ronby')=>'7',
               esc_html__('Eight', 'ronby')=>'8',
            )
         ),	 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 1 Counter Number", 'ronby'),
            "param_name" => "counter_number1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 1 Counter Title", 'ronby'),
            "param_name" => "counter_title1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 2 Counter Number", 'ronby'),
            "param_name" => "counter_number2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 2 Counter Title", 'ronby'),
            "param_name" => "counter_title2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 3 Counter Number", 'ronby'),
            "param_name" => "counter_number3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-3 Counter Title", 'ronby'),
            "param_name" => "counter_title3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 4 Counter Number", 'ronby'),
            "param_name" => "counter_number4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-4 Counter Title", 'ronby'),
            "param_name" => "counter_title4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 5 Counter Number", 'ronby'),
            "param_name" => "counter_number5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-5 Counter Title", 'ronby'),
            "param_name" => "counter_title5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 6 Counter Number", 'ronby'),
            "param_name" => "counter_number6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '6',
                                '7',
                                '8',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-6 Counter Title", 'ronby'),
            "param_name" => "counter_title6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '6',
                                '7',
                                '8',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 7 Counter Number", 'ronby'),
            "param_name" => "counter_number7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '7',
                                '8',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-7 Counter Title", 'ronby'),
            "param_name" => "counter_title7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '7',
                                '8',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box- 8 Counter Number", 'ronby'),
            "param_name" => "counter_number8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '8',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-8 Counter Title", 'ronby'),
            "param_name" => "counter_title8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_counter_box',
               'value' => array(
                                '8',
                        )
            )
         ),	
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Background Image", 'ronby'),
            "param_name" => "counter_sec_bg_img",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		array(
			 "type"        => "checkbox",
			 "heading"     => esc_html__("Do you want up arrow Icon?"),
			 "param_name"  => "up_arrow_icon",
			 "admin_label" => true,
			 "value"       => array(
							   'Style-1'=>'style1',
							   'Style-2'=>'style2',
							   'Style-3'=>'style3',
							   'Style-4'=>'style4',
									), 
			 "description" => ''
			  ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Counter Box Background Color", 'ronby'),
            "param_name" => "counter_box_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Counter Box Number Color", 'ronby'),
            "param_name" => "counter_box_number_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Counter Box Title Color", 'ronby'),
            "param_name" => "counter_box_title_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Counter Box Overlay Color", 'ronby'),
            "param_name" => "counter_sec_overlay_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),			 
   )
)
);

/******************************************
Fitness Woocommerce Products Section
*******************************************/
		
vc_map( array(
      "name" => esc_html__("FT- Fitness Woocommerce Products Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_woo_products_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Category wise Products.', 'ronby'),
      "params" => array(
	
       array(
        "type" => "dropdown",
        "heading" => esc_html__("Which Category Products do you want to display?", 'ronby'),
        "param_name" => "cat_id",
        "value" => $categories_array,
        "description" => '',
		"group" => '',
    ),

        array(
          'param_name'    => 'order',
          'type'          => 'dropdown',
          'value' => array(
                    array(
                    'value' => 'DESC',
                    'label' => esc_html__( 'DESCENDING', 'ronby' ),
                    ),
                    array(
                    'value' => 'ASC',
                    'label' => esc_html__( 'ASCENDING', 'ronby' ),
                    ),
                    ),
          'heading'       => esc_html__('Order', 'ronby'),
          'description'   => 'Select the post order(ASC or DESC). By default is DESCENDING Order',
          'class'         => ''
        ),
        array(
          'param_name'    => 'orderby',
          'type'          => 'dropdown',
          'value' => array(
                    array(
                    'value' => 'date',
                    'label' => esc_html__( 'Date', 'ronby' ),
                    ),
                    array(
                    'value' => 'title',
                    'label' => esc_html__( 'Title', 'ronby' ),
                    ),
					array(
                    'value' => 'id',
                    'label' => esc_html__( 'ID', 'ronby' ),
                    ),
                    ),
          'heading'       => esc_html__('Order By', 'ronby'),
          'description'   => 'Select the post Sorting. By default is Orderby Date.',
          'class'         => ''
        ),	
			

       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("How many Products want to display?", 'ronby'),
            "param_name" => "post_per_page",
            "value" => '',
            "description" => 'By default is set to all.'
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Product Box Background Color", 'ronby'),
            "param_name" => "box_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Product Box Border Color", 'ronby'),
            "param_name" => "border_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Product Box Middle Border Color", 'ronby'),
            "param_name" => "middle_border_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Badge Background Color", 'ronby'),
            "param_name" => "badge_bg",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Badge Text Color", 'ronby'),
            "param_name" => "badge_text_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "checkbox",            
            "class" => "",
            "heading" => esc_html__("Dashed Border", 'ronby'),
            "param_name" => "dashed_border",
            "value" => array(
					'yes'=>'yes',
			),
            "description" => '',
            "group" => 'Design-Options',
         ),			 
   )
)
);

/*****************************
Fitness Trainers Profile Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Trainers Profile Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_trainers_profile",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Trainers Profile section.', 'ronby'),
      "params" => array(         
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Name", 'ronby'),
            "param_name" => "lead_trainer_name",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Designation", 'ronby'),
            "param_name" => "lead_trainer_designation",
            "value" => '',
            "description" => '',
         ),
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Short Description", 'ronby'),
            "param_name" => "lead_trainer_description",
            "value" => '',
            "description" => '',
         ),	 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Facebook URL", 'ronby'),
            "param_name" => "lead_trainer_fb_url",
            "value" => '',
            "description" => '',
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Twitter URL", 'ronby'),
            "param_name" => "lead_trainer_twitter_url",
            "value" => '',
            "description" => '',
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Linkedin URL", 'ronby'),
            "param_name" => "lead_trainer_linkedin_url",
            "value" => '',
            "description" => '',
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Pinterest URL", 'ronby'),
            "param_name" => "lead_trainer_pinterest_url",
            "value" => '',
            "description" => '',
         ),		 
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Profile Image", 'ronby'),
            "param_name" => "lead_trainer_img",
            "value" => '',
            "description" => '',
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Link To URL", 'ronby'),
            "param_name" => "lead_trainer_link",
            "value" => '',
            "description" => '',
         ),			 
         array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Number of Trainers", 'ronby'),
            "param_name" => "number_of_members",
            'admin_label' => true,
			"description" => esc_html__("Select minimum Two members.", 'ronby'),
            "value" => array(
               esc_html__('One', 'ronby')=>'1',
               esc_html__('Two', 'ronby')=>'2',
               esc_html__('Three', 'ronby')=>'3',
               esc_html__('Four', 'ronby')=>'4',
               esc_html__('Five', 'ronby')=>'5',
               esc_html__('Six', 'ronby')=>'6',
               esc_html__('Seven', 'ronby')=>'7',
               esc_html__('Eight', 'ronby')=>'8',
               esc_html__('Nine', 'ronby')=>'9',
               esc_html__('Ten', 'ronby')=>'10',
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Name", 'ronby'),
            "param_name" => "trainer_name1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Designation", 'ronby'),
            "param_name" => "trainer_designation1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Phone", 'ronby'),
            "param_name" => "trainer_phone1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Email", 'ronby'),
            "param_name" => "trainer_email1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Image URL", 'ronby'),
            "param_name" => "trainer_img_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Link URL", 'ronby'),
            "param_name" => "trainer_link_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	

         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Name", 'ronby'),
            "param_name" => "trainer_name2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Designation", 'ronby'),
            "param_name" => "trainer_designation2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Phone", 'ronby'),
            "param_name" => "trainer_phone2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Email", 'ronby'),
            "param_name" => "trainer_email2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Image URL", 'ronby'),
            "param_name" => "trainer_img_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-2 Link URL", 'ronby'),
            "param_name" => "trainer_link_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Name", 'ronby'),
            "param_name" => "trainer_name3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Designation", 'ronby'),
            "param_name" => "trainer_designation3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Phone", 'ronby'),
            "param_name" => "trainer_phone3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Email", 'ronby'),
            "param_name" => "trainer_email3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Image URL", 'ronby'),
            "param_name" => "trainer_img_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-3 Link URL", 'ronby'),
            "param_name" => "trainer_link_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Name", 'ronby'),
            "param_name" => "trainer_name4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Designation", 'ronby'),
            "param_name" => "trainer_designation4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Phone", 'ronby'),
            "param_name" => "trainer_phone4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Email", 'ronby'),
            "param_name" => "trainer_email4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Image URL", 'ronby'),
            "param_name" => "trainer_img_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-4 Link URL", 'ronby'),
            "param_name" => "trainer_link_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Name", 'ronby'),
            "param_name" => "trainer_name5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Designation", 'ronby'),
            "param_name" => "trainer_designation5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Phone", 'ronby'),
            "param_name" => "trainer_phone5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Email", 'ronby'),
            "param_name" => "trainer_email5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Image URL", 'ronby'),
            "param_name" => "trainer_img_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-5 Link URL", 'ronby'),
            "param_name" => "trainer_link_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Name", 'ronby'),
            "param_name" => "trainer_name6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Designation", 'ronby'),
            "param_name" => "trainer_designation6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Phone", 'ronby'),
            "param_name" => "trainer_phone6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Email", 'ronby'),
            "param_name" => "trainer_email6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Image URL", 'ronby'),
            "param_name" => "trainer_img_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-6 Link URL", 'ronby'),
            "param_name" => "trainer_link_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Name", 'ronby'),
            "param_name" => "trainer_name7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Designation", 'ronby'),
            "param_name" => "trainer_designation7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Phone", 'ronby'),
            "param_name" => "trainer_phone7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Email", 'ronby'),
            "param_name" => "trainer_email7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Image URL", 'ronby'),
            "param_name" => "trainer_img_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-7 Link URL", 'ronby'),
            "param_name" => "trainer_link_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Name", 'ronby'),
            "param_name" => "trainer_name8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Designation", 'ronby'),
            "param_name" => "trainer_designation8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Phone", 'ronby'),
            "param_name" => "trainer_phone8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Email", 'ronby'),
            "param_name" => "trainer_email8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('8',
                                '9',
                                '10',
                        )
            )
         ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Image URL", 'ronby'),
            "param_name" => "trainer_img_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array( '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('8',
                                '9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-8 Link URL", 'ronby'),
            "param_name" => "trainer_link_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Name", 'ronby'),
            "param_name" => "trainer_name9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Designation", 'ronby'),
            "param_name" => "trainer_designation9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Phone", 'ronby'),
            "param_name" => "trainer_phone9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Email", 'ronby'),
            "param_name" => "trainer_email9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('9',
                                '10',
                        )
            )
         ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Image URL", 'ronby'),
            "param_name" => "trainer_img_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('9',
                                '10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-9 Link URL", 'ronby'),
            "param_name" => "trainer_link_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-10 Name", 'ronby'),
            "param_name" => "trainer_name10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-10 Designation", 'ronby'),
            "param_name" => "trainer_designation10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-10 Phone", 'ronby'),
            "param_name" => "trainer_phone10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-10 Email", 'ronby'),
            "param_name" => "trainer_email10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('10',
                        )
            )
         ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-10 Image URL", 'ronby'),
            "param_name" => "trainer_img_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-1 Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-10 Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-10 Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-10 Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('10',
                        )
            )
         ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Trainer-10 Link URL", 'ronby'),
            "param_name" => "trainer_link_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Name Color", 'ronby'),
            "param_name" => "lead_trainer_name_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Designation Color", 'ronby'),
            "param_name" => "lead_trainer_designation_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),			 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Name Color", 'ronby'),
            "param_name" => "trainer_name_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),
 		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Designation Color", 'ronby'),
            "param_name" => "trainer_designation_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	 
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Description Color", 'ronby'),
            "param_name" => "trainer_description_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Phone Color", 'ronby'),
            "param_name" => "trainer_phone_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Email Color", 'ronby'),
            "param_name" => "trainer_email_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Icon Color", 'ronby'),
            "param_name" => "trainer_icon_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Lead Trainer Overlay Color", 'ronby'),
            "param_name" => "lead_overlay_background_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		array(
			 "type"        => "checkbox",
			 "heading"     => esc_html__("Do you want up arrow Icon?"),
			 "param_name"  => "up_arrow_icon",
			 "admin_label" => true,
			 "value"       => array(
							   'Style-1'=>'style1',
							   'Style-2'=>'style2',
							   'Style-3'=>'style3',
							   'Style-4'=>'style4',
									), 
			 "description" => '',
			 "group" => 'Design-Options',
			  ),
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Box Border Color", 'ronby'),
            "param_name" => "border_c",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Box Background Color", 'ronby'),
            "param_name" => "box_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Box Margin Top", 'ronby'),
            "param_name" => "box_margin_top",
            "value" => '',
            "description" => 'Example: 50px',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Box Margin Bottom", 'ronby'),
            "param_name" => "box_margin_bottom",
            "value" => '',
            "description" => 'Example: 50px',
            "group" => 'Design-Options',
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Box Phone and Email Icon Padding Left", 'ronby'),
            "param_name" => "icon_p_left",
            "value" => '',
            "description" => 'Example: 50px',
            "group" => 'Design-Options',
         ),			 
   )
)
);

/*****************************
Fitness Blog Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Blog Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_blog_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Blog section.', 'ronby'),
      "params" => array(         

		array(
        "type" => "dropdown_multi",
        "heading" => esc_html__("Which Category Post do you want to display?", 'ronby'),
        "param_name" => "multiple",
        "value" => $blog_categories_array,
        "description" => esc_html__( 'Press ctrl+A command to select all categories', 'ronby' ),
		),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("How many post do you want to display?", 'ronby'),
            "param_name" => "num_post",
            "value" => '',
            "description" => esc_html__( 'Enter nemeric value. By default, All post will display.', 'ronby' ),
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("How many words do you want to display?", 'ronby'),
            "param_name" => "character",
            "value" => '',
            "description" => esc_html__( 'Enter nemeric value.', 'ronby' ),
         ),
        array(
          'param_name'    => 'order',
          'type'          => 'dropdown',
          'value' => array(
                    array(
                    'value' => 'DESC',
                    'label' => esc_html__( 'DESC', 'ronby' ),
                    ),
                    array(
                    'value' => 'ASC',
                    'label' => esc_html__( 'ASC', 'ronby' ),
                    ),
                    ),
          'heading'       => esc_html__('Order', 'ronby'),
          'description'   => 'Select the post order(ASC or DESC). By default is DESC Order',
          'class'         => ''
        ),
        array(
          'param_name'    => 'orderby',
          'type'          => 'dropdown',
          'value' => array(
                    array(
                    'value' => 'date',
                    'label' => esc_html__( 'Date', 'ronby' ),
                    ),
                    array(
                    'value' => 'title',
                    'label' => esc_html__( 'Title', 'ronby' ),
                    ),
                    array(
                    'value' => 'rand',
                    'label' => esc_html__( 'Random', 'ronby' ),
                    ),
                    array(
                    'value' => 'id',
                    'label' => esc_html__( 'ID', 'ronby' ),
                    ),
                    array(
                    'value' => 'author',
                    'label' => esc_html__( 'Author', 'ronby' ),
                    ),
                    array(
                    'value' => 'comment_count',
                    'label' => esc_html__( 'Comment count', 'ronby' ),
                    ),
                    array(
                    'value' => 'menu_order',
                    'label' => esc_html__( 'Menu order', 'ronby' ),
                    ),
                    array(
                    'value' => 'modified',
                    'label' => esc_html__( 'Modified', 'ronby' ),
                    ),
                    array(
                    'value' => 'parent',
                    'label' => esc_html__( 'Parent', 'ronby' ),
                    ),
                    ),
          'heading'       => esc_html__('Sort Post By Order', 'ronby'),
          'description'   => 'By default is Order By Date',
          'class'         => ''
        ),		 
			  
   )
)
);

/*****************************
Fitness Brand Slider Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Brand Slider Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_brand_slider",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Blog section.', 'ronby'),
      "params" => array(         

        array(
            "type" => "attach_images",
            "class" => "",
            "heading" => esc_html__("Slider Images", 'ronby'),
            "param_name" => "images",
            "value" => '',
            "description" => '',
         ),
		array(
			 "type"        => "checkbox",
			 "heading"     => esc_html__("Do you want up arrow Icon?"),
			 "param_name"  => "up_arrow_icon",
			 "admin_label" => true,
			 "value"       => array(
							   'Style-1'=>'style1',
							   'Style-2'=>'style2',
							   'Style-3'=>'style3',
							   'Style-4'=>'style4',
									), 
			 "description" => ''
			  ),		 
        array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Background Color", 'ronby'),
            "param_name" => "background_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Padding Top", 'ronby'),
            "param_name" => "padding_top",
            "value" => '',
            "description" => esc_html__("Example:50px", 'ronby'),
            "group" => 'Design-Options',
         ),		
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Padding Bottom", 'ronby'),
            "param_name" => "padding_bottom",
            "value" => '',
            "description" => esc_html__("Example:50px", 'ronby'),
            "group" => 'Design-Options',
         ),			 
   )
)
);

/*****************************
Fitness Class Details
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Class Details", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_class_details",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Class Details.', 'ronby'),
      "params" => array(         

		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Price", 'ronby'),
            "param_name" => "price",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Price Duration", 'ronby'),
            "param_name" => "price_duration",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Instructor Name", 'ronby'),
            "param_name" => "instructor_name",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Class Title", 'ronby'),
            "param_name" => "class_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Start Date", 'ronby'),
            "param_name" => "start_date",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Start Time", 'ronby'),
            "param_name" => "start_time",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Description", 'ronby'),
            "param_name" => "description",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("List Heading", 'ronby'),
            "param_name" => "list_heading",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("List Items", 'ronby'),
            "param_name" => "list_items",
            "value" => '',
            "description" =>  esc_html__('Each item must be in new line.', 'ronby'),
         ),		
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Short Description at the bottom", 'ronby'),
            "param_name" => "short_description",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Button Label", 'ronby'),
            "param_name" => "btn_label",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Button URL", 'ronby'),
            "param_name" => "btn_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Featured Image", 'ronby'),
            "param_name" => "image",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Instructor Name Color", 'ronby'),
            "param_name" => "instructor_name_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Class Title Color", 'ronby'),
            "param_name" => "class_title_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Start Date Color", 'ronby'),
            "param_name" => "start_date_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Start Date Info Color", 'ronby'),
            "param_name" => "start_date_info_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Price Background Color", 'ronby'),
            "param_name" => "price_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Background Color", 'ronby'),
            "param_name" => "btn_background_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Text Color", 'ronby'),
            "param_name" => "btn_text_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 
   )
)
);

/*****************************
Fitness Contact Info
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Contact Info", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_contact_info",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows contact info.', 'ronby'),
      "params" => array(  
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Map Address", 'ronby'),
            "param_name" => "map_address",
            "value" => '',
            "description" => 'Example: Victoria 3000 Australia'
         ),
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Map Height", 'ronby'),
            "param_name" => "map_height",
            "value" => '',
            "description" => 'Enter here Height in pixel(e.g. 350px). By default is set to 480px.'
         ),		  
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line", 'ronby'),
            "param_name" => "headline",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Short Description", 'ronby'),
            "param_name" => "short_description",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Facebook URL", 'ronby'),
            "param_name" => "facebook_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Twitter URL", 'ronby'),
            "param_name" => "twitter_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Linkedin URL", 'ronby'),
            "param_name" => "linkedin_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Pinterest URL", 'ronby'),
            "param_name" => "pinterest_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Email", 'ronby'),
            "param_name" => "email",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Phone", 'ronby'),
            "param_name" => "phone",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Fax", 'ronby'),
            "param_name" => "fax",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Address", 'ronby'),
            "param_name" => "address",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Headline Color", 'ronby'),
            "param_name" => "headline_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Short Description Color", 'ronby'),
            "param_name" => "short_description_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Information Title Color", 'ronby'),
            "param_name" => "information_title_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Information Details Color", 'ronby'),
            "param_name" => "information_details_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 
   )
)
);

/*****************************
Fitness Contact Form
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Contact Form", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_fitness_contact_form",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Contact Form.', 'ronby'),
      "params" => array(      
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Headline One", 'ronby'),
					"param_name" => "headline_one",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Headline Two", 'ronby'),
					"param_name" => "headline_two",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),				 
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Recipient Name", 'ronby'),
					"param_name" => "recipient_name",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Recipient Email", 'ronby'),
					"param_name" => "recipient_email",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Email Subject", 'ronby'),
					"param_name" => "email_subject",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Name Field Placeholder", 'ronby'),
					"param_name" => "name_field_placeholder",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Email Field Placeholder", 'ronby'),
					"param_name" => "email_field_placeholder",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),		
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Problem Field Placeholder", 'ronby'),
					"param_name" => "problem_field_placeholder",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Message Field Placeholder", 'ronby'),
					"param_name" => "message_field_placeholder",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Button Label", 'ronby'),
					"param_name" => "button_label",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
                 array(
					"type" => "checkbox",
					"class" => "",
					"heading" => esc_html__("Do you want Select options?", 'ronby'),
					"param_name" => "wanttoselect",
					"std"		=> "no",
					"value" => array(
						//Label => Value
						"Yes" => "yes"
					),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Placeholder For Select", 'ronby'),
					"param_name" => "yourselect",
					"value" => 'Select One',
					'dependency' => array(
						 'element' => 'wanttoselect',
						 'value' =>'yes',
					 ),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Add items comma separated", 'ronby'),
					"param_name" => "selectitems",
					"value" => 'One, Two, Three, Four, Five',
					'dependency' => array(
						 'element' => 'wanttoselect',
						 'value' =>'yes',
					 ),
					"description" => 'Add items comma separated with a space like One, Two, Three, Four, Five'
				 ),
				 array(
					"type" => "checkbox",
					"class" => "",
					"heading" => esc_html__("Do you want Radio options?", 'ronby'),
					"param_name" => "wanttoradio",
					"std"		=> "no",
					"value" => array(
						//Label => Value
						"Yes" => "yes"
					),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Placeholder For Radio", 'ronby'),
					"param_name" => "yourradio",
					"value" => 'Select Radio',
					'dependency' => array(
						 'element' => 'wanttoradio',
						 'value' =>'yes',
					 ),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Add radio items comma separated", 'ronby'),
					"param_name" => "radioitems",
					"value" => 'One, Two, Three, Four, Five',
					'dependency' => array(
						 'element' => 'wanttoradio',
						 'value' =>'yes',
					 ),
					"description" => 'Add radio items comma separated with a space like One, Two, Three, Four, Five'
				 ),
				 array(
					"type" => "checkbox",
					"class" => "",
					"heading" => esc_html__("Do you want Checkbox options?", 'ronby'),
					"param_name" => "wanttocheckbox",
					"std"		=> "no",
					"value" => array(
						//Label => Value
						"Yes" => "yes"
					),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Placeholder For Checkbox", 'ronby'),
					"param_name" => "yourcheckbox",
					"value" => 'Select Checkbox',
					'dependency' => array(
						 'element' => 'wanttocheckbox',
						 'value' =>'yes',
					 ),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Add checkbox items comma separated", 'ronby'),
					"param_name" => "checkboxitems",
					"value" => 'One, Two, Three, Four, Five',
					'dependency' => array(
						 'element' => 'wanttocheckbox',
						 'value' =>'yes',
					 ),
					"description" => 'Add checkbox items comma separated with a space like One, Two, Three, Four, Five'
				 ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Headline One Color", 'ronby'),
            "param_name" => "headline_one_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Headline Two Color", 'ronby'),
            "param_name" => "headline_two_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
			"group" =>  esc_html__('Design-Options', 'ronby'),
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Text Color", 'ronby'),
            "param_name" => "btn_text_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
			"group" =>  esc_html__('Design-Options', 'ronby'),
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Background Color", 'ronby'),
            "param_name" => "btn_bg_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
			"group" =>  esc_html__('Design-Options', 'ronby'),
         ),			 
   )
)
);

/*****************************
Page Header Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Page Header Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_page_header_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Page Header section.', 'ronby'),
      "params" => array(         

			array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Page Header Style", 'ronby'),
            "param_name" => "page_header_style",
			'value' => array(
			        array(
                    'value' => '1',
                    'label' => esc_html__( 'Style 1', 'ronby' ),
                    ),
                    array(
                    'value' => '2',
                    'label' => esc_html__( 'Style 2', 'ronby' ),
                    ),
                    array(
                    'value' => '3',
                    'label' => esc_html__( 'Style 3', 'ronby' ),
                    ),
                    array(
                    'value' => '4',
                    'label' => esc_html__( 'Style 4', 'ronby' ),
                    ),
                    array(
                    'value' => '5',
                    'label' => esc_html__( 'Style 5', 'ronby' ),
                    ),    
                    array(
                    'value' => '6',
                    'label' => esc_html__( 'Style 6', 'ronby' ),
                    ), 
										
                    ),
            "description" => ''
         ),	
			array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Page Breadcrumb Switch", 'ronby'),
            "param_name" => "page_breadcrumb_switch",
			'value' => array(
			        array(
                    'value' => '1',
                    'label' => esc_html__( 'Yes', 'ronby' ),
                    ),
                    array(
                    'value' => '2',
                    'label' => esc_html__( 'No', 'ronby' ),
                    ),										
                    ),
            "description" => ''
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Padding Top", 'ronby'),
            "param_name" => "padding_top",
            "value" => '',
            "description" =>  esc_html__('Example: 100px', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Padding Bottom", 'ronby'),
            "param_name" => "padding_bottom",
            "value" => '',
            "description" =>  esc_html__('Example: 100px', 'ronby'),
         ),	
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Background Image", 'ronby'),
            "param_name" => "bg_image",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Overlay Color", 'ronby'),
            "param_name" => "overlay_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		

		 
   )
)
);

/*****************************
Fitness Team Details Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Fitness Team Details Section", 'ronby'),
      "base" => "ronby_shortcode_for_fitness_team_details",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Fitness Team Details section.', 'ronby'),
      "params" => array(         

	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Name", 'ronby'),
            "param_name" => "trainer_name",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Designation", 'ronby'),
            "param_name" => "trainer_designation",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Trainer Description", 'ronby'),
            "param_name" => "description",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Trainer Short Description at the bottom", 'ronby'),
            "param_name" => "short_description",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Facebook URL", 'ronby'),
            "param_name" => "trainer_fb_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Twitter URL", 'ronby'),
            "param_name" => "trainer_twitter_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Linkedin URL", 'ronby'),
            "param_name" => "trainer_linkedin_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Pinterest URL", 'ronby'),
            "param_name" => "trainer_pinterest_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Profile Image", 'ronby'),
            "param_name" => "profile_img",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Button Label", 'ronby'),
            "param_name" => "btn_label",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Button URL", 'ronby'),
            "param_name" => "btn_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Working Day", 'ronby'),
            "param_name" => "trainer_working_day",
            "value" => '',
            "description" =>  esc_html__('Example: Monday to Friday', 'ronby'),
         ),			
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Working Time", 'ronby'),
            "param_name" => "trainer_working_time",
            "value" => '',
            "description" =>  esc_html__('Example: 8.00 AM - 5.30 PM', 'ronby'),
         ),	 	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Phone", 'ronby'),
            "param_name" => "trainer_phone",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Email", 'ronby'),
            "param_name" => "trainer_email",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Trainer Location", 'ronby'),
            "param_name" => "location",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Time Table Title", 'ronby'),
            "param_name" => "opening_hours_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-1 Title", 'ronby'),
            "param_name" => "day1_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-1 Time", 'ronby'),
            "param_name" => "day1_time",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-2 Title", 'ronby'),
            "param_name" => "day2_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-2 Time", 'ronby'),
            "param_name" => "day2_time",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-3 Title", 'ronby'),
            "param_name" => "day3_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-3 Time", 'ronby'),
            "param_name" => "day3_time",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-4 Title", 'ronby'),
            "param_name" => "day4_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-4 Time", 'ronby'),
            "param_name" => "day4_time",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-5 Title", 'ronby'),
            "param_name" => "day5_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-5 Time", 'ronby'),
            "param_name" => "day5_time",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-6 Title", 'ronby'),
            "param_name" => "day6_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-6 Time", 'ronby'),
            "param_name" => "day6_time",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-7 Title", 'ronby'),
            "param_name" => "day7_title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Day-7 Time", 'ronby'),
            "param_name" => "day7_time",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),			 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Name Color", 'ronby'),
            "param_name" => "trainer_name_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),			 
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Designation Color", 'ronby'),
            "param_name" => "trainer_designation_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Info Label Color", 'ronby'),
            "param_name" => "trainer_info_label_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),	
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Info Text Color", 'ronby'),
            "param_name" => "trainer_info_text_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),	
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Description Color", 'ronby'),
            "param_name" => "trainer_desc_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Time-Table Background Color", 'ronby'),
            "param_name" => "trainer_timetable_bg_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Trainer Time-Table Text Color", 'ronby'),
            "param_name" => "trainer_timetable_text_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),	
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Text Color", 'ronby'),
            "param_name" => "btn_text_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),	
		array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Background Color", 'ronby'),
            "param_name" => "btn_bg_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),			 
   )
)
);

/******************* 
Pricing Badge
********************/
vc_map( array(
      "name" => esc_html__("FT- Pricing Badge", 'ronby'),
      "base" => "ronby_shortcode_for_pricing_badge",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows the Pricing Badge', 'ronby'),
      "params" => array(
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading Line 1", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" => ''
         ),
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Price 1", 'ronby'),
            "param_name" => "price1",
            "value" => '',
            "description" => ''
         ),	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Duration 1", 'ronby'),
            "param_name" => "duration1",
            "value" => '',
            "description" => ''
         ),		
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Badge 1 Background Color", 'ronby'),
            "param_name" => "bg1_color",
            "value" => '',
            "description" => ''
         ),	
		array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Badge 1 Size", 'ronby'),
            "param_name" => "badge1_size",
            'value' => array(
			        array(
                    'value' => '',
                    'label' => esc_html__( 'Select Badge Size', 'ronby' ),
                    ),
                    array(
                    'value' => 'badge-large',
                    'label' => esc_html__( 'Badge Large', 'ronby' ),
                    ),
                    array(
                    'value' => 'badge-medium',
                    'label' => esc_html__( 'Badge Medium', 'ronby' ),
                    ),
                    array(
                    'value' => 'badge-small',
                    'label' => esc_html__( 'Badge Small', 'ronby' ),
                    ),                             
                    ),
            "description" => '',
         ),		 
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading Line 2", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" => ''
         ),
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Price 2", 'ronby'),
            "param_name" => "price2",
            "value" => '',
            "description" => ''
         ),	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Duration 2", 'ronby'),
            "param_name" => "duration2",
            "value" => '',
            "description" => ''
         ),	
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Badge 2 Background Color", 'ronby'),
            "param_name" => "bg2_color",
            "value" => '',
            "description" => ''
         ),	
		array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Badge 2 Size", 'ronby'),
            "param_name" => "badge2_size",
            'value' => array(
			        array(
                    'value' => '',
                    'label' => esc_html__( 'Select Badge Size', 'ronby' ),
                    ),
                    array(
                    'value' => 'badge-large',
                    'label' => esc_html__( 'Badge Large', 'ronby' ),
                    ),					
                    array(
                    'value' => 'badge-medium',
                    'label' => esc_html__( 'Badge Medium', 'ronby' ),
                    ),			
                    array(
                    'value' => 'badge-small',
                    'label' => esc_html__( 'Badge Small', 'ronby' ),
                    ),                             
                    ),
            "description" => '',
         ),			 
       array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Image", 'ronby'),
            "param_name" => "image",
            "value" => '',
            "description" => '',
            "group" => '',
         ),
		array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Badge Position", 'ronby'),
            "param_name" => "badge_position",
            'value' => array(
			        array(
                    'value' => '',
                    'label' => esc_html__( 'Select Badge Position', 'ronby' ),
                    ),
                    array(
                    'value' => 'position-1',
                    'label' => esc_html__( 'Right- 1', 'ronby' ),
                    ),					
                    array(
                    'value' => 'position-2',
                    'label' => esc_html__( 'Right- 2', 'ronby' ),
                    ),
                    array(
                    'value' => 'position-4',
                    'label' => esc_html__( 'Right- 3', 'ronby' ),
                    ),						
                    array(
                    'value' => 'position-3',
                    'label' => esc_html__( 'Left', 'ronby' ),
                    ),                             
                    ),
            "description" => '',
         ),			 
   )
)
);

/******************* 
Restaurant Food Category
********************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Food Category", 'ronby'),
      "base" => "ronby_shortcode_for_restaurant_food_category",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows the food categories.', 'ronby'),
      "params" => array(
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading Line 1", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" => ''
         ),
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading Line 2", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" => ''
         ),	
		array(
        "type" => "dropdown_multi",
        "heading" => esc_html__("Which Category Post do you want to display?", 'ronby'),
        "param_name" => "multiple_cat",
        "value" => $categories_array,
        "description" => esc_html__( 'Press ctrl+A command to select all categories', 'ronby' ),
		),
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Product Type", 'ronby'),
            "param_name" => "product_type",
            "value" => '',
            "description" => esc_html__( 'Example: Recips or Products', 'ronby' ),
         ),		
       array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Left Bottom Background Image", 'ronby'),
            "param_name" => "left_bottom_img",
            "value" => '',
            "description" => '',
            "group" => '',
         ),
       array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Right Top Background Image", 'ronby'),
            "param_name" => "right_top_img",
            "value" => '',
            "description" => '',
            "group" => '',
         ),	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Button Label", 'ronby'),
            "param_name" => "btn_label",
            "value" => '',
            "description" => esc_html__( '', 'ronby' ),
         ),	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Button URL", 'ronby'),
            "param_name" => "btn_url",
            "value" => '',
            "description" => esc_html__( '', 'ronby' ),
         ),
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Heading One Color", 'ronby'),
            "param_name" => "heading1_color",
            "value" => '',
            "description" => esc_html__( '', 'ronby' ),
			"group" => esc_html__( 'Design-Options', 'ronby' ),
         ),
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Heading Two Color", 'ronby'),
            "param_name" => "heading2_color",
            "value" => '',
            "description" => esc_html__( '', 'ronby' ),
			"group" => esc_html__( 'Design-Options', 'ronby' ),
         ),		 
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Button Text Color", 'ronby'),
            "param_name" => "btn_text_color",
            "value" => '',
            "description" => esc_html__( '', 'ronby' ),
			"group" => esc_html__( 'Design-Options', 'ronby' ),
         ),		
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Button Background Color", 'ronby'),
            "param_name" => "btn_bg_color",
            "value" => '',
            "description" => esc_html__( '', 'ronby' ),
            "group" => esc_html__( 'Design-Options', 'ronby' ),
         ),	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Padding Top?", 'ronby'),
            "param_name" => "padding_top",
            "value" => '',
			 "description" => esc_html__( 'Example: 50px', 'ronby' ),
            "group" => esc_html__( 'Design-Options', 'ronby' ),
         ),	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Padding Bottom?", 'ronby'),
            "param_name" => "padding_bottom",
            "value" => '',
			 "description" => esc_html__( 'Example: 50px', 'ronby' ),
            "group" => esc_html__( 'Design-Options', 'ronby' ),
         ),			 
   )
)
);

/*****************************
Restaurant Heading Section- 1
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Heading Section- 1", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_restaurant_heading_section_one",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Heading Section.', 'ronby'),
      "params" => array(         
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line 1", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line 2", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),			 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading One Color", 'ronby'),
            "param_name" => "heading1_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading Two Color", 'ronby'),
            "param_name" => "heading2_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
			 
   )
)
);

/*****************************
Restaurant Heading Section- 2
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Heading Section- 2", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_restaurant_heading_section_two",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Heading Section.', 'ronby'),
      "params" => array(         
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line 1", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line 2", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),			 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading One Color", 'ronby'),
            "param_name" => "heading1_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading Two Color", 'ronby'),
            "param_name" => "heading2_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
			 
   )
)
);

/*****************************
Restaurant Feature Box
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Feature Box", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_restaurant_feature_box",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Feature Box.', 'ronby'),
      "params" => array(         
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line", 'ronby'),
            "param_name" => "heading",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Description", 'ronby'),
            "param_name" => "desc",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	

		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Feature Box Icon', 'ronby' ),
            'param_name' => 'icon',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),
         ),				
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading Color", 'ronby'),
            "param_name" => "heading_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Description Color", 'ronby'),
            "param_name" => "desc_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Icon Color", 'ronby'),
            "param_name" => "icon_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),				 
   )
)
);

/*****************************
Restaurant Feature Box Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Feature Box Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_restaurant_feature_box_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Feature Box Section.', 'ronby'),
      "params" => array(         

		array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading One", 'ronby'),
            "param_name" => "headingline1",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Two", 'ronby'),
            "param_name" => "headingline2",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
         array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Number of Feature Box", 'ronby'),
            "param_name" => "number_of_feature_box",
            'admin_label' => true,
			"description" => esc_html__("Select minimum Two Features.", 'ronby'),
            "value" => array(
               esc_html__('One', 'ronby')=>'1',
               esc_html__('Two', 'ronby')=>'2',
               esc_html__('Three', 'ronby')=>'3',
               esc_html__('Four', 'ronby')=>'4',
               esc_html__('Five', 'ronby')=>'5',
               esc_html__('Six', 'ronby')=>'6',
               esc_html__('Seven', 'ronby')=>'7',
               esc_html__('Eight', 'ronby')=>'8',
               esc_html__('Nine', 'ronby')=>'9',
               esc_html__('Ten', 'ronby')=>'10',
            )
         ),

		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-1 Icon', 'ronby' ),
            'param_name' => 'icon1',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),
         			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array('1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
                        )
            ),
            ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-1 Heading", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-1 Description", 'ronby'),
            "param_name" => "desc1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-2 Icon', 'ronby' ),
            'param_name' => 'icon2',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),
         			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array(
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
                        )
            ),
            ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-2 Heading", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-2 Description", 'ronby'),
            "param_name" => "desc2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
	
		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-3 Icon', 'ronby' ),
            'param_name' => 'icon3',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),        			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array(
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
                        )
            ),
            ),			 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-3 Heading", 'ronby'),
            "param_name" => "heading3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-3 Description", 'ronby'),
            "param_name" => "desc3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-4 Icon', 'ronby' ),
            'param_name' => 'icon4',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),        			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array(
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
                        )
            ),
            ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-4 Heading", 'ronby'),
            "param_name" => "heading4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-4 Description", 'ronby'),
            "param_name" => "desc4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-5 Icon', 'ronby' ),
            'param_name' => 'icon5',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),        			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array(
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
                        )
            ),
            ),	 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-5 Heading", 'ronby'),
            "param_name" => "heading5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-5 Description", 'ronby'),
            "param_name" => "desc5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-6 Icon', 'ronby' ),
            'param_name' => 'icon6',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),        			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array(
							'6',
							'7',
							'8',
							'9',
							'10',
                        )
            ),
            ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-6 Heading", 'ronby'),
            "param_name" => "heading6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-6 Description", 'ronby'),
            "param_name" => "desc6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-7 Icon', 'ronby' ),
            'param_name' => 'icon7',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),        			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array(
							'7',
							'8',
							'9',
							'10',
                        )
            ),
            ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-7 Heading", 'ronby'),
            "param_name" => "heading7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-7 Description", 'ronby'),
            "param_name" => "desc7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-8 Icon', 'ronby' ),
            'param_name' => 'icon8',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),        			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array(
							'8',
							'9',
							'10',
                        )
            ),
            ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-8 Heading", 'ronby'),
            "param_name" => "heading8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-8 Description", 'ronby'),
            "param_name" => "desc8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-9 Icon', 'ronby' ),
            'param_name' => 'icon9',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),        			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array(
							'9',
							'10',
                        )
            ),
            ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-9 Heading", 'ronby'),
            "param_name" => "heading9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-9 Description", 'ronby'),
            "param_name" => "desc9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            'heading' => esc_html__( 'Box-10 Icon', 'ronby' ),
            'param_name' => 'icon10',
            "value" => '',
            "description" =>  esc_html__('Enter here icon class name: Example: fab fa-pinterest-p', 'ronby'),        			
            'dependency' => array(
            'element' => 'number_of_feature_box',
            'value' => array(
							'10',
                        )
            ),
            ),		 
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Box-10 Heading", 'ronby'),
            "param_name" => "heading10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Box-10 Description", 'ronby'),
            "param_name" => "desc10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_feature_box',
               'value' => array(
                                '10',
                        )
            )
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading Color", 'ronby'),
            "param_name" => "heading_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Description Color", 'ronby'),
            "param_name" => "desc_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Icon Color", 'ronby'),
            "param_name" => "icon_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Padding Top?", 'ronby'),
            "param_name" => "padding_top",
            "value" => '',
            "description" => esc_html__("Example: 50px", 'ronby'),
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Padding Bottom?", 'ronby'),
            "param_name" => "padding_bottom",
            "value" => '',
            "description" => esc_html__("Example: 50px", 'ronby'),
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading One Color", 'ronby'),
            "param_name" => "heading1_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading Two Color", 'ronby'),
            "param_name" => "heading2_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),			 
   )
)
);

/*****************************
Restaurant Team Details Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Team Details Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_restaurant_team_details_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Team Details.', 'ronby'),
      "params" => array(         
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Chef Title One", 'ronby'),
            "param_name" => "title1",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Chef Title Two", 'ronby'),
            "param_name" => "title2",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Chef Role", 'ronby'),
            "param_name" => "team_role",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Chef Description", 'ronby'),
            "param_name" => "desc",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
       array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Chef Info- 1 Icon', 'ronby' ),
            'param_name' => 'info1icon',
            'value' => '',
            'description' => esc_html__( 'Select icon from library.', 'ronby' ),
            ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Chef Info- 1 Text", 'ronby'),
            "param_name" => "info1title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
       array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Chef Info- 2 Icon', 'ronby' ),
            'param_name' => 'info2icon',
            'value' => '',
            'description' => esc_html__( 'Select icon from library.', 'ronby' ),
            ),			
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Chef Info- 2 Text", 'ronby'),
            "param_name" => "info2title",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Facebook Profile URL", 'ronby'),
            "param_name" => "fb_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Twitter Profile URL", 'ronby'),
            "param_name" => "twitter_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Linkedin Profile URL", 'ronby'),
            "param_name" => "linkedin_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Pinterest Profile URL", 'ronby'),
            "param_name" => "pinterest_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),			 
        array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Master Chef Image", 'ronby'),
            "param_name" => "master_chef_img",
            "value" => '',
            "description" => '',
         ),
	
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Team Members Image", 'ronby'),
            "param_name" => "team_member_img",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Title-1 Color", 'ronby'),
            "param_name" => "title1_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Title-2 Color", 'ronby'),
            "param_name" => "title2_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Team Role Color", 'ronby'),
            "param_name" => "team_role_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Description Color", 'ronby'),
            "param_name" => "desc_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Info Icon Color", 'ronby'),
            "param_name" => "infoicon_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Info Text Color", 'ronby'),
            "param_name" => "infotitle_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Master Chef Image Background Color", 'ronby'),
            "param_name" => "master_chef_img_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Section Background Color", 'ronby'),
            "param_name" => "sec_bg_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 
   )
)
);

/*****************************
Restaurant Products Tab Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Products Tab Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_restaurant_products_tab_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Products', 'ronby'),
      "params" => array(         

		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Item Filter Categories", 'ronby'),
            "param_name" => "features",
            "description" => esc_html__('Input each Category on New Line. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design.','ronby')
         ),
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Item Filter Icons", 'ronby'),
            "param_name" => "features_icon",
            "description" => esc_html__('Input each Icon on New Line. For example: flaticon-cocktail','ronby')
         ),
		 array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Label for Show All Items", 'ronby'),
            "param_name" => "showall",
            "description" => esc_html__('Input label for "Show All" items.','ronby')
         ),
		 array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Icon for Show All Items", 'ronby'),
            "param_name" => "showall_icon",
            "description" => esc_html__('Input icon for "Show All" items. For example: flaticon-hamburger-meal','ronby')
         ),
		 array(
            "type" => "dropdown",            
            "class" => "",
            "heading" => esc_html__("Number of Items", 'ronby'),
            "param_name" => "number_of_items",
            'admin_label' => true,
            "value" => array(
               esc_html__('One', 'ronby')=>'1',
			   esc_html__('Two', 'ronby')=>'2', 
			   esc_html__('Three', 'ronby')=>'3',
			   esc_html__('Four', 'ronby')=>'4',
			   esc_html__('Five', 'ronby')=>'5', 
			   esc_html__('Six', 'ronby')=>'6',
			   esc_html__('Seven', 'ronby')=>'7',
			   esc_html__('Eight', 'ronby')=>'8', 
			   esc_html__('Nine', 'ronby')=>'9',
			   esc_html__('Ten', 'ronby')=>'10',
			   esc_html__('Eleven', 'ronby')=>'11',
			   esc_html__('Twelve', 'ronby')=>'12', 
			   esc_html__('Thirteen', 'ronby')=>'13',
			   esc_html__('Fourteen', 'ronby')=>'14',
			   esc_html__('Fifteen', 'ronby')=>'15', 
			   esc_html__('Sixteen', 'ronby')=>'16',
			   esc_html__('Seventeen', 'ronby')=>'17',
			   esc_html__('Eighteen', 'ronby')=>'18', 
			   esc_html__('Nineteen', 'ronby')=>'19',
			   esc_html__('Twenty', 'ronby')=>'20',
			   esc_html__('Twenty One', 'ronby')=>'21',
			   esc_html__('Twenty Two', 'ronby')=>'22', 
			   esc_html__('Twenty Three', 'ronby')=>'23',
			   esc_html__('Twenty Four', 'ronby')=>'24',
			   esc_html__('Twenty Five', 'ronby')=>'25', 
			   esc_html__('Twenty Six', 'ronby')=>'26',
			   esc_html__('Twenty Seven', 'ronby')=>'27',
			   esc_html__('Twenty Eight', 'ronby')=>'28', 
			   esc_html__('Twenty Nine', 'ronby')=>'29',
			   esc_html__('Thirty', 'ronby')=>'30',
			   esc_html__('Thirty One', 'ronby')=>'31',
			   esc_html__('Thirty Two', 'ronby')=>'32', 
			   esc_html__('Thirty Three', 'ronby')=>'33',
			   esc_html__('Thirty Four', 'ronby')=>'34',
			   esc_html__('Thirty Five', 'ronby')=>'35', 
			   esc_html__('Thirty Six', 'ronby')=>'36',
			   esc_html__('Thirty Seven', 'ronby')=>'37',
			   esc_html__('Thirty Eight', 'ronby')=>'38', 
			   esc_html__('Thirty Nine', 'ronby')=>'39',
			   esc_html__('Forty', 'ronby')=>'40',
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Title", 'ronby'),
            "param_name" => "item_title1",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Image URL", 'ronby'),
            "param_name" => "item_img1",
            "value" => '',
            "description" => esc_html__('Input Item 1 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Price", 'ronby'),
            "param_name" => "item_price1",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features1",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Short Description", 'ronby'),
            "param_name" => "text1",
            "value" => '',
            "description" => esc_html__('Input Item 1 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 More Info URL", 'ronby'),
            "param_name" => "more_url1",
            "value" => '',
            "description" => esc_html__('Input Item 1 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Date", 'ronby'),
            "param_name" => "item_date1",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating1",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Title", 'ronby'),
            "param_name" => "item_title2",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Image URL", 'ronby'),
            "param_name" => "item_img2",
            "value" => '',
            "description" => esc_html__('Input Item 2 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Price", 'ronby'),
            "param_name" => "item_price2",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features2",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Short Description", 'ronby'),
            "param_name" => "text2",
            "value" => '',
            "description" => esc_html__('Input Item 2 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 More Info URL", 'ronby'),
            "param_name" => "more_url2",
            "value" => '',
            "description" => esc_html__('Input Item 2 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Date", 'ronby'),
            "param_name" => "item_date2",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating2",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Title", 'ronby'),
            "param_name" => "item_title3",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Image URL", 'ronby'),
            "param_name" => "item_img3",
            "value" => '',
            "description" => esc_html__('Input Item 3 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Price", 'ronby'),
            "param_name" => "item_price3",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features3",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Short Description", 'ronby'),
            "param_name" => "text3",
            "value" => '',
            "description" => esc_html__('Input Item 3 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 More Info URL", 'ronby'),
            "param_name" => "more_url3",
            "value" => '',
            "description" => esc_html__('Input Item 3 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Date", 'ronby'),
            "param_name" => "item_date3",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating3",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Title", 'ronby'),
            "param_name" => "item_title4",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Image URL", 'ronby'),
            "param_name" => "item_img4",
            "value" => '',
            "description" => esc_html__('Input Item 4 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Price", 'ronby'),
            "param_name" => "item_price4",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features4",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Short Description", 'ronby'),
            "param_name" => "text4",
            "value" => '',
            "description" => esc_html__('Input Item 4 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 More Info URL", 'ronby'),
            "param_name" => "more_url4",
            "value" => '',
            "description" => esc_html__('Input Item 4 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Date", 'ronby'),
            "param_name" => "item_date4",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating4",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Title", 'ronby'),
            "param_name" => "item_title5",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Image URL", 'ronby'),
            "param_name" => "item_img5",
            "value" => '',
            "description" => esc_html__('Input Item 5 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Price", 'ronby'),
            "param_name" => "item_price5",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features5",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Short Description", 'ronby'),
            "param_name" => "text5",
            "value" => '',
            "description" => esc_html__('Input Item 5 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 More Info URL", 'ronby'),
            "param_name" => "more_url5",
            "value" => '',
            "description" => esc_html__('Input Item 5 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Date", 'ronby'),
            "param_name" => "item_date5",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating5",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Title", 'ronby'),
            "param_name" => "item_title6",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Image URL", 'ronby'),
            "param_name" => "item_img6",
            "value" => '',
            "description" => esc_html__('Input Item 6 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Price", 'ronby'),
            "param_name" => "item_price6",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features6",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Short Description", 'ronby'),
            "param_name" => "text6",
            "value" => '',
            "description" => esc_html__('Input Item 6 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 More Info URL", 'ronby'),
            "param_name" => "more_url6",
            "value" => '',
            "description" => esc_html__('Input Item 6 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Date", 'ronby'),
            "param_name" => "item_date6",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating6",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Title", 'ronby'),
            "param_name" => "item_title7",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Image URL", 'ronby'),
            "param_name" => "item_img7",
            "value" => '',
            "description" => esc_html__('Input Item 7 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Price", 'ronby'),
            "param_name" => "item_price7",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features7",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Short Description", 'ronby'),
            "param_name" => "text7",
            "value" => '',
            "description" => esc_html__('Input Item 7 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 More Info URL", 'ronby'),
            "param_name" => "more_url7",
            "value" => '',
            "description" => esc_html__('Input Item 7 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Date", 'ronby'),
            "param_name" => "item_date7",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating7",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Title", 'ronby'),
            "param_name" => "item_title8",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Image URL", 'ronby'),
            "param_name" => "item_img8",
            "value" => '',
            "description" => esc_html__('Input Item 8 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Price", 'ronby'),
            "param_name" => "item_price8",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features8",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Short Description", 'ronby'),
            "param_name" => "text8",
            "value" => '',
            "description" => esc_html__('Input Item 8 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 More Info URL", 'ronby'),
            "param_name" => "more_url8",
            "value" => '',
            "description" => esc_html__('Input Item 8 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Date", 'ronby'),
            "param_name" => "item_date8",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating8",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Title", 'ronby'),
            "param_name" => "item_title9",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10','11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Image URL", 'ronby'),
            "param_name" => "item_img9",
            "value" => '',
            "description" => esc_html__('Input Item 9 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Price", 'ronby'),
            "param_name" => "item_price9",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features9",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Short Description", 'ronby'),
            "param_name" => "text9",
            "value" => '',
            "description" => esc_html__('Input Item 9 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 More Info URL", 'ronby'),
            "param_name" => "more_url9",
            "value" => '',
            "description" => esc_html__('Input Item 9 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Date", 'ronby'),
            "param_name" => "item_date9",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating9",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Title", 'ronby'),
            "param_name" => "item_title10",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Image URL", 'ronby'),
            "param_name" => "item_img10",
            "value" => '',
            "description" => esc_html__('Input Item 10 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Price", 'ronby'),
            "param_name" => "item_price10",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features10",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Short Description", 'ronby'),
            "param_name" => "text10",
            "value" => '',
            "description" => esc_html__('Input Item 10 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 More Info URL", 'ronby'),
            "param_name" => "more_url10",
            "value" => '',
            "description" => esc_html__('Input Item 10 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Date", 'ronby'),
            "param_name" => "item_date10",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating10",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Title", 'ronby'),
            "param_name" => "item_title11",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Image URL", 'ronby'),
            "param_name" => "item_img11",
            "value" => '',
            "description" => esc_html__('Input Item 11 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Price", 'ronby'),
            "param_name" => "item_price11",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features11",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Short Description", 'ronby'),
            "param_name" => "text11",
            "value" => '',
            "description" => esc_html__('Input Item 11 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 More Info URL", 'ronby'),
            "param_name" => "more_url11",
            "value" => '',
            "description" => esc_html__('Input Item 11 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Date", 'ronby'),
            "param_name" => "item_date11",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating11",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 Title", 'ronby'),
            "param_name" => "item_title12",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 Image URL", 'ronby'),
            "param_name" => "item_img12",
            "value" => '',
            "description" => esc_html__('Input Item 12 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 Price", 'ronby'),
            "param_name" => "item_price12",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features12",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 Short Description", 'ronby'),
            "param_name" => "text12",
            "value" => '',
            "description" => esc_html__('Input Item 12 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 More Info URL", 'ronby'),
            "param_name" => "more_url12",
            "value" => '',
            "description" => esc_html__('Input Item 12 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Date", 'ronby'),
            "param_name" => "item_date13",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating13",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Title", 'ronby'),
            "param_name" => "item_title13",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Image URL", 'ronby'),
            "param_name" => "item_img13",
            "value" => '',
            "description" => esc_html__('Input Item 13 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Price", 'ronby'),
            "param_name" => "item_price13",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features13",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Short Description", 'ronby'),
            "param_name" => "text13",
            "value" => '',
            "description" => esc_html__('Input Item 13 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 More Info URL", 'ronby'),
            "param_name" => "more_url13",
            "value" => '',
            "description" => esc_html__('Input Item 13 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Date", 'ronby'),
            "param_name" => "item_date14",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating14",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Title", 'ronby'),
            "param_name" => "item_title14",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Image URL", 'ronby'),
            "param_name" => "item_img14",
            "value" => '',
            "description" => esc_html__('Input Item 14 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Price", 'ronby'),
            "param_name" => "item_price14",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features14",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Short Description", 'ronby'),
            "param_name" => "text14",
            "value" => '',
            "description" => esc_html__('Input Item 14 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 More Info URL", 'ronby'),
            "param_name" => "more_url14",
            "value" => '',
            "description" => esc_html__('Input Item 14 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Date", 'ronby'),
            "param_name" => "item_date14",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating14",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Title", 'ronby'),
            "param_name" => "item_title15",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Image URL", 'ronby'),
            "param_name" => "item_img15",
            "value" => '',
            "description" => esc_html__('Input Item 15 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Price", 'ronby'),
            "param_name" => "item_price15",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features15",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Short Description", 'ronby'),
            "param_name" => "text15",
            "value" => '',
            "description" => esc_html__('Input Item 15 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 More Info URL", 'ronby'),
            "param_name" => "more_url15",
            "value" => '',
            "description" => esc_html__('Input Item 15 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Date", 'ronby'),
            "param_name" => "item_date15",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating15",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating16",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Title", 'ronby'),
            "param_name" => "item_title16",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Image URL", 'ronby'),
            "param_name" => "item_img16",
            "value" => '',
            "description" => esc_html__('Input Item 16 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Price", 'ronby'),
            "param_name" => "item_price16",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features16",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Short Description", 'ronby'),
            "param_name" => "text16",
            "value" => '',
            "description" => esc_html__('Input Item 16 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 More Info URL", 'ronby'),
            "param_name" => "more_url16",
            "value" => '',
            "description" => esc_html__('Input Item 16 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Date", 'ronby'),
            "param_name" => "item_date16",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Title", 'ronby'),
            "param_name" => "item_title17",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Image URL", 'ronby'),
            "param_name" => "item_img17",
            "value" => '',
            "description" => esc_html__('Input Item 17 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Price", 'ronby'),
            "param_name" => "item_price17",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features17",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Short Description", 'ronby'),
            "param_name" => "text17",
            "value" => '',
            "description" => esc_html__('Input Item 17 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 More Info URL", 'ronby'),
            "param_name" => "more_url17",
            "value" => '',
            "description" => esc_html__('Input Item 17 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Date", 'ronby'),
            "param_name" => "item_date17",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating17",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Title", 'ronby'),
            "param_name" => "item_title18",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Image URL", 'ronby'),
            "param_name" => "item_img18",
            "value" => '',
            "description" => esc_html__('Input Item 18 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Price", 'ronby'),
            "param_name" => "item_price18",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features18",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Short Description", 'ronby'),
            "param_name" => "text18",
            "value" => '',
            "description" => esc_html__('Input Item 18 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 More Info URL", 'ronby'),
            "param_name" => "more_url18",
            "value" => '',
            "description" => esc_html__('Input Item 18 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Date", 'ronby'),
            "param_name" => "item_date18",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating18",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Title", 'ronby'),
            "param_name" => "item_title19",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Image URL", 'ronby'),
            "param_name" => "item_img19",
            "value" => '',
            "description" => esc_html__('Input Item 19 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Price", 'ronby'),
            "param_name" => "item_price19",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features19",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Short Description", 'ronby'),
            "param_name" => "text19",
            "value" => '',
            "description" => esc_html__('Input Item 19 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 More Info URL", 'ronby'),
            "param_name" => "more_url19",
            "value" => '',
            "description" => esc_html__('Input Item 19 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Date", 'ronby'),
            "param_name" => "item_date19",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating19",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Title", 'ronby'),
            "param_name" => "item_title20",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Image URL", 'ronby'),
            "param_name" => "item_img20",
            "value" => '',
            "description" => esc_html__('Input Item 20 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Price", 'ronby'),
            "param_name" => "item_price20",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features20",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Short Description", 'ronby'),
            "param_name" => "text20",
            "value" => '',
            "description" => esc_html__('Input Item 20 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 More Info URL", 'ronby'),
            "param_name" => "more_url20",
            "value" => '',
            "description" => esc_html__('Input Item 20 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Date", 'ronby'),
            "param_name" => "item_date20",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating20",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Title", 'ronby'),
            "param_name" => "item_title21",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Image URL", 'ronby'),
            "param_name" => "item_img21",
            "value" => '',
            "description" => esc_html__('Input Item 21 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Price", 'ronby'),
            "param_name" => "item_price21",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features21",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Short Description", 'ronby'),
            "param_name" => "text21",
            "value" => '',
            "description" => esc_html__('Input Item 21 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 More Info URL", 'ronby'),
            "param_name" => "more_url21",
            "value" => '',
            "description" => esc_html__('Input Item 21 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Date", 'ronby'),
            "param_name" => "item_date21",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating21",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Title", 'ronby'),
            "param_name" => "item_title22",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Image URL", 'ronby'),
            "param_name" => "item_img22",
            "value" => '',
            "description" => esc_html__('Input Item 22 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Price", 'ronby'),
            "param_name" => "item_price22",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features22",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Short Description", 'ronby'),
            "param_name" => "text22",
            "value" => '',
            "description" => esc_html__('Input Item 22 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 More Info URL", 'ronby'),
            "param_name" => "more_url22",
            "value" => '',
            "description" => esc_html__('Input Item 22 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Date", 'ronby'),
            "param_name" => "item_date22",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating22",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Title", 'ronby'),
            "param_name" => "item_title23",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Image URL", 'ronby'),
            "param_name" => "item_img23",
            "value" => '',
            "description" => esc_html__('Input Item 23 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Price", 'ronby'),
            "param_name" => "item_price23",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features23",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Short Description", 'ronby'),
            "param_name" => "text23",
            "value" => '',
            "description" => esc_html__('Input Item 23 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 More Info URL", 'ronby'),
            "param_name" => "more_url23",
            "value" => '',
            "description" => esc_html__('Input Item 23 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Date", 'ronby'),
            "param_name" => "item_date23",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating23",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Title", 'ronby'),
            "param_name" => "item_title24",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Image URL", 'ronby'),
            "param_name" => "item_img24",
            "value" => '',
            "description" => esc_html__('Input Item 24 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Price", 'ronby'),
            "param_name" => "item_price24",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features24",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Short Description", 'ronby'),
            "param_name" => "text24",
            "value" => '',
            "description" => esc_html__('Input Item 24 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 More Info URL", 'ronby'),
            "param_name" => "more_url24",
            "value" => '',
            "description" => esc_html__('Input Item 24 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Date", 'ronby'),
            "param_name" => "item_date24",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating24",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Title", 'ronby'),
            "param_name" => "item_title25",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Image URL", 'ronby'),
            "param_name" => "item_img25",
            "value" => '',
            "description" => esc_html__('Input Item 25 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Price", 'ronby'),
            "param_name" => "item_price25",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features25",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Short Description", 'ronby'),
            "param_name" => "text25",
            "value" => '',
            "description" => esc_html__('Input Item 25 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 More Info URL", 'ronby'),
            "param_name" => "more_url25",
            "value" => '',
            "description" => esc_html__('Input Item 25 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Date", 'ronby'),
            "param_name" => "item_date19",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating25",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Title", 'ronby'),
            "param_name" => "item_title26",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Image URL", 'ronby'),
            "param_name" => "item_img26",
            "value" => '',
            "description" => esc_html__('Input Item 26 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Price", 'ronby'),
            "param_name" => "item_price26",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features26",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Short Description", 'ronby'),
            "param_name" => "text26",
            "value" => '',
            "description" => esc_html__('Input Item 26 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 More Info URL", 'ronby'),
            "param_name" => "more_url26",
            "value" => '',
            "description" => esc_html__('Input Item 26 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Date", 'ronby'),
            "param_name" => "item_date26",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating26",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Title", 'ronby'),
            "param_name" => "item_title27",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Image URL", 'ronby'),
            "param_name" => "item_img27",
            "value" => '',
            "description" => esc_html__('Input Item 27 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Price", 'ronby'),
            "param_name" => "item_price27",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features27",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Short Description", 'ronby'),
            "param_name" => "text27",
            "value" => '',
            "description" => esc_html__('Input Item 27 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 More Info URL", 'ronby'),
            "param_name" => "more_url27",
            "value" => '',
            "description" => esc_html__('Input Item 27 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Date", 'ronby'),
            "param_name" => "item_date27",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating27",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Title", 'ronby'),
            "param_name" => "item_title28",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Image URL", 'ronby'),
            "param_name" => "item_img28",
            "value" => '',
            "description" => esc_html__('Input Item 28 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Price", 'ronby'),
            "param_name" => "item_price28",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features28",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Short Description", 'ronby'),
            "param_name" => "text28",
            "value" => '',
            "description" => esc_html__('Input Item 28 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 More Info URL", 'ronby'),
            "param_name" => "more_url28",
            "value" => '',
            "description" => esc_html__('Input Item 28 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Date", 'ronby'),
            "param_name" => "item_date28",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating28",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Title", 'ronby'),
            "param_name" => "item_title29",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Image URL", 'ronby'),
            "param_name" => "item_img29",
            "value" => '',
            "description" => esc_html__('Input Item 29 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Price", 'ronby'),
            "param_name" => "item_price29",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features29",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Short Description", 'ronby'),
            "param_name" => "text29",
            "value" => '',
            "description" => esc_html__('Input Item 29 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 More Info URL", 'ronby'),
            "param_name" => "more_url29",
            "value" => '',
            "description" => esc_html__('Input Item 29 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Date", 'ronby'),
            "param_name" => "item_date29",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating29",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Title", 'ronby'),
            "param_name" => "item_title30",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Image URL", 'ronby'),
            "param_name" => "item_img30",
            "value" => '',
            "description" => esc_html__('Input Item 30 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Price", 'ronby'),
            "param_name" => "item_price30",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features30",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Short Description", 'ronby'),
            "param_name" => "text30",
            "value" => '',
            "description" => esc_html__('Input Item 30 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 More Info URL", 'ronby'),
            "param_name" => "more_url30",
            "value" => '',
            "description" => esc_html__('Input Item 30 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Date", 'ronby'),
            "param_name" => "item_date30",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating30",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Title", 'ronby'),
            "param_name" => "item_title31",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Image URL", 'ronby'),
            "param_name" => "item_img31",
            "value" => '',
            "description" => esc_html__('Input Item 31 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Price", 'ronby'),
            "param_name" => "item_price31",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features31",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Short Description", 'ronby'),
            "param_name" => "text31",
            "value" => '',
            "description" => esc_html__('Input Item 31 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 More Info URL", 'ronby'),
            "param_name" => "more_url31",
            "value" => '',
            "description" => esc_html__('Input Item 31 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Date", 'ronby'),
            "param_name" => "item_date31",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array( 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating31",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array( 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 Title", 'ronby'),
            "param_name" => "item_title32",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 Image URL", 'ronby'),
            "param_name" => "item_img32",
            "value" => '',
            "description" => esc_html__('Input Item 32 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 Price", 'ronby'),
            "param_name" => "item_price32",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features32",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 Short Description", 'ronby'),
            "param_name" => "text32",
            "value" => '',
            "description" => esc_html__('Input Item 32 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 More Info URL", 'ronby'),
            "param_name" => "more_url32",
            "value" => '',
            "description" => esc_html__('Input Item 32 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 Date", 'ronby'),
            "param_name" => "item_date32",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array( 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating32",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array( 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-33 Title", 'ronby'),
            "param_name" => "item_title33",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-33 Image URL", 'ronby'),
            "param_name" => "item_img33",
            "value" => '',
            "description" => esc_html__('Input Item 33 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-33 Price", 'ronby'),
            "param_name" => "item_price33",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-33 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features33",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-33 Short Description", 'ronby'),
            "param_name" => "text33",
            "value" => '',
            "description" => esc_html__('Input Item 33 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-33 More Info URL", 'ronby'),
            "param_name" => "more_url33",
            "value" => '',
            "description" => esc_html__('Input Item 33 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-33 Date", 'ronby'),
            "param_name" => "item_date33",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-33 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating33",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-34 Title", 'ronby'),
            "param_name" => "item_title34",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-34 Image URL", 'ronby'),
            "param_name" => "item_img34",
            "value" => '',
            "description" => esc_html__('Input Item 34 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-34 Price", 'ronby'),
            "param_name" => "item_price34",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-34 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features34",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-34 Short Description", 'ronby'),
            "param_name" => "text34",
            "value" => '',
            "description" => esc_html__('Input Item 34 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-34 More Info URL", 'ronby'),
            "param_name" => "more_url34",
            "value" => '',
            "description" => esc_html__('Input Item 34 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-34 Date", 'ronby'),
            "param_name" => "item_date34",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-34 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating34",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-35 Title", 'ronby'),
            "param_name" => "item_title35",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-35 Image URL", 'ronby'),
            "param_name" => "item_img35",
            "value" => '',
            "description" => esc_html__('Input Item 35 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-35 Price", 'ronby'),
            "param_name" => "item_price35",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-35 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features35",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-35 Short Description", 'ronby'),
            "param_name" => "text35",
            "value" => '',
            "description" => esc_html__('Input Item 35 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-35 More Info URL", 'ronby'),
            "param_name" => "more_url35",
            "value" => '',
            "description" => esc_html__('Input Item 35 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-35 Date", 'ronby'),
            "param_name" => "item_date35",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-35 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating35",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-36 Title", 'ronby'),
            "param_name" => "item_title36",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-36 Image URL", 'ronby'),
            "param_name" => "item_img36",
            "value" => '',
            "description" => esc_html__('Input Item 36 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-36 Price", 'ronby'),
            "param_name" => "item_price36",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-36 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features36",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-36 Short Description", 'ronby'),
            "param_name" => "text36",
            "value" => '',
            "description" => esc_html__('Input Item 36 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-36 More Info URL", 'ronby'),
            "param_name" => "more_url36",
            "value" => '',
            "description" => esc_html__('Input Item 36 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-36 Date", 'ronby'),
            "param_name" => "item_date36",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-36 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating36",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-37 Title", 'ronby'),
            "param_name" => "item_title37",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-37 Image URL", 'ronby'),
            "param_name" => "item_img37",
            "value" => '',
            "description" => esc_html__('Input Item 37 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-37 Price", 'ronby'),
            "param_name" => "item_price37",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-37 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features37",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-37 Short Description", 'ronby'),
            "param_name" => "text37",
            "value" => '',
            "description" => esc_html__('Input Item 37 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-37 More Info URL", 'ronby'),
            "param_name" => "more_url37",
            "value" => '',
            "description" => esc_html__('Input Item 37 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-37 Date", 'ronby'),
            "param_name" => "item_date37",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-37 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating37",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-38 Title", 'ronby'),
            "param_name" => "item_title38",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-38 Image URL", 'ronby'),
            "param_name" => "item_img38",
            "value" => '',
            "description" => esc_html__('Input Item 38 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-38 Price", 'ronby'),
            "param_name" => "item_price38",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-38 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features38",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-38 Short Description", 'ronby'),
            "param_name" => "text38",
            "value" => '',
            "description" => esc_html__('Input Item 38 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-38 More Info URL", 'ronby'),
            "param_name" => "more_url38",
            "value" => '',
            "description" => esc_html__('Input Item 38 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-38 Date", 'ronby'),
            "param_name" => "item_date38",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-38 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating38",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-39 Title", 'ronby'),
            "param_name" => "item_title39",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-39 Image URL", 'ronby'),
            "param_name" => "item_img39",
            "value" => '',
            "description" => esc_html__('Input Item 39 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-39 Price", 'ronby'),
            "param_name" => "item_price39",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-39 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features39",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-39 Short Description", 'ronby'),
            "param_name" => "text39",
            "value" => '',
            "description" => esc_html__('Input Item 39 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-39 More Info URL", 'ronby'),
            "param_name" => "more_url39",
            "value" => '',
            "description" => esc_html__('Input Item 39 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-39 Date", 'ronby'),
            "param_name" => "item_date39",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-39 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating39",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-40 Title", 'ronby'),
            "param_name" => "item_title40",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => '40'
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-40 Image URL", 'ronby'),
            "param_name" => "item_img40",
            "value" => '',
            "description" => esc_html__('Input Item 40 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => '40'
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-40 Price", 'ronby'),
            "param_name" => "item_price40",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => '40'
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-40 Category Classes for Filter", 'ronby'),
            "param_name" => "item_features40",
			"description" => esc_html__('Separate each Category by SPACE. IMPORTANT: To let the filter work Do Not use any space in category name. For example: Input Web-Design instead of Web Design. And the names should exactly match the categories you put in the top field "Item Filter Categories".','ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => '40'
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-40 Short Description", 'ronby'),
            "param_name" => "text40",
            "value" => '',
            "description" => esc_html__('Input Item 40 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => '40'
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-40 More Info URL", 'ronby'),
            "param_name" => "more_url40",
            "value" => '',
            "description" => esc_html__('Input Item 40 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => '40'
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-40 Date", 'ronby'),
            "param_name" => "item_date40",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-40 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating40",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'40',
						)
            )
         ),	
		 array(
            "type" => "attach_image",            
            "class" => "",
            "heading" => esc_html__("Section Background Image", 'ronby'),
            "param_name" => "bg_img",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
            "group" => esc_html__('Design-Options', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Section Padding Top", 'ronby'),
            "param_name" => "padding_top",
            "value" => '',
            "description" => esc_html__('Example: 50px', 'ronby'),
            "group" => esc_html__('Design-Options', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Section Padding Bottom", 'ronby'),
            "param_name" => "padding_bottom",
            "value" => '',
            "description" => esc_html__('Example: 50px', 'ronby'),
            "group" => esc_html__('Design-Options', 'ronby'),
         ),			 
      )
   )
);

/*****************************
Restaurant Video Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Video Section", 'ronby'),
      "base" => "ronby_shortcode_for_restaurant_video_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Video Section.', 'ronby'),
      "params" => array(         

        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading One", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" => '',
         ),	 
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading Two", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" => '',
         ),	
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Youtube URL", 'ronby'),
            "param_name" => "youtube_url",
            "value" => '',
            "description" => '',
         ),		 
        array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Background Image", 'ronby'),
            "param_name" => "bg_img",
            "value" => '',
            "description" => '',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading One Color", 'ronby'),
            "param_name" => "heading1_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Heading Two Color", 'ronby'),
            "param_name" => "heading2_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 
   )
)
);

/*****************************
Restaurant Blog Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Blog Section", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_restaurant_blog_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Blog Section.', 'ronby'),
      "params" => array(         
		array(
        "type" => "dropdown_multi",
        "heading" => esc_html__("Which Category Post do you want to display?", 'ronby'),
        "param_name" => "multiple",
        "value" => $blog_categories_array,
        "description" => esc_html__( 'Press ctrl+A command to select all categories', 'ronby' ),
		),
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("How many post do you want to display?", 'ronby'),
            "param_name" => "num_post",
            "value" => '',
            "description" => esc_html__( 'Enter nemeric value. By default, All post will display.', 'ronby' ),
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("How many words do you want to display?", 'ronby'),
            "param_name" => "word_limit",
            "value" => '',
            "description" => esc_html__( 'Example:25. Enter nemeric value.', 'ronby' ),
         ),
        array(
          'param_name'    => 'order',
          'type'          => 'dropdown',
          'value' => array(
                    array(
                    'value' => 'DESC',
                    'label' => esc_html__( 'DESC', 'ronby' ),
                    ),
                    array(
                    'value' => 'ASC',
                    'label' => esc_html__( 'ASC', 'ronby' ),
                    ),
                    ),
          'heading'       => esc_html__('Order', 'ronby'),
          'description'   => 'Select the post order(ASC or DESC). By default is DESC Order',
          'class'         => ''
        ),
        array(
          'param_name'    => 'orderby',
          'type'          => 'dropdown',
          'value' => array(
                    array(
                    'value' => 'date',
                    'label' => esc_html__( 'Date', 'ronby' ),
                    ),
                    array(
                    'value' => 'title',
                    'label' => esc_html__( 'Title', 'ronby' ),
                    ),
                    array(
                    'value' => 'rand',
                    'label' => esc_html__( 'Random', 'ronby' ),
                    ),
                    array(
                    'value' => 'id',
                    'label' => esc_html__( 'ID', 'ronby' ),
                    ),
                    array(
                    'value' => 'author',
                    'label' => esc_html__( 'Author', 'ronby' ),
                    ),
                    array(
                    'value' => 'comment_count',
                    'label' => esc_html__( 'Comment count', 'ronby' ),
                    ),
                    array(
                    'value' => 'menu_order',
                    'label' => esc_html__( 'Menu order', 'ronby' ),
                    ),
                    array(
                    'value' => 'modified',
                    'label' => esc_html__( 'Modified', 'ronby' ),
                    ),
                    array(
                    'value' => 'parent',
                    'label' => esc_html__( 'Parent', 'ronby' ),
                    ),
                    ),
          'heading'       => esc_html__('Sort Post By Order', 'ronby'),
          'description'   => 'By default is Order By Date',
          'class'         => ''
        ),		 
	 
   )
)
);

/*****************************
Restaurant Testimonial Slider
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Testimonial Slider", 'ronby'),
      "base" => "ronby_shortcode_for_restaurant_testimonial_slider",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Testimonial Slider.', 'ronby'),
      "params" => array(         

         array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Number of Testimonials", 'ronby'),
            "param_name" => "number_of_testimonial",
            'admin_label' => true,
			"description" => esc_html__("Select minimum Two testimonial.", 'ronby'),
            "value" => array(
               esc_html__('One', 'ronby')=>'1',
               esc_html__('Two', 'ronby')=>'2',
               esc_html__('Three', 'ronby')=>'3',
               esc_html__('Four', 'ronby')=>'4',
               esc_html__('Five', 'ronby')=>'5',
               esc_html__('Six', 'ronby')=>'6',
               esc_html__('Seven', 'ronby')=>'7',
               esc_html__('Eight', 'ronby')=>'8',
               esc_html__('Nine', 'ronby')=>'9',
               esc_html__('Ten', 'ronby')=>'10',
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 1 Name", 'ronby'),
            "param_name" => "name1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 1 Designation", 'ronby'),
            "param_name" => "designation1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 1 Review", 'ronby'),
            "param_name" => "text1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 1 Image URL", 'ronby'),
            "param_name" => "img_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 2 Name", 'ronby'),
            "param_name" => "name2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 2 Designation", 'ronby'),
            "param_name" => "designation2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 2 Review", 'ronby'),
            "param_name" => "text2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 2 Image URL", 'ronby'),
            "param_name" => "img_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 3 Name", 'ronby'),
            "param_name" => "name3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 3 Designation", 'ronby'),
            "param_name" => "designation3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 3 Review", 'ronby'),
            "param_name" => "text3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 3 Image URL", 'ronby'),
            "param_name" => "img_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 4 Name", 'ronby'),
            "param_name" => "name4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 4 Designation", 'ronby'),
            "param_name" => "designation4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 4 Review", 'ronby'),
            "param_name" => "text4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 4 Image URL", 'ronby'),
            "param_name" => "img_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 5 Name", 'ronby'),
            "param_name" => "name5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 5 Designation", 'ronby'),
            "param_name" => "designation5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 5 Review", 'ronby'),
            "param_name" => "text5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 5 Image URL", 'ronby'),
            "param_name" => "img_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 6 Name", 'ronby'),
            "param_name" => "name6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 6 Designation", 'ronby'),
            "param_name" => "designation6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 6 Review", 'ronby'),
            "param_name" => "text6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 6 Image URL", 'ronby'),
            "param_name" => "img_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 7 Name", 'ronby'),
            "param_name" => "name7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 7 Designation", 'ronby'),
            "param_name" => "designation7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 7 Review", 'ronby'),
            "param_name" => "text7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 7 Image URL", 'ronby'),
            "param_name" => "img_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 8 Name", 'ronby'),
            "param_name" => "name8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 8 Designation", 'ronby'),
            "param_name" => "designation8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 8 Review", 'ronby'),
            "param_name" => "text8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 8 Image URL", 'ronby'),
            "param_name" => "img_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 9 Name", 'ronby'),
            "param_name" => "name9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 9 Designation", 'ronby'),
            "param_name" => "designation9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 9 Review", 'ronby'),
            "param_name" => "text9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 9 Image URL", 'ronby'),
            "param_name" => "img_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),	
        array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 10 Name", 'ronby'),
            "param_name" => "name10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 10 Designation", 'ronby'),
            "param_name" => "designation10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '10',
                        )
            )
         ),
         array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Client- 10 Review", 'ronby'),
            "param_name" => "text10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Client- 10 Image URL", 'ronby'),
            "param_name" => "img_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_testimonial',
               'value' => array(
                                '10',
                        )
            )
         ),
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Name Color", 'ronby'),
            "param_name" => "name_color",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            "group" => esc_html__("Design-Options", 'ronby'),
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Designation Color", 'ronby'),
            "param_name" => "designation_color",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            "group" => esc_html__("Design-Options", 'ronby'),
         ),	
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Text Color", 'ronby'),
            "param_name" => "text_color",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            "group" => esc_html__("Design-Options", 'ronby'),
         ),			 
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Section Background Color", 'ronby'),
            "param_name" => "bg_color",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            "group" => esc_html__("Design-Options", 'ronby'),
         ),		 
   )
)
);

/*****************************
Restaurant Contact Info
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Contact Info", 'ronby'),
      "base" => "ronby_shortcode_for_ronby_restaurant_contact_info",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows contact info.', 'ronby'),
      "params" => array(  
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Map Address", 'ronby'),
            "param_name" => "map_address",
            "value" => '',
            "description" => 'Example: Victoria 3000 Australia'
         ),
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Map Height", 'ronby'),
            "param_name" => "map_height",
            "value" => '',
            "description" => 'Enter here Height in pixel(e.g. 350px). By default is set to 480px.'
         ),		  
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Heading Line", 'ronby'),
            "param_name" => "headline",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),
		 array(
            "type" => "textarea",            
            "class" => "",
            "heading" => esc_html__("Short Description", 'ronby'),
            "param_name" => "short_description",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Facebook URL", 'ronby'),
            "param_name" => "facebook_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Twitter URL", 'ronby'),
            "param_name" => "twitter_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Linkedin URL", 'ronby'),
            "param_name" => "linkedin_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Pinterest URL", 'ronby'),
            "param_name" => "pinterest_url",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Email", 'ronby'),
            "param_name" => "email",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Phone", 'ronby'),
            "param_name" => "phone",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),	
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Fax", 'ronby'),
            "param_name" => "fax",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Address", 'ronby'),
            "param_name" => "address",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Headline Color", 'ronby'),
            "param_name" => "headline_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Short Description Color", 'ronby'),
            "param_name" => "short_description_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Information Title Color", 'ronby'),
            "param_name" => "information_title_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Information Details Color", 'ronby'),
            "param_name" => "information_details_color",
            "value" => '',
            "description" => '',
            "group" => 'Design-Options',
         ),		 
   )
)
);

/*****************************
Restaurant Contact Form
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Contact Form", 'ronby'),
      "base" => "ronby_shortcode_for_restaurant_contact_form",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Contact Form.', 'ronby'),
      "params" => array(      
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Headline One", 'ronby'),
					"param_name" => "headline_one",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Headline Two", 'ronby'),
					"param_name" => "headline_two",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),				 
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Recipient Name", 'ronby'),
					"param_name" => "recipient_name",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Recipient Email", 'ronby'),
					"param_name" => "recipient_email",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Email Subject", 'ronby'),
					"param_name" => "email_subject",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Name Field Placeholder", 'ronby'),
					"param_name" => "name_field_placeholder",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Email Field Placeholder", 'ronby'),
					"param_name" => "email_field_placeholder",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),		
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Problem Field Placeholder", 'ronby'),
					"param_name" => "problem_field_placeholder",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Message Field Placeholder", 'ronby'),
					"param_name" => "message_field_placeholder",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Button Label", 'ronby'),
					"param_name" => "button_label",
					"value" => '',
					"description" => '',
					"group" => '',
				 ),	
                 array(
					"type" => "checkbox",
					"class" => "",
					"heading" => esc_html__("Do you want Select options?", 'ronby'),
					"param_name" => "wanttoselect",
					"std"		=> "no",
					"value" => array(
						//Label => Value
						"Yes" => "yes"
					),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Placeholder For Select", 'ronby'),
					"param_name" => "yourselect",
					"value" => 'Select One',
					'dependency' => array(
						 'element' => 'wanttoselect',
						 'value' =>'yes',
					 ),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Add items comma separated", 'ronby'),
					"param_name" => "selectitems",
					"value" => 'One, Two, Three, Four, Five',
					'dependency' => array(
						 'element' => 'wanttoselect',
						 'value' =>'yes',
					 ),
					"description" => 'Add items comma separated with a space like One, Two, Three, Four, Five'
				 ),
				 array(
					"type" => "checkbox",
					"class" => "",
					"heading" => esc_html__("Do you want Radio options?", 'ronby'),
					"param_name" => "wanttoradio",
					"std"		=> "no",
					"value" => array(
						//Label => Value
						"Yes" => "yes"
					),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Placeholder For Radio", 'ronby'),
					"param_name" => "yourradio",
					"value" => 'Select Radio',
					'dependency' => array(
						 'element' => 'wanttoradio',
						 'value' =>'yes',
					 ),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Add radio items comma separated", 'ronby'),
					"param_name" => "radioitems",
					"value" => 'One, Two, Three, Four, Five',
					'dependency' => array(
						 'element' => 'wanttoradio',
						 'value' =>'yes',
					 ),
					"description" => 'Add radio items comma separated with a space like One, Two, Three, Four, Five'
				 ),
				 array(
					"type" => "checkbox",
					"class" => "",
					"heading" => esc_html__("Do you want Checkbox options?", 'ronby'),
					"param_name" => "wanttocheckbox",
					"std"		=> "no",
					"value" => array(
						//Label => Value
						"Yes" => "yes"
					),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Placeholder For Checkbox", 'ronby'),
					"param_name" => "yourcheckbox",
					"value" => 'Select Checkbox',
					'dependency' => array(
						 'element' => 'wanttocheckbox',
						 'value' =>'yes',
					 ),
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Add checkbox items comma separated", 'ronby'),
					"param_name" => "checkboxitems",
					"value" => 'One, Two, Three, Four, Five',
					'dependency' => array(
						 'element' => 'wanttocheckbox',
						 'value' =>'yes',
					 ),
					"description" => 'Add checkbox items comma separated with a space like One, Two, Three, Four, Five'
				 ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Headline One Color", 'ronby'),
            "param_name" => "headline_one_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
            "group" =>  esc_html__('Design-Options', 'ronby'),
         ),
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Headline Two Color", 'ronby'),
            "param_name" => "headline_two_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
			"group" =>  esc_html__('Design-Options', 'ronby'),
         ),		
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Text Color", 'ronby'),
            "param_name" => "btn_text_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
			"group" =>  esc_html__('Design-Options', 'ronby'),
         ),	
		 array(
            "type" => "colorpicker",            
            "class" => "",
            "heading" => esc_html__("Button Background Color", 'ronby'),
            "param_name" => "btn_bg_color",
            "value" => '',
            "description" =>  esc_html__('', 'ronby'),
			"group" =>  esc_html__('Design-Options', 'ronby'),
         ),			 
   )
)
);

/******************************************
Restaurant Team Member Box
*******************************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Team Member Box", 'ronby'),
      "base" => "ronby_shortcode_for_restaurant_team_member_box",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows the Team Member Box.', 'ronby'),
      "params" => array(
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Name", 'ronby'),
            "param_name" => "name",
            "value" => '',
            "description" => ''
         ),

       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Designation", 'ronby'),
            "param_name" => "designation",
            "value" => '',
            "description" => ''
         ),
	
	
       array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Description", 'ronby'),
            "param_name" => "description",
            "value" => '',
            "description" => ''
         ),
	
		 
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Twitter URL", 'ronby'),
            "param_name" => "twitter_url",
            "value" => '',
            "description" => ''
         ),	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Facebook URL", 'ronby'),
            "param_name" => "facebook_url",
            "value" => '',
            "description" => ''
         ),
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Pinterest URL", 'ronby'),
            "param_name" => "pinterest_url",
            "value" => '',
            "description" => ''
         ),
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Linkedin URL", 'ronby'),
            "param_name" => "linkedin_url",
            "value" => '',
            "description" => ''
         ),

		 array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Do you want to Highlight the Box?", 'ronby'),
            "param_name" => "box_highlight_status",
			'value' => array(
						array(
						'value' => 'no',
						'label' => __( 'No', 'ronby' ),
						),
						array(
						'value' => 'yes',
						'label' => __( 'Yes', 'ronby' ),
						),
						),
            "description" => ''
         ),
		 array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Attach Profile Image", 'ronby'),
            "param_name" => "profile_img",
            "value" => '',
            "description" => '',
         ),	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Link to URL", 'ronby'),
            "param_name" => "link_to_url",
            "value" => '',
            "description" => ''
         ),		 
		 array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Box Highlight Background Color", 'ronby'),
            "param_name" => "box_highlight_bg_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),	
			 

		 array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Name Color", 'ronby'),
            "param_name" => "name_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Designation Color", 'ronby'),
            "param_name" => "designation_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Description Color", 'ronby'),
            "param_name" => "description_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),		 
		 array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Icon Area Background Color", 'ronby'),
            "param_name" => "icon_area_bg_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),			 
		 array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Image Overlay Color", 'ronby'),
            "param_name" => "img_overlay_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),
		 array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Box Background Color", 'ronby'),
            "param_name" => "box_bg_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),		 		 
   )
)
);

/*****************************
Restaurant Team Member Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Team Member Section", 'ronby'),
      "base" => "ronby_shortcode_for_restaurant_team_member_section",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Team Members section.', 'ronby'),
      "params" => array(    
	  
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading-1", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" => ''
         ),
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading-2", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" => ''
         ),	
       array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Left Side Image", 'ronby'),
            "param_name" => "bg_img",
            "value" => '',
            "description" => ''
         ),		 
         array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Number of Team Member", 'ronby'),
            "param_name" => "number_of_members",
            'admin_label' => true,
			"description" => esc_html__("Select minimum Two members.", 'ronby'),
            "value" => array(
               esc_html__('One', 'ronby')=>'1',
               esc_html__('Two', 'ronby')=>'2',
               esc_html__('Three', 'ronby')=>'3',
               esc_html__('Four', 'ronby')=>'4',
               esc_html__('Five', 'ronby')=>'5',
               esc_html__('Six', 'ronby')=>'6',
               esc_html__('Seven', 'ronby')=>'7',
               esc_html__('Eight', 'ronby')=>'8',
               esc_html__('Nine', 'ronby')=>'9',
               esc_html__('Ten', 'ronby')=>'10',
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-1 Name", 'ronby'),
            "param_name" => "member_name1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-1 Designation", 'ronby'),
            "param_name" => "member_designation1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-1 Description", 'ronby'),
            "param_name" => "member_desc1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-1 Image URL", 'ronby'),
            "param_name" => "member_img_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-1 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-1 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-1 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-1 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-1 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url1",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('1',
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-2 Name", 'ronby'),
            "param_name" => "member_name2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-2 Designation", 'ronby'),
            "param_name" => "member_designation2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-2 Description", 'ronby'),
            "param_name" => "member_desc2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-2 Image URL", 'ronby'),
            "param_name" => "member_img_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-2 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-2 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-2 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-2 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-2 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url2",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '2',
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-3 Name", 'ronby'),
            "param_name" => "member_name3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-3 Designation", 'ronby'),
            "param_name" => "member_designation3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-3 Description", 'ronby'),
            "param_name" => "member_desc3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-3 Image URL", 'ronby'),
            "param_name" => "member_img_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-3 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-3 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-3 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-3 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-3 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url3",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '3',
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-4 Name", 'ronby'),
            "param_name" => "member_name4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-4 Designation", 'ronby'),
            "param_name" => "member_designation4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-4 Description", 'ronby'),
            "param_name" => "member_desc4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-4 Image URL", 'ronby'),
            "param_name" => "member_img_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-4 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-4 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-4 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-4 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-4 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url4",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '4',
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-5 Name", 'ronby'),
            "param_name" => "member_name5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array('5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-5 Designation", 'ronby'),
            "param_name" => "member_designation5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-5 Description", 'ronby'),
            "param_name" => "member_desc5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-5 Image URL", 'ronby'),
            "param_name" => "member_img_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-5 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-5 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                 '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-5 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-5 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-5 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url5",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '5',
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-6 Name", 'ronby'),
            "param_name" => "member_name6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-6 Designation", 'ronby'),
            "param_name" => "member_designation6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-6 Description", 'ronby'),
            "param_name" => "member_desc6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-6 Image URL", 'ronby'),
            "param_name" => "member_img_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-6 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-6 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-6 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-6 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-6 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url6",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '6',
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-7 Name", 'ronby'),
            "param_name" => "member_name7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-7 Designation", 'ronby'),
            "param_name" => "member_designation7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-7 Description", 'ronby'),
            "param_name" => "member_desc7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-7 Image URL", 'ronby'),
            "param_name" => "member_img_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-7 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-7 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-7 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-7 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-7 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url7",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '7',
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-8 Name", 'ronby'),
            "param_name" => "member_name8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-8 Designation", 'ronby'),
            "param_name" => "member_designation8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-8 Description", 'ronby'),
            "param_name" => "member_desc8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-8 Image URL", 'ronby'),
            "param_name" => "member_img_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-8 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-8 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-8 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-8 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-8 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url8",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '8',
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-9 Name", 'ronby'),
            "param_name" => "member_name9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-9 Designation", 'ronby'),
            "param_name" => "member_designation9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-9 Description", 'ronby'),
            "param_name" => "member_desc9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-9 Image URL", 'ronby'),
            "param_name" => "member_img_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-9 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-9 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-9 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-9 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-9 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url9",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '9',
                                '10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-10 Name", 'ronby'),
            "param_name" => "member_name10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
								'10',
                        )
            )
         ),
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-10 Designation", 'ronby'),
            "param_name" => "member_designation10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-10 Description", 'ronby'),
            "param_name" => "member_desc10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-10 Image URL", 'ronby'),
            "param_name" => "member_img_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-10 Profile Details URL", 'ronby'),
            "param_name" => "member_link_to_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-10 Facebook Profile URL", 'ronby'),
            "param_name" => "member_fb_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-10 Twitter Profile URL", 'ronby'),
            "param_name" => "member_twitter_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),		
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-10 Linkedin Profile URL", 'ronby'),
            "param_name" => "member_linkedin_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                                '10',
                        )
            )
         ),	
         array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Member-10 Pinterest Profile URL", 'ronby'),
            "param_name" => "member_pinterest_url10",
            "value" => '',
            "description" => esc_html__("", 'ronby'),
            'dependency' => array(
               'element'=>'number_of_members',
               'value' => array(
                               '10',
                        )
            )
         ),	
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Heading-1 Color", 'ronby'),
            "param_name" => "heading1_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),	
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Heading-2 Color", 'ronby'),
            "param_name" => "heading2_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Name Color", 'ronby'),
            "param_name" => "name_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),	
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Designation Color", 'ronby'),
            "param_name" => "designation_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),	
       array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => esc_html__("Description Color", 'ronby'),
            "param_name" => "desc_color",
            "value" => '',
            "description" => '',
            "group" => esc_html__("Design-Options", 'ronby'),
         ),	
       array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Feature Box Margin Bottom?", 'ronby'),
            "param_name" => "f_box_margin_bottom",
            "value" => '',
            "description" => esc_html__("Example: 50px", 'ronby'),
            "group" => esc_html__("Design-Options", 'ronby'),
         ),		 
   )
)
);

/*****************************
Restaurant Team Details Section
******************************/
vc_map( array(
      "name" => esc_html__("FT- Restaurant Team Details Section", 'ronby'),
      "base" => "ronby_shortcode_for_restaurant_team_details_section_two",
      "icon" => plugins_url( 'images/vc.png', __FILE__ ),
      "class" => "",
      "category" => esc_html__('by Fluent-Themes Shortcodes', 'ronby'),
      'admin_enqueue_js' => '',
      'admin_enqueue_css' => '',
      'description' => esc_html__('Shows Restaurant Team Details Section.', 'ronby'),
      "params" => array(   
 		array(
            "type" => "attach_image",
            "class" => "",
            "heading" => esc_html__("Profile Image", 'ronby'),
            "param_name" => "profile_img",
            "value" => '',
            "description" => '',
         ),	     
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading-1", 'ronby'),
            "param_name" => "heading1",
            "value" => '',
            "description" => '',
         ),	
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Heading-2", 'ronby'),
            "param_name" => "heading2",
            "value" => '',
            "description" => '',
         ),		
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Designation", 'ronby'),
            "param_name" => "designation",
            "value" => '',
            "description" => '',
         ),	
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Short Description", 'ronby'),
            "param_name" => "short_description",
            "value" => '',
            "description" => '',
         ),		
		array(
            "type" => "textarea",
            "class" => "",
            "heading" => esc_html__("Detail Description", 'ronby'),
            "param_name" => "detail_description",
            "value" => '',
            "description" => '',
         ),	
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Info-1 Icon", 'ronby'),
            "param_name" => "info1icon",
            "value" => '',
            "description" => esc_html__("Example:far fa-arrow-alt-circle-right", 'ronby'),
         ),	
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Info-1 Title", 'ronby'),
            "param_name" => "info1title",
            "value" => '',
            "description" => '',
         ),	
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Info-2 Icon", 'ronby'),
            "param_name" => "info2icon",
            "value" => '',
            "description" => esc_html__("Example:far fa-arrow-alt-circle-right", 'ronby'),
         ),	
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Info-2 Title", 'ronby'),
            "param_name" => "info2title",
            "value" => '',
            "description" => '',
         ),	
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Facebook URL", 'ronby'),
            "param_name" => "fb_url",
            "value" => '',
            "description" => '',
         ),
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Twitter URL", 'ronby'),
            "param_name" => "twitter_url",
            "value" => '',
            "description" => '',
         ),
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Linkedin URL", 'ronby'),
            "param_name" => "linkedin_url",
            "value" => '',
            "description" => '',
         ),	
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Pinterest URL", 'ronby'),
            "param_name" => "pinterest_url",
            "value" => '',
            "description" => '',
         ),	
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Menu Heading- 1", 'ronby'),
            "param_name" => "menu_heading1",
            "value" => '',
            "description" => '',
         ),
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => esc_html__("Menu Heading- 2", 'ronby'),
            "param_name" => "menu_heading2",
            "value" => '',
            "description" => '',
         ),			 
		 array(
            "type" => "dropdown",            
            "class" => "",
            "heading" => esc_html__("Number of Items", 'ronby'),
            "param_name" => "number_of_items",
            'admin_label' => true,
			"description" => esc_html__("Select Minimum Two", 'ronby'),
            "value" => array(
               esc_html__('One', 'ronby')=>'1',
			   esc_html__('Two', 'ronby')=>'2', 
			   esc_html__('Three', 'ronby')=>'3',
			   esc_html__('Four', 'ronby')=>'4',
			   esc_html__('Five', 'ronby')=>'5', 
			   esc_html__('Six', 'ronby')=>'6',
			   esc_html__('Seven', 'ronby')=>'7',
			   esc_html__('Eight', 'ronby')=>'8', 
			   esc_html__('Nine', 'ronby')=>'9',
			   esc_html__('Ten', 'ronby')=>'10',
			   esc_html__('Eleven', 'ronby')=>'11',
			   esc_html__('Twelve', 'ronby')=>'12', 
			   esc_html__('Thirteen', 'ronby')=>'13',
			   esc_html__('Fourteen', 'ronby')=>'14',
			   esc_html__('Fifteen', 'ronby')=>'15', 
			   esc_html__('Sixteen', 'ronby')=>'16',
			   esc_html__('Seventeen', 'ronby')=>'17',
			   esc_html__('Eighteen', 'ronby')=>'18', 
			   esc_html__('Nineteen', 'ronby')=>'19',
			   esc_html__('Twenty', 'ronby')=>'20',
			   esc_html__('Twenty One', 'ronby')=>'21',
			   esc_html__('Twenty Two', 'ronby')=>'22', 
			   esc_html__('Twenty Three', 'ronby')=>'23',
			   esc_html__('Twenty Four', 'ronby')=>'24',
			   esc_html__('Twenty Five', 'ronby')=>'25', 
			   esc_html__('Twenty Six', 'ronby')=>'26',
			   esc_html__('Twenty Seven', 'ronby')=>'27',
			   esc_html__('Twenty Eight', 'ronby')=>'28', 
			   esc_html__('Twenty Nine', 'ronby')=>'29',
			   esc_html__('Thirty', 'ronby')=>'30',
			   esc_html__('Thirty One', 'ronby')=>'31',
			   esc_html__('Thirty Two', 'ronby')=>'32', 
			   esc_html__('Thirty Three', 'ronby')=>'33',
			   esc_html__('Thirty Four', 'ronby')=>'34',
			   esc_html__('Thirty Five', 'ronby')=>'35', 
			   esc_html__('Thirty Six', 'ronby')=>'36',
			   esc_html__('Thirty Seven', 'ronby')=>'37',
			   esc_html__('Thirty Eight', 'ronby')=>'38', 
			   esc_html__('Thirty Nine', 'ronby')=>'39',
			   esc_html__('Forty', 'ronby')=>'40',
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Title", 'ronby'),
            "param_name" => "item_title1",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Image URL", 'ronby'),
            "param_name" => "item_img1",
            "value" => '',
            "description" => esc_html__('Input Item 1 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Price", 'ronby'),
            "param_name" => "item_price1",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Short Description", 'ronby'),
            "param_name" => "text1",
            "value" => '',
            "description" => esc_html__('Input Item 1 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 More Info URL", 'ronby'),
            "param_name" => "more_url1",
            "value" => '',
            "description" => esc_html__('Input Item 1 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Date", 'ronby'),
            "param_name" => "item_date1",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-1 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating1",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('1',
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Title", 'ronby'),
            "param_name" => "item_title2",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Image URL", 'ronby'),
            "param_name" => "item_img2",
            "value" => '',
            "description" => esc_html__('Input Item 2 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Price", 'ronby'),
            "param_name" => "item_price2",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Short Description", 'ronby'),
            "param_name" => "text2",
            "value" => '',
            "description" => esc_html__('Input Item 2 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 More Info URL", 'ronby'),
            "param_name" => "more_url2",
            "value" => '',
            "description" => esc_html__('Input Item 2 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Date", 'ronby'),
            "param_name" => "item_date2",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-2 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating2",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'2',
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Title", 'ronby'),
            "param_name" => "item_title3",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Image URL", 'ronby'),
            "param_name" => "item_img3",
            "value" => '',
            "description" => esc_html__('Input Item 3 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Price", 'ronby'),
            "param_name" => "item_price3",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Short Description", 'ronby'),
            "param_name" => "text3",
            "value" => '',
            "description" => esc_html__('Input Item 3 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 More Info URL", 'ronby'),
            "param_name" => "more_url3",
            "value" => '',
            "description" => esc_html__('Input Item 3 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Date", 'ronby'),
            "param_name" => "item_date3",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating3",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'3',
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Title", 'ronby'),
            "param_name" => "item_title4",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Image URL", 'ronby'),
            "param_name" => "item_img4",
            "value" => '',
            "description" => esc_html__('Input Item 4 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Price", 'ronby'),
            "param_name" => "item_price4",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Short Description", 'ronby'),
            "param_name" => "text4",
            "value" => '',
            "description" => esc_html__('Input Item 4 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 More Info URL", 'ronby'),
            "param_name" => "more_url4",
            "value" => '',
            "description" => esc_html__('Input Item 4 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-4 Date", 'ronby'),
            "param_name" => "item_date4",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-3 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating4",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'4',
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Title", 'ronby'),
            "param_name" => "item_title5",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Image URL", 'ronby'),
            "param_name" => "item_img5",
            "value" => '',
            "description" => esc_html__('Input Item 5 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Price", 'ronby'),
            "param_name" => "item_price5",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Short Description", 'ronby'),
            "param_name" => "text5",
            "value" => '',
            "description" => esc_html__('Input Item 5 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 More Info URL", 'ronby'),
            "param_name" => "more_url5",
            "value" => '',
            "description" => esc_html__('Input Item 5 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Date", 'ronby'),
            "param_name" => "item_date5",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-5 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating5",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'5',
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Title", 'ronby'),
            "param_name" => "item_title6",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Image URL", 'ronby'),
            "param_name" => "item_img6",
            "value" => '',
            "description" => esc_html__('Input Item 6 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Price", 'ronby'),
            "param_name" => "item_price6",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Short Description", 'ronby'),
            "param_name" => "text6",
            "value" => '',
            "description" => esc_html__('Input Item 6 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 More Info URL", 'ronby'),
            "param_name" => "more_url6",
            "value" => '',
            "description" => esc_html__('Input Item 6 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Date", 'ronby'),
            "param_name" => "item_date6",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-6 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating6",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								
								'6',
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Title", 'ronby'),
            "param_name" => "item_title7",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Image URL", 'ronby'),
            "param_name" => "item_img7",
            "value" => '',
            "description" => esc_html__('Input Item 7 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Price", 'ronby'),
            "param_name" => "item_price7",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Short Description", 'ronby'),
            "param_name" => "text7",
            "value" => '',
            "description" => esc_html__('Input Item 7 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 More Info URL", 'ronby'),
            "param_name" => "more_url7",
            "value" => '',
            "description" => esc_html__('Input Item 7 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Date", 'ronby'),
            "param_name" => "item_date7",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-7 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating7",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'7',
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Title", 'ronby'),
            "param_name" => "item_title8",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Image URL", 'ronby'),
            "param_name" => "item_img8",
            "value" => '',
            "description" => esc_html__('Input Item 8 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Price", 'ronby'),
            "param_name" => "item_price8",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Short Description", 'ronby'),
            "param_name" => "text8",
            "value" => '',
            "description" => esc_html__('Input Item 8 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 More Info URL", 'ronby'),
            "param_name" => "more_url8",
            "value" => '',
            "description" => esc_html__('Input Item 8 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Date", 'ronby'),
            "param_name" => "item_date8",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-8 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating8",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'8',
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Title", 'ronby'),
            "param_name" => "item_title9",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10','11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Image URL", 'ronby'),
            "param_name" => "item_img9",
            "value" => '',
            "description" => esc_html__('Input Item 9 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Price", 'ronby'),
            "param_name" => "item_price9",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Short Description", 'ronby'),
            "param_name" => "text9",
            "value" => '',
            "description" => esc_html__('Input Item 9 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 More Info URL", 'ronby'),
            "param_name" => "more_url9",
            "value" => '',
            "description" => esc_html__('Input Item 9 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Date", 'ronby'),
            "param_name" => "item_date9",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-9 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating9",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'9',
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Title", 'ronby'),
            "param_name" => "item_title10",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Image URL", 'ronby'),
            "param_name" => "item_img10",
            "value" => '',
            "description" => esc_html__('Input Item 10 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Price", 'ronby'),
            "param_name" => "item_price10",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Short Description", 'ronby'),
            "param_name" => "text10",
            "value" => '',
            "description" => esc_html__('Input Item 10 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 More Info URL", 'ronby'),
            "param_name" => "more_url10",
            "value" => '',
            "description" => esc_html__('Input Item 10 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Date", 'ronby'),
            "param_name" => "item_date10",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-10 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating10",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'10',
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Title", 'ronby'),
            "param_name" => "item_title11",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Image URL", 'ronby'),
            "param_name" => "item_img11",
            "value" => '',
            "description" => esc_html__('Input Item 11 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Price", 'ronby'),
            "param_name" => "item_price11",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Short Description", 'ronby'),
            "param_name" => "text11",
            "value" => '',
            "description" => esc_html__('Input Item 11 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 More Info URL", 'ronby'),
            "param_name" => "more_url11",
            "value" => '',
            "description" => esc_html__('Input Item 11 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Date", 'ronby'),
            "param_name" => "item_date11",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-11 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating11",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'11',
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 Title", 'ronby'),
            "param_name" => "item_title12",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 Image URL", 'ronby'),
            "param_name" => "item_img12",
            "value" => '',
            "description" => esc_html__('Input Item 12 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 Price", 'ronby'),
            "param_name" => "item_price12",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 Short Description", 'ronby'),
            "param_name" => "text12",
            "value" => '',
            "description" => esc_html__('Input Item 12 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-12 More Info URL", 'ronby'),
            "param_name" => "more_url12",
            "value" => '',
            "description" => esc_html__('Input Item 12 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'12',
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Date", 'ronby'),
            "param_name" => "item_date13",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating13",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Title", 'ronby'),
            "param_name" => "item_title13",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Image URL", 'ronby'),
            "param_name" => "item_img13",
            "value" => '',
            "description" => esc_html__('Input Item 13 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Price", 'ronby'),
            "param_name" => "item_price13",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 Short Description", 'ronby'),
            "param_name" => "text13",
            "value" => '',
            "description" => esc_html__('Input Item 13 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-13 More Info URL", 'ronby'),
            "param_name" => "more_url13",
            "value" => '',
            "description" => esc_html__('Input Item 13 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('13',
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Date", 'ronby'),
            "param_name" => "item_date14",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating14",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Title", 'ronby'),
            "param_name" => "item_title14",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Image URL", 'ronby'),
            "param_name" => "item_img14",
            "value" => '',
            "description" => esc_html__('Input Item 14 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Price", 'ronby'),
            "param_name" => "item_price14",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Short Description", 'ronby'),
            "param_name" => "text14",
            "value" => '',
            "description" => esc_html__('Input Item 14 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 More Info URL", 'ronby'),
            "param_name" => "more_url14",
            "value" => '',
            "description" => esc_html__('Input Item 14 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Date", 'ronby'),
            "param_name" => "item_date14",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-14 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating14",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'14',
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Title", 'ronby'),
            "param_name" => "item_title15",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Image URL", 'ronby'),
            "param_name" => "item_img15",
            "value" => '',
            "description" => esc_html__('Input Item 15 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Price", 'ronby'),
            "param_name" => "item_price15",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Short Description", 'ronby'),
            "param_name" => "text15",
            "value" => '',
            "description" => esc_html__('Input Item 15 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 More Info URL", 'ronby'),
            "param_name" => "more_url15",
            "value" => '',
            "description" => esc_html__('Input Item 15 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Date", 'ronby'),
            "param_name" => "item_date15",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-15 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating15",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'15',
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating16",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),			 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Title", 'ronby'),
            "param_name" => "item_title16",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Image URL", 'ronby'),
            "param_name" => "item_img16",
            "value" => '',
            "description" => esc_html__('Input Item 16 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Price", 'ronby'),
            "param_name" => "item_price16",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Short Description", 'ronby'),
            "param_name" => "text16",
            "value" => '',
            "description" => esc_html__('Input Item 16 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 More Info URL", 'ronby'),
            "param_name" => "more_url16",
            "value" => '',
            "description" => esc_html__('Input Item 16 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-16 Date", 'ronby'),
            "param_name" => "item_date16",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'16',
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Title", 'ronby'),
            "param_name" => "item_title17",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Image URL", 'ronby'),
            "param_name" => "item_img17",
            "value" => '',
            "description" => esc_html__('Input Item 17 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Price", 'ronby'),
            "param_name" => "item_price17",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Short Description", 'ronby'),
            "param_name" => "text17",
            "value" => '',
            "description" => esc_html__('Input Item 17 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 More Info URL", 'ronby'),
            "param_name" => "more_url17",
            "value" => '',
            "description" => esc_html__('Input Item 17 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Date", 'ronby'),
            "param_name" => "item_date17",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-17 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating17",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'17',
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Title", 'ronby'),
            "param_name" => "item_title18",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Image URL", 'ronby'),
            "param_name" => "item_img18",
            "value" => '',
            "description" => esc_html__('Input Item 18 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Price", 'ronby'),
            "param_name" => "item_price18",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Short Description", 'ronby'),
            "param_name" => "text18",
            "value" => '',
            "description" => esc_html__('Input Item 18 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 More Info URL", 'ronby'),
            "param_name" => "more_url18",
            "value" => '',
            "description" => esc_html__('Input Item 18 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Date", 'ronby'),
            "param_name" => "item_date18",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-18 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating18",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'18',
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Title", 'ronby'),
            "param_name" => "item_title19",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Image URL", 'ronby'),
            "param_name" => "item_img19",
            "value" => '',
            "description" => esc_html__('Input Item 19 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Price", 'ronby'),
            "param_name" => "item_price19",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Short Description", 'ronby'),
            "param_name" => "text19",
            "value" => '',
            "description" => esc_html__('Input Item 19 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 More Info URL", 'ronby'),
            "param_name" => "more_url19",
            "value" => '',
            "description" => esc_html__('Input Item 19 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Date", 'ronby'),
            "param_name" => "item_date19",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-19 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating19",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'19',
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Title", 'ronby'),
            "param_name" => "item_title20",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Image URL", 'ronby'),
            "param_name" => "item_img20",
            "value" => '',
            "description" => esc_html__('Input Item 20 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Price", 'ronby'),
            "param_name" => "item_price20",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Short Description", 'ronby'),
            "param_name" => "text20",
            "value" => '',
            "description" => esc_html__('Input Item 20 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 More Info URL", 'ronby'),
            "param_name" => "more_url20",
            "value" => '',
            "description" => esc_html__('Input Item 20 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Date", 'ronby'),
            "param_name" => "item_date20",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-20 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating20",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'20',
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Title", 'ronby'),
            "param_name" => "item_title21",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Image URL", 'ronby'),
            "param_name" => "item_img21",
            "value" => '',
            "description" => esc_html__('Input Item 21 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Price", 'ronby'),
            "param_name" => "item_price21",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Short Description", 'ronby'),
            "param_name" => "text21",
            "value" => '',
            "description" => esc_html__('Input Item 21 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 More Info URL", 'ronby'),
            "param_name" => "more_url21",
            "value" => '',
            "description" => esc_html__('Input Item 21 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Date", 'ronby'),
            "param_name" => "item_date21",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-21 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating21",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'21',
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Title", 'ronby'),
            "param_name" => "item_title22",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Image URL", 'ronby'),
            "param_name" => "item_img22",
            "value" => '',
            "description" => esc_html__('Input Item 22 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Price", 'ronby'),
            "param_name" => "item_price22",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Short Description", 'ronby'),
            "param_name" => "text22",
            "value" => '',
            "description" => esc_html__('Input Item 22 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 More Info URL", 'ronby'),
            "param_name" => "more_url22",
            "value" => '',
            "description" => esc_html__('Input Item 22 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Date", 'ronby'),
            "param_name" => "item_date22",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-22 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating22",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'22',
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Title", 'ronby'),
            "param_name" => "item_title23",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Image URL", 'ronby'),
            "param_name" => "item_img23",
            "value" => '',
            "description" => esc_html__('Input Item 23 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Price", 'ronby'),
            "param_name" => "item_price23",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Short Description", 'ronby'),
            "param_name" => "text23",
            "value" => '',
            "description" => esc_html__('Input Item 23 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 More Info URL", 'ronby'),
            "param_name" => "more_url23",
            "value" => '',
            "description" => esc_html__('Input Item 23 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Date", 'ronby'),
            "param_name" => "item_date23",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-23 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating23",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'23',
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Title", 'ronby'),
            "param_name" => "item_title24",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Image URL", 'ronby'),
            "param_name" => "item_img24",
            "value" => '',
            "description" => esc_html__('Input Item 24 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', '31', '32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Price", 'ronby'),
            "param_name" => "item_price24",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Short Description", 'ronby'),
            "param_name" => "text24",
            "value" => '',
            "description" => esc_html__('Input Item 24 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 More Info URL", 'ronby'),
            "param_name" => "more_url24",
            "value" => '',
            "description" => esc_html__('Input Item 24 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Date", 'ronby'),
            "param_name" => "item_date24",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-24 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating24",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								
								'24',
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Title", 'ronby'),
            "param_name" => "item_title25",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Image URL", 'ronby'),
            "param_name" => "item_img25",
            "value" => '',
            "description" => esc_html__('Input Item 25 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Price", 'ronby'),
            "param_name" => "item_price25",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Short Description", 'ronby'),
            "param_name" => "text25",
            "value" => '',
            "description" => esc_html__('Input Item 25 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 More Info URL", 'ronby'),
            "param_name" => "more_url25",
            "value" => '',
            "description" => esc_html__('Input Item 25 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('25',
								'26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Date", 'ronby'),
            "param_name" => "item_date19",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-25 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating25",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'25',
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Title", 'ronby'),
            "param_name" => "item_title26",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Image URL", 'ronby'),
            "param_name" => "item_img26",
            "value" => '',
            "description" => esc_html__('Input Item 26 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Price", 'ronby'),
            "param_name" => "item_price26",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Short Description", 'ronby'),
            "param_name" => "text26",
            "value" => '',
            "description" => esc_html__('Input Item 26 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 More Info URL", 'ronby'),
            "param_name" => "more_url26",
            "value" => '',
            "description" => esc_html__('Input Item 26 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('26',
								'27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Date", 'ronby'),
            "param_name" => "item_date26",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-26 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating26",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'26',
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Title", 'ronby'),
            "param_name" => "item_title27",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Image URL", 'ronby'),
            "param_name" => "item_img27",
            "value" => '',
            "description" => esc_html__('Input Item 27 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Price", 'ronby'),
            "param_name" => "item_price27",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Short Description", 'ronby'),
            "param_name" => "text27",
            "value" => '',
            "description" => esc_html__('Input Item 27 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 More Info URL", 'ronby'),
            "param_name" => "more_url27",
            "value" => '',
            "description" => esc_html__('Input Item 27 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('27',
								'28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Date", 'ronby'),
            "param_name" => "item_date27",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-27 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating27",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'27',
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Title", 'ronby'),
            "param_name" => "item_title28",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Image URL", 'ronby'),
            "param_name" => "item_img28",
            "value" => '',
            "description" => esc_html__('Input Item 28 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Price", 'ronby'),
            "param_name" => "item_price28",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Short Description", 'ronby'),
            "param_name" => "text28",
            "value" => '',
            "description" => esc_html__('Input Item 28 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 More Info URL", 'ronby'),
            "param_name" => "more_url28",
            "value" => '',
            "description" => esc_html__('Input Item 28 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('28',
								'29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Date", 'ronby'),
            "param_name" => "item_date28",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-28 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating28",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'28',
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Title", 'ronby'),
            "param_name" => "item_title29",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Image URL", 'ronby'),
            "param_name" => "item_img29",
            "value" => '',
            "description" => esc_html__('Input Item 29 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Price", 'ronby'),
            "param_name" => "item_price29",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Short Description", 'ronby'),
            "param_name" => "text29",
            "value" => '',
            "description" => esc_html__('Input Item 29 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 More Info URL", 'ronby'),
            "param_name" => "more_url29",
            "value" => '',
            "description" => esc_html__('Input Item 29 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('29',
								'30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Date", 'ronby'),
            "param_name" => "item_date29",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-29 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating29",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'29',
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Title", 'ronby'),
            "param_name" => "item_title30",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Image URL", 'ronby'),
            "param_name" => "item_img30",
            "value" => '',
            "description" => esc_html__('Input Item 30 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Price", 'ronby'),
            "param_name" => "item_price30",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Short Description", 'ronby'),
            "param_name" => "text30",
            "value" => '',
            "description" => esc_html__('Input Item 30 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 More Info URL", 'ronby'),
            "param_name" => "more_url30",
            "value" => '',
            "description" => esc_html__('Input Item 30 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('30',
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Date", 'ronby'),
            "param_name" => "item_date30",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-30 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating30",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'30', 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Title", 'ronby'),
            "param_name" => "item_title31",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Image URL", 'ronby'),
            "param_name" => "item_img31",
            "value" => '',
            "description" => esc_html__('Input Item 31 image url', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array('31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Price", 'ronby'),
            "param_name" => "item_price31",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),

		  array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Short Description", 'ronby'),
            "param_name" => "text31",
            "value" => '',
            "description" => esc_html__('Input Item 31 Short Description', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 More Info URL", 'ronby'),
            "param_name" => "more_url31",
            "value" => '',
            "description" => esc_html__('Input Item 31 more info url. Make a details page of this item and use that page url here.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'31',
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Date", 'ronby'),
            "param_name" => "item_date31",
            "value" => '',
            "description" => esc_html__('', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array( 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-31 Star Rating out of 5", 'ronby'),
            "param_name" => "item_rating31",
            "value" => '',
            "description" => esc_html__('Example: 5. Numeric value only acceptable.', 'ronby'),
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array( 
								'31', 
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),		 
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 Title", 'ronby'),
            "param_name" => "item_title32",
			'dependency' => array(
               'element'=>'number_of_items',
               'value' => array(
								'32',
								'33',
								'34',
								'35',
								'36',
								'37',
								'38',
								'39',
								'40',
						)
            )
         ),
		 array(
            "type" => "textfield",            
            "class" => "",
            "heading" => esc_html__("Item-32 Image URL", 'ronby'),
            "param_name" => "item_img32",
            "value" => '',
            "description" => esc_html__('Inp