<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( $related_products ) : ?>

    <?php

    $is_slider = ( count( $related_products ) >= 4 && yit_get_option( 'shop-related-slider' ) == 'yes' ) ? true : false;

    //force grid view
    $woocommerce_loop['view'] = 'grid';

    ?>

    <div class="clearfix related products">

    <?php if ( shortcode_exists( 'box_title' ) ) {
            echo do_shortcode("[box_title class='releated-products-title' font_size='18' border_color='#f2f2f2' font_alignment='center' border='middle']" . __( 'Related Products', 'yit' ) . "[/box_title]");
        } else {
            echo "<h2>" . __( 'Related Products', 'yit' ) . "</h2>";
        }?>

    <?php if ( $is_slider ) : ?>
        <div class="products-slider-wrapper" data-autoplay="true" >
            <div class="products-slider">
                <div class="row">
                    <ul class="products">
    <?php else : ?>
        <?php woocommerce_product_loop_start(); ?>
    <?php endif; ?>

    <?php foreach ( $related_products as $related_product ) : ?>

        <?php
        $post_object = get_post( $related_product->get_id() );

        setup_postdata( $GLOBALS['post'] =& $post_object );

        wc_get_template_part( 'content', 'product' ); ?>

    <?php endforeach; ?>

    <?php if ( $is_slider ) : ?>
                    </ul>
                </div>
            </div>
            <div class="es-nav">
                <div class="es-nav-prev"><span class="fa fa-chevron-left"></span></div>
                <div class="es-nav-next"><span class="fa fa-chevron-right"></span></div>
            </div>
        </div>
    <?php else: ?>
        <?php woocommerce_product_loop_end(); ?>
    <?php endif; ?>
    </div>

<?php endif;

wp_reset_postdata();
