<?php
/**
 * The template for displaying product widget entries.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-widget-product.php.
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

$rating_html = version_compare( WC()->version , '2.7', '<' ) ? $product->get_rating_html() : wc_get_rating_html( $product->get_average_rating() );
$title = $product->get_name();
$product_id = yit_get_base_product_id( $product );
?>

<li>
	<?php do_action( 'woocommerce_widget_product_item_start', $args ); ?>

	<a class="clearfix" href="<?php echo esc_url( get_permalink( $product_id ) ); ?>" title="<?php echo esc_attr( $title ); ?>">
		<?php echo $product->get_image(); ?>
		<span class="product-title"><?php echo $title; ?></span>
        <span class="product_price"><?php echo $product->get_price_html(); ?></span>
        <?php if ( !empty( $show_rating ) ) {
            echo $rating_html;
        } ?>
    </a>
    
    <?php do_action( 'woocommerce_widget_product_item_end', $args ); ?>
</li>