<?php
/**
 * Shipping Calculator
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/shipping-calculator.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

if ( 'no' === get_option( 'woocommerce_enable_shipping_calc' ) || ! WC()->cart->needs_shipping() ) {
	return;
}

wp_enqueue_script( 'wc-country-select' );

do_action( 'woocommerce_before_shipping_calculator' ); ?>

<form class="woocommerce-shipping-calculator" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">

    <h3 class="head"><?php _e( 'Calculate Shipping', 'yit' ); ?></h3>

    <table class="shop_table shipping" cellspacing="0">
        <tr>
            <td>

                <section class="clearfix shipping-calculator-form" style="display:none;">

                    <p class="form-row form-row-wide">
                        <select name="calc_shipping_country" id="calc_shipping_country" class="country_to_state country_select" rel="calc_shipping_state">
                            <option value=""><?php _e( 'Select a country&hellip;', 'yit' ); ?></option>
                            <?php
                            foreach( WC()->countries->get_shipping_countries() as $key => $value )
                                echo '<option value="' . esc_attr( $key ) . '"' . selected( WC()->customer->get_shipping_country(), esc_attr( $key ), false ) . '>' . esc_html( $value ) . '</option>';
                            ?>
                        </select>
                    </p>

                    <?php if ( apply_filters( 'woocommerce_shipping_calculator_enable_state', true ) ) : ?>
                        <p class="form-row form-row-wide" id="calc_shipping_state_field">
                            <?php
                            $current_cc = WC()->customer->get_shipping_country();
                            $current_r  = WC()->customer->get_shipping_state();
                            $states     = WC()->countries->get_states( $current_cc );

                            // Hidden Input
                            if ( is_array( $states ) && empty( $states ) ) {
                                ?>
                                <input type="hidden" name="calc_shipping_state" id="calc_shipping_state" placeholder="<?php _e( 'State / county', 'yit' ); ?>" />
                                <?php
                            } elseif ( is_array( $states ) ) {
                                ?>
                                <span>
                                    <select name="calc_shipping_state" class="state_select" id="calc_shipping_state" placeholder="<?php _e( 'State / county', 'yit' ); ?>">
                                        <option value=""><?php _e( 'Select a state&hellip;', 'yit' ); ?></option>
                                        <?php
                                        foreach ( $states as $ckey => $cvalue )
                                            echo '<option value="' . esc_attr( $ckey ) . '" ' . selected( $current_r, $ckey, false ) . '>' . __( esc_html( $cvalue ), 'yit' ) .'</option>';
                                        ?>
                                    </select>
                                </span>
                                <?php
                                // Standard Input
                            } else {
                                ?>
                                <input type="text" class="input-text" value="<?php echo esc_attr( $current_r ); ?>" placeholder="<?php _e( 'State / county', 'yit' ); ?>" name="calc_shipping_state" id="calc_shipping_state" />
                                <?php
                            }
                            ?>
                        </p>
                    <?php endif; ?>

                    <?php if ( apply_filters( 'woocommerce_shipping_calculator_enable_city', false ) ) : ?>

                        <p class="form-row form-row-wide" id="calc_shipping_city_field">
                            <input type="text" class="input-text" value="<?php echo esc_attr( WC()->customer->get_shipping_city() ); ?>" placeholder="<?php _e( 'City', 'yit' ); ?>" name="calc_shipping_city" id="calc_shipping_city" />
                        </p>

                    <?php endif; ?>

                    <?php if ( apply_filters( 'woocommerce_shipping_calculator_enable_postcode', true ) ) : ?>

                        <p class="form-row form-row-wide form-row-wide-last">
                            <input type="text" class="input-text" value="<?php echo esc_attr( WC()->customer->get_shipping_postcode() ); ?>" placeholder="<?php _e( 'Postcode / Zip', 'yit' ); ?>" name="calc_shipping_postcode" id="calc_shipping_postcode" />
                        </p>

                    <?php endif; ?>

                    <div class="clearfix"></div>

                    <button type="submit" name="calc_shipping" value="1" class="btn btn-flat-red"><?php _e( 'Update', 'yit' ); ?></button>

                    <?php wp_nonce_field( 'woocommerce-shipping-calculator', 'woocommerce-shipping-calculator-nonce' ); ?>
                </section>
            </td>
        </tr>
    </table>

</form>

<?php do_action( 'woocommerce_after_shipping_calculator' ); ?>
