<?php
/*
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

/**
 * Template file for show the products
 *
 * @package Yithemes
 * @author  Emanuela Castorina <emanuela.castorina@yithemes.com>
 * @since   1.0.0
 */

$query_args = array(
    'posts_per_page' => 1,
    'p'              => $product_id,
    'post_type'      => 'product',
);

$products = new WP_Query( $query_args );
$animate_data   = ( $animate != '' ) ? 'data-animate="' . $animate . '"' : '';
$animate_data  .= ( $animation_delay != '' ) ? ' data-delay="' . $animation_delay . '"' : '';
$animate        = ( $animate != '' ) ? ' yit_animate' : '';
$size = ( isset( $size ) ) ? $size : 'small';

if ( $products->have_posts() ) : ?>
    <?php while( $products->have_posts() ): $products->the_post() ?>
        <?php global $product; ?>
        <?php 

        if ( version_compare( WC()->version , '2.7', '<' ) ) {

            $product_id = $product->ID;
            $product_title = $product->post_title;
            $rating_html = $product->get_rating_html();

        } else {

            $product_id = yit_get_base_product_id( $product );
            $product_title = $product->get_name();
            $rating_html = wc_get_rating_html( $product->get_average_rating() );

        }
        
        ?>
        <div class="lookbook-wrapper<?php echo esc_attr( $animate . $vc_css ) ?>">
            <div class="lookbook-listed-product">
                <a class="lookbook-thumb" href="<?php echo esc_url( get_permalink( $product_id ) ); ?>" title="<?php echo esc_attr( $product_title ); ?>">
                    <?php echo $product->get_image( 'sc_single_product_' . $size ); ?>
                </a>

                <div class="lookbook-information">
                    <a href="<?php echo esc_url( get_permalink( $product_id ) ); ?>" title="<?php echo esc_attr( $product_title ); ?>">
                        <?php echo $product_title; ?>
                    </a>
                    <div class="lookbook-product-price">
                        <?php echo $product->get_price_html(); ?>
                    </div>
                    <?php if ( 'yes' == get_option( 'woocommerce_enable_review_rating' ) ) echo $rating_html; ?>
                </div>
            </div>
        </div>
    <?php endwhile; ?>
<?php endif;

wp_reset_query();
?>
