<?php
/**
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

/**
 * Theme's functions.php file.
 *
 * This file bootstrap the entire framework.
 *
 * @package Yithemes
 *
 */


/*
 * WARNING: This file is part of the Your Inspiration Themes framework core.
 * Edit this section at your own risk.
 */

//let's start the game!
require_once('core/yit.php');

add_filter( 'yith_random_products_args', 'yith_hide_outofstock_products', 10, 1 );

/**
 * @param array $query_args
 */
function yith_hide_outofstock_products( $query_args ){

	$tax_query = WC()->query->get_tax_query();
	$out_of_stock_query = array(
		'taxonomy' => 'product_visibility',
		'field'    => 'name',
		'terms'    => 'outofstock',
		'operator' => 'NOT IN',
	);

	$tax_query[] = $out_of_stock_query;

	if( isset( $query_args['tax_query'] ) ){
		$tax_query[] = array(
			'taxonomy' => 'product_cat',
			'field'    => 'term_id',
			'terms'    => explode(',', $query_args['tax_query'] ),
			'operator' => 'IN'

		);

	}

	$query_args['tax_query'] = $tax_query;

	return $query_args;

}