<?php
/**
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if ( ! defined( 'YIT' ) ) {
    exit( 'Direct access forbidden.' );
}


// wp_editor is includes since 3.3 of wordpress
if ( ! function_exists( 'wp_editor' ) ) {
    include 'textarea.php';
    return;
}

extract( $args );

$editor_args = array(
	'wpautop' => true, // use wpautop?
	'media_buttons' => true, // show insert/upload button(s)
	'textarea_name' => $name, // set the textarea name to something different, square brackets [] can be used here
	'textarea_rows' => 20, // rows="..."
	'tabindex' => '',
	'editor_css' => '', // intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped".
	'editor_class' => '', // add extra class(es) to the editor textarea
	'teeny' => false, // output the minimal editor config used in Press This
	'dfw' => false, // replace the default fullscreen with DFW (needs specific DOM elements and css)
	'tinymce' => true, // load TinyMCE, can be used to pass settings directly to TinyMCE using an array()
	'quicktags' => true // load Quicktags, can be used to pass settings directly to Quicktags using an array()
);
?>
<?php if ( ! empty( $title ) ) : ?><label for="<?php echo $id ?>"><?php echo $title ?></label><?php endif; ?>    
<div class="editor"><?php wp_editor( $value, $id, $editor_args ); ?></div>
<p><span class="desc"><?php echo $desc ?></span></p>