<?php
/*
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

/*
Template Name: Comments
*/


if( YIT_Request()->is_ajax && isset( $_REQUEST['post_id'] ) ){
    global $post, $wp_query, $wp_the_query, $withcomments;

    $comments = get_comments( array(
        'post_id' => $post->ID,
        'orderby' => 'comment_date_gmt',
        'status' => 'approve',
        )
    );

    $wp_query->comments      = $comments;
    $wp_query->comment_count = count($comments);
}



if ( post_password_required() ) {
    return;
}

if( pings_open() ) {
    yit_get_template( 'comments/trackbacks.php' );
}

?>

<?php if ( have_comments() ) : ?>
    <div id="comments" class="comments-area">

        <h3 class="comments-title">
            <?php
            printf( _n( '1 comment', '%1$s comments', get_comments_number(), 'yit' ), number_format_i18n( get_comments_number() ) );
            ?>
        </h3>

        <ol class="comment-list">
            <?php
            $wp_list_comments = wp_list_comments( array(
                'style'      => 'ol',
                'short_ping' => true,
                'echo'       => true,
                'callback'   => 'yit_list_comments'
            ) );
            ?>

        </ol>

        <?php yit_get_template( 'comments/paginations.php' ) ?>
    </div><!-- #comments -->
<?php endif; // have_comments() ?>

<?php

$fields = array(
      'author' =>
        '<div class="row">' .
        '<p class="comment-form-author col-sm-4"><label for="author">' . __( 'Name', 'yit' ) . ' *</label> ' .
        '<input id="author" class="border" name="author" type="text" value="" size="30"/></p>',

      'email' =>
        '<p class="comment-form-email col-sm-4"><label for="email">' . __( 'Email', 'yit' ) . ' *</label> ' .
        '<input id="email" class="border" name="email" type="text" value="" size="30"/></p>',

      'url' =>
        '<p class="comment-form-url col-sm-4"><label for="url">' . __( 'Website', 'yit' ) . '</label>' .
        '<input id="url" class="border" name="url" type="text" value="" size="30" /></p>' .
        '</div>'
);

$comment_field = '<p class="comment-form-comment"><label for="comment">' . _x( 'Comment', 'noun', 'yit' ) .
                 '</label> <textarea id="comment" class="border" name="comment" cols="45" rows="8" aria-required="true"></textarea></p>';


$args = array(
    'title_reply'           => __( 'Leave a reply' ,  'yit' ),
    'title_teply_to'        => __( 'Send reply to %s', 'yit' ),
    'label_submit'          => __( 'Send reply' ,  'yit' ),
    'cancel_reply_link'     => __( 'Delete Message', 'yit' ),
    'comment_notes_after'   => '',
    'comment_notes_before'  => '',
    'fields'                => $fields,
    'comment_field'         => $comment_field
);
?>

<?php
    comment_form( $args );
    wp_reset_query();
?>


