<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	add_filter('gdlr_core_use_font_icons', 'logisco_gdlr_core_use_font_icons');
	if( !function_exists('logisco_gdlr_core_use_font_icons') ){
		function logisco_gdlr_core_use_font_icons( $icons ){
			return logisco_get_option('plugin', 'font-icon', $icons);
		}
	} 
	
	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'logisco_page_builder_body_class');
	if( !function_exists('logisco_page_builder_body_class') ){
		function logisco_page_builder_body_class( $classes ) {
			return $classes . ' logisco-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'logisco_gdlr_core_sidebar_class');
	if( !function_exists('logisco_gdlr_core_sidebar_class') ){
		function logisco_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' logisco-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'logisco_goodlayers_core_setup');
	if( !function_exists( 'logisco_goodlayers_core_setup' ) ){
		function logisco_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'logisco_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'logisco_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'logisco_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'logisco_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'logisco_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'logisco_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_nav_same_term', 'logisco_gdlr_core_portfolio_single_nav_same_term');
			add_filter('gdlr_core_portfolio_single_related', 'logisco_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'logisco_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'logisco_gdlr_core_portfolio_hover_icon_class');

			// youtube cookies
			add_filter('gdlr_core_privacy_settings', 'logisco_gdlr_core_privacy_settings');
		}
	}

	// youtube no cookies
	if( !function_exists('logisco_gdlr_core_privacy_settings') ){
		function logisco_gdlr_core_privacy_settings(){
			if( function_exists('gdlr_core_get_privacy_options') ){
				$privacy_options = gdlr_core_get_privacy_options(1) + gdlr_core_get_privacy_options(2);
				$privacy_settings = array();
				foreach( $privacy_options as $privacy_option_slug => $privacy_option ){
					$privacy_settings[$privacy_option_slug] = logisco_get_option('plugin', $privacy_option_slug, 
						(empty($privacy_option['default'])? '': $privacy_option['default']));
				}

				return $privacy_settings;
			}
			
			return array();
		}
	}

	// portfolio hover icon class
	if( !function_exists('logisco_gdlr_core_portfolio_hover_icon_class') ){
		function logisco_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return logisco_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return logisco_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return logisco_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}

	// to enable srcset
	if( !function_exists('logisco_gdlr_core_enable_srcset') ){
		function logisco_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = logisco_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}
			
	// for goodlayers core pagination
	if( !function_exists('logisco_gdlr_core_pagination_style') ){
		function logisco_gdlr_core_pagination_style( $style ) {
			return logisco_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('logisco_gdlr_core_pagination_align') ){
		function logisco_gdlr_core_pagination_align( $align ) {
			return logisco_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('logisco_gdlr_core_custom_post_slug') ){
		function logisco_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = logisco_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = logisco_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = logisco_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = logisco_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = logisco_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('logisco_gdlr_core_portfolio_single_nav') ){
		function logisco_gdlr_core_portfolio_single_nav( $check ) {
			return logisco_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('logisco_gdlr_core_portfolio_single_nav_same_term') ){
		function logisco_gdlr_core_portfolio_single_nav_same_term( $check ) {
			return logisco_get_option('general', 'enable-single-portfolio-navigation-in-same-tag', $check);
		}
	}
	if( !function_exists('logisco_gdlr_core_portfolio_single_related') ){
		function logisco_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = logisco_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = logisco_get_option('general', 'related-portfolio-style', 'grid');
				$args['num-fetch'] = logisco_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['column-size'] = logisco_get_option('general', 'related-portfolio-column-size', 15);
				$args['thumbnail-size'] = logisco_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['excerpt-number'] = logisco_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['column-size'] = logisco_get_option('general', 'related-portfolio-column-size', 15);

				return $args;
			}else{
				return array();
			}
		}
	}

	// set default social share option
	if( !function_exists('logisco_gdlr_core_social_share_list') ){
		function logisco_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = logisco_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = logisco_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['google-plus'] = logisco_get_option('general', 'blog-social-google-plus', $social['google-plus']);
			$social['pinterest'] = logisco_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = logisco_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = logisco_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = logisco_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'logisco_register_custom_uploaded_font');
	if( !function_exists('logisco_register_custom_uploaded_font') ){
		function logisco_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = logisco_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$font_option['name'] = str_replace('+', '', $font_option['name']);
					while( !empty($custom_fonts[$font_option['name']]) ){
						$font_option['name'] = $font_option['name'] . '+';
					}

					$custom_fonts[$font_option['name']] = array(
						'eot' => empty($font_option['eot'])? '': $font_option['eot'],
						'ttf' => empty($font_option['ttf'])? '': $font_option['ttf'],
						'woff' => empty($font_option['woff'])? '': $font_option['woff'],
						'font-weight' => empty($font_option['font-weight'])? 'normal': $font_option['font-weight'],
						'font-style' => empty($font_option['font-style'])? 'normal': $font_option['font-style']
					);
				}
			}			
			
			return $custom_fonts;
			
		} // logisco_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('logisco_gdlr_core_widget_title_nav') ){
		function logisco_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'logisco_gdlr_core_page_builder_post_type');
	if( !function_exists('logisco_gdlr_core_page_builder_post_type') ){
		function logisco_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'logisco_gdlr_core_lightbox_type');
	if( !function_exists('logisco_gdlr_core_lightbox_type') ){
		function logisco_gdlr_core_lightbox_type(){
			$lightbox_type = logisco_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = logisco_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'logisco_lightbox_body_class');
	if( !function_exists('logisco_lightbox_body_class') ){
		function logisco_lightbox_body_class($class){
			$link_to_lightbox = logisco_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}

	add_filter('gdlr_core_lightbox_video_autoplay', 'logisco_lightbox_video_autoplay');
	if( !function_exists('logisco_lightbox_video_autoplay') ){
		function logisco_lightbox_video_autoplay($autoplay){
			$video_autoplay = logisco_get_option('plugin', 'lightbox-video-autoplay', 'enable');
			return ($video_autoplay == 'enable')? true: false;
		}
	}
	
	
	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'logisco_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'logisco_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('logisco_gdlr_core_page_builder_page_template_list') ){
		function logisco_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['home'] = array(
				'title' => esc_html__('Home', 'logisco'),
				'type' => 'wrapper',
			);
			$templates['about-us-1'] = array(
				'title' => esc_html__('About Us 1', 'logisco'),
				'type' => 'wrapper',
			);
			$templates['about-us-2'] = array(
				'title' => esc_html__('About Us 2', 'logisco'),
				'type' => 'wrapper',
			);
			$templates['about-our-team'] = array(
				'title' => esc_html__('About Our Team', 'logisco'),
				'type' => 'wrapper',
			);
			$templates['career'] = array(
				'title' => esc_html__('Career', 'logisco'),
				'type' => 'wrapper',
			);
			$templates['get-a-quote'] = array(
				'title' => esc_html__('Get A Quote', 'logisco'),
				'type' => 'wrapper',
			);
			$templates['contact'] = array(
				'title' => esc_html__('Contact', 'logisco'),
				'type' => 'wrapper',
			);
			$templates['contact-2'] = array(
				'title' => esc_html__('Contact 2', 'logisco'),
				'type' => 'wrapper',
			);
			$templates['contact-3'] = array(
				'title' => esc_html__('Contact 3', 'logisco'),
				'type' => 'wrapper',
			);
			return $templates;
		} // logisco_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('logisco_gdlr_core_page_builder_get_page_template') ){
		function logisco_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'home': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5979","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"260px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"100px","right":"","bottom":"","left":"","settings":"unlink"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-padding":{"top":"70px","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"190px","right":"0px","bottom":"30px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"150px","right":"","bottom":"","left":"0px","settings":"unlink"},"tablet-margin":"","mobile-padding":{"top":"0px","right":"","bottom":"","left":"0px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We Provide One Stop Logistic & Warehousing Services .","caption":"Guaranteed by more than a hundred awards","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"33px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#c5c5c5","item-left-margin":"","caption-spaces":"20px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"34px","bottom":"18px","left":"34px","settings":"unlink"},"border-radius":"27px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53d34","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"","text-font-weight":"800","text-letter-spacing":"1px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#212121","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"0.77","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"3px","t-right":"3px","b-right":"3px","b-left":"3px","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"45px","right":"25px","bottom":"5px","left":"25px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"35px","left":"125px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"tablet-margin":{"top":"","right":"","bottom":"","left":"30px","settings":"unlink"},"mobile-padding":{"top":"","right":"20px","bottom":"5px","left":"20px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Homepage Enquiry Form"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Enquire Now","caption":"We will get back to you within 24 hours.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#969696","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"6725","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"enable","container-background-color":"#ffffff","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":{"t-left":"3px","t-right":"3px","b-right":"3px","b-left":"3px","settings":"link"},"container-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"container-shadow-color":"#0a0a0a","container-shadow-opacity":"0.12","container-z-index":"999","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"map-height","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"unlink"},"background-shadow-color":"#ffffff","background-shadow-opacity":"0","padding":{"top":"50px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6437","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"6401","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"map-height","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0","padding":{"top":"90px","right":"40px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"0px","right":"30px","bottom":"30px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We Provide Service Across The Globe","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"31px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#e53d34","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We offer a Global Logistics Network with our worldwide offices and also high quality distribution facilities which are staffed by dedicated teams of the top of experts. We have more than 30 years of experiences in this field.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#4f5d77","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6994","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"115px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Homepage Column Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6431","character":"","title":"Fast Service","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"center_icon-top","icon-size":"30px","title-size":"23px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Homepage Column Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6430","character":"","title":"Safe Delivery","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"center_icon-top","icon-size":"30px","title-size":"23px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"29px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Homepage Column Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6429","character":"","title":"24/7 Support","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","read-more-text":"Learn More","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"center_icon-top","icon-size":"30px","title-size":"23px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"3px","right":"","bottom":"30px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6439","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30"},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"gradient","background-extending":"right","background-color":"#143369","background-normal-color-opacity":"1","background-gradient-color":"#143369","background-gradient-color-opacity":"0.9","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"3px","t-right":"0px","b-right":"0px","b-left":"0px","settings":"unlink"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"25px","bottom":"65px","left":"60px","settings":"unlink"},"margin":{"top":"-40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Re Button 2"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Quick Tracking Service","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"6440","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"30px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"-2px","right":"25px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>This is just an example of the custom HTML form. You may need to link it to your third party app or use third party html snippet . This theme doesn’t offer the tracking system.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#778cb2","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>*Please enter (House) Air Waybill No., B/L No., or Container No. For OPTIONAL SEARCH using your Customer Account No.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"15px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#91addd","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<form class=\"logisco-custom-tracking-form\" >\n<div class=\"logisco-custom-tracking-form-input\" >\n<input type=\"text\" placeholder=\"CL-XXX-XXX-XX\" style=\"background: #fff;\" />\n</div>\n<div class=\"logisco-custom-tracking-form-submit\" >\n<input type=\"submit\" value=\"Track Now!\" />\n</div>\n</form>\n","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#0a0a0a","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tab-feature","value":{"id":"","class":"","tabs":[{"title-background":"6996","title-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-1-n.jpg","title-background-active":"6996","title-background-active-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-1-n.jpg","title-image":"7000","title-image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-1-icon-n.png","title":"Land Transport","caption":"1000+ Trucks in 120 Cities","content-left-title":"Land Transport","content-left-caption":"1000+ Trucks in 120 Cities","content":"<p><span style=\"font-size: 23px; color: #b8cff7;\">Logisco Ground’s flexible model, using only quality carriers, means you benefit from improved service levels, greater flexibility and time-definite deliveries. Our expertise in transport management and planning allows us to design.</span>[gdlr_core_space height=\"20px\"] <span style=\"font-size: 19px;\">Through our global network of control towers and state-of-the-art technology, we are able to monitor and dynamically react to situations such as adverse weather, additional pick ups or drop offs, or heavy traffic, meaning that your goods are always traveling the most efficient route.Our non-asset based Road network provides you with flexibility, improved service levels.</span></p>","content-button-text":"More Detail","content-button-link":"/logisco/our-services/land-transport/","content-button-target":"_self","content-button2-text":"[gdlr_core_icon icon=\"fa fa-file-pdf-o\" size=\"\" color=\"\" margin-left=\"\" margin-right=\"10px\" ]Download PDF ","content-button2-link":"/logisco/wp-content/uploads/2018/12/goodlayers-pdf.pdf","content-button2-target":"_self"},{"title-background":"6997","title-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-2-n.jpg","title-background-active":"6997","title-background-active-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-2-n.jpg","title-image":"7001","title-image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-2-icon-n.png","title":"Air Freight","caption":"120+ Aircrafts in 30 Cities","content-left-title":"Air Freight","content-left-caption":"120+ Aircrafts in 30 Cities","content":"<p><span style=\"font-size: 23px; color: #b8cff7;\">Airfreight is fast-moving, challenging and constantly changing – it’s the nature of the business. Around the globe capacity and demand can change in the blink of an eye so it’s essential to have a partner.</span>[gdlr_core_space height=\"20px\"]<span style=\"font-size: 19px;\">Logisco is one of the largest air freight transportation providers in the world, offering a full and comprehensive package of premium, value-added services and specialist products all of which are specifically tailor-made for you. Across our worldwide network you can choose the service which best suits your needs. From New York to Shanghai and everywhere in between.</span></p>","content-button-text":"More Detail","content-button-link":"/logisco/our-services/air-freight/","content-button-target":"_self","content-button2-text":"[gdlr_core_icon icon=\"fa fa-file-pdf-o\" size=\"\" color=\"\" margin-left=\"\" margin-right=\"10px\" ]Download PDF ","content-button2-link":"/logisco/wp-content/uploads/2018/12/goodlayers-pdf.pdf","content-button2-target":"_self"},{"title-background":"6998","title-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-3-n.jpg","title-background-active":"6998","title-background-active-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-3-n.jpg","title-image":"7002","title-image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-3-icon-n.png","title":"Ocean Freight","caption":"6000+ Containers in 20 Ports","content-left-title":"Ocean Freight","content-left-caption":"6000+ Containers in 20 Ports","content":"<p><span style=\"font-size: 23px; color: #b8cff7;\">Our extensive and long-term relations with shipping lines mean we can provide you with access to a global carrier portfolio, covering major ports, with the best transit times, fully flexible scheduling.</span>[gdlr_core_space height=\"20px\"]<span style=\"font-size: 19px;\">Logisco can offer a flexible range of Ocean Freight services for both Less-Than-Container Load (LCL) and Full-Container Load (FCL) shipments. These are backed by comprehensive Ocean Freight Management Services as well as Break-bulk, Project Forwarding, Partial and Full Charter Services. </span></p>","content-button-text":"More Detail","content-button-link":"/logisco/our-services/ocean-freight/","content-button-target":"_self","content-button2-text":"[gdlr_core_icon icon=\"fa fa-file-pdf-o\" size=\"\" color=\"\" margin-left=\"\" margin-right=\"10px\" ]Download PDF ","content-button2-link":"/logisco/wp-content/uploads/2018/12/goodlayers-pdf.pdf","content-button2-target":"_self"},{"title-background":"6999","title-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-4-n.jpg","title-background-active":"6999","title-background-active-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-4-n.jpg","title-image":"7003","title-image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2019/01/tab-4-icon-n.png","title":"Smart Warehouses","caption":"Cover 1,000,000 sqm.","content-left-title":"Smart Warehouses","content-left-caption":"Cover 1,000,000 sqm.","content":"<p><span style=\"font-size: 23px; color: #b8cff7;\">Logisco Ground’s flexible model, using only quality carriers, means you benefit from improved service levels, greater flexibility and time-definite deliveries. Our expertise in transport management and planning. </span>[gdlr_core_space height=\"19px\"] <span style=\"font-size: 20px;\">Through our global network of control towers and state-of-the-art technology, we are able to monitor and dynamically react to situations such as adverse weather, additional pick ups or drop offs, or heavy traffic, meaning that your goods are always traveling the most efficient route. Our non-asset based Road network provides you with flexibility.</span></p>","content-button-text":"More Detail","content-button-link":"/logisco/our-services/smart-warehouses/","content-button-target":"_self","content-button2-text":"[gdlr_core_icon icon=\"fa fa-file-pdf-o\" size=\"\" color=\"\" margin-left=\"\" margin-right=\"10px\" ]Download PDF ","content-button2-link":"/logisco/wp-content/uploads/2018/12/goodlayers-pdf.pdf","content-button2-target":"_self"}],"enable-content-divider":"disable","button-style":"solid","button2-style":"border","tab-title-background":"","tab-title-background-active":"","tab-title-text":"","tab-title-caption":"","content-background":"","content-divider":"","button-background":"","button-border":"","button-text":"","button2-background":"","button2-border":"","button2-text":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tab-feature-vertical","value":{"id":"","class":"","caption":"Why choose us","title":"What Makes Us Different","tabs":[{"title-background":"6475","title-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/tab-about-1-1.jpg","title":"We are passionate about customers","content-background":"6471","content-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/tab-vertical-bg.jpg","content-title-image":"6470","content-title-image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/tab-1-verticle-icon.png","content-title-caption":"Why customers love us","content-title":"We are passionate about customers","content":"<p>Logistics, a leading global asset-light supply chain management company, designs and implements industry leading solutions for large and medium-size national and multinational companies. Approximately 73,000 employees in more than 120 countries are dedicated to delivering effective and robust supply-chain solutions across a variety of sectors where we apply our operational expertise to provide best-in-class services.[gdlr_core_space height=\"25px\"]<span style=\"font-size: 21px;\">Airfreight is fast-moving, challenging and constantly changing – it’s the nature of the business. Around the globe capacity and demand can change in the blink of an eye so it’s essential to have a partner who provides stability.</span>[gdlr_core_space height=\"20px\"][gdlr_core_button button-text=\"See Case Studies\" button-link=\"/logisco/portfolio-3-columns/\" button-link-target=\"_parent\" margin-right=\"20px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#e53d34\" border-color=\"#e53d34\" border-radius=\"0px\" text-size=\"15px\"]</p>\n"},{"title-background":"6476","title-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/tab-about-2-1.jpg","title":"We are energetic and eager","content-background":"6471","content-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/tab-vertical-bg.jpg","content-title-image":"6431","content-title-image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/icon1.png","content-title-caption":"Why customers love us","content-title":"We are energetic and eager","content":"<p>Logistics, a leading global asset-light supply chain management company, designs and implements industry leading solutions for large and medium-size national and multinational companies. Approximately 73,000 employees in more than 120 countries are dedicated to delivering effective and robust supply-chain solutions across a variety of sectors where we apply our operational expertise to provide best-in-class services.[gdlr_core_space height=\"25px\"]<span style=\"font-size: 21px;\">Airfreight is fast-moving, challenging and constantly changing – it’s the nature of the business. Around the globe capacity and demand can change in the blink of an eye so it’s essential to have a partner who provides stability.</span>[gdlr_core_space height=\"20px\"][gdlr_core_button button-text=\"See Case Studies\" button-link=\"/logisco/portfolio-3-columns/\" button-link-target=\"_parent\" margin-right=\"20px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#e53d34\" border-color=\"#e53d34\" border-radius=\"0px\" text-size=\"15px\"]</p>"},{"title-background":"6477","title-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/tab-about-3-1.jpg","title":"We are performance driven ","content-background":"6471","content-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/tab-vertical-bg.jpg","content-title-image":"6430","content-title-image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/icon2.png","content-title-caption":"Why customers love us","content-title":"We are performance driven ","content":"<p>Logistics, a leading global asset-light supply chain management company, designs and implements industry leading solutions for large and medium-size national and multinational companies. Approximately 73,000 employees in more than 120 countries are dedicated to delivering effective and robust supply-chain solutions across a variety of sectors where we apply our operational expertise to provide best-in-class services.[gdlr_core_space height=\"25px\"]<span style=\"font-size: 21px;\">Airfreight is fast-moving, challenging and constantly changing – it’s the nature of the business. Around the globe capacity and demand can change in the blink of an eye so it’s essential to have a partner who provides stability.</span>[gdlr_core_space height=\"20px\"][gdlr_core_button button-text=\"See Case Studies\" button-link=\"/logisco/portfolio-3-columns/\" button-link-target=\"_parent\" margin-right=\"20px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#e53d34\" border-color=\"#e53d34\" border-radius=\"0px\" text-size=\"15px\"]</p>"},{"title-background":"6478","title-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/tab-about-4-1.jpg","title":"We are successful ","content-background":"6471","content-background-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/tab-vertical-bg.jpg","content-title-image":"6429","content-title-image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/icon3.png","content-title-caption":"Why customers love us","content-title":"We are performance driven ","content":"<p>Logistics, a leading global asset-light supply chain management company, designs and implements industry leading solutions for large and medium-size national and multinational companies. Approximately 73,000 employees in more than 120 countries are dedicated to delivering effective and robust supply-chain solutions across a variety of sectors where we apply our operational expertise to provide best-in-class services.[gdlr_core_space height=\"25px\"]<span style=\"font-size: 21px;\">Airfreight is fast-moving, challenging and constantly changing – it’s the nature of the business. Around the globe capacity and demand can change in the blink of an eye so it’s essential to have a partner who provides stability.</span>[gdlr_core_space height=\"20px\"][gdlr_core_button button-text=\"See Case Studies\" button-link=\"/logisco/portfolio-3-columns/\" button-link-target=\"_parent\" margin-right=\"20px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#e53d34\" border-color=\"#e53d34\" border-radius=\"0px\" text-size=\"15px\"]</p>"}],"head-background-color":"#0a0a0a","title-caption-color":"","title-color":"","title-divider-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"815px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6483","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"200px","right":"0px","bottom":"170px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6131","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=wtPB-VNNK2Q","page-id":"6063","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"See Video Introduction ","caption":"Take a tour and see how the greatest logistic company in USA works","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"34px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#e53d34","item-left-margin":"","caption-spaces":"23px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite. like these sweet mornings of spring</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#9db1df","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-77px","right":"-21px","bottom":"0px","left":"-20px","settings":"unlink"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"0px","bottom":"","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"icon","icon":"","image":"","title":"Open Innovation","caption":"","content":"<p>[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_parent\" margin-right=\"0px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#eaa29e\" border-color=\"#eaa29e\" border-radius=\"0px\" text-size=\"13px\"]</p>","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#ffffff","caption-color":"","content-color":"#eaa29e","icon-size":"35px","title-size":"17px","title-font-weight":"700","caption-size":"15px","content-size":"15px","content-padding":{"top":"90px","right":"40px","bottom":"80px","left":"40px","settings":"unlink"},"padding-bottom":"0px","sync-height":"","centering-sync-height-content":"disable","background-color":"","background-image":"6484","background-opacity":"1","border-type":"outer","border-color":"","border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-media-type":"icon","b-icon":"","b-image":"","b-title":"Open Innovation","b-caption":"","b-content":"<p>[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_parent\" margin-right=\"0px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#eaa29e\" border-color=\"#eaa29e\" border-radius=\"0px\" text-size=\"13px\"]</p>","b-text-align":"center","b-icon-color":"","b-title-color":"","b-caption-color":"","b-content-color":"","b-icon-size":"35px","b-title-size":"17px","b-title-font-weight":"700","b-caption-size":"15px","b-content-size":"15px","b-content-padding":{"top":"90px","right":"40px","bottom":"80px","left":"40px","settings":"unlink"},"b-background-color":"","b-background-image":"6487","b-background-opacity":"1","b-border-type":"outer","b-border-color":"","b-border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"b-border-radius":"3px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-77px","right":"-21px","bottom":"0px","left":"-20px","settings":"unlink"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"0px","bottom":"","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"icon","icon":"","image":"","title":"AI Port Management","caption":"","content":"<p>[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_parent\" margin-right=\"0px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#eaa29e\" border-color=\"#eaa29e\" border-radius=\"0px\" text-size=\"13px\"]</p>","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#ffffff","caption-color":"","content-color":"#eaa29e","icon-size":"35px","title-size":"17px","title-font-weight":"700","caption-size":"15px","content-size":"15px","content-padding":{"top":"90px","right":"40px","bottom":"80px","left":"40px","settings":"unlink"},"padding-bottom":"0px","sync-height":"","centering-sync-height-content":"disable","background-color":"","background-image":"6485","background-opacity":"1","border-type":"outer","border-color":"","border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-media-type":"icon","b-icon":"","b-image":"","b-title":"AI Port Management","b-caption":"","b-content":"<p>[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_parent\" margin-right=\"0px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#eaa29e\" border-color=\"#eaa29e\" border-radius=\"0px\" text-size=\"13px\"]</p>","b-text-align":"center","b-icon-color":"","b-title-color":"","b-caption-color":"","b-content-color":"","b-icon-size":"35px","b-title-size":"17px","b-title-font-weight":"700","b-caption-size":"15px","b-content-size":"15px","b-content-padding":{"top":"90px","right":"40px","bottom":"80px","left":"40px","settings":"unlink"},"b-background-color":"","b-background-image":"6488","b-background-opacity":"1","b-border-type":"outer","b-border-color":"","b-border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"b-border-radius":"3px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-77px","right":"-20px","bottom":"0px","left":"-20px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"0px","bottom":"","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"flipbox","value":{"id":"","class":"","media-type":"icon","icon":"","image":"","title":"Digitalization insights","caption":"","content":"<p>[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_parent\" margin-right=\"0px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#eaa29e\" border-color=\"#eaa29e\" border-radius=\"0px\" text-size=\"13px\"]</p>","link-to":"custom-url","custom-image":"","video-url":"","link-url":"#","link-target":"_self","text-align":"center","icon-color":"","title-color":"#ffffff","caption-color":"","content-color":"#eaa29e","icon-size":"35px","title-size":"17px","title-font-weight":"700","caption-size":"15px","content-size":"15px","content-padding":{"top":"90px","right":"40px","bottom":"80px","left":"40px","settings":"unlink"},"padding-bottom":"0px","sync-height":"","centering-sync-height-content":"disable","background-color":"","background-image":"6486","background-opacity":"1","border-type":"outer","border-color":"","border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"b-media-type":"icon","b-icon":"","b-image":"","b-title":"Digitalization insights","b-caption":"","b-content":"<p>[gdlr_core_button button-text=\"Learn More\" button-link=\"#\" button-link-target=\"_parent\" margin-right=\"0px\" padding=\"0px 0px 3px 0px\" border-width=\"0px 0px 2px 0px\" button-background=\"transparent\" text-color=\"#eaa29e\" border-color=\"#eaa29e\" border-radius=\"0px\" text-size=\"13px\"]</p>","b-text-align":"center","b-icon-color":"","b-title-color":"","b-caption-color":"","b-content-color":"","b-icon-size":"35px","b-title-size":"17px","b-title-font-weight":"700","b-caption-size":"15px","b-content-size":"15px","b-content-padding":{"top":"90px","right":"40px","bottom":"80px","left":"40px","settings":"unlink"},"b-background-color":"","b-background-image":"6489","b-background-opacity":"1","b-border-type":"outer","b-border-color":"","b-border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"b-border-radius":"3px","b-pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"800px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Logisco sparks innovation that moves our customers and industry forward – by actively engaging in innovative networks such as the International Data Space Association, IDG</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#677182","padding-bottom":"20px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6582","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Homepage Portfolio"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"7","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"with-frame","enable-portfolio-title":"enable","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon","column-size":"20","thumbnail-size":"Portfolio Thumbnail","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"disable","layout":"carousel","carousel-autoslide":"enable","carousel-scrolling-item-amount":"3","carousel-navigation":"both","carousel-bullet-style":"cylinder","excerpt":"none","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"none","portfolio-title-font-size":"19px","portfolio-title-font-weight":"800","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-tag-font-style":"normal","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-grid-frame-margin":{"top":"-25px","right":"45px","bottom":"18px","left":"45px","settings":"unlink"},"portfolio-grid-frame-background-shadow-size":{"x":"","y":"","size":"32px","settings":"unlink"},"portfolio-grid-frame-background-shadow-color":"#0a0a0a","portfolio-grid-frame-background-shadow-opacity":"0.13","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"10px","frame-shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"frame-shadow-color":"","frame-shadow-opacity":"","overlay-color":"","overlay-opacity":"","title-align":"left","title-left-media":"image","title-left-icon":"","title-left-image":"6528","title":"Case Study","caption":"","caption-position":"top","read-more-text":"View All","read-more-link":"/logisco/portfolio-3-columns/","read-more-target":"_self","title-size":"35px","title-letter-spacing":"0px","title-line-height":"","title-font-style":"","title-text-transform":"none","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"18px","title-left-icon-color":"","title-color":"#000000","caption-color":"","read-more-color":"#e53d34","read-more-divider-color":"#e53d34","title-wrap-bottom-margin":"60px","title-carousel-nav-style":"gdlr-core-plain-style"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":"","container-margin":"","container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":"","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.07","padding":{"top":"40px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5993","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"0","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6490","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"","padding":{"top":"90px","right":"60px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"30px","bottom":"","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"More About Us","caption":"Know us more","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#8aa7da","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We design and implement industry leading solutions for multinational companies. Approximately 73,000 employees.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"21px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#c7d8ff","padding-bottom":"6px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>At Logisco, we know experience matters. That’s why customers trust us — we have more than 80 years of experience in the logistics and transportation industry. For your air charter services, this translates to competence around the globe.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#ffffff","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"More Detail","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"13px","right":"29px","bottom":"18px","left":"29px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53d34","background-hover-color":"#e5716b","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6491","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.07","padding":{"top":"95px","right":"40px","bottom":"55px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"30px","bottom":"","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Using High Technology","caption":"we are an advanced company","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9a9a9a","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"5966","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/building-logis.png","icon":"","icon-hover":"","title":"We Use AI In The Line ","caption":"That’s why customers trust us — we have more than 80 years of experience in the logistics and transportation. ","link-url":"","link-target":"_self"},{"image":"5964","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/home-logis.png","icon":"","icon-hover":"","title":"Smart Warehouse","caption":"That’s why customers trust us — we have more than 80 years of experience in the logistics and transportation. ","link-url":"","link-target":"_self"},{"image":"5965","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/gopgo-logis.png","icon":"","icon-hover":"","title":"100% Accuracy","caption":"That’s why customers trust us — we have more than 80 years of experience in the logistics and transportation. ","link-url":"","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#252525","caption-color":"#676767","border-color":"","icon-size":"14px","content-size":"20px","content-font-weight":"700","content-text-transform":"","content-letter-spacing":"","caption-size":"15px","caption-font-weight":"400","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"38px","list-bottom-margin":"50px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"half-height-2","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6492","background-image-style":"cover","background-image-position":"top-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"895px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Industry Solutions","caption":"We are expert in many industries","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9a9a9a","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>As one of the leading providers of logistics solutions across the globe, Logisco has an immense portfolio of transport and contract logistics solutions that spans multiple industries.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#757f90","padding-bottom":"20px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/aerospace-defense/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"26px","bottom":"40px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"30px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6092","character":"","title":"Aerospace & Defense","caption":"","caption-position":"bottom","content":"<p>The Aerospace & Defense industry requires innovative supply chain solutions for their unique demands.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"5px","right":"","bottom":"30px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/automotive/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"55px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"13px","bottom":"40px","left":"13px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6094","character":"","title":"Automotive","caption":"","caption-position":"bottom","content":"<p>Our worldwide network for procurement, distribution and aftermarket logistics ensures your components and vehicles.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/oil-gas/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"40px","left":"26px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6093","character":"","title":"Oil & Gas","caption":"","caption-position":"bottom","content":"<p>When it comes to managing the logistics of oil and gas, safety and efficiency are the greatest concerns.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/retail-fashion/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"26px","bottom":"40px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6494","character":"","title":"Retail & Fashion","caption":"","caption-position":"bottom","content":"<p>Speed, flexibility, and efficiency are the key in the retail industry. That’s why numerous retailers across the globe.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"8px","right":"","bottom":"26px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/healthcare/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"55px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"13px","bottom":"40px","left":"13px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6495","character":"","title":"Healthcare","caption":"","caption-position":"bottom","content":"<p>The reliable delivery of healthcare products can be lifesaving. Which is why we develop supply chain solutions.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"25px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/consumer/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"60px","left":"26px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6496","character":"","title":"Consumer","caption":"","caption-position":"bottom","content":"<p>Logisco has an in-depth understanding of the consumer industry and offers innovative.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"23px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our global logistics network, cutting-edge IT systems, in-house expertise and excellent customer service. <a style=\"color: #143369;\" href=\"#\">Learn More</a></p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#929bab","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6497","mobile-background-image":"6835","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":"","mobile-padding":{"top":"70px","right":"","bottom":"10px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30"},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Quote Form"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Request a Free Quote","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"34px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We will get back to you within 24 hours in Monday - Friday / 09:00 - 18:00</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#777777","padding-bottom":"2px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><span style=\"font-size: 21px; font-weight: bold; color: #252525;\">Or call us   </span><span style=\"font-size: 21px; color: #e53c35;\">+1-345-645-4563</span></p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"35px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"hp-quote-form","cf7-id":"6499","padding-bottom":"20px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1380px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6501","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"90px","right":"","bottom":"10px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"6507","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-1-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"6508","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-2-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"6509","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-3-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"6510","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-4-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"6511","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-5-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6515","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"85px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"65px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get Updates","caption":"News & Events","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9a9a9a","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"58px"}},{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"3","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-widget","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-1","blog-image-style":"style-1","blog-full-alignment":"left","blog-image-alignment":"center","blog-list-with-frame":"disable","always-show-overlay-content":"disable","blog-image-thumbnail-overlay":"none","blog-image-thumbnail-overlay-opacity":"0.4","show-thumbnail":"enable","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-bullet-style":"default","blog-widget-column":"60","blog-widget-bottom-divider":"disable","item-size":"large","excerpt":"specify-number","excerpt-number":"55","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","filterer-bottom-margin":"","blog-title-font-size":"17px","blog-title-font-weight":"700","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","category-background-color":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Posts","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/logisco/blog-full-right-sidebar-with-frame/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"5px","bottom":"0px","left":"0px","settings":"unlink"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#e53d34","icon-color":"#e53d34","text-hover-color":"#e5716b","icon-hover-color":"#e56962","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"","text-font-weight":"800","text-letter-spacing":"","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Frequently Asked Questions","caption":"know us more","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9a9a9a","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"Shipping Tracking","content":"At Logisco, we know experience matters. That’s why customers trust us — we have more than 80 years of experience in the logistics and transportation industry. For your air charter services, this translates to competence around the globe.  Please make sure that the correct Reference Type matches the number being entered. Please follow these instructions for help. That’s why customers trust us — we have more than 80 years of experience."},{"head-text":"","title":"New Customers","content":"At Logisco, we know experience matters. That’s why customers trust us — we have more than 80 years of experience in the logistics and transportation industry. For your air charter services, this translates to competence around the globe.  Please make sure that the correct Reference Type matches the number being entered. Please follow these instructions for help. That’s why customers trust us — we have more than 80 years of experience."},{"head-text":"","title":"Applying For a Job","content":"At Logisco, we know experience matters. That’s why customers trust us — we have more than 80 years of experience in the logistics and transportation industry. For your air charter services, this translates to competence around the globe.  Please make sure that the correct Reference Type matches the number being entered. Please follow these instructions for help. That’s why customers trust us — we have more than 80 years of experience."},{"head-text":"","title":"Contact Info","content":"At Logisco, we know experience matters. That’s why customers trust us — we have more than 80 years of experience in the logistics and transportation industry. For your air charter services, this translates to competence around the globe.  Please make sure that the correct Reference Type matches the number being entered. Please follow these instructions for help. That’s why customers trust us — we have more than 80 years of experience."},{"head-text":"","title":"General Enquiries","content":"At Logisco, we know experience matters. That’s why customers trust us — we have more than 80 years of experience in the logistics and transportation industry. For your air charter services, this translates to competence around the globe.  Please make sure that the correct Reference Type matches the number being entered. Please follow these instructions for help. That’s why customers trust us — we have more than 80 years of experience."}],"active":"1","allow-closing-all-tabs":"disable","style":"icon","align":"left","icon-position":"left","padding-bottom":"30px","title-font-size":"","title-font-weight":"","title-letter-spacing":"","title-text-transform":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6514","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Client’s Testimonial","caption":"What they say","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#adc3ea","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our commitment to sustainability helps us reduce waste and share the benefits with<br />our customers. It permeates the way we do business, driving us to innovate.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#c3d9ff","padding-bottom":"45px"}},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Jonathan Smith","position":"CEO Of Public Bakery CO.","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic.","image":"6517","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/hp-testimonial-1.jpg","rating":""},{"title":"David Beckham","position":"CEO Of Apple","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic.","image":"6518","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/hp-testimonial-2.jpg","rating":""},{"title":"Joseph Martin","position":"Head Of Logistic, Micrsoft","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic.","image":"6519","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/hp-testimonial-3.jpg","rating":""},{"title":"Kerry Jensen","position":"CFO Of  Tumi","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic.","image":"6521","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/hp-testimonial-4-1.jpg","rating":""}],"style":"left","with-frame":"enable","column":"2","thumbnail-size":"medium","enable-quote":"enable","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-nav-style":"default","carousel-bullet-style":"cylinder","title-size":"28px","title-text-transform":"uppercase","title-font-weight":"","title-letter-spacing":"","name-size":"18px","caption-size":"16px","content-size":"18px","title-color":"","caption-color":"","quote-color":"#e53d34","content-color":"","name-color":"#143369","position-color":"#143369","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Subscribe to newsletter","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Re Button 2"},"items":[{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"rectangle","padding-bottom":"30px"}}]}]}]';
				case 'about-us-1': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6821","mobile-background-image":"","background-image-style":"cover","background-image-position":"bottom-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6959","thumbnail-size":"full","z-index":"","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"6063","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Who is Logisco?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"32px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"27px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#656565","padding-bottom":"23px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#656565","padding-bottom":"23px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"3000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Locations of Service","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"53000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Emplees World Wide","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"2000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Trucks in The Fleet","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"300000","animation-time":"","suffix":"","divider":"disable","bottom-text":"shipped items and counting","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6837","mobile-background-image":"","background-image-style":"cover","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.15","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"tablet-margin":"","mobile-padding":{"top":"70px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Mission","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"32px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"55px"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height logis1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"6087","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/clock-icon.png","icon":"","icon-hover":"","title":"Fast Service","caption":"A wonderful serenity has taken pos.session of my entire soul, like these sweet mornings of spring which I enjoy.","link-url":"","link-target":"_self"},{"image":"6089","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/paper-icon.png","icon":"","icon-hover":"","title":"100% Accuracy","caption":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","link-url":"","link-target":"_self"},{"image":"6088","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/paper2-icon.png","icon":"","icon-hover":"","title":"Safety & Guarantee","caption":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","link-url":"","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#252525","caption-color":"#4f5d77","border-color":"","icon-size":"14px","content-size":"20px","content-font-weight":"700","content-text-transform":"","content-letter-spacing":"","caption-size":"16px","caption-font-weight":"400","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"38px","list-bottom-margin":"50px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height logis1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in </p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"22px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#090909","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#656565","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. </p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#656565","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#e53d34","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"57px","right":"0px","bottom":"21px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco call to action1"},"items":[{"template":"wrapper","type":"column","column":"48","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"11px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We can be your great business partner and help you growth strongly.","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"27px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get A Quote Now","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/logisco/get-a-quote/","button-link-target":"_self","icon-position":"left","icon":"fa fa-comments","text-align":"center","full-width-button":"disable","button-padding":{"top":"16px","right":"31px","bottom":"21px","left":"31px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"#d1a9a9","icon-hover-color":"","background-color":"#4f1212","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"16px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"850px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6838","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"190px","right":"0px","bottom":"200px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"90px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6131","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=wtPB-VNNK2Q","page-id":"6063","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"See Video Introduction ","caption":"Take a tour and see how the greatest logistic company in USA works","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"34px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#e53d34","item-left-margin":"","caption-spaces":"23px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#9db1df","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1320px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-85px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/aerospace-defense/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#191919","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"26px","bottom":"40px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"70px","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6092","character":"","title":"Aerospace & Defense","caption":"","caption-position":"bottom","content":"<p>The Aerospace & Defense industry requires innovative supply chain solutions for their unique demands.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/automotive/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"55px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"13px","bottom":"40px","left":"13px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6094","character":"","title":"Automotive","caption":"","caption-position":"bottom","content":"<p>Our worldwide network for procurement, distribution and aftermarket logistics ensures your components and vehicles.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/oil-gas/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"background-shadow-color":"#111111","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"40px","left":"26px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6093","character":"","title":"Oil & Gas","caption":"","caption-position":"bottom","content":"<p>When it comes to managing the logistics of oil and gas, safety and efficiency are the greatest concerns.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"800px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Logisco sparks innovation that moves our customers and industry forward – by actively engaging in innovative networks such as the International Data Space Association, IDG</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#9b9b9b","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Industries","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/logisco/industry-solutions/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"17px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53d34","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"800","text-letter-spacing":"","text-transform":"uppercase","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"bg1","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6242","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"","background-opacity":"","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"bg1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"30px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6095","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"6063","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"We are passionate about customers","caption":"Why customers love us","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#919191","item-left-margin":"","caption-spaces":"6px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Logistics, a leading global asset-light supply chain management company, designs and implements industry leading solutions for large and medium-size national and multinational companies. Approximately 73,000 employees in more than 120 countries are dedicated to delivering effective and robust supply-chain solutions across a variety of.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#727272","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Airfreight is fast-moving, challenging and constantly changing – it’s the nature of the business. Around the globe capacity and demand can change in the blink.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"21px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#2b2b2b","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Case Studies","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/logisco/portfolio-3-columns/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"2px","left":"0px","settings":"unlink"},"border-radius":"0px","button-background":"transparent","button-border":"enable","border-width":{"top":"0px","right":"0px","bottom":"1px","left":"0px","settings":"unlink"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#e53d34","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#e53d34","border-hover-color":"","border-on-text-color":"","button-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"unlink"},"button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"18px","text-font-weight":"400","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]}]';
				case 'about-us-2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6837","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height logis1","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"40px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"10px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Mission","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"6087","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/clock-icon.png","icon":"","icon-hover":"","title":"Fast Service","caption":"A wonderful serenity has taken pos.session of my entire soul, like these sweet mornings of spring which I enjoy.","link-url":"","link-target":"_self"},{"image":"6089","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/paper-icon.png","icon":"","icon-hover":"","title":"100% Accuracy","caption":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","link-url":"","link-target":"_self"},{"image":"6088","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/paper2-icon.png","icon":"","icon-hover":"","title":"Safety & Guarantee","caption":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","link-url":"","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#252525","caption-color":"#4f5d77","border-color":"","icon-size":"14px","content-size":"20px","content-font-weight":"700","content-text-transform":"","content-letter-spacing":"","caption-size":"16px","caption-font-weight":"400","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"38px","list-bottom-margin":"50px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height logis1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"right","background-color":"#143369","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"50px","bottom":"0px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Who are we?","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in </p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"20px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#a4c5ff","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ffffff","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. </p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ffffff","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.2","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height2","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6378","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height2","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"10px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"tab","value":{"id":"","class":"","tabs":[{"title":"overview","content":"<p><span style=\"color: #143369; font-size: 21px; font-weight: bold;\">Why Choose Our Service</span> [gdlr_core_space height=\"20px\"]Using Logisco is easy. We deliver packages up to 50kg, anywhere in USA & Europe. All you must do is place a single order with your local Logisco office. With just one booking, we will collect your shipment​​​​​​​ in a single vehicle at your location, and track it with a single tracking system. Following your package from start to finish. <strong>Partnership is an over-used word, but it does go some way to describing our customer-focused services. </strong>We strive to bring much more to the relationship than simply a means of reaching your customers across the world.solutions that meet the needs of today and enable the opportunities of tomorrow. [gdlr_core_space height=\"15px\"]At Logisco, we know experience matters. That’s why customers trust us — we have more than 60 years of experience in the logistics and.</p>\n"},{"title":"security","content":"<p><span style=\"color: #143369; font-size: 21px; font-weight: bold;\">Security</span> [gdlr_core_space height=\"20px\"]Using Logisco is easy. We deliver packages up to 50kg, anywhere in USA & Europe. All you must do is place a single order with your local Logisco office. With just one booking, we will collect your shipment​​​​​​​ in a single vehicle at your location, and track it with a single tracking system. Following your package from start to finish. <strong>Partnership is an over-used word, but it does go some way to describing our customer-focused services. </strong>We strive to bring much more to the relationship than simply a means of reaching your customers across the world.solutions that meet the needs of today and enable the opportunities of tomorrow. [gdlr_core_space height=\"15px\"]At Logisco, we know experience matters. That’s why customers trust us — we have more than 60 years of experience in the logistics and.</p>\n"},{"title":"managment","content":"<p><span style=\"color: #143369; font-size: 21px; font-weight: bold;\">Management</span> [gdlr_core_space height=\"20px\"]Using Logisco is easy. We deliver packages up to 50kg, anywhere in USA & Europe. All you must do is place a single order with your local Logisco office. With just one booking, we will collect your shipment​​​​​​​ in a single vehicle at your location, and track it with a single tracking system. Following your package from start to finish. <strong>Partnership is an over-used word, but it does go some way to describing our customer-focused services. </strong>We strive to bring much more to the relationship than simply a means of reaching your customers across the world.solutions that meet the needs of today and enable the opportunities of tomorrow. [gdlr_core_space height=\"15px\"]At Logisco, we know experience matters. That’s why customers trust us — we have more than 60 years of experience in the logistics and.</p>\n"}],"style":"style1-horizontal","align":"left","tab-title-color":"","tab-title-active-color":"","tab-title-background-color":"","tab-title-active-background-color":"","tab-title-border-color":"","tab-title-border-active-color":"","tab-content-color":"#838383","padding-bottom":"50px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#1b1b1b","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our History","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>2000 - 2005</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"21px","content-font-weight":"700","content-letter-spacing":"","content-text-transform":"none","text-color":"#ffffff","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"0px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#bfbfbf","padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>2005 - 2010</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"21px","content-font-weight":"700","content-letter-spacing":"","content-text-transform":"none","text-color":"#ffffff","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"0px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#bfbfbf","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>2010 - 2015</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"21px","content-font-weight":"700","content-letter-spacing":"","content-text-transform":"none","text-color":"#ffffff","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"0px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the .</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#bfbfbf","padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>2015 - Now</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"21px","content-font-weight":"700","content-letter-spacing":"","content-text-transform":"none","text-color":"#ffffff","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"0px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>The quick, brown fox jumps over a lazy dog. DJs flock by when MTV ax quiz prog. Junk MTV quiz graced by fox whelps. Bawds jog, flick quartz, vex nymphs. Waltz, bad nymph, for quick jigs vex! Fox nymphs grab quick-jived waltz. Brick quiz whangs jumpy veldt fox. Bright vixens jump; dozy fowl quack. Quick wafting zephyrs vex bold Jim. Quick zephyrs blow, vexing daft Jim. Sex-charged fop blew my junk TV quiz. How quickly daft jumping.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#bfbfbf","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"87px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"3000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Locations of Service","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"53000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Emplees World Wide","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"2000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Trucks in The Fleet","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"300000","animation-time":"","suffix":"","divider":"disable","bottom-text":"shipped items and counting","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"800px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Logisco sparks innovation that moves our customers and industry forward – by actively engaging in innovative networks such as the International Data Space Association, IDG</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#98a3bc","padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Industries","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/logisco/industry-solutions/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"17px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53d34","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"","text-font-weight":"","text-letter-spacing":"","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#143369","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"57px","right":"0px","bottom":"21px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco call to action1"},"items":[{"template":"wrapper","type":"column","column":"48","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"11px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We can be your great business partner and help you growth strongly.","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"27px","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get A Quote Now","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/logisco/get-a-quote/","button-link-target":"_self","icon-position":"left","icon":"fa fa-comments","text-align":"center","full-width-button":"disable","button-padding":{"top":"16px","right":"31px","bottom":"21px","left":"31px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"#b8c3d8","icon-hover-color":"","background-color":"#081835","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"16px","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1380px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6501","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"6507","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-1-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"6508","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-2-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"6509","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-3-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"6510","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-4-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"},{"id":"6511","thumbnail":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/banner-5-150x140.png","link-to":"none","custom-image":"","video-url":"","page-id":"399","custom-url":"","custom-link-target":"_self"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","image-bottom-margin":"","padding-bottom":"30px"}}]}]';
				case 'about-our-team': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6821","mobile-background-image":"","background-image-style":"cover","background-image-position":"bottom-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"20px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"our team","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6960","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"6368","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"our team","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"105px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"About Our Team","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"36px","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"22px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains. She had a last view back on the skyline of her.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"19px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#1d1d1d","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. </p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#656565","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"6087","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/clock-icon.png","icon":"","icon-hover":"","title":"Fast Service","caption":"A wonderful serenity has taken pos.session of my entire soul, like these sweet mornings of spring which I enjoy.","link-url":"","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#252525","caption-color":"#4f5d77","border-color":"","icon-size":"14px","content-size":"20px","content-font-weight":"700","content-text-transform":"","content-letter-spacing":"","caption-size":"16px","caption-font-weight":"400","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"38px","list-bottom-margin":"50px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"6089","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/paper-icon.png","icon":"","icon-hover":"","title":"100% Accuracy","caption":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","link-url":"","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#252525","caption-color":"#4f5d77","border-color":"","icon-size":"14px","content-size":"20px","content-font-weight":"700","content-text-transform":"","content-letter-spacing":"","caption-size":"16px","caption-font-weight":"400","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"38px","list-bottom-margin":"50px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"6088","image-img":"https://demo.goodlayers.com/logisco/wp-content/uploads/2018/12/paper2-icon.png","icon":"","icon-hover":"","title":"Safety & Guarantee","caption":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","link-url":"","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"#252525","caption-color":"#4f5d77","border-color":"","icon-size":"14px","content-size":"20px","content-font-weight":"700","content-text-transform":"","content-letter-spacing":"","caption-size":"16px","caption-font-weight":"400","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"38px","list-bottom-margin":"50px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"3000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Locations of Service","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"53000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Emplees World Wide","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"2000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Trucks in The Fleet","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"logisco Number color"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#ababab","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"300000","animation-time":"","suffix":"","divider":"disable","bottom-text":"shipped items and counting","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"53px","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"6","orderby":"date","order":"desc","text-align":"left","personnel-style":"grid","enable-position":"enable","disable-link":"disable","enable-divider":"enable","enable-excerpt":"disable","enable-social-shortcode":"enable","column-size":"3","thumbnail-size":"Blog Column Thumbnail","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation","carousel-bullet-style":"default","personnel-title-font-size":"23px","personnel-title-font-weight":"800","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"16px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","shadow-size":"","shadow-color":"","shadow-opacity":"0.2","personnel-thumbnail-bottom-margin":"","personnel-title-bottom-margin":"","personnel-modern-content-bottom":"","padding-bottom":"20px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"895px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Industry Solutions","caption":"We are expert in many industries","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#9a9a9a","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>As one of the leading providers of logistics solutions across the globe, Logisco has an immense portfolio of transport and contract logistics solutions that spans multiple industries.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#757f90","padding-bottom":"20px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/aerospace-defense/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"26px","bottom":"40px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6092","character":"","title":"Aerospace & Defense","caption":"","caption-position":"bottom","content":"<p>The Aerospace & Defense industry requires innovative supply chain solutions for their unique demands.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/automotive/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#0f0f0f","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"55px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"13px","bottom":"40px","left":"13px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6094","character":"","title":"Automotive","caption":"","caption-position":"bottom","content":"<p>Our worldwide network for procurement, distribution and aftermarket logistics ensures your components and vehicles.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"/logisco/industry-solutions/oil-gas/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.08","padding":{"top":"55px","right":"30px","bottom":"50px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"55px","left":"26px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6093","character":"","title":"Oil & Gas","caption":"","caption-position":"bottom","content":"<p>When it comes to managing the logistics of oil and gas, safety and efficiency are the greatest concerns.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"22px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"capitalize","caption-size":"20px","caption-font-weight":"700","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Our global logistics network, cutting-edge IT systems, in-house expertise and excellent customer service. <a style=\"color: #143369;\" href=\"#\">Learn More</a></p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#929bab","padding-bottom":"35px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.2","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5963","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"20px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"190px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"50px","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Video Tour For This Service","caption":"Take a tour and see the greatest logistic company in USA ","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"35px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#e53d34","item-left-margin":"","caption-spaces":"7px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>At Logisco, we know experience matters. That’s why customers trust us — we have more than 60 years of experience in the logistics and transportation industry. For your services, this translates to competence around the globe.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","text-color":"#aab6ca","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#181818","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6023","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"0.4","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"135px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"110px","right":"20px","bottom":"110px","left":"20px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"30px","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6131","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=wtPB-VNNK2Q","page-id":"6401","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]}]}]';
				case 'career': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6920","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Career Opportunities","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>At Logisco, we recruit, train, and retain the very best logistics and technical experts the world over. We love to promote from within more than 30 percent of our staff of 26,000 employees has been at Logisco 20 years or more. Our high retention rate is influenced by a unique compensation program for positions that are more than just jobs they’re chances to grow, thrive,</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#393939","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Success Stories","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"11px","right":"29px","bottom":"16px","left":"29px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53c35","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"15px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"19px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#969696","padding-bottom":"10px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"fa fa-dot-circle-o","icon-hover":"","title":"Nearshoring is fast becoming a Retail trend, with many stakeholders.","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-dot-circle-o","icon-hover":"","title":"Transporting goods from a Distribution Center (DC) to the final point.","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-dot-circle-o","icon-hover":"","title":"Logisco orchestrates the flow of products, partly or completely.","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"fa fa-dot-circle-o","icon-hover":"","title":"Solutions that provide short response times to urgent requests.","caption":"","link-url":"","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#e53c35","icon-background-color":"","content-color":"#181818","caption-color":"","border-color":"","icon-size":"14px","content-size":"17px","content-font-weight":"400","content-text-transform":"none","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"5px","icon-right-margin":"","list-bottom-margin":"18px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6922","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"career svc"},"items":[{"template":"wrapper","type":"column","column":"12","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"career svc"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6874","thumbnail-size":"full","z-index":"","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"6747","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#7f95ae","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"3000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Locations of Service","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"50","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6876","thumbnail-size":"full","z-index":"","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"6747","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#7f95ae","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"53000","animation-time":"","suffix":"","divider":"disable","bottom-text":"Emplees World Wide","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"50","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"12","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6875","thumbnail-size":"full","z-index":"","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"6747","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>More Than</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#7f95ae","padding-bottom":"10px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"","end-number":"120","animation-time":"","suffix":"","divider":"disable","bottom-text":"Connected Countries","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"17","number-size":"50","number-font-weight":"700","bottom-text-size":"17px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"50px"}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Logisco sparks innovation that moves our customers and industry forward – by actively engaging in innovative networks such as the International Data Space.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#7b879d","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"780px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"20px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Open Jobs","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"14px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"45px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"25px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#e53c35"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Logisco sparks innovation that moves our customers and industry forward – by actively engaging in innovative networks such as the International Data Space Association, IDG</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#828282","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.08","padding":{"top":"52px","right":"30px","bottom":"40px","left":"29px","settings":"unlink"},"margin":{"top":"0px","right":"26px","bottom":"40px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Project Manager Continuous  Improvement","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Location</strong> : London</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Department</strong> : Customer Service</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Job Detail","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"8px","right":"18px","bottom":"10px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53c35","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.08","padding":{"top":"52px","right":"30px","bottom":"40px","left":"29px","settings":"unlink"},"margin":{"top":"0px","right":"13px","bottom":"40px","left":"13px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Senior Ocean Customer Service  Representative","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Location</strong> : London</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Department</strong> : Customer Service</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Job Detail","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"8px","right":"18px","bottom":"10px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53c35","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.08","padding":{"top":"52px","right":"30px","bottom":"40px","left":"29px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"40px","left":"26px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Professional driver (m / w / d)  Local transport","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Location</strong> : London</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Department</strong> : Customer Service</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Job Detail","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"8px","right":"18px","bottom":"10px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53c35","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.08","padding":{"top":"52px","right":"30px","bottom":"40px","left":"29px","settings":"unlink"},"margin":{"top":"0px","right":"26px","bottom":"40px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Project Manager Continuous  Improvement","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Location</strong> : London</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Department</strong> : Customer Service</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Job Detail","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"8px","right":"18px","bottom":"10px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53c35","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.08","padding":{"top":"52px","right":"30px","bottom":"40px","left":"29px","settings":"unlink"},"margin":{"top":"0px","right":"13px","bottom":"40px","left":"13px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Senior Ocean Customer Service  Representative","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Location</strong> : London</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Department</strong> : Customer Service</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Job Detail","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"8px","right":"18px","bottom":"10px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53c35","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"column svc logisco","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-color":"#e53d34","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"30px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.08","padding":{"top":"52px","right":"30px","bottom":"40px","left":"29px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"40px","left":"26px","settings":"unlink"},"mobile-padding":{"top":"40px","right":"30px","bottom":"40px","left":"30px","settings":"unlink"},"mobile-margin":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":"Homepage Column Service 2"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Professional driver (m / w / d)  Local transport","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#143369","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Location</strong> : London</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><strong>Department</strong> : Customer Service</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#585858","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Job Detail","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","text-align":"left","full-width-button":"disable","button-padding":{"top":"8px","right":"18px","bottom":"10px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53c35","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"10px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"850px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6838","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"180px","right":"0px","bottom":"150px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"90px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"6131","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=wtPB-VNNK2Q","page-id":"6063","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"See Video Introduction ","caption":"Take a tour and see how the greatest logistic company in USA works","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"34px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"21px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#e53d34","item-left-margin":"","caption-spaces":"23px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#9db1df","padding-bottom":"0px"}}]}]';
				case 'get-a-quote': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Request a Free Quote","caption":"We will get back to you within 24 hours in Monday - Friday / 09:00 - 18:00","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"31px","mobile-title-font-size":"31px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#171717","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#777777","item-left-margin":"","caption-spaces":"25px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"22px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Phone : +1-2452-355-32</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"700","content-letter-spacing":"","content-text-transform":"none","text-color":"#252525","padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Email : quote@logiscocorp.co</p>","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"700","content-letter-spacing":"","content-text-transform":"none","text-color":"#252525","padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Address</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"700","content-letter-spacing":"","content-text-transform":"none","text-color":"#252525","padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Box 3233</p><p>1810 Kings Way</p><p>King Street, 5th Avenue, New York</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#9d9d9d","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Re Button 2"},"items":[{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"6499","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Homepage Column Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6431","character":"","title":"Fast Service","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"center_icon-top","icon-size":"30px","title-size":"23px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Homepage Column Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6430","character":"","title":"Safe Delivery","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"center_icon-top","icon-size":"30px","title-size":"23px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"29px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"20px","left":"","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Homepage Column Service"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"6429","character":"","title":"24/7 Support","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"enable","read-more-icon":"fa fa-long-arrow-right","style":"center_icon-top","icon-size":"30px","title-size":"23px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"16px","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"3px","right":"","bottom":"30px","left":""},"character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"10px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"30px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"Solutions","content":"At Logisco, we know experience matters. That’s why customers trust us — we have more than 60 years of experience in the logistics and transportation industry. For your services, this translates to competence around the globe.  Using Logisco is easy. We deliver packages up to 50kg, anywhere in USA & Europe. All you must do is place a single order with your local Logisco  office. With just one booking, we will collect your shipment​​​​​​​ in a single vehicle at your location. Far far away, behind the word mountains, far from the countries Vokalia and Consonanti."},{"head-text":"","title":"Cost Saving With Us","content":"At Logisco, we know experience matters. That’s why customers trust us — we have more than 60 years of experience in the logistics and transportation industry. For your services, this translates to competence around the globe.  Using Logisco is easy. We deliver packages up to 50kg, anywhere in USA & Europe. All you must do is place a single order with your local Logisco  office. With just one booking, we will collect your shipment​​​​​​​ in a single vehicle at your location."},{"head-text":"","title":"High Quality Services","content":"At Logisco, we know experience matters. That’s why customers trust us — we have more than 60 years of experience in the logistics and transportation industry. For your services, this translates to competence around the globe.  Using Logisco is easy. We deliver packages up to 50kg, anywhere in USA & Europe. All you must do is place a single order with your local Logisco  office. With just one booking, we will collect your shipment​​​​​​​ in a single vehicle at your location."},{"head-text":"","title":"No Hassle Pricing","content":"At Logisco, we know experience matters. That’s why customers trust us — we have more than 60 years of experience in the logistics and transportation industry. For your services, this translates to competence around the globe.  Using Logisco is easy. We deliver packages up to 50kg, anywhere in USA & Europe. All you must do is place a single order with your local Logisco  office. With just one booking, we will collect your shipment​​​​​​​ in a single vehicle at your location."}],"active":"1","allow-closing-all-tabs":"disable","style":"background-title-icon","align":"left","icon-position":"left","padding-bottom":"30px","title-font-size":"","title-font-weight":"","title-letter-spacing":"","title-text-transform":"default"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Info For Asian Clients","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"9px","right":"18px","bottom":"11px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53c35","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"1px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"45px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Info For EU Clients","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"22px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"17px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"9px","right":"18px","bottom":"11px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e53c35","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"1px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6867","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"650px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"250px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]';
				case 'contact':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6338","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":"","container-margin":"","container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":"","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"350px","right":"0px","bottom":"160px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":"","skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Us","caption":"Get Intouch","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-icon":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-divider":"disable","heading-tag":"h3","icon-font-size":"30px","title-font-size":"75px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"25px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-size":"","title-link-font-weight":"","title-link-letter-spacing":"","title-link-text-transform":"none","title-link-icon-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-color":"","caption-color":"#f2f2f2","caption-highlight-color":"","caption-spaces":"25px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":"","container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":"","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"45px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-phone","text-align":"left","icon-size":"40px","icon-color":"#143369","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Phone","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"23px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":"","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these.</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">+1-2345-2345</a></p>\n","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-envelope-o","text-align":"left","icon-size":"40px","icon-color":"#143369","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Email","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"23px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":"","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these.</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">Contact@goodlayers.com</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","class":"","icon":"fa fa-location-arrow","text-align":"left","icon-size":"40px","icon-color":"#143369","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Location","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"23px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":"","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>4 apt. Flawing Street. The Grand Avenue.<br />Liverpool, UK 33342</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p><a href=\"#\">View On Google Map</a></p>","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"680px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f3f3f3","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":"","container-margin":"","container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":"","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"85px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":"","mobile-margin":"","skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"760px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Leave us your info ","caption":"and we will get back to you.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"39px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":"","padding-bottom":"45px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"1979","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"2","wpgmap2-id":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"disable","text-size":"15px","icon-color":"#1e1e1e","icon-space":"40px","padding-bottom":"30px"}}]}]';
				case 'contact-2':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6345","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":"","container-margin":"","container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":"","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"390px","right":"0px","bottom":"170px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"100px","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":"","skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Us","caption":"Get Intouch","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"75px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"25px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-color":"","caption-color":"#ffffff","item-left-margin":"","caption-spaces":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f5f5f5","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":"","mobile-margin":"","skin":"White form"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Leave us your info ","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"35px"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1979","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"20px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Location","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>4 apt. Flawing Street. The Grand Avenue.<br />Liverpool, UK 33342</p>","text-align":"left","font-size":"16px","padding-bottom":"0px"}},{"template":"element","type":"icon-list","value":{"id":"","tabs":[{"icon":"fa fa-envelope-o","icon-hover":"fa fa-envelope-o","title":"contact@logiscowptheme.com"},{"icon":"fa fa-phone","icon-hover":"fa fa-phone","title":"+1-3524-3356"}],"icon-size":"16px","content-size":"16px","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Map","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"1","wpgmap2-id":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"#","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"disable","text-size":"15px","icon-color":"#232323","icon-space":"37px","padding-bottom":"0px"}}]}]';
				case 'contact-3':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"5979","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.3","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":"","container-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":"","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"360px","right":"0px","bottom":"180px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":"","skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Us","caption":"Get Intouch","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-icon":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-divider":"disable","heading-tag":"h3","icon-font-size":"30px","title-font-size":"75px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"25px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-size":"","title-link-font-weight":"","title-link-letter-spacing":"","title-link-text-transform":"none","title-link-icon-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-color":"","caption-color":"#ffffff","caption-highlight-color":"","caption-spaces":"15px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#262626","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6338","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"0.8","background-filter":"none","background-blur-size":"","border-radius":"","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"65px","bottom":"80px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":"","mobile-margin":"","skin":"White Text"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"London","caption":"","caption-position":"top","enable-title-bottom-divider":"disable","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"28px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"104px","padding-bottom":"32px","icon-color":"","divider-color":"#ffffff"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>4 apt. Flawing Street. The Grand Avenue. Liverpool, UK 33342</p>\n<p>Tel : +44-20-2355-3456<br />\nEmail : London@logiscoWP.com</p>\n","text-align":"left","font-size":"16px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"2","wpgmap2-id":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#0a0a0a","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"6336","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"0.8","background-filter":"none","background-blur-size":"","border-radius":"","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"65px","bottom":"80px","left":"65px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":"","mobile-margin":"","skin":"White Text"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"New York","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"28px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"113px","padding-bottom":"32px","icon-color":"","divider-color":"#ffffff"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>88 Flower Avenue. Kingdom St.<br />New York 7689</p><p>Tel : +1-4533-4435-2<br />Email : Sanfran@logiscoWP.com</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","class":"","wpgmap-id":"3","wpgmap2-id":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"680px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f3f3f3","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":"","container-margin":"","container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":"","enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":"","mobile-margin":"","skin":"White form"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"760px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Leave us your info ","caption":"and we will get back to you.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-icon":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-divider":"disable","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-size":"","title-link-font-weight":"","title-link-letter-spacing":"","title-link-text-transform":"none","title-link-icon-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-color":"","caption-color":"","caption-highlight-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"1979","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"pulse","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ffffff","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"#","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"disable","text-size":"15px","icon-color":"#353535","icon-space":"40px","padding-bottom":"30px"}}]}]';
			}

		} // logisco_gdlr_core_page_builder_get_page_template
	} // function_exists