<?php 
	/*	
	*	Goodlayers Getting Start Page
	*	---------------------------------------------------------------------
	*	This file that creates getting start page
	*	---------------------------------------------------------------------
	*/	

	if( class_exists('gdlr_core_getting_start') ){
		new gdlr_core_getting_start(array(
			'parent-slug' => 'goodlayers_main_menu',
			'page-title' => esc_html__('Getting Start / Import', 'logisco'),
			'menu-title' => esc_html__('Getting Start / Import', 'logisco'),
			'capability' => 'edit_theme_options'
		));
	}

	add_filter('gdlr_core_getting_start_option', 'logisco_gdlr_core_getting_start_option', 10, 2);
	if( !function_exists('logisco_gdlr_core_getting_start_option') ){
		function logisco_gdlr_core_getting_start_option( $options, $slug ){
			if( $slug == 'gdlr_core_getting_start' ){

				$content = array();

				// install plugins link
				$plugins_complete = logisco_tgmpa_complete();
				if( !$plugins_complete ){
					$content['required-plugins'] = array(
						'title' => esc_html__('Required Plugins', 'logisco'),
						'type' => 'page',
						'content' => '<p>' . wp_kses(__('<strong>Before moving on, please make sure that all required plugins are installed and activated</strong><br>This is very important step to make the theme run properly.', 'logisco'), array('strong'=>array(), 'br'=>array()) ) . 
							'</p><a class="gdlr-core-button" href="' . esc_attr(admin_url('themes.php?page=tgmpa-install-plugins')) . '" >' . esc_html__('Install Required Plugins', 'logisco') . '</a>' .
							'<h3>' . esc_html__('1. Install plugins then click on \'Return To Require Plugins Installer', 'logisco') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin1.jpg') . '" alt="' . esc_attr__('Required Plugin', 'logisco') . '" />' .
							'<h3>' . esc_html__('2. Activate plugins', 'logisco') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin2.jpg') . '" alt="' . esc_attr__('Required Plugin', 'logisco') . '" />'
					);
				}

				// guidelines
				$content['guidelines'] = array(
					'title' => esc_html__('Guidelines', 'logisco'),
					'type' => 'page',
					'content' => 
						wp_kses(__('<h4>1.) Installation</h4>', 'logisco'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/D0uQR0S3bAQ" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>' .
						wp_kses(__('<h4>2.) Importing Demo</h4>', 'logisco'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/z7m28VGUEV8" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>' .
						wp_kses(__('<h4>3.) Creating Portfolio</h4>', 'logisco'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/XFrtHJuPW_4" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>4.) Creating Personnel</h4>', 'logisco'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/MwFxxSlYuAA" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>5.) Creating Blog</h4>', 'logisco'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/fqcdMzTjvrE" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>6.) Goodlayers Page Builder</h4>', 'logisco'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/N0haJbDM8ac" frameborder="0" allowfullscreen></iframe>'
				);

				// import demo
				$content['import-demo'] = array(
					'title' => esc_html__('Import Demo', 'logisco'),
					'type' => 'demo',
					'content' => wp_kses(__('<strong>Get import error?</strong> Please make sure that your server has PHP max_execution_time at least 300, memory_limit at least 512MB. You may set these values temporaly and change it back after finish importing.<br><strong>If you\'re importing main demo (Full Version), PHP max_input_vars is recommended to be at least 4000</strong>', 'logisco'), array('strong'=>array(), 'br'=>array())),
					'demo-content' => wp_kses(
						__('<strong>Main demo (Full verion)</strong> - include all pages shown in demo such as elements, features, about us, services contact, all portfolio pages, all blog pages. It\'s 100+ pages and 170+ images in total.', 'logisco') . '<br><br>' . 
						__('<strong>Main demo (Lite verion)</strong> - include about us, services, few portfolios, few blog pages. Element and feature page are not included.', 'logisco') . '<br><br>' . 
						__('Please also be cautious that over 1000+ images will be generated in main demo.', 'logisco'), 
						array('strong'=>array(), 'br'=>array())),
				);

				// system status
				$content['system-status'] = array(
					'title' => esc_html__('System Status', 'logisco'),
					'type' => 'system-status',
					'content' => wp_kses(__('<strong>To import demo content</strong>, PHP max_execution_time at least 300 secs and  memory_limit at least 512MB is recommended. <strong><br>If you\'re importing main demo (Full Version)</strong>, PHP max_input_vars is recommended to be at least 4000.', 'logisco'), array('strong'=>array(), 'br'=>array()))
				);

				// obtain product validation link
				if( !empty($GLOBALS['tgmpa']) ){
					$plugin_slug = 'envato-market';
					$plugin_url = 'admin.php?page=envato-market';
					$product_validation_url = logisco_tgmpa_auto_install_url($plugin_slug,  $plugin_url);

					$tgmpa = call_user_func(array(get_class($GLOBALS['tgmpa']), 'get_instance'));
					if( !$tgmpa->is_plugin_installed($plugin_slug) ){
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'logisco'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates, you need to install and activate the plugin \'Envato Market\'</strong>.<br>You\'ll also need API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'logisco'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Get envato market plugin now!', 'logisco') . '</a>'
						);
					}else{
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'logisco'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates</strong>, you need to fill the infomation in \'Envato Market\' plugin page.<br>You need to retrieve API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'logisco'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Go to plugin settings!', 'logisco') . '</a>'
						);
					}
				}

				// support
				$content['support'] = array(
					'title' => esc_html__('Support', 'logisco'),
					'type' => 'page',
					'content' => wp_kses(__('<p><strong>Have questions about how to use the theme?</strong></p><p>Make sure that you read all through the document we provided. The document is contained in main package that you downloaded from Themeforest. It\'s in the folder \'Document-Instruction\', open the file \'index.html\' with your browser. Or you can view online document here.</p>', 'logisco'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
						'<a class="gdlr-core-button" target="_blank" href="#" >' . esc_html__('View Online Document', 'logisco') . '</a><br><br>' .
						wp_kses(__('<p><strong>Have problems or can\'t find answer in the document?</strong></p><p>1. Make sure that you are running the latest version of the theme.<br>2. Make sure that you deeply checked theme\'s instruction and try to search for public tickets in case of someone else asked the same question before. <br> 3. Try to deactivate all plugins (Except Goodlayers plugins) and see if the problem resolved or not.</p>', 'logisco'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) .
						wp_kses(sprintf(__('<p>After doing these steps and still see the problem, feel free to submit tickets in our support website. Our supporter are happy to help you.<br><strong>Please note that you will need Purchase code to submit the ticket</strong> - <a href="%s" target="_blank" >How to get purchased code?</a></p>', 'logisco'), 'https://help.market.envato.com/hc/en-us/articles/202822600'), array('strong'=>array(), 'br'=>array(), 'p'=> array(), 'a'=>array('href'=>array(), 'target'=>array())) ) .
						'<a class="gdlr-core-button" target="_blank" href="http://support.goodlayers.com" >' . esc_html__('Go to support website', 'logisco') . '</a>'
				);

				return array(
					'header' => array(
						'logo' => get_template_directory_uri() . '/images/getting-start/header.png',
						'title' => esc_html__('Congratulations !', 'logisco'),
						'caption' => '<strong>' . esc_html__('Logisco', 'logisco') . '</strong> ' . esc_html__('WordPress theme is now installed and ready to use. Thank you so much for choosing Goodlayers!', 'logisco')
					),
					'content' => $content
				);
			}

			return $options;
		}
	}

	// add filter for demo import
	add_filter('gdlr_core_demo_options', 'logisco_gdlr_core_demo_options');
	if( !function_exists('logisco_gdlr_core_demo_options') ){
		function logisco_gdlr_core_demo_options($demo){
			return array(
				'logisco' => array(
					'title' => esc_html__('Logisco', 'logisco'),
					'url' => 'http://demo.goodlayers.com/logisco',
					'xml' => get_template_directory() . '/admin/function/files/logisco.xml',
					'page' => 2039,
					'menu' => array('main_menu' => 102, 'mobile_menu' => 102),
					'widget' => '{"gdlrcst_sidebar_name":{"0":{"name":"Blog","id":"blog"},"1":{"name":"Blog Left","id":"blog-left"},"2":{"name":"Blog Right","id":"blog-right"},"3":{"name":"Shop","id":"shop"},"5":{"name":"Services","id":"services"},"6":{"name":"Industry - Aero","id":"industry-aero"},"7":{"name":"Industry - Auto","id":"industry-auto"},"8":{"name":"Industry - Oil","id":"industry-oil"},"9":{"name":"Industry - Retail","id":"industry-retail"},"10":{"name":"Industry - Healthcare","id":"industry-healthcare"},"11":{"name":"Industry - Consumer","id":"industry-consumer"}},"sidebars_widgets":{"wp_inactive_widgets":["gdlr-core-recent-post-widget-2"],"gdlr-core-sidebar-preset":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-1":["text-1"],"footer-2":["text-5"],"footer-3":["gdlr-core-custom-menu-widget-2"],"footer-4":[],"blog":["text-2","gdlr-core-recent-post-widget-3","gdlr-core-recent-portfolio-widget-2","recent-comments-3","tag_cloud-1"],"blog-left":["search-3","text-3","recent-posts-3"],"blog-right":["text-4","recent-comments-4","tag_cloud-2"],"shop":["woocommerce_top_rated_products-1","woocommerce_product_categories-1","woocommerce_price_filter-1","woocommerce_widget_cart-1"],"services":["gdlr-core-custom-menu-widget-3","text-6","text-7"],"industry-aero":["gdlr-core-custom-menu-widget-4","text-9","text-8"],"industry-auto":["gdlr-core-custom-menu-widget-5","text-10","text-20"],"industry-oil":["gdlr-core-custom-menu-widget-6","text-21","text-13"],"industry-retail":["gdlr-core-custom-menu-widget-7","text-23","text-24"],"industry-healthcare":["gdlr-core-custom-menu-widget-8","text-16","text-15"],"industry-consumer":["gdlr-core-custom-menu-widget-9","text-22","text-19"],"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_bcn_widget":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Useful Links","menu":"133","style":"half"},"3":{"title":"Our Services","menu":"134","style":"box"},"4":{"title":"Service Industries","menu":"135","style":"box"},"5":{"title":"Service Industries","menu":"135","style":"box"},"6":{"title":"Service Industries","menu":"135","style":"box"},"7":{"title":"Service Industries","menu":"135","style":"box"},"8":{"title":"Service Industries","menu":"135","style":"box"},"9":{"title":"Service Industries","menu":"135","style":"box"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Case Study","category":"","num-fetch":"6"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"2":{"title":"Recent News","style":"style-1","category":"","num-fetch":"3","order-by":"date","order":"desc","thumbnail-size":"thumbnail"},"3":{"title":"Recent News","style":"style-1","category":"","num-fetch":"3","order-by":"date","order":"desc","thumbnail-size":"thumbnail"},"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"3":{"title":"","number":5},"4":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"3":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"3":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"","text":"<img class=\"alignnone size-full wp-image-5803\" src=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/logo.png\" alt=\"\" width=\"138\" \/>\r\n[gdlr_core_space height=\"-27px\"]\r\nLogistco is one of the world\u2019s leading logistics companies. Its strong market position lies in the seafreight, airfreight, contract logistics and overland businesses.\r\n\r\n[gdlr_core_social_network facebook=\"#url\"  twitter=\"#url\" linkedin=\"#\" skype=\"#\" vimeo=\"#\" icon-size=\"16px\" icon-color=\"#fff\" ]","filter":true,"visual":true},"2":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"3":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"4":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"5":{"title":"Contact Info","text":"Box 3233\r\n1810 Kings Way\r\nKing Street, 5th Avenue, New York\r\n\r\n<span style=\"color: #fff;\">+1-2355-3345-5<\/span>\r\n<span style=\"color: #e53d34;\">contact@logiscocorp.com<\/span>","filter":true,"visual":true},"6":{"title":"Brochures","text":"<span style=\"font-size: 15px\">View our prospectus brochure. We provide very in-depth detail about our services and pricing for this year.<\/span> [gdlr_core_space height=\"30px\"] [gdlr_core_button button-text=\"Presentation Brochure\" icon button-link=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/goodlayers-pdf.pdf\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#e53c35\" border-radius=\"3px\" icon=\"fa fa-file-pdf-o\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" padding=\"15px 66px 19px 27px\"] [gdlr_core_space height=\"8px\"] [gdlr_core_button button-text=\"Service Rate Of 2018\" icon button-link=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/goodlayers-pdf.pdf\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#143369\" border-radius=\"3px\" icon=\"fa fa-dollar\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" padding=\"15px 86px 19px 27px\"]","filter":true,"visual":true},"7":{"title":"","text":"[gdlr_core_space height=\"70px\"][gdlr_widget_box shadow-size=\"20px\" shadow-color=\"#000\" shadow-opacity=\"0.1\" padding=\"20px 37px 20px 37px\" ][gdlr_core_title title=\"Need Help?\" title-font-size=\"19px\" title-font-weight=\"700\" title-font-uppercase=\"disable\" title-font-letter-spacing=\"0px\" \r\npadding-bottom=\"20px\" ]Please feel free to contact us. We will get back to you with 1-2 business days. Or just call us now\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]<a href=\"mailto:admin@logiscotheme.co\" style=\"font-size: 14px;\">admin@logiscotheme.co<\/a>[gdlr_core_space height=\"12px\"][gdlr_core_icon icon=\"fa fa-phone\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]+1-2354-3334-77[\/gdlr_widget_box][gdlr_core_button button-text=\"Get A Free Quote\" icon button-link=\"https:\/\/demo.goodlayers.com\/logisco\/get-a-quote\/\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#f1f1f1\" border-radius=\"0px\" icon=\"fa fa-comments\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" full-width-button=\"enable\" position=\"relative\" padding=\"19px 57px 22px 57px\" text-color=\"#143369\" ]","filter":true,"visual":true},"8":{"title":"Download Related Material","text":"<span style=\"font-size: 15px;\">We provide very in-depth detail about our services and pricing for this year.<\/span> [gdlr_core_space height=\"30px\"] [gdlr_core_button button-text=\"Aerospace (PDF, 1.4 MaB)\" button-link=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/goodlayers-pdf.pdf\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#e53c35\" border-radius=\"3px\" icon=\"fa fa-download\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" padding=\"15px 47px 19px 27px\"] [gdlr_core_space height=\"8px\"]","filter":true,"visual":true},"9":{"title":"","text":"<img class=\"alignnone size-full wp-image-6717\" src=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/industry-person-1.jpg\" alt=\"\" width=\"500\" height=\"312\" \/>[gdlr_core_space height=\"-48px\"][gdlr_widget_box shadow-size=\"20px\" shadow-color=\"#000\" shadow-opacity=\"0.1\" padding=\"20px 37px 20px 37px\" ][gdlr_core_title title=\"Allan Smith\" title-font-size=\"19px\" title-color=\"#143369\" title-font-weight=\"700\" title-font-uppercase=\"disable\" title-font-letter-spacing=\"0px\"\r\npadding-bottom=\"20px\" ]Executive Vice President,\r\nAero &amp; Defense Department\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]Allan@LogiscoTheme.co[gdlr_core_space height=\"12px\"][gdlr_core_icon icon=\"fa fa-phone\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]+1-2354-3334-77[\/gdlr_widget_box][gdlr_core_button button-text=\"Get A Free Quote\" icon button-link=\"https:\/\/demo.goodlayers.com\/logisco\/get-a-quote\/\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#f1f1f1\" border-radius=\"0px\" icon=\"fa fa-comments\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" full-width-button=\"enable\" position=\"relative\" padding=\"19px 57px 22px 57px\" text-color=\"#143369\" ]","filter":true,"visual":true},"10":{"title":"","text":"<img class=\"alignnone wp-image-6716 size-full\" src=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/industry-person-6.jpg\" alt=\"\" width=\"500\" height=\"312\" \/>[gdlr_core_space height=\"-48px\"][gdlr_widget_box shadow-size=\"20px\" shadow-color=\"#000\" shadow-opacity=\"0.1\" padding=\"20px 37px 20px 37px\" ][gdlr_core_title title=\"John Doe\" title-font-size=\"19px\" title-color=\"#143369\" title-font-weight=\"700\" title-font-uppercase=\"disable\" title-font-letter-spacing=\"0px\"\r\npadding-bottom=\"20px\" ]Executive Vice President,\r\nAutomotive Department\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]Allan@LogiscoTheme.co[gdlr_core_space height=\"12px\"][gdlr_core_icon icon=\"fa fa-phone\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]+1-2354-3334-77[\/gdlr_widget_box][gdlr_core_button button-text=\"Get A Free Quote\" icon button-link=\"https:\/\/demo.goodlayers.com\/logisco\/get-a-quote\/\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#f1f1f1\" border-radius=\"0px\" icon=\"fa fa-comments\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" full-width-button=\"enable\" position=\"relative\" padding=\"19px 57px 22px 57px\" text-color=\"#143369\" ]","filter":true,"visual":true},"13":{"title":"Download Related Material","text":"<span style=\"font-size: 15px;\">We provide very in-depth detail about our services and pricing for this year.<\/span> [gdlr_core_space height=\"30px\"] [gdlr_core_button button-text=\"Aerospace (PDF, 1.4 MaB)\" button-link=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/goodlayers-pdf.pdf\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#e53c35\" border-radius=\"3px\" icon=\"fa fa-download\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" padding=\"15px 47px 19px 27px\"] [gdlr_core_space height=\"8px\"]","filter":true,"visual":true},"15":{"title":"Download Related Material","text":"<span style=\"font-size: 15px;\">We provide very in-depth detail about our services and pricing for this year.<\/span> [gdlr_core_space height=\"30px\"] [gdlr_core_button button-text=\"Aerospace (PDF, 1.4 MaB)\" button-link=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/goodlayers-pdf.pdf\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#e53c35\" border-radius=\"3px\" icon=\"fa fa-download\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" padding=\"15px 47px 19px 27px\"] [gdlr_core_space height=\"8px\"]","filter":true,"visual":true},"16":{"title":"","text":"<img class=\"alignnone wp-image-6713 size-full\" src=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/industry-person-3.jpg\" alt=\"\" width=\"500\" height=\"312\" \/>[gdlr_core_space height=\"-48px\"][gdlr_widget_box shadow-size=\"20px\" shadow-color=\"#000\" shadow-opacity=\"0.1\" padding=\"20px 37px 20px 37px\" ][gdlr_core_title title=\"Phillip Banker\" title-font-size=\"19px\" title-color=\"#143369\" title-font-weight=\"700\" title-font-uppercase=\"disable\" title-font-letter-spacing=\"0px\"\r\npadding-bottom=\"20px\" ]Executive Vice President,\r\nHealthcare Department\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]Allan@LogiscoTheme.co[gdlr_core_space height=\"12px\"][gdlr_core_icon icon=\"fa fa-phone\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]+1-2354-3334-77[\/gdlr_widget_box][gdlr_core_button button-text=\"Get A Free Quote\" icon button-link=\"https:\/\/demo.goodlayers.com\/logisco\/get-a-quote\/\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#f1f1f1\" border-radius=\"0px\" icon=\"fa fa-comments\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" full-width-button=\"enable\" position=\"relative\" padding=\"19px 57px 22px 57px\" text-color=\"#143369\" ]","filter":true,"visual":true},"19":{"title":"Download Related Material","text":"<span style=\"font-size: 15px;\">We provide very in-depth detail about our services and pricing for this year.<\/span> [gdlr_core_space height=\"30px\"] [gdlr_core_button button-text=\"Aerospace (PDF, 1.4 MaB)\" button-link=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/goodlayers-pdf.pdf\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#e53c35\" border-radius=\"3px\" icon=\"fa fa-download\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" padding=\"15px 47px 19px 27px\"] [gdlr_core_space height=\"8px\"]","filter":true,"visual":true},"20":{"title":"Download Related Material","text":"<span style=\"font-size: 15px;\">We provide very in-depth detail about our services and pricing for this year.<\/span> [gdlr_core_space height=\"30px\"] [gdlr_core_button button-text=\"Aerospace (PDF, 1.4 MaB)\" button-link=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/goodlayers-pdf.pdf\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#e53c35\" border-radius=\"3px\" icon=\"fa fa-download\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" padding=\"15px 47px 19px 27px\"] [gdlr_core_space height=\"8px\"]","filter":true,"visual":true},"21":{"title":"","text":"<img class=\"alignnone wp-image-6715 size-full\" src=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/industry-person-5.jpg\" alt=\"\" width=\"500\" height=\"312\" \/>[gdlr_core_space height=\"-48px\"][gdlr_widget_box shadow-size=\"20px\" shadow-color=\"#000\" shadow-opacity=\"0.1\" padding=\"20px 37px 20px 37px\" ][gdlr_core_title title=\"Paul Sherman\" title-font-size=\"19px\" title-color=\"#143369\" title-font-weight=\"700\" title-font-uppercase=\"disable\" title-font-letter-spacing=\"0px\"\r\npadding-bottom=\"20px\" ]Executive Vice President,\r\nOil &amp; Gas Department\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]Allan@LogiscoTheme.co[gdlr_core_space height=\"12px\"][gdlr_core_icon icon=\"fa fa-phone\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]+1-2354-3334-77[\/gdlr_widget_box][gdlr_core_button button-text=\"Get A Free Quote\" icon button-link=\"https:\/\/demo.goodlayers.com\/logisco\/get-a-quote\/\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#f1f1f1\" border-radius=\"0px\" icon=\"fa fa-comments\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" full-width-button=\"enable\" position=\"relative\" padding=\"19px 57px 22px 57px\" text-color=\"#143369\" ]","filter":true,"visual":true},"22":{"title":"","text":"<img class=\"alignnone wp-image-6712 size-full\" src=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/industry-person-2.jpg\" alt=\"\" width=\"500\" height=\"312\" \/>[gdlr_core_space height=\"-48px\"][gdlr_widget_box shadow-size=\"20px\" shadow-color=\"#000\" shadow-opacity=\"0.1\" padding=\"20px 37px 20px 37px\" ][gdlr_core_title title=\"Jenny Carter\" title-font-size=\"19px\" title-color=\"#143369\" title-font-weight=\"700\" title-font-uppercase=\"disable\" title-font-letter-spacing=\"0px\"\r\npadding-bottom=\"20px\" ]Executive Vice President,\r\nConsumer Department\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]Allan@LogiscoTheme.co[gdlr_core_space height=\"12px\"][gdlr_core_icon icon=\"fa fa-phone\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]+1-2354-3334-77[\/gdlr_widget_box][gdlr_core_button button-text=\"Get A Free Quote\" icon button-link=\"https:\/\/demo.goodlayers.com\/logisco\/get-a-quote\/\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#f1f1f1\" border-radius=\"0px\" icon=\"fa fa-comments\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" full-width-button=\"enable\" position=\"relative\" padding=\"19px 57px 22px 57px\" text-color=\"#143369\" ]","filter":true,"visual":true},"23":{"title":"","text":"<img class=\"alignnone wp-image-6714 size-full\" src=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/industry-person-4.jpg\" alt=\"\" width=\"500\" height=\"312\" \/>[gdlr_core_space height=\"-48px\"][gdlr_widget_box shadow-size=\"20px\" shadow-color=\"#000\" shadow-opacity=\"0.1\" padding=\"20px 37px 20px 37px\" ][gdlr_core_title title=\"Linsey Smith\" title-font-size=\"19px\" title-color=\"#143369\" title-font-weight=\"700\" title-font-uppercase=\"disable\" title-font-letter-spacing=\"0px\"\r\npadding-bottom=\"20px\" ]Executive Vice President,\r\nRetail Department\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]Allan@LogiscoTheme.co[gdlr_core_space height=\"12px\"][gdlr_core_icon icon=\"fa fa-phone\" size=\"14px\" color=\"#2a2a2a\" margin-right=\"11px\" margin-left=\"2px\"]+1-2354-3334-77[\/gdlr_widget_box][gdlr_core_button button-text=\"Get A Free Quote\" icon button-link=\"https:\/\/demo.goodlayers.com\/logisco\/get-a-quote\/\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#f1f1f1\" border-radius=\"0px\" icon=\"fa fa-comments\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" full-width-button=\"enable\" position=\"relative\" padding=\"19px 57px 22px 57px\" text-color=\"#143369\" ]","filter":true,"visual":true},"24":{"title":"Download Related Material","text":"<span style=\"font-size: 15px;\">We provide very in-depth detail about our services and pricing for this year.<\/span> [gdlr_core_space height=\"30px\"] [gdlr_core_button button-text=\"Aerospace (PDF, 1.4 MaB)\" button-link=\"https:\/\/demo.goodlayers.com\/logisco\/wp-content\/uploads\/2018\/12\/goodlayers-pdf.pdf\" button-link-target=\"_blank\" margin-right=\"20px\" background-color=\"#e53c35\" border-radius=\"3px\" icon=\"fa fa-download\" icon-position=\"left\" text-size=\"16px\" text-font-weight=\"700\" text-transform=\"none\" text-letter-spacing=\"0px\" margin-right=\"0px\" padding=\"15px 47px 19px 27px\"] [gdlr_core_space height=\"8px\"]","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"1":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"1":{"title":"Product Categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"1":{"title":"Top Rated Products","number":5},"_multiwidget":1},"widget_woocommerce_widget_cart":{"1":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"logisco_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1360px","container-padding":"20px","sidebar-title-divider":"disable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"disable","top-bar-width":"full","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-menu-position":"none","top-bar-left-text":"[gdlr_core_dropdown_tab]\n\n[gdlr_core_tab title=\"New York\" ]\n[gdlr_core_icon icon=\"icon_clock\" size=\"15px\" color=\"#fff\" margin-left=\"\" margin-right=\"10px\" ]Mon - Fri \/ 08:00 - 18:00 <div style=\"margin-left: 12px; margin-right: 17px; display: inline;\">|<\/div>[gdlr_core_icon icon=\"fa fa-envelope-open\" size=\"14px\" color=\"#fff\" margin-left=\"\" margin-right=\"10px\" ]<a href=\"mailto:admin@logiscotheme.co\">admin@logiscotheme.co<\/a> <div style=\"margin-left: 12px; margin-right: 17px; display: inline;\">|<\/div>[gdlr_core_icon icon=\"fa fa-phone\" size=\"15px\" color=\"#fff\" margin-left=\"\" margin-right=\"10px\" ]+1-2354-334-77\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"London\"]\n[gdlr_core_icon icon=\"icon_clock\" size=\"15px\" color=\"#fff\" margin-left=\"\" margin-right=\"10px\" ]Mon - Fri \/ 09:00 - 19:00 <div style=\"margin-left: 12px; margin-right: 17px; display: inline;\">|<\/div>[gdlr_core_icon icon=\"fa fa-envelope-open\" size=\"14px\" color=\"#fff\" margin-left=\"\" margin-right=\"10px\" ]<a href=\"mailto:admin:@logiscotheme.co.uk\">admin@logiscotheme.co<\/a> <div style=\"margin-left: 12px; margin-right: 17px; display: inline;\">|<\/div>[gdlr_core_icon icon=\"fa fa-phone\" size=\"15px\" color=\"#fff\" margin-left=\"\" margin-right=\"10px\" ]+44-324-345-67[\/gdlr_core_tab]\n\n[\/gdlr_core_dropdown_tab]","top-bar-right-text":"","top-bar-right-button-text":"Get A Quote","top-bar-right-button-link":"\/logisco\/get-a-quote\/","top-bar-right-button-link-target":"_self","top-bar-top-padding":"27px","top-bar-bottom-padding":"27px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"#","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"55","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"16px","navigation-left-offset":"0","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"6950","logo-top-padding":"48px","logo-bottom-padding":"40px","logo-left-padding":"","max-logo-width":"175px","mobile-logo":"","max-tablet-logo-width":"130px","max-mobile-logo-width":"130px","mobile-logo-position":"logo-left","main-navigation-top-padding":"56px","main-navigation-bottom-padding":"15px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","navigation-right-top-margin":"","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-type":"right","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"130px","fixed-navigation-logo-top-padding":"28px","fixed-navigation-logo-bottom-padding":"21px","fixed-navigation-top-padding":"32px","fixed-navigation-bottom-padding":"34","fixed-navigation-anchor-offset":"75","enable-mobile-navigation-sticky":"enable","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"130px","default-title-bottom-padding":"160px","default-page-caption-top-margin":"13px","default-title-font-transform":"none","default-title-font-size":"51px","default-title-font-weight":"800","default-title-letter-spacing":"0px","default-caption-font-transform":"none","default-caption-font-size":"21px","default-caption-font-weight":"400","default-caption-letter-spacing":"0px","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-title-background-overlay-opacity":"5","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"6345","default-404-background-opacity":"100","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"413px","single-blog-title-bottom-gradient-size":"413px","default-blog-title-background-overlay-opacity":"0","blog-style":"style-2","blockquote-style":"style-2","blog-sidebar":"right","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"blog","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["date","author","category","comment"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","enable-related-post":"enable","related-post-blog-style":"blog-column-with-frame","related-post-blog-column-style":"style-1","related-post-column-size":"20","related-post-meta-option":["date"],"related-post-thumbnail-size":"Portfolio Side Description Large","related-post-num-fetch":"3","related-post-excerpt-number":"0","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar-preset","archive-blog-style":"blog-full","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"shop","woocommerce-archive-column-size":"30","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"30","woocommerce-related-product-num-fetch":"2","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"fa fa-external-link","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"67px","footer-bottom-padding":"42px","footer-style":"footer-3","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"38px","copyright-bottom-padding":"38px","copyright-text":"","copyright-left":"Copyright 2019 Logisco, All Right Reserved","copyright-right":"<a href=\"#\" style=\"margin-left:21px;\">Home<\/a><a href=\"#\" style=\"margin-left:21px;\">About       <\/a><a href=\"#\" style=\"margin-left:21px;\">Updates<\/a><a href=\"#\" style=\"margin-left:21px;\">Services<\/a><a href=\"#\" style=\"margin-left:21px;\">Contact<\/a>","enable-back-to-top":"disable","navigation-slide-bar-top-margin":"-13px","top-bar-full-left-padding":"15px","top-bar-full-right-padding":"0px"},"logisco_typography":{"heading-font":"Assistant","navigation-font":"Karla","content-font":"Karla","info-font":"Karla","blog-info-font":"Karla","quote-font":"PT Sans","testimonial-font":"Karla","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","header-font-weight":"","content-font-size":"16px","content-font-weight":"","content-line-height":"1.7","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-size":"15px","navigation-font-weight":"800","navigation-font-letter-spacing":"1px","navigation-text-transform":"uppercase","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"20px","sidebar-title-font-weight":"700","sidebar-title-font-letter-spacing":"0px","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"700","footer-title-font-letter-spacing":"0","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"16px","copyright-font-weight":"600","copyright-font-letter-spacing":"0","copyright-text-transform":"none","font-upload":"","fixed-navigation-font-size":"14","fixed-navigation-font-weight":"","fixed-navigation-font-letter-spacing":"1","fixed-navigation-text-transform":""},"logisco_color":{"skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e0e0e0","content":"#ffffff","icon":"","link":"","link-hover":"#ffffff","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#143369","button-background-hover":"#516487","button-border-color":"","button-border-hover-color":""},{"name":"logisco Number color","title":"#143369","title-hover":"","caption":"#143369","content":"#143369","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#143369","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"logisco skin color ","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4f1212","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"logisco call to action1","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4f1212","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"call to blue","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#081835","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Homepage Column Service","title":"#252525","title-hover":"","caption":"","content":"#4f5d77","icon":"","link":"#143369","link-hover":"#5d6f99","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Homepage Column Service 2","title":"#143369","title-hover":"","caption":"","content":"#585858","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Homepage Portfolio","title":"#143369","title-hover":"","caption":"","content":"","icon":"#e53c35","link":"","link-hover":"","divider":"#e53c35","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Homepage Enquiry Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#313131","element-content":"#adadad","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Red Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#b5b5b5","button-text":"","button-text-hover":"","button-background":"#e53c35","button-background-hover":"#e57875","button-border-color":"","button-border-hover-color":""},{"name":"Personnel White","title":"#ffffff","title-hover":"","caption":"#e0e0e0","content":"#d1d1d1","icon":"","link":"#ffffff","link-hover":"#d1d1d1","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"career svc","title":"#143369","title-hover":"","caption":"#090909","content":"#090909","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Re Button 2","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#727272","button-text":"","button-text-hover":"","button-background":"#e53c35","button-background-hover":"#e57875","button-border-color":"","button-border-hover-color":""},{"name":"Quote Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#f5f5f5","element-background":"#f5f5f5","element-content":"#727272","button-text":"","button-text-hover":"","button-background":"#e53c35","button-background-hover":"#e57f7b","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#e53c35","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#1e1e1e","header-plain-bottom-border-color":"#e8e8e8","logo-background-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-background-color":"#ffffff","top-cart-text-color":"#2d2d2d","top-cart-view-cart-color":"#666666","top-cart-checkout-color":"#143369","breadcrumbs-text-color":"#7f7f7f","breadcrumbs-text-active-color":"#143369","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#cc2d2d","main-menu-text-color":"#a0a0a0","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-menu-text-hover-background-color":"#393939","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-bar-right-icon-color":"#ffffff","woocommerce-cart-icon-number-background":"#e53d34","woocommerce-cart-icon-number-color":"#ffffff","navigation-right-button-text-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-color":"","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-border-hover-color":"#555555","page-preload-background-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","body-content-color":"#636363","heading-color":"#383838","link-color":"#3c5a90","link-hover-color":"#3c4660","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#cecece","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#143369","sidebar-link-color":"#143369","sidebar-link-hover-color":"#3c4660","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#919191","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#666666","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","tag-cloud-text-color":"#ffffff","tag-cloud-background-color":"#143369","tag-cloud-border-color":"#143369","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","footer-background-color":"#181e2a","footer-title-color":"#ffffff","footer-content-color":"#7b8596","footer-link-color":"#7b8596","footer-link-hover-color":"#ffffff","footer-divider-color":"#3a4251","copyright-background-color":"#0f131b","copyright-text-color":"#6a7281","copyright-link-color":"#6a7281","copyright-link-hover-color":"#ffffff","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-style-2-tags-color":"#143369","single-blog-navigation-color":"#383838","single-blog-navigation2-left-overlay":"#143369","single-blog-navigation2-overlay":"#143369","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#a7a7a7","blog-title-color":"#343434","blog-title-hover-color":"#e53d34","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#143369","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#143369","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#e53c35","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#191919","portfolio-title-hover-color":"","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-grid2-tag-background":"#143369","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#143369","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#143369","price-table-active-head-top-gradient-color":"#415582","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#a5bbd1","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#143369","price-table-active-button-background-top-gradient-color":"#4e6489","accordion-normal-icon-color":"#777777","accordion-normal-title-head-color":"#191919","accordion-normal-title-color":"#777777","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-head-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#143369","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#143369","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#143369","button-background-hover-color":"#53689b","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#143369","button-top-gradient-background-color":"#53689b","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#252525","flipbox-background-color":"#143369","flipbox-border-color":"#526287","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#143369","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#e53c35","slider-control-navigation-background-color":"#dfdfdf","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#143369","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#143369","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","woocommerce-theme-color":"#e53d34","woocommerce-price-color":"#e53d34","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#e58682","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#e53d34","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e","custom-menu-widget-box-style-text":"#727272","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","accordion-normal-icon-active-color":"#e53d34","accordion-normal-title-active-color":"#e53d34","blog-widget-info-front":"#e53d34"},"logisco_plugin":{"enable-srcset":"disable","thumbnail-sizing":[{"name":"Gallery Thumb","width":"1000","height":"650","hard-crop":""},{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"800","height":"480","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape","width":"1280","height":"580","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Square Thumbnail","width":"700","height":"700","hard-crop":""},{"name":"Square Thumbnail","width":"700","height":"700","hard-crop":""},{"name":"Gallery Portrait Thumbnail","width":"700","height":"770","hard-crop":""}],"consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox":"lightGallery","ilightbox-skin":"dark","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-head-script2":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"6401","enable-preload":"disable","preload-image":""}}'
				),
			);
		}
	}

	// add action when finish install plugins
	add_action('logisco_tgmpa_no_item_redirect', 'logisco_tgmpa_no_item_redirect');
	if( !function_exists('logisco_tgmpa_no_item_redirect') ){
		function logisco_tgmpa_no_item_redirect(){
			echo '<script type="text/javascript">';
			echo 'window.location = \'' . admin_url('admin.php?page=gdlr_core_getting_start') . '\';';
			echo '</script>';
		}
	}

	// install required plugin and redirect to getting start page
	add_action('after_switch_theme', 'logisco_getting_start_redirect'); 	
	if( !function_exists('logisco_getting_start_redirect') ){
		function logisco_getting_start_redirect(){

			$default_theme_option = '{"logisco_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1360px","container-padding":"20px","sidebar-title-divider":"disable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"disable","enable-top-bar-on-mobile":"disable","top-bar-width":"full","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-menu-position":"none","top-bar-left-text":"","top-bar-right-text":"","top-bar-right-button-text":"Get A Quote","top-bar-right-button-link":"","top-bar-right-button-link-target":"_self","top-bar-top-padding":"27px","top-bar-bottom-padding":"27px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"#","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"55","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"16px","navigation-left-offset":"0","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"","logo-top-padding":"40px","logo-bottom-padding":"40px","logo-left-padding":"","max-logo-width":"175px","mobile-logo":"","max-tablet-logo-width":"130px","max-mobile-logo-width":"130px","mobile-logo-position":"logo-left","main-navigation-top-padding":"56px","main-navigation-bottom-padding":"15px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","navigation-right-top-margin":"","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-type":"right","right-menu-style":"hamburger","enable-main-navigation-sticky":"disable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"130px","fixed-navigation-logo-top-padding":"28px","fixed-navigation-logo-bottom-padding":"21px","fixed-navigation-top-padding":"32px","fixed-navigation-bottom-padding":"34","fixed-navigation-anchor-offset":"75","enable-mobile-navigation-sticky":"enable","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"130px","default-title-bottom-padding":"160px","default-page-caption-top-margin":"13px","default-title-font-transform":"none","default-title-font-size":"51px","default-title-font-weight":"800","default-title-letter-spacing":"0px","default-caption-font-transform":"none","default-caption-font-size":"21px","default-caption-font-weight":"400","default-caption-letter-spacing":"0px","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-title-background-overlay-opacity":"5","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"6345","default-404-background-opacity":"100","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"413px","single-blog-title-bottom-gradient-size":"413px","default-blog-title-background-overlay-opacity":"0","blog-style":"style-3","blockquote-style":"style-2","blog-sidebar":"right","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar-preset","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"disable","blog-date-feature-year":"disable","meta-option":["date","author","category","comment"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-1","related-post-column-size":"20","related-post-meta-option":["date"],"related-post-thumbnail-size":"Portfolio Side Description Large","related-post-num-fetch":"3","related-post-excerpt-number":"0","blog-social-share":"enable","blog-social-share-count":"disable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar-preset","archive-blog-style":"blog-full","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"disable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-column-size":"30","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"30","woocommerce-related-product-num-fetch":"2","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"fa fa-external-link","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"67px","footer-bottom-padding":"42px","footer-style":"footer-3","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"38px","copyright-bottom-padding":"38px","copyright-text":"","copyright-left":"","copyright-right":"","enable-back-to-top":"disable","navigation-slide-bar-top-margin":"-13px","top-bar-full-left-padding":"15px","top-bar-full-right-padding":"0px","woocommerce-archive-product-style":"grid-2"},"logisco_typography":{"heading-font":"Assistant","navigation-font":"Karla","content-font":"Karla","info-font":"Karla","blog-info-font":"Karla","quote-font":"PT Sans","testimonial-font":"Karla","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","header-font-weight":"","content-font-size":"16px","content-font-weight":"","content-line-height":"1.7","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-size":"15px","navigation-font-weight":"800","navigation-font-letter-spacing":"1px","navigation-text-transform":"uppercase","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"19px","sidebar-title-font-weight":"700","sidebar-title-font-letter-spacing":"0px","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"700","footer-title-font-letter-spacing":"0","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"16px","copyright-font-weight":"600","copyright-font-letter-spacing":"0","copyright-text-transform":"none","font-upload":"","fixed-navigation-font-size":"14","fixed-navigation-font-weight":"","fixed-navigation-font-letter-spacing":"1","fixed-navigation-text-transform":""},"logisco_color":{"skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e0e0e0","content":"#ffffff","icon":"","link":"","link-hover":"#ffffff","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#143369","button-background-hover":"#516487","button-border-color":"","button-border-hover-color":""},{"name":"logisco Number color","title":"#143369","title-hover":"","caption":"#143369","content":"#143369","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#143369","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"logisco skin color ","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4f1212","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"logisco call to action1","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#4f1212","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"call to blue","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#081835","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Homepage Column Service","title":"#252525","title-hover":"","caption":"","content":"#4f5d77","icon":"","link":"#143369","link-hover":"#5d6f99","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Homepage Column Service 2","title":"#143369","title-hover":"","caption":"","content":"#585858","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Homepage Portfolio","title":"#143369","title-hover":"","caption":"","content":"","icon":"#e53c35","link":"","link-hover":"","divider":"#e53c35","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Homepage Enquiry Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#313131","element-content":"#adadad","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Red Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#b5b5b5","button-text":"","button-text-hover":"","button-background":"#e53c35","button-background-hover":"#e57875","button-border-color":"","button-border-hover-color":""},{"name":"Personnel White","title":"#ffffff","title-hover":"","caption":"#e0e0e0","content":"#d1d1d1","icon":"","link":"#ffffff","link-hover":"#d1d1d1","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"career svc","title":"#143369","title-hover":"","caption":"#090909","content":"#090909","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Re Button 2","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"#727272","button-text":"","button-text-hover":"","button-background":"#e53c35","button-background-hover":"#e57875","button-border-color":"","button-border-hover-color":""},{"name":"Quote Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#f5f5f5","element-background":"#f5f5f5","element-content":"#727272","button-text":"","button-text-hover":"","button-background":"#e53c35","button-background-hover":"#e57f7b","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#e53c35","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#1e1e1e","header-plain-bottom-border-color":"#e8e8e8","logo-background-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-background-color":"#ffffff","top-cart-text-color":"#2d2d2d","top-cart-view-cart-color":"#323232","top-cart-checkout-color":"#ffffff","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#143369","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#cc2d2d","main-menu-text-color":"#a0a0a0","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-menu-text-hover-background-color":"#393939","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-bar-right-icon-color":"#ffffff","woocommerce-cart-icon-number-background":"#e53d34","woocommerce-cart-icon-number-color":"#ffffff","navigation-right-button-text-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-color":"","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-border-hover-color":"#555555","page-preload-background-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","body-content-color":"#636363","heading-color":"#383838","link-color":"#1d1d1d","link-hover-color":"#1d1d1d","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#cecece","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#0f0f0f","sidebar-link-color":"#7e7e7e","sidebar-link-hover-color":"#3f3f3f","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#919191","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#666666","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","tag-cloud-text-color":"#ffffff","tag-cloud-background-color":"#143369","tag-cloud-border-color":"#143369","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","footer-background-color":"#181e2a","footer-title-color":"#ffffff","footer-content-color":"#7b8596","footer-link-color":"#7b8596","footer-link-hover-color":"#ffffff","footer-divider-color":"#3a4251","copyright-background-color":"#0f131b","copyright-text-color":"#6a7281","copyright-link-color":"#6a7281","copyright-link-hover-color":"#ffffff","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-style-2-tags-color":"#143369","single-blog-navigation-color":"#383838","single-blog-navigation2-left-overlay":"#143369","single-blog-navigation2-overlay":"#143369","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#a7a7a7","blog-title-color":"#343434","blog-title-hover-color":"#e53d34","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#143369","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#143369","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#e53c35","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#191919","portfolio-title-hover-color":"","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-grid2-tag-background":"#143369","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#143369","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#143369","price-table-active-head-top-gradient-color":"#415582","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#a5bbd1","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#143369","price-table-active-button-background-top-gradient-color":"#4e6489","accordion-normal-icon-color":"#777777","accordion-normal-title-head-color":"#191919","accordion-normal-title-color":"#777777","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-head-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#143369","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#143369","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#143369","button-background-hover-color":"#53689b","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#143369","button-top-gradient-background-color":"#53689b","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#252525","flipbox-background-color":"#143369","flipbox-border-color":"#526287","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#143369","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#e53c35","slider-control-navigation-background-color":"#dfdfdf","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#143369","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#143369","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","woocommerce-theme-color":"#e53d34","woocommerce-price-color":"#e53d34","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#e58682","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#e53d34","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e","custom-menu-widget-box-style-text":"#727272","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","accordion-normal-icon-active-color":"#e53d34","accordion-normal-title-active-color":"#e53d34","blog-widget-info-front":"#e53d34","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#000000","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","single-blog-navigation-title-color":"#959595"},"logisco_plugin":{"enable-srcset":"disable","thumbnail-sizing":[{"name":"Gallery Thumb","width":"1000","height":"650","hard-crop":""},{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"800","height":"480","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape","width":"1280","height":"580","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Square Thumbnail","width":"700","height":"700","hard-crop":""},{"name":"Square Thumbnail","width":"700","height":"700","hard-crop":""},{"name":"Gallery Portrait Thumbnail","width":"700","height":"770","hard-crop":""}],"consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox":"lightGallery","ilightbox-skin":"dark","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-head-script2":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"1706","enable-preload":"disable","preload-image":""}}';
			$default_theme_option = json_decode($default_theme_option, true);
			foreach( $default_theme_option as $option_slug => $option_value ){
				$option = get_option($option_slug, array());
				if( empty($option) ){
					update_option($option_slug, $option_value);
				}
			}

			// redirect to plugin installation
			$plugin_slug = 'goodlayers-core';
			$getting_start_url = 'admin.php?page=gdlr_core_getting_start';
			// $redirect_url = logisco_tgmpa_does_plugin_active($plugin_slug,  $getting_start_url);
			$redirect_url = logisco_tgmpa_auto_install_url($plugin_slug,  $getting_start_url);
			
			if( empty($redirect_url) ){
				wp_redirect(admin_url('themes.php?page=tgmpa-install-plugins'));
			}else{
				wp_redirect($redirect_url);
			}

		}
	}