<?php

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.5.2
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'my_theme_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
function my_theme_register_required_plugins() {
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(
                array(
			'name' => 'Lifeline Core Plugin',
			'slug' => 'lifeline',
			'source' => SH_ROOT . 'framework/tgm/plugins/lifeline.zip',
			'required' => true,
			'version' => '2.1',
			'force_activation' => true,
			'force_deactivation' => false,
			'external_url' => 'http://www.webinane.com/',
			'file_path' => ABSPATH . 'wp-content/plugins/lifeline/lifeline.php'
		),
        array(
            'name' => esc_html__('Envato Market Plugin', 'lifeline'),
            'slug' => 'envato-market',
            'source' => SH_ROOT . 'framework/tgm/plugins/envato-market.zip',
            'required' => true,
            'version' => '1.0',
            'force_activation' => true,
            'force_deactivation' => true,
            'external_url' => 'https://theme.webinane.com/wp/lifeline',
            'file_path' => ABSPATH . 'wp-content/plugins/envato-market.zip',
            'plugin_author' => 'Webinane',
            'plugin_desc' => esc_html__('This plugin is need to update Lifeline theme.', 'lifeline')
        ),
		array(
			'name' => 'Visual Composer',
			'slug' => 'js_composer',
			'source' => 'https://s3.amazonaws.com/webinane-themes-plugins/js_composer.zip',
			'required' => true,
			'version' => '5.5.5',
			'force_activation' => true,
			'force_deactivation' => false,
			'external_url' => 'http://wpbakery.com/',
			'file_path' => ABSPATH . 'wp-content/plugins/js_composer/js_composer.php'
		),
		array(
			'name' => 'Layer Slider',
			'slug' => 'LayerSlider',
			'source' => 'https://s3.amazonaws.com/webinane-themes-plugins/LayerSlider.zip',
			'required' => true,
			'version' => '6.6.0',
			'force_activation' => false,
			'force_deactivation' => false,
			'external_url' => 'http://codecanyon.net/user/kreatura/',
			'file_path' => ABSPATH . 'wp-content/plugins/LayerSlider/layerslider.php'
		),
		array(
			'name' => 'Revolution Slider',
			'slug' => 'revslider',
			'source' => 'https://s3.amazonaws.com/webinane-themes-plugins/revslider.zip',
			'required' => true,
			'version' => '5.4.5.1',
			'force_activation' => false,
			'force_deactivation' => false,
			'external_url' => 'http://kreaturamedia.com/',
			'file_path' => ABSPATH . 'wp-content/plugins/revslider/revslider.php'
		),
        array(
	        'name'     => esc_html__( 'Contact Form 7', 'lifeline' ),
	        'slug'     => 'contact-form-7',
	        'required' => false,
        ),
		array(
			'name' => 'Woo Commerce WP',
			'slug' => 'woocommerce',
			'required' => true,
		),
	);

	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	$config = array(
		'id' => 'lifeline', // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '', // Default absolute path to bundled plugins.
		'menu' => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug' => 'themes.php', // Parent menu slug.
		'capability' => 'edit_theme_options', // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices' => true, // Show admin notices or not.
		'dismissable' => true, // If false, a user cannot dismiss the nag message.
		'dismiss_msg' => '', // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false, // Automatically activate plugins after installation or not.
		'message' => '', // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}
