<?php
/**
 * Default Theme Options and Internal Theme Settings
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

// -----------------------------------------------------------------
// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
// -- Internal theme settings
// -----------------------------------------------------------------
laundrycity_storage_set('settings', array(
	
	'custom_sidebars'			=> 8,							// How many custom sidebars will be registered (in addition to theme preset sidebars): 0 - 10

	'ajax_views_counter'		=> true,						// Use AJAX for increment posts counter (if cache plugins used) 
																// or increment posts counter then loading page (without cache plugin)
	'disable_jquery_ui'			=> false,						// Prevent loading custom jQuery UI libraries in the third-party plugins

	'max_load_fonts'			=> 3,							// Max fonts number to load from Google fonts or from uploaded fonts

	'use_mediaelements'			=> true,						// Load script "Media Elements" to play video and audio

	'max_excerpt_length'		=> 40,							// Max words number for the excerpt in the blog style 'Excerpt'.
																// For style 'Classic' - get half from this value
	'message_maxlength'			=> 1000							// Max length of the message from contact form
	
));



// -----------------------------------------------------------------
// -- Theme fonts (Google and/or custom fonts)
// -----------------------------------------------------------------

// Fonts to load when theme start
// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
// For example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
laundrycity_storage_set('load_fonts', array(

	// Font-face packed with theme
	array(
		'name'   => 'Arcon',
		'family' => 'sans-serif'
		),

	array(
		'name'   => 'sofiaprolight',
		'family' => 'sans-serif'
		),

	array(
		'name'   => 'woodfordbourne',
		'family' => 'sans-serif'
		)
));

// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
laundrycity_storage_set('load_fonts_subset', 'latin,latin-ext');

// Settings of the main tags
laundrycity_storage_set('theme_fonts', array(
	'p' => array(
		'title'				=> esc_html__('Main text', 'laundrycity'),
		'description'		=> esc_html__('Font settings of the main text of the site', 'laundrycity'),
		'font-family'		=> 'sofiaprolight, sans-serif',
		'font-size' 		=> '1rem',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.745em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '',
		'margin-top'		=> '0em',
		'margin-bottom'		=> '1.4em'
		),
	'h1' => array(
		'title'				=> esc_html__('Heading 1', 'laundrycity'),
		'font-family'		=> 'woodfordbourne, sans-serif',
		'font-size' 		=> '3.4375rem',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.21em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0',
		'margin-top'		=> '0.9583em',
		'margin-bottom'		=> '1.01em'
		),
	'h2' => array(
		'title'				=> esc_html__('Heading 2', 'laundrycity'),
		'font-family'		=> 'arcon, sans-serif',
		'font-size' 		=> '3.125rem',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.2em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'uppercase',
		'letter-spacing'	=> '10px',
		'margin-top'		=> '1.7344em',
		'margin-bottom'		=> '1.08em'
		),
	'h3' => array(
		'title'				=> esc_html__('Heading 3', 'laundrycity'),
		'font-family'		=> 'arcon, sans-serif',
		'font-size' 		=> '2.5em',
		'font-weight'		=> '300',
		'font-style'		=> 'normal',
		'line-height'		=> '1.30515em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0',
		'margin-top'		=> '1.1333em',
		'margin-bottom'		=> '0.879em'
		),
	'h4' => array(
		'title'				=> esc_html__('Heading 4', 'laundrycity'),
		'font-family'		=> 'woodfordbourne, sans-serif',
		'font-size' 		=> '1.7em',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.2043em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '1px',
		'margin-top'		=> '1.74em',
		'margin-bottom'		=> '0.9em'
		),
	'h5' => array(
		'title'				=> esc_html__('Heading 5', 'laundrycity'),
		'font-family'		=> 'woodfordbourne, sans-serif',
		'font-size' 		=> '1.375em',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.35em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0px',
		'margin-top'		=> '2.4em',
		'margin-bottom'		=> '1.25em'
		),
	'h6' => array(
		'title'				=> esc_html__('Heading 6', 'laundrycity'),
		'font-family'		=> 'woodfordbourne, sans-serif',
		'font-size' 		=> '1.05em',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.33em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.3px',
		'margin-top'		=> '1.85em',
		'margin-bottom'		=> '0.9412em'
		),
	'logo' => array(
		'title'				=> esc_html__('Logo text', 'laundrycity'),
		'description'		=> esc_html__('Font settings of the text case of the logo', 'laundrycity'),
		'font-family'		=> 'woodfordbourne, sans-serif',
		'font-size' 		=> '1.8em',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.25em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'uppercase',
		'letter-spacing'	=> '1px'
		),
	'button' => array(
		'title'				=> esc_html__('Buttons', 'laundrycity'),
		'font-family'		=> 'woodfordbourne, sans-serif',
		'font-size' 		=> '15px',
		'font-weight'		=> '700',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0.5px'
		),
	'input' => array(
		'title'				=> esc_html__('Input fields', 'laundrycity'),
		'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'laundrycity'),
		'font-family'		=> 'sofiaprolight, sans-serif',
		'font-size' 		=> '0.875em',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.2em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0px'
		),
	'info' => array(
		'title'				=> esc_html__('Post meta', 'laundrycity'),
		'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'laundrycity'),
		'font-family'		=> 'sofiaprolight, sans-serif',
		'font-size' 		=> '13px',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0px',
		'margin-top'		=> '0.4em',
		'margin-bottom'		=> ''
		),
	'menu' => array(
		'title'				=> esc_html__('Main menu', 'laundrycity'),
		'description'		=> esc_html__('Font settings of the main menu items', 'laundrycity'),
		'font-family'		=> 'woodfordbourne, sans-serif',
		'font-size' 		=> '12px',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'uppercase',
		'letter-spacing'	=> '2.3px'
		),
	'submenu' => array(
		'title'				=> esc_html__('Dropdown menu', 'laundrycity'),
		'description'		=> esc_html__('Font settings of the dropdown menu items', 'laundrycity'),
		'font-family'		=> 'sofiaprolight, sans-serif',
		'font-size' 		=> '15px',
		'font-weight'		=> '300',
		'font-style'		=> 'normal',
		'line-height'		=> '1em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0px'
		)
));


// -----------------------------------------------------------------
// -- Theme colors for customizer
// -- Attention! Inner scheme must be last in the array below
// -----------------------------------------------------------------
laundrycity_storage_set('schemes', array(

	// Color scheme: 'default'
	'default' => array(
		'title'	 => esc_html__('Default', 'laundrycity'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#ffffff',
			'bd_color'				=> '#e5e5e5',

			// Text and links colors
			'text'					=> '#7b7c7f',//+
			'text_light'			=> '#919191',//+
			'text_dark'				=> '#1a1e32',//+
			'text_link'				=> '#86cee9',//+
			'text_hover'			=> '#e34a32',//+
			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#f7f7f7',//+
			'alter_bg_hover'		=> '#e6e8eb',
			'alter_bd_color'		=> '#e5e5e5',//+
			'alter_bd_hover'		=> '#dadada',
			'alter_text'			=> '#333333',
			'alter_light'			=> '#b7b7b7',
			'alter_dark'			=> '#1a1e32',//+
			'alter_link'			=> '#e34a32',//+
			'alter_hover'			=> '#e34a32',//+

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#f6f6f6',//+
			'input_bg_hover'		=> 'rgba(221,225,229,0.3)',
			'input_bd_color'		=> '#f6f6f6',//+
			'input_bd_hover'		=> '#e5e5e5',
			'input_text'			=> '#a7a8ac',//+
			'input_light'			=> '#e5e5e5',
			'input_dark'			=> '#e5e5e5',//+
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#ffffff',//+
			'inverse_light'			=> '#333333',
			'inverse_dark'			=> '#000000',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#1d1d1d',

			// Additional accented colors (if used in the current theme)
			// For example:
			'accent2'				=> '#ffcd30'//+
		
		)
	),

	// Color scheme: 'dark'
	'dark' => array(
		'title'  => esc_html__('Dark', 'laundrycity'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#0e0d12',
			'bd_color'				=> '#1c1b1f',

			// Text and links colors
			'text'					=> '#b7b7b7',
			'text_light'			=> '#5f5f5f',
			'text_dark'				=> '#ffffff',
			'text_link'				=> '#fe7259',
			'text_hover'			=> '#ffaa5f',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#1e1d22',
			'alter_bg_hover'		=> '#28272e',
			'alter_bd_color'		=> '#313131',
			'alter_bd_hover'		=> '#3d3d3d',
			'alter_text'			=> '#a6a6a6',
			'alter_light'			=> '#5f5f5f',
			'alter_dark'			=> '#ffffff',
			'alter_link'			=> '#86cee9',//+
			'alter_hover'			=> '#fe7259',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> 'rgba(62,61,66,0.5)',
			'input_bg_hover'		=> 'rgba(62,61,66,0.5)',
			'input_bd_color'		=> 'rgba(62,61,66,0.5)',
			'input_bd_hover'		=> '#353535',
			'input_text'			=> '#b7b7b7',
			'input_light'			=> '#5f5f5f',
			'input_dark'			=> '#ffffff',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#1d1d1d',
			'inverse_light'			=> '#5f5f5f',
			'inverse_dark'			=> '#000000',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#1d1d1d',
		
			// Additional accented colors (if used in the current theme)
			// For example:
			'accent2'				=> '#ffcd30'//+

		)
	)

));



// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('laundrycity_options_create')) {

	function laundrycity_options_create() {

		laundrycity_storage_set('options', array(
		
			// Section 'Title & Tagline' - add theme options in the standard WP section
			'title_tagline' => array(
				"title" => esc_html__('Title, Tagline & Site icon', 'laundrycity'),
				"desc" => wp_kses_data( __('Specify site title and tagline (if need) and upload the site icon', 'laundrycity') ),
				"type" => "section"
				),
		
		
			// Section 'Header' - add theme options in the standard WP section
			'header_image' => array(
				"title" => esc_html__('Header', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload logo images, select header type and widgets set for the header', 'laundrycity') ),
				"type" => "section"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'laundrycity'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Header fullheight', 'laundrycity'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'laundrycity'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'header_style' => array(
				"title" => esc_html__('Header style', 'laundrycity'),
				"desc" => wp_kses_data( __('Select style to display the site header', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"std" => 'header-default',
				"options" => apply_filters('laundrycity_filter_list_header_styles', array(
					'header-default' => esc_html__('Default Header',	'laundrycity')
				)),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'laundrycity'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"std" => 'default',
				"options" => array(
					'default' => esc_html__('Default','laundrycity'),
					'over' => esc_html__('Over',	'laundrycity'),
					'under' => esc_html__('Under',	'laundrycity')
				),
				"type" => "select"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'laundrycity'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'laundrycity') ),
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'laundrycity'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"dependency" => array(
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => laundrycity_get_list_range(0,6),
				"type" => "select"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'laundrycity'),
				"desc" => wp_kses_data( __('Select color scheme to decorate header area', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"std" => 'inherit',
				"options" => laundrycity_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_info' => array(
				"title" => esc_html__('Menu settings', 'laundrycity'),
				"desc" => wp_kses_data( __('Select main menu style, position, color scheme and other parameters', 'laundrycity') ),
				"type" => "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'laundrycity'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'laundrycity'),
					'left'	=> esc_html__('Left',	'laundrycity'),
					'right'	=> esc_html__('Right',	'laundrycity')
				),
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Menu Color Scheme', 'laundrycity'),
				"desc" => wp_kses_data( __('Select color scheme to decorate main menu area', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"std" => 'inherit',
				"options" => laundrycity_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'laundrycity'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'laundrycity') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'laundrycity'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'laundrycity') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'laundrycity'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'laundrycity') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'logo_info' => array(
				"title" => esc_html__('Logo settings', 'laundrycity'),
				"desc" => wp_kses_data( __('Select logo images for the normal and Retina displays', 'laundrycity') ),
				"type" => "info"
				),
			'logo' => array(
				"title" => esc_html__('Logo', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload site logo', 'laundrycity') ),
				"std" => '',
				"type" => "image"
				),
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'laundrycity') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse' => array(
				"title" => esc_html__('Logo inverse', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it on the dark background', 'laundrycity') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse_retina' => array(
				"title" => esc_html__('Logo inverse for Retina', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'laundrycity') ),
				"std" => '',
				"type" => "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'laundrycity') ),
				"std" => '',
				"type" => "image"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'laundrycity') ),
				"std" => '',
				"type" => "image"
				),
			'logo_text' => array(
				"title" => esc_html__('Logo from Site name', 'laundrycity'),
				"desc" => wp_kses_data( __('Do you want use Site name and description as Logo if images above are not selected?', 'laundrycity') ),
				"std" => 1,
				"type" => "checkbox"
				),
			
		
		
			// Section 'Content'
			'content' => array(
				"title" => esc_html__('Content', 'laundrycity'),
				"desc" => wp_kses_data( __('Options for the content area', 'laundrycity') ),
				"type" => "section",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'laundrycity'),
				"desc" => wp_kses_data( __('Select width of the body content', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => array(
					'boxed'		=> esc_html__('Boxed',		'laundrycity'),
					'wide'		=> esc_html__('Wide',		'laundrycity'),
					'fullwide'	=> esc_html__('Fullwide',	'laundrycity'),
					'fullscreen'=> esc_html__('Fullscreen',	'laundrycity')
				),
				"type" => "select"
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'laundrycity'),
				"desc" => wp_kses_data( __('Select color scheme to decorate whole site. Attention! Case "Inherit" can be used only for custom pages, not for root site content in the Appearance - Customize', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"std" => 'default',
				"options" => laundrycity_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'laundrycity'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'laundrycity') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'laundrycity'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'laundrycity') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'laundrycity'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'laundrycity') ),
				"std" => 0,
				"type" => "checkbox"
				),
            'privacy_text' => array(
                "title" => esc_html__("Text with Privacy Policy link", 'laundrycity'),
                "desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'laundrycity') ),
                "std"   => wp_kses_post( __( 'I agree that my submitted data is being collected and stored.', 'laundrycity') ),
                "type"  => "text"
            ),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'laundrycity') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"std" => '',
				"type" => "image"
				),
			'no_image' => array(
				"title" => esc_html__('No image placeholder', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload image, used as placeholder for the posts without featured image', 'laundrycity') ),
				"std" => '',
				"type" => "image"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'laundrycity'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'laundrycity') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'laundrycity')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Color Scheme', 'laundrycity'),
				"desc" => wp_kses_data( __('Select color scheme to decorate sidebar', 'laundrycity') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'laundrycity')
				),
				"std" => 'side',
				"options" => laundrycity_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'laundrycity'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'laundrycity') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'laundrycity')
				),
				"refresh" => false,
				"std" => 'right',
				"options" => laundrycity_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets above the page', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'laundrycity')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'laundrycity')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'laundrycity')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets below the page', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'laundrycity')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
		
		
		
			// Section 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'laundrycity'),
				"desc" => wp_kses_data( __('Select set of widgets and columns number for the site footer', 'laundrycity') ),
				"type" => "section"
				),
			'footer_style' => array(
				"title" => esc_html__('Footer style', 'laundrycity'),
				"desc" => wp_kses_data( __('Select style to display the site footer', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Footer', 'laundrycity')
				),
				"std" => 'footer-default',
				"options" => apply_filters('laundrycity_filter_list_footer_styles', array(
					'footer-default' => esc_html__('Default Footer',	'laundrycity')
				)),
				"type" => "select"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'laundrycity'),
				"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'laundrycity') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'laundrycity')
				),
				"std" => 'dark',
				"options" => laundrycity_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'laundrycity'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'laundrycity') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'laundrycity')
				),
				"std" => 'footer_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'laundrycity'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'laundrycity') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'laundrycity')
				),
				"dependency" => array(
					'footer_widgets' => array('^hide')
				),
				"std" => 4,
				"options" => laundrycity_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwide', 'laundrycity'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'laundrycity') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'laundrycity')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'laundrycity'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'laundrycity') ),
				'refresh' => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'laundrycity') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'laundrycity'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'laundrycity') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'laundrycity'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'laundrycity') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'laundrycity'),
				"desc" => wp_kses_data( __('Copyright text in the footer', 'laundrycity') ),
				"std" => esc_html__('AxiomThemes &copy; {Y}. All rights reserved.', 'laundrycity'),
				"refresh" => false,
				"type" => "textarea"
				),
		
		
		
			// Section 'Homepage' - settings for home page
			'homepage' => array(
				"title" => esc_html__('Homepage', 'laundrycity'),
				"desc" => wp_kses_data( __('Select blog style and widgets to display on the homepage', 'laundrycity') ),
				"type" => "section"
				),
			'expand_content_home' => array(
				"title" => esc_html__('Expand content', 'laundrycity'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the Homepage', 'laundrycity') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style_home' => array(
				"title" => esc_html__('Blog style', 'laundrycity'),
				"desc" => wp_kses_data( __('Select posts style for the homepage', 'laundrycity') ),
				"std" => 'excerpt',
				"options" => laundrycity_get_list_blog_styles(),
				"type" => "select"
				),
			'first_post_large_home' => array(
				"title" => esc_html__('First post large', 'laundrycity'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of the Homepage', 'laundrycity') ),
				"dependency" => array(
					'blog_style_home' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_widgets_home' => array(
				"title" => esc_html__('Header widgets', 'laundrycity'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the homepage', 'laundrycity') ),
				"std" => 'header_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_home' => array(
				"title" => esc_html__('Sidebar widgets', 'laundrycity'),
				"desc" => wp_kses_data( __('Select sidebar to show on the homepage', 'laundrycity') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_home' => array(
				"title" => esc_html__('Sidebar position', 'laundrycity'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the homepage', 'laundrycity') ),
				"refresh" => false,
				"std" => 'right',
				"options" => laundrycity_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_home' => array(
				"title" => esc_html__('Widgets above the page', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'laundrycity') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_home' => array(
				"title" => esc_html__('Widgets above the content', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'laundrycity') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_home' => array(
				"title" => esc_html__('Widgets below the content', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'laundrycity') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_home' => array(
				"title" => esc_html__('Widgets below the page', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'laundrycity') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
			// Section 'Blog archive'
			'blog' => array(
				"title" => esc_html__('Blog archive', 'laundrycity'),
				"desc" => wp_kses_data( __('Options for the blog archive', 'laundrycity') ),
				"type" => "section",
				),
			'expand_content_blog' => array(
				"title" => esc_html__('Expand content', 'laundrycity'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the blog archive', 'laundrycity') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style' => array(
				"title" => esc_html__('Blog style', 'laundrycity'),
				"desc" => wp_kses_data( __('Select posts style for the blog archive', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"dependency" => array(
					'#page_template' => array( 'blog.php' ),
					'.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => 'excerpt',
				"options" => laundrycity_get_list_blog_styles(),
				"type" => "select"
				),
			'blog_columns' => array(
				"title" => esc_html__('Blog columns', 'laundrycity'),
				"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'laundrycity') ),
				"std" => 2,
				"options" => laundrycity_get_list_range(2,4),
				"type" => "hidden"
				),
			'post_type' => array(
				"title" => esc_html__('Post type', 'laundrycity'),
				"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"dependency" => array(
					'#page_template' => array( 'blog.php' ),
					'.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"linked" => 'parent_cat',
				"refresh" => false,
				"hidden" => true,
				"std" => 'post',
				"options" => laundrycity_get_list_posts_types(),
				"type" => "select"
				),
			'parent_cat' => array(
				"title" => esc_html__('Category to show', 'laundrycity'),
				"desc" => wp_kses_data( __('Select category to show in the blog archive', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"dependency" => array(
					'#page_template' => array( 'blog.php' ),
					'.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"refresh" => false,
				"hidden" => true,
				"std" => '0',
				"options" => laundrycity_array_merge(array(0 => esc_html__('- Select category -', 'laundrycity')), laundrycity_get_list_categories()),
				"type" => "select"
				),
			'posts_per_page' => array(
				"title" => esc_html__('Posts per page', 'laundrycity'),
				"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"dependency" => array(
					'#page_template' => array( 'blog.php' ),
					'.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"hidden" => true,
				"std" => '10',
				"type" => "text"
				),
			"blog_pagination" => array( 
				"title" => esc_html__('Pagination style', 'laundrycity'),
				"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"std" => "pages",
				"options" => array(
					'pages'	=> esc_html__("Page numbers", 'laundrycity'),
					'links'	=> esc_html__("Older/Newest", 'laundrycity'),
					'more'	=> esc_html__("Load more", 'laundrycity'),
					'infinite' => esc_html__("Infinite scroll", 'laundrycity')
				),
				"type" => "select"
				),
			'show_filters' => array(
				"title" => esc_html__('Show filters', 'laundrycity'),
				"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"dependency" => array(
					'#page_template' => array( 'blog.php' ),
					'.editor-page-attributes__template select' => array( 'blog.php' ),
					'blog_style' => array('portfolio', 'gallery')
				),
				"hidden" => true,
				"std" => 0,
				"type" => "checkbox"
				),
			'first_post_large' => array(
				"title" => esc_html__('First post large', 'laundrycity'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of blog archive', 'laundrycity') ),
				"dependency" => array(
					'blog_style' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			"blog_content" => array( 
				"title" => esc_html__('Posts content', 'laundrycity'),
				"desc" => wp_kses_data( __("Show full post's content in the blog or only post's excerpt", 'laundrycity') ),
				"std" => "excerpt",
				"options" => array(
					'excerpt'	=> esc_html__('Excerpt',	'laundrycity'),
					'fullpost'	=> esc_html__('Full post',	'laundrycity')
				),
				"type" => "select"
				),
			'time_diff_before' => array(
				"title" => esc_html__('Time difference', 'laundrycity'),
				"desc" => wp_kses_data( __("How many days show time difference instead post's date", 'laundrycity') ),
				"std" => 5,
				"type" => "text"
				),
			'related_posts' => array(
				"title" => esc_html__('Related posts', 'laundrycity'),
				"desc" => wp_kses_data( __('How many related posts should be displayed in the single post?', 'laundrycity') ),
				"std" => 2,
				"options" => laundrycity_get_list_range(2,4),
				"type" => "select"
				),
			'related_style' => array(
				"title" => esc_html__('Related posts style', 'laundrycity'),
				"desc" => wp_kses_data( __('Select style of the related posts output', 'laundrycity') ),
				"std" => 2,
				"options" => laundrycity_get_list_styles(1,2),
				"type" => "select"
				),
			"blog_animation" => array( 
				"title" => esc_html__('Animation for the posts', 'laundrycity'),
				"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'laundrycity')
				),
				"dependency" => array(
					'#page_template' => array( 'blog.php' ),
					'.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => "none",
				"options" => laundrycity_get_list_animations_in(),
				"type" => "select"
				),
			'header_widgets_blog' => array(
				"title" => esc_html__('Header widgets', 'laundrycity'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the blog archive', 'laundrycity') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_blog' => array(
				"title" => esc_html__('Sidebar widgets', 'laundrycity'),
				"desc" => wp_kses_data( __('Select sidebar to show on the blog archive', 'laundrycity') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_blog' => array(
				"title" => esc_html__('Sidebar position', 'laundrycity'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the blog archive', 'laundrycity') ),
				"refresh" => false,
				"std" => 'right',
				"options" => laundrycity_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_blog' => array(
				"title" => esc_html__('Widgets above the page', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'laundrycity') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_blog' => array(
				"title" => esc_html__('Widgets above the content', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'laundrycity') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_blog' => array(
				"title" => esc_html__('Widgets below the content', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'laundrycity') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_blog' => array(
				"title" => esc_html__('Widgets below the page', 'laundrycity'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'laundrycity') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'laundrycity')), laundrycity_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
		
			// Section 'Colors' - choose color scheme and customize separate colors from it
			'scheme' => array(
				"title" => esc_html__('* Color scheme editor', 'laundrycity'),
				"desc" => wp_kses_data( __("<b>Simple settings</b> - you can change only accented color, used for links, buttons and some accented areas.", 'laundrycity') )
						. '<br>'
						. wp_kses_data( __("<b>Advanced settings</b> - change all scheme's colors and get full control over the appearance of your site!", 'laundrycity') ),
				"priority" => 1000,
				"type" => "section"
				),
		
			'color_settings' => array(
				"title" => esc_html__('Color settings', 'laundrycity'),
				"desc" => '',
				"std" => 'simple',
				"options" => array(
					"simple"  => esc_html__("Simple", 'laundrycity'),
					"advanced" => esc_html__("Advanced", 'laundrycity')
				),
				"refresh" => false,
				"type" => "switch"
				),
		
			'color_scheme_editor' => array(
				"title" => esc_html__('Color Scheme', 'laundrycity'),
				"desc" => wp_kses_data( __('Select color scheme to edit colors', 'laundrycity') ),
				"std" => 'default',
				"options" => laundrycity_get_list_schemes(),
				"refresh" => false,
				"type" => "select"
				),
		
			'scheme_storage' => array(
				"title" => esc_html__('Colors storage', 'laundrycity'),
				"desc" => esc_html__('Hidden storage of the all color from the all color shemes (only for internal usage)', 'laundrycity'),
				"std" => '',
				"refresh" => false,
				"type" => "hidden"
				),
		
			'scheme_info_single' => array(
				"title" => esc_html__('Colors for single post/page', 'laundrycity'),
				"desc" => wp_kses_data( __('Specify colors for single post/page (not for alter blocks)', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
				
			'bg_color' => array(
				"title" => esc_html__('Background color', 'laundrycity'),
				"desc" => wp_kses_data( __('Background color of the whole page', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'bd_color' => array(
				"title" => esc_html__('Border color', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the bordered elements, separators, etc.', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'text' => array(
				"title" => esc_html__('Text', 'laundrycity'),
				"desc" => wp_kses_data( __('Plain text color on single page/post', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_light' => array(
				"title" => esc_html__('Light text', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the post meta: post date and author, comments number, etc.', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_dark' => array(
				"title" => esc_html__('Dark text', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the headers, strong text, etc.', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_link' => array(
				"title" => esc_html__('Links', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of links and accented areas', 'laundrycity') ),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_hover' => array(
				"title" => esc_html__('Links hover', 'laundrycity'),
				"desc" => wp_kses_data( __('Hover color for links and accented areas', 'laundrycity') ),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_alter' => array(
				"title" => esc_html__('Colors for alternative blocks', 'laundrycity'),
				"desc" => wp_kses_data( __('Specify colors for alternative blocks - rectangular blocks with its own background color (posts in homepage, blog archive, search results, widgets on sidebar, footer, etc.)', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'alter_bg_color' => array(
				"title" => esc_html__('Alter background color', 'laundrycity'),
				"desc" => wp_kses_data( __('Background color of the alternative blocks', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bg_hover' => array(
				"title" => esc_html__('Alter hovered background color', 'laundrycity'),
				"desc" => wp_kses_data( __('Background color for the hovered state of the alternative blocks', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_color' => array(
				"title" => esc_html__('Alternative border color', 'laundrycity'),
				"desc" => wp_kses_data( __('Border color of the alternative blocks', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_hover' => array(
				"title" => esc_html__('Alternative hovered border color', 'laundrycity'),
				"desc" => wp_kses_data( __('Border color for the hovered state of the alter blocks', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_text' => array(
				"title" => esc_html__('Alter text', 'laundrycity'),
				"desc" => wp_kses_data( __('Text color of the alternative blocks', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_light' => array(
				"title" => esc_html__('Alter light', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with alternative background', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_dark' => array(
				"title" => esc_html__('Alter dark', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the headers inside block with alternative background', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_link' => array(
				"title" => esc_html__('Alter link', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the links inside block with alternative background', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_hover' => array(
				"title" => esc_html__('Alter hover', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with alternative background', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_input' => array(
				"title" => esc_html__('Colors for the form fields', 'laundrycity'),
				"desc" => wp_kses_data( __('Specify colors for the form fields and textareas', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'input_bg_color' => array(
				"title" => esc_html__('Inactive background', 'laundrycity'),
				"desc" => wp_kses_data( __('Background color of the inactive form fields', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bg_hover' => array(
				"title" => esc_html__('Active background', 'laundrycity'),
				"desc" => wp_kses_data( __('Background color of the focused form fields', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_color' => array(
				"title" => esc_html__('Inactive border', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the border in the inactive form fields', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_hover' => array(
				"title" => esc_html__('Active border', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the border in the focused form fields', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_text' => array(
				"title" => esc_html__('Inactive field', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the text in the inactive fields', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_light' => array(
				"title" => esc_html__('Disabled field', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the disabled field', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_dark' => array(
				"title" => esc_html__('Active field', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the active field', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_inverse' => array(
				"title" => esc_html__('Colors for inverse blocks', 'laundrycity'),
				"desc" => wp_kses_data( __('Specify colors for inverse blocks, rectangular blocks with background color equal to the links color or one of accented colors (if used in the current theme)', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'inverse_text' => array(
				"title" => esc_html__('Inverse text', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the text inside block with accented background', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_light' => array(
				"title" => esc_html__('Inverse light', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with accented background', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_dark' => array(
				"title" => esc_html__('Inverse dark', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the headers inside block with accented background', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_link' => array(
				"title" => esc_html__('Inverse link', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the links inside block with accented background', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_hover' => array(
				"title" => esc_html__('Inverse hover', 'laundrycity'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with accented background', 'laundrycity') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$laundrycity_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),


			// Section 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'laundrycity'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'laundrycity') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'laundrycity')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'laundrycity'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'laundrycity') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'laundrycity')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// Panel 'Fonts' - manage fonts loading and set parameters of the base theme elements
			'fonts' => array(
				"title" => esc_html__('* Fonts settings', 'laundrycity'),
				"desc" => '',
				"priority" => 1500,
				"type" => "panel"
				),

			// Section 'Load_fonts'
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'laundrycity'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'laundrycity') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'laundrycity') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'laundrycity'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'laundrycity') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'laundrycity') ),
				"refresh" => false,
				"std" => '$laundrycity_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=laundrycity_get_theme_setting('max_load_fonts'); $i++) {
			$fonts["load_fonts-{$i}-info"] = array(
				"title" => esc_html(sprintf(__('Font %s', 'laundrycity'), $i)),
				"desc" => '',
				"type" => "info",
				);
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'laundrycity'),
				"desc" => '',
				"refresh" => false,
				"std" => '$laundrycity_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'laundrycity'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'laundrycity') )
							: '',
				"refresh" => false,
				"std" => '$laundrycity_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'laundrycity'),
					'serif' => esc_html__('serif', 'laundrycity'),
					'sans-serif' => esc_html__('sans-serif', 'laundrycity'),
					'monospace' => esc_html__('monospace', 'laundrycity'),
					'cursive' => esc_html__('cursive', 'laundrycity'),
					'fantasy' => esc_html__('fantasy', 'laundrycity')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'laundrycity'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'laundrycity') )
											. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'laundrycity') )
							: '',
				"refresh" => false,
				"std" => '$laundrycity_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Sections with font's attributes for each theme element
		$theme_fonts = laundrycity_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								: esc_html(sprintf(__('%s settings', 'laundrycity'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								: wp_kses_post( sprintf(__('Font settings of the "%s" tag.', 'laundrycity'), $tag) ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = laundrycity_get_list_load_fonts(true);
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'laundrycity'),
						'100' => esc_html__('100 (Light)', 'laundrycity'), 
						'200' => esc_html__('200 (Light)', 'laundrycity'), 
						'300' => esc_html__('300 (Thin)',  'laundrycity'),
						'400' => esc_html__('400 (Normal)', 'laundrycity'),
						'500' => esc_html__('500 (Semibold)', 'laundrycity'),
						'600' => esc_html__('600 (Semibold)', 'laundrycity'),
						'700' => esc_html__('700 (Bold)', 'laundrycity'),
						'800' => esc_html__('800 (Black)', 'laundrycity'),
						'900' => esc_html__('900 (Black)', 'laundrycity')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'laundrycity'),
						'normal' => esc_html__('Normal', 'laundrycity'), 
						'italic' => esc_html__('Italic', 'laundrycity')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'laundrycity'),
						'none' => esc_html__('None', 'laundrycity'), 
						'underline' => esc_html__('Underline', 'laundrycity'),
						'overline' => esc_html__('Overline', 'laundrycity'),
						'line-through' => esc_html__('Line-through', 'laundrycity')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'laundrycity'),
						'none' => esc_html__('None', 'laundrycity'), 
						'uppercase' => esc_html__('Uppercase', 'laundrycity'),
						'lowercase' => esc_html__('Lowercase', 'laundrycity'),
						'capitalize' => esc_html__('Capitalize', 'laundrycity')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"refresh" => false,
					"std" => '$laundrycity_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters into Theme Options
		laundrycity_storage_merge_array('options', '', $fonts);

		// Add Header Video if WP version < 4.7
		if (!function_exists('get_header_video_url')) {
			laundrycity_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'laundrycity'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'laundrycity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'laundrycity')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}
	}
}




// -----------------------------------------------------------------
// -- Create and manage Theme Options
// -----------------------------------------------------------------

// Theme init priorities:
// 2 - create Theme Options
if (!function_exists('laundrycity_options_theme_setup2')) {
	add_action( 'after_setup_theme', 'laundrycity_options_theme_setup2', 2 );
	function laundrycity_options_theme_setup2() {
		laundrycity_options_create();
	}
}

// Step 1: Load default settings and previously saved mods
if (!function_exists('laundrycity_options_theme_setup5')) {
	add_action( 'after_setup_theme', 'laundrycity_options_theme_setup5', 5 );
	function laundrycity_options_theme_setup5() {
		laundrycity_storage_set('options_reloaded', false);
		laundrycity_load_theme_options();
	}
}

// Step 2: Load current theme customization mods
if (is_customize_preview()) {
	if (!function_exists('laundrycity_load_custom_options')) {
		add_action( 'wp_loaded', 'laundrycity_load_custom_options' );
		function laundrycity_load_custom_options() {
			if (!laundrycity_storage_get('options_reloaded')) {
				laundrycity_storage_set('options_reloaded', true);
				laundrycity_load_theme_options();
			}
		}
	}
}

// Load current values for each customizable option
if ( !function_exists('laundrycity_load_theme_options') ) {
	function laundrycity_load_theme_options() {
		$options = laundrycity_storage_get('options');
		$reset = (int) get_theme_mod('reset_options', 0);
		foreach ($options as $k=>$v) {
			if (isset($v['std'])) {
				if (strpos($v['std'], '$laundrycity_')!==false) {
					$func = substr($v['std'], 1);
					if (function_exists($func)) {
						$v['std'] = $func($k);
					}
				}
				$value = $v['std'];
				if (!$reset) {
					if (isset($_GET[$k]))
						$value = sanitize_text_field($_GET[$k]);
					else {
						$tmp = get_theme_mod($k, -987654321);
						if ($tmp != -987654321) $value = $tmp;
					}
				}
				laundrycity_storage_set_array2('options', $k, 'val', $value);
				if ($reset) remove_theme_mod($k);
			}
		}
		if ($reset) {
			// Unset reset flag
			set_theme_mod('reset_options', 0);
			// Regenerate CSS with default colors and fonts
			laundrycity_customizer_save_css();
		} else {
			do_action('laundrycity_action_load_options');
		}
	}
}

// Override options with stored page/post meta
if ( !function_exists('laundrycity_override_theme_options') ) {
	add_action( 'wp', 'laundrycity_override_theme_options', 1 );
	function laundrycity_override_theme_options($query=null) {
		if (is_page_template('blog.php')) {
			laundrycity_storage_set('blog_archive', true);
			laundrycity_storage_set('blog_template', get_the_ID());
		}
		laundrycity_storage_set('blog_mode', laundrycity_detect_blog_mode());
		if (is_singular()) {
			laundrycity_storage_set('options_meta', get_post_meta(get_the_ID(), 'laundrycity_options', true));
		}
	}
}


// Return customizable option value
if (!function_exists('laundrycity_get_theme_option')) {
	function laundrycity_get_theme_option($name, $defa='', $strict_mode=false, $post_id=0) {
		$rez = $defa;
		$from_post_meta = false;
		if ($post_id > 0) {
			if (!laundrycity_storage_isset('post_options_meta', $post_id))
				laundrycity_storage_set_array('post_options_meta', $post_id, get_post_meta($post_id, 'laundrycity_options', true));
			if (laundrycity_storage_isset('post_options_meta', $post_id, $name)) {
				$tmp = laundrycity_storage_get_array('post_options_meta', $post_id, $name);
				if (!laundrycity_is_inherit($tmp)) {
					$rez = $tmp;
					$from_post_meta = true;
				}
			}
		}
		if (!$from_post_meta && laundrycity_storage_isset('options')) {
			if ( !laundrycity_storage_isset('options', $name) ) {
				$rez = $tmp = '_not_exists_';
				if (function_exists('trx_addons_get_option'))
					$rez = trx_addons_get_option($name, $tmp, false);
				if ($rez === $tmp) {
					if ($strict_mode) {
						$s = debug_backtrace();
						$s = array_shift($s);
						echo '<pre>' . sprintf(esc_html__('Undefined option "%s" called from:', 'laundrycity'), $name);
						if (function_exists('dco')) dco($s);
						else print_r($s);
						echo '</pre>';
                        wp_die();
					} else
						$rez = $defa;
				}
			} else {
				$blog_mode = laundrycity_storage_get('blog_mode');
				// Override option from GET or POST for current blog mode
				if (!empty($blog_mode) && isset($_REQUEST[$name . '_' . $blog_mode])) {
					$rez = sanitize_text_field($_REQUEST[$name . '_' . $blog_mode]);
				// Override option from GET
				} else if (isset($_REQUEST[$name])) {
					$rez = sanitize_text_field($_REQUEST[$name]);
				// Override option from current page settings (if exists)
				} else if (laundrycity_storage_isset('options_meta', $name) && !laundrycity_is_inherit(laundrycity_storage_get_array('options_meta', $name))) {
					$rez = laundrycity_storage_get_array('options_meta', $name);
				// Override option from current blog mode settings: 'home', 'search', 'page', 'post', 'blog', etc. (if exists)
				} else if (!empty($blog_mode) && laundrycity_storage_isset('options', $name . '_' . $blog_mode, 'val') && !laundrycity_is_inherit(laundrycity_storage_get_array('options', $name . '_' . $blog_mode, 'val'))) {
					$rez = laundrycity_storage_get_array('options', $name . '_' . $blog_mode, 'val');
				// Get saved option value
				} else if (laundrycity_storage_isset('options', $name, 'val')) {
					$rez = laundrycity_storage_get_array('options', $name, 'val');
				// Get ThemeREX Addons option value
				} else if (function_exists('trx_addons_get_option')) {
					$rez = trx_addons_get_option($name, $defa, false);
				}
			}
		}
		return $rez;
	}
}


// Check if customizable option exists
if (!function_exists('laundrycity_check_theme_option')) {
	function laundrycity_check_theme_option($name) {
		return laundrycity_storage_isset('options', $name);
	}
}

// Get dependencies list from the Theme Options
if ( !function_exists('laundrycity_get_theme_dependencies') ) {
	function laundrycity_get_theme_dependencies() {
		$options = laundrycity_storage_get('options');
		$depends = array();
		foreach ($options as $k=>$v) {
			if (isset($v['dependency'])) 
				$depends[$k] = $v['dependency'];
		}
		return $depends;
	}
}

// Return internal theme setting value
if (!function_exists('laundrycity_get_theme_setting')) {
	function laundrycity_get_theme_setting($name) {
		return laundrycity_storage_isset('settings', $name) ? laundrycity_storage_get_array('settings', $name) : false;
	}
}


// Set theme setting
if ( !function_exists( 'laundrycity_set_theme_setting' ) ) {
	function laundrycity_set_theme_setting($option_name, $value) {
		if (laundrycity_storage_isset('settings', $option_name))
			laundrycity_storage_set_array('settings', $option_name, $value);
	}
}
?>