<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

$laundrycity_post_id    = get_the_ID();
$laundrycity_post_date  = laundrycity_get_date();
$laundrycity_post_title = get_the_title();
$laundrycity_post_link  = get_permalink();
$laundrycity_post_author_id   = get_the_author_meta('ID');
$laundrycity_post_author_name = get_the_author_meta('display_name');
$laundrycity_post_author_url  = get_author_posts_url($laundrycity_post_author_id, '');

$laundrycity_args = get_query_var('laundrycity_args_widgets_posts');
$laundrycity_show_date = isset($laundrycity_args['show_date']) ? (int) $laundrycity_args['show_date'] : 1;
$laundrycity_show_image = isset($laundrycity_args['show_image']) ? (int) $laundrycity_args['show_image'] : 1;
$laundrycity_show_author = isset($laundrycity_args['show_author']) ? (int) $laundrycity_args['show_author'] : 1;
$laundrycity_show_counters = isset($laundrycity_args['show_counters']) ? (int) $laundrycity_args['show_counters'] : 1;
$laundrycity_show_categories = isset($laundrycity_args['show_categories']) ? (int) $laundrycity_args['show_categories'] : 1;

$laundrycity_output = laundrycity_storage_get('laundrycity_output_widgets_posts');

$laundrycity_post_counters_output = '';
if ( $laundrycity_show_counters ) {
	$laundrycity_post_counters_output = '<span class="post_info_item post_info_counters">'
								. laundrycity_get_post_counters('comments')
							. '</span>';
}


$laundrycity_output .= '<article class="post_item with_thumb">';

if ($laundrycity_show_image) {
	$laundrycity_post_thumb = get_the_post_thumbnail($laundrycity_post_id, laundrycity_get_thumb_size('tiny'), array(
		'alt' => get_the_title()
	));
	if ($laundrycity_post_thumb) $laundrycity_output .= '<div class="post_thumb">' . ($laundrycity_post_link ? '<a href="' . esc_url($laundrycity_post_link) . '">' : '') . ($laundrycity_post_thumb) . ($laundrycity_post_link ? '</a>' : '') . '</div>';
}

$laundrycity_output .= '<div class="post_content">'
			. ($laundrycity_show_categories 
					? '<div class="post_categories">'
						. laundrycity_get_post_categories()
						. $laundrycity_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($laundrycity_post_link ? '<a href="' . esc_url($laundrycity_post_link) . '">' : '') . ($laundrycity_post_title) . ($laundrycity_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('laundrycity_filter_get_post_info', 
								'<div class="post_info">'
									. ($laundrycity_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($laundrycity_post_link ? '<a href="' . esc_url($laundrycity_post_link) . '" class="post_info_date">' : '') 
											. esc_html($laundrycity_post_date) 
											. ($laundrycity_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($laundrycity_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'laundrycity') . ' ' 
											. ($laundrycity_post_link ? '<a href="' . esc_url($laundrycity_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($laundrycity_post_author_name) 
											. ($laundrycity_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$laundrycity_show_categories && $laundrycity_post_counters_output
										? $laundrycity_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
laundrycity_storage_set('laundrycity_output_widgets_posts', $laundrycity_output);
?>