<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

// Header sidebar
$laundrycity_header_name = laundrycity_get_theme_option('header_widgets');
$laundrycity_header_present = !laundrycity_is_off($laundrycity_header_name) && is_active_sidebar($laundrycity_header_name);
if ($laundrycity_header_present) { 
	laundrycity_storage_set('current_sidebar', 'header');
	$laundrycity_header_wide = laundrycity_get_theme_option('header_wide');
	ob_start();
    if ( is_active_sidebar( $laundrycity_header_name ) ) {
        dynamic_sidebar( $laundrycity_header_name );
    }
	$laundrycity_widgets_output = ob_get_contents();
	ob_end_clean();
	if (trim(strip_tags($laundrycity_widgets_output)) != '') {
		$laundrycity_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $laundrycity_widgets_output);
		$laundrycity_need_columns = strpos($laundrycity_widgets_output, 'columns_wrap')===false;
		if ($laundrycity_need_columns) {
			$laundrycity_columns = max(0, (int) laundrycity_get_theme_option('header_columns'));
			if ($laundrycity_columns == 0) $laundrycity_columns = min(6, max(1, substr_count($laundrycity_widgets_output, '<aside ')));
			if ($laundrycity_columns > 1)
				$laundrycity_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($laundrycity_columns).' widget ', $laundrycity_widgets_output);
			else
				$laundrycity_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($laundrycity_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$laundrycity_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($laundrycity_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'laundrycity_action_before_sidebar' );
				laundrycity_show_layout($laundrycity_widgets_output);
				do_action( 'laundrycity_action_after_sidebar' );
				if ($laundrycity_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$laundrycity_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>