<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

// Page (category, tag, archive, author) title

if ( laundrycity_need_page_title() ) {
	laundrycity_sc_layouts_showed('title', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title">
						<?php
						// Post meta on the single post
						if ( is_single() && false )  {
							?><div class="sc_layouts_title_meta"><?php
								laundrycity_show_post_meta(array(
									'date' => false,
									'categories' => true,
									'seo' => true,
									'share' => false,
									'counters' => 'views,comments,likes'
									)
								);
							?></div><?php
						}

						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$laundrycity_blog_title = laundrycity_get_blog_title();
							$laundrycity_blog_title_text = $laundrycity_blog_title_class = $laundrycity_blog_title_link = $laundrycity_blog_title_link_text = '';
							if (is_array($laundrycity_blog_title)) {
								$laundrycity_blog_title_text = $laundrycity_blog_title['text'];
								$laundrycity_blog_title_class = !empty($laundrycity_blog_title['class']) ? ' '.$laundrycity_blog_title['class'] : '';
								$laundrycity_blog_title_link = !empty($laundrycity_blog_title['link']) ? $laundrycity_blog_title['link'] : '';
								$laundrycity_blog_title_link_text = !empty($laundrycity_blog_title['link_text']) ? $laundrycity_blog_title['link_text'] : '';
							} else
								$laundrycity_blog_title_text = $laundrycity_blog_title;
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr($laundrycity_blog_title_class); ?>"><?php
								$laundrycity_top_icon = laundrycity_get_category_icon();
								if (!empty($laundrycity_top_icon)) {
                                    $alt = basename($laundrycity_top_icon);
                                    $alt = substr($alt,0,strlen($alt) - 4);
									$laundrycity_attr = laundrycity_getimagesize($laundrycity_top_icon);
									?><img src="<?php echo esc_url($laundrycity_top_icon); ?>" alt="<?php echo esc_html($alt); ?>" <?php if (!empty($laundrycity_attr[3])) laundrycity_show_layout($laundrycity_attr[3]);?>><?php
								}
								echo wp_kses_data($laundrycity_blog_title_text);
							?></h1>
							<?php
							if (!empty($laundrycity_blog_title_link) && !empty($laundrycity_blog_title_link_text)) {
								?><a href="<?php echo esc_url($laundrycity_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($laundrycity_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'laundrycity_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>