<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

$laundrycity_args = get_query_var('laundrycity_logo_args');

// Site logo
$laundrycity_logo_image  = laundrycity_get_logo_image(isset($laundrycity_args['type']) ? $laundrycity_args['type'] : '');
$laundrycity_logo_text   = laundrycity_is_on(laundrycity_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$laundrycity_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($laundrycity_logo_image) || !empty($laundrycity_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($laundrycity_logo_image)) {
			$laundrycity_attr = laundrycity_getimagesize($laundrycity_logo_image);
			echo '<img src="'.esc_url($laundrycity_logo_image).'" alt="'.esc_html($laundrycity_logo_text).'"'.(!empty($laundrycity_attr[3]) ? sprintf(' %s', $laundrycity_attr[3]) : '').'>' ;
		} else {
			laundrycity_show_layout(laundrycity_prepare_macros($laundrycity_logo_text), '<span class="logo_text">', '</span>');
			laundrycity_show_layout(laundrycity_prepare_macros($laundrycity_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>