<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0.06
 */

$laundrycity_header_css = $laundrycity_header_image = '';
$laundrycity_header_video = laundrycity_get_header_video();
if (true || empty($laundrycity_header_video)) {
	$laundrycity_header_image = get_header_image();
	if (laundrycity_is_on(laundrycity_get_theme_option('header_image_override')) && apply_filters('laundrycity_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($laundrycity_cat_img = laundrycity_get_category_image()) != '')
				$laundrycity_header_image = $laundrycity_cat_img;
		} else if (is_singular() || laundrycity_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$laundrycity_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($laundrycity_header_image)) $laundrycity_header_image = $laundrycity_header_image[0];
			} else
				$laundrycity_header_image = '';
		}
	}
}

$laundrycity_header_id = str_replace('header-custom-', '', laundrycity_get_theme_option("header_style"));

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($laundrycity_header_id);
						echo !empty($laundrycity_header_image) || !empty($laundrycity_header_video) ? ' with_bg_image' : ' without_bg_image';
						if ($laundrycity_header_video!='') echo ' with_bg_video';
						if ($laundrycity_header_image!='') echo ' '.esc_attr(laundrycity_add_inline_style('background-image: url('.esc_url($laundrycity_header_image).');'));
						if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
						if (laundrycity_is_on(laundrycity_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
						?> scheme_<?php echo esc_attr(laundrycity_is_inherit(laundrycity_get_theme_option('header_scheme')) 
														? laundrycity_get_theme_option('color_scheme') 
														: laundrycity_get_theme_option('header_scheme'));
						?>"><?php

	// Background video
	if (!empty($laundrycity_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('laundrycity_action_show_layout', $laundrycity_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );


		
?></header>