<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0.10
 */

// Footer sidebar
$laundrycity_footer_name = laundrycity_get_theme_option('footer_widgets');
$laundrycity_footer_present = !laundrycity_is_off($laundrycity_footer_name) && is_active_sidebar($laundrycity_footer_name);
if ($laundrycity_footer_present) { 
	laundrycity_storage_set('current_sidebar', 'footer');
	$laundrycity_footer_wide = laundrycity_get_theme_option('footer_wide');
	ob_start();
    if ( is_active_sidebar( $laundrycity_footer_name ) ) {
        dynamic_sidebar( $laundrycity_footer_name );
    }
	$laundrycity_out = trim(ob_get_contents());
	ob_end_clean();
	if (trim(strip_tags($laundrycity_out)) != '') {
		$laundrycity_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $laundrycity_out);
		$laundrycity_need_columns = true;
		if ($laundrycity_need_columns) {
			$laundrycity_columns = max(0, (int) laundrycity_get_theme_option('footer_columns'));
			if ($laundrycity_columns == 0) $laundrycity_columns = min(6, max(1, substr_count($laundrycity_out, '<aside ')));
			if ($laundrycity_columns > 1)
				$laundrycity_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($laundrycity_columns).' widget ', $laundrycity_out);
			else
				$laundrycity_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($laundrycity_footer_wide) ? ' footer_fullwidth' : ''; ?>">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$laundrycity_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($laundrycity_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'laundrycity_action_before_sidebar' );
				laundrycity_show_layout($laundrycity_out);
				do_action( 'laundrycity_action_after_sidebar' );
				if ($laundrycity_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$laundrycity_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>