<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0.10
 */

// Logo
if (laundrycity_is_on(laundrycity_get_theme_option('logo_in_footer'))) {
	$laundrycity_logo_image = '';
	if (laundrycity_get_retina_multiplier(2) > 1)
		$laundrycity_logo_image = laundrycity_get_theme_option( 'logo_footer_retina' );
	if (empty($laundrycity_logo_image)) 
		$laundrycity_logo_image = laundrycity_get_theme_option( 'logo_footer' );
	$laundrycity_logo_text   = get_bloginfo( 'name' );
	if (!empty($laundrycity_logo_image) || !empty($laundrycity_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($laundrycity_logo_image)) {
                    $alt = basename($laundrycity_logo_image);
                    $alt = substr($alt,0,strlen($alt) - 4);
					$laundrycity_attr = laundrycity_getimagesize($laundrycity_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($laundrycity_logo_image).'" class="logo_footer_image" alt="'.esc_html($alt).'"'.(!empty($laundrycity_attr[3]) ? sprintf(' %s', $laundrycity_attr[3]) : '').'></a>' ;
				} else if (!empty($laundrycity_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($laundrycity_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>