<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0.10
 */

// Copyright area
$laundrycity_footer_scheme =  laundrycity_is_inherit(laundrycity_get_theme_option('footer_scheme')) ? laundrycity_get_theme_option('color_scheme') : laundrycity_get_theme_option('footer_scheme');
$laundrycity_copyright_scheme = laundrycity_is_inherit(laundrycity_get_theme_option('copyright_scheme')) ? $laundrycity_footer_scheme : laundrycity_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($laundrycity_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php
				// Replace {{...}} and [[...]] on the <i>...</i> and <b>...</b>
				$laundrycity_copyright = laundrycity_prepare_macros(laundrycity_get_theme_option('copyright'));
				if (!empty($laundrycity_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $laundrycity_copyright, $laundrycity_matches)) {
						$laundrycity_copyright = str_replace($laundrycity_matches[1], date_i18n(str_replace(array('{', '}'), '', $laundrycity_matches[1])), $laundrycity_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($laundrycity_copyright));
				}
			?></div>
		</div>
	</div>
</div>
