<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

$laundrycity_sidebar_position = laundrycity_get_theme_option('sidebar_position');
if (laundrycity_sidebar_present()) {
	ob_start();
	$laundrycity_sidebar_name = laundrycity_get_theme_option('sidebar_widgets');
	laundrycity_storage_set('current_sidebar', 'sidebar');
    if ( is_active_sidebar( $laundrycity_sidebar_name ) ) {
        dynamic_sidebar( $laundrycity_sidebar_name );
    }
	$laundrycity_out = trim(ob_get_contents());
	ob_end_clean();
	if (trim(strip_tags($laundrycity_out)) != '') {
		?>
		<div class="sidebar <?php echo esc_attr($laundrycity_sidebar_position); ?> widget_area<?php if (!laundrycity_is_inherit(laundrycity_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(laundrycity_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'laundrycity_action_before_sidebar' );
				laundrycity_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $laundrycity_out));
				do_action( 'laundrycity_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>