<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

laundrycity_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'classie', laundrycity_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'imagesloaded', laundrycity_get_file_url('js/theme.gallery/imagesloaded.min.js'), array(), null, true );
wp_enqueue_script( 'masonry', laundrycity_get_file_url('js/theme.gallery/masonry.min.js'), array(), null, true );
wp_enqueue_script( 'laundrycity-gallery-script', laundrycity_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$laundrycity_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$laundrycity_sticky_out = is_array($laundrycity_stickies) && count($laundrycity_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$laundrycity_cat = laundrycity_get_theme_option('parent_cat');
	$laundrycity_post_type = laundrycity_get_theme_option('post_type');
	$laundrycity_taxonomy = laundrycity_get_post_type_taxonomy($laundrycity_post_type);
	$laundrycity_show_filters = laundrycity_get_theme_option('show_filters');
	$laundrycity_tabs = array();
	if (!laundrycity_is_off($laundrycity_show_filters)) {
		$laundrycity_args = array(
			'type'			=> $laundrycity_post_type,
			'child_of'		=> $laundrycity_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $laundrycity_taxonomy,
			'pad_counts'	=> false
		);
		$laundrycity_portfolio_list = get_terms($laundrycity_args);
		if (is_array($laundrycity_portfolio_list) && count($laundrycity_portfolio_list) > 0) {
			$laundrycity_tabs[$laundrycity_cat] = esc_html__('All', 'laundrycity');
			foreach ($laundrycity_portfolio_list as $laundrycity_term) {
				if (isset($laundrycity_term->term_id)) $laundrycity_tabs[$laundrycity_term->term_id] = $laundrycity_term->name;
			}
		}
	}
	if (count($laundrycity_tabs) > 0) {
		$laundrycity_portfolio_filters_ajax = true;
		$laundrycity_portfolio_filters_active = $laundrycity_cat;
		$laundrycity_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters laundrycity_tabs laundrycity_tabs_ajax">
			<ul class="portfolio_titles laundrycity_tabs_titles">
				<?php
				foreach ($laundrycity_tabs as $laundrycity_id=>$laundrycity_title) {
					?><li><a href="<?php echo esc_url(laundrycity_get_hash_link(sprintf('#%s_%s_content', $laundrycity_portfolio_filters_id, $laundrycity_id))); ?>" data-tab="<?php echo esc_attr($laundrycity_id); ?>"><?php echo esc_html($laundrycity_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$laundrycity_ppp = laundrycity_get_theme_option('posts_per_page');
			if (laundrycity_is_inherit($laundrycity_ppp)) $laundrycity_ppp = '';
			foreach ($laundrycity_tabs as $laundrycity_id=>$laundrycity_title) {
				$laundrycity_portfolio_need_content = $laundrycity_id==$laundrycity_portfolio_filters_active || !$laundrycity_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $laundrycity_portfolio_filters_id, $laundrycity_id)); ?>"
					class="portfolio_content laundrycity_tabs_content"
					data-blog-template="<?php echo esc_attr(laundrycity_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(laundrycity_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($laundrycity_ppp); ?>"
					data-post-type="<?php echo esc_attr($laundrycity_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($laundrycity_taxonomy); ?>"
					data-cat="<?php echo esc_attr($laundrycity_id); ?>"
					data-parent-cat="<?php echo esc_attr($laundrycity_cat); ?>"
					data-need-content="<?php echo (false===$laundrycity_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($laundrycity_portfolio_need_content) 
						laundrycity_show_portfolio_posts(array(
							'cat' => $laundrycity_id,
							'parent_cat' => $laundrycity_cat,
							'taxonomy' => $laundrycity_taxonomy,
							'post_type' => $laundrycity_post_type,
							'page' => 1,
							'sticky' => $laundrycity_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		laundrycity_show_portfolio_posts(array(
			'cat' => $laundrycity_cat,
			'parent_cat' => $laundrycity_cat,
			'taxonomy' => $laundrycity_taxonomy,
			'post_type' => $laundrycity_post_type,
			'page' => 1,
			'sticky' => $laundrycity_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>