<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

laundrycity_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	?><div class="posts_container"><?php
	
	$laundrycity_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$laundrycity_sticky_out = is_array($laundrycity_stickies) && count($laundrycity_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($laundrycity_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	while ( have_posts() ) { the_post(); 
		if ($laundrycity_sticky_out && !is_sticky()) {
			$laundrycity_sticky_out = false;
			?></div><?php
		}
		get_template_part( 'content', $laundrycity_sticky_out && is_sticky() ? 'sticky' : 'excerpt' );
	}
	if ($laundrycity_sticky_out) {
		$laundrycity_sticky_out = false;
		?></div><?php
	}
	
	?></div><?php

	laundrycity_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>