<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('laundrycity_storage_get')) {
	function laundrycity_storage_get($var_name, $default='') {
		global $LAUNDRYCITY_STORAGE;
		return isset($LAUNDRYCITY_STORAGE[$var_name]) ? $LAUNDRYCITY_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('laundrycity_storage_set')) {
	function laundrycity_storage_set($var_name, $value) {
		global $LAUNDRYCITY_STORAGE;
		$LAUNDRYCITY_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('laundrycity_storage_empty')) {
	function laundrycity_storage_empty($var_name, $key='', $key2='') {
		global $LAUNDRYCITY_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($LAUNDRYCITY_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($LAUNDRYCITY_STORAGE[$var_name][$key]);
		else
			return empty($LAUNDRYCITY_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('laundrycity_storage_isset')) {
	function laundrycity_storage_isset($var_name, $key='', $key2='') {
		global $LAUNDRYCITY_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($LAUNDRYCITY_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($LAUNDRYCITY_STORAGE[$var_name][$key]);
		else
			return isset($LAUNDRYCITY_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('laundrycity_storage_inc')) {
	function laundrycity_storage_inc($var_name, $value=1) {
		global $LAUNDRYCITY_STORAGE;
		if (empty($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = 0;
		$LAUNDRYCITY_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('laundrycity_storage_concat')) {
	function laundrycity_storage_concat($var_name, $value) {
		global $LAUNDRYCITY_STORAGE;
		if (empty($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = '';
		$LAUNDRYCITY_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('laundrycity_storage_get_array')) {
	function laundrycity_storage_get_array($var_name, $key, $key2='', $default='') {
		global $LAUNDRYCITY_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($LAUNDRYCITY_STORAGE[$var_name][$key]) ? $LAUNDRYCITY_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($LAUNDRYCITY_STORAGE[$var_name][$key][$key2]) ? $LAUNDRYCITY_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('laundrycity_storage_set_array')) {
	function laundrycity_storage_set_array($var_name, $key, $value) {
		global $LAUNDRYCITY_STORAGE;
		if (!isset($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = array();
		if ($key==='')
			$LAUNDRYCITY_STORAGE[$var_name][] = $value;
		else
			$LAUNDRYCITY_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('laundrycity_storage_set_array2')) {
	function laundrycity_storage_set_array2($var_name, $key, $key2, $value) {
		global $LAUNDRYCITY_STORAGE;
		if (!isset($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = array();
		if (!isset($LAUNDRYCITY_STORAGE[$var_name][$key])) $LAUNDRYCITY_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$LAUNDRYCITY_STORAGE[$var_name][$key][] = $value;
		else
			$LAUNDRYCITY_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('laundrycity_storage_merge_array')) {
	function laundrycity_storage_merge_array($var_name, $key, $value) {
		global $LAUNDRYCITY_STORAGE;
		if (!isset($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = array();
		if ($key==='')
			$LAUNDRYCITY_STORAGE[$var_name] = array_merge($LAUNDRYCITY_STORAGE[$var_name], $value);
		else
			$LAUNDRYCITY_STORAGE[$var_name][$key] = array_merge($LAUNDRYCITY_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('laundrycity_storage_set_array_after')) {
	function laundrycity_storage_set_array_after($var_name, $after, $key, $value='') {
		global $LAUNDRYCITY_STORAGE;
		if (!isset($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = array();
		if (is_array($key))
			laundrycity_array_insert_after($LAUNDRYCITY_STORAGE[$var_name], $after, $key);
		else
			laundrycity_array_insert_after($LAUNDRYCITY_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('laundrycity_storage_set_array_before')) {
	function laundrycity_storage_set_array_before($var_name, $before, $key, $value='') {
		global $LAUNDRYCITY_STORAGE;
		if (!isset($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = array();
		if (is_array($key))
			laundrycity_array_insert_before($LAUNDRYCITY_STORAGE[$var_name], $before, $key);
		else
			laundrycity_array_insert_before($LAUNDRYCITY_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('laundrycity_storage_push_array')) {
	function laundrycity_storage_push_array($var_name, $key, $value) {
		global $LAUNDRYCITY_STORAGE;
		if (!isset($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($LAUNDRYCITY_STORAGE[$var_name], $value);
		else {
			if (!isset($LAUNDRYCITY_STORAGE[$var_name][$key])) $LAUNDRYCITY_STORAGE[$var_name][$key] = array();
			array_push($LAUNDRYCITY_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('laundrycity_storage_pop_array')) {
	function laundrycity_storage_pop_array($var_name, $key='', $defa='') {
		global $LAUNDRYCITY_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($LAUNDRYCITY_STORAGE[$var_name]) && is_array($LAUNDRYCITY_STORAGE[$var_name]) && count($LAUNDRYCITY_STORAGE[$var_name]) > 0) 
				$rez = array_pop($LAUNDRYCITY_STORAGE[$var_name]);
		} else {
			if (isset($LAUNDRYCITY_STORAGE[$var_name][$key]) && is_array($LAUNDRYCITY_STORAGE[$var_name][$key]) && count($LAUNDRYCITY_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($LAUNDRYCITY_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('laundrycity_storage_inc_array')) {
	function laundrycity_storage_inc_array($var_name, $key, $value=1) {
		global $LAUNDRYCITY_STORAGE;
		if (!isset($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = array();
		if (empty($LAUNDRYCITY_STORAGE[$var_name][$key])) $LAUNDRYCITY_STORAGE[$var_name][$key] = 0;
		$LAUNDRYCITY_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('laundrycity_storage_concat_array')) {
	function laundrycity_storage_concat_array($var_name, $key, $value) {
		global $LAUNDRYCITY_STORAGE;
		if (!isset($LAUNDRYCITY_STORAGE[$var_name])) $LAUNDRYCITY_STORAGE[$var_name] = array();
		if (empty($LAUNDRYCITY_STORAGE[$var_name][$key])) $LAUNDRYCITY_STORAGE[$var_name][$key] = '';
		$LAUNDRYCITY_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('laundrycity_storage_call_obj_method')) {
	function laundrycity_storage_call_obj_method($var_name, $method, $param=null) {
		global $LAUNDRYCITY_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($LAUNDRYCITY_STORAGE[$var_name]) ? $LAUNDRYCITY_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($LAUNDRYCITY_STORAGE[$var_name]) ? $LAUNDRYCITY_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('laundrycity_storage_get_obj_property')) {
	function laundrycity_storage_get_obj_property($var_name, $prop, $default='') {
		global $LAUNDRYCITY_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($LAUNDRYCITY_STORAGE[$var_name]->$prop) ? $LAUNDRYCITY_STORAGE[$var_name]->$prop : $default;
	}
}
?>