<?php
/**
 * Theme functions: init, enqueue scripts and styles, include required files and widgets
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

// Theme storage
$LAUNDRYCITY_STORAGE = array(
	// Theme required plugin's slugs
	'required_plugins' => array(

		// Required plugins
		// DON'T COMMENT OR REMOVE NEXT LINES!
		'trx_addons',

		// Recommended (supported) plugins
		// If plugin not need - comment (or remove) it

		'essential-grid',
		'js_composer',
		'mailchimp-for-wp',
		'revslider',
		'wp-gdpr-compliance'
		)
);


//-------------------------------------------------------
//-- Theme init
//-------------------------------------------------------

// Theme init priorities:
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)

if ( !function_exists('laundrycity_theme_setup1') ) {
	add_action( 'after_setup_theme', 'laundrycity_theme_setup1', 1 );
	function laundrycity_theme_setup1() {
		// Make theme available for translation
		// Translations can be filed in the /languages directory
		// Attention! Translations must be loaded before first call any translation functions!
		load_theme_textdomain( 'laundrycity', laundrycity_get_folder_dir('languages') );

		// Set theme content width
		$GLOBALS['content_width'] = apply_filters( 'laundrycity_filter_content_width', 1170 );
	}
}

if ( !function_exists('laundrycity_theme_setup') ) {
	add_action( 'after_setup_theme', 'laundrycity_theme_setup' );
	function laundrycity_theme_setup() {

		// Add default posts and comments RSS feed links to head 
		add_theme_support( 'automatic-feed-links' );
		
		// Enable support for Post Thumbnails
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size(370, 0, false);
		
		// Add thumb sizes
		// ATTENTION! If you change list below - check filter's names in the 'trx_addons_filter_get_thumb_size' hook
		$thumb_sizes = apply_filters('laundrycity_filter_add_thumb_sizes', array(
			'laundrycity-thumb-huge'		=> array(1170, 658, true),
			'laundrycity-thumb-big' 		=> array( 760, 428, true),
			'laundrycity-thumb-med' 		=> array( 370, 208, true),
			'laundrycity-thumb-tiny' 		=> array(  90,  90, true),
			'laundrycity-thumb-masonry-big' => array( 760,   0, false),		// Only downscale, not crop
			'laundrycity-thumb-masonry'		=> array( 370,   0, false),		// Only downscale, not crop
			)
		);
		$mult = laundrycity_get_theme_option('retina_ready', 1);
		if ($mult > 1) $GLOBALS['content_width'] = apply_filters( 'laundrycity_filter_content_width', 1170*$mult);
		foreach ($thumb_sizes as $k=>$v) {
			// Add Original dimensions
			add_image_size( $k, $v[0], $v[1], $v[2]);
			// Add Retina dimensions
			if ($mult > 1) add_image_size( $k.'-@retina', $v[0]*$mult, $v[1]*$mult, $v[2]);
		}
		
		// Custom header setup
		add_theme_support( 'custom-header', array(
			'header-text'=>false,
			'video' => true
			)
		);

		// Custom backgrounds setup
		add_theme_support( 'custom-background', array()	);
		
		// Supported posts formats
		add_theme_support( 'post-formats', array('gallery', 'video', 'audio', 'link', 'quote', 'image', 'status', 'aside', 'chat') ); 
 
 		// Autogenerate title tag
		add_theme_support('title-tag');
 		
		// Add theme menus
		add_theme_support('nav-menus');
		
		// Switch default markup for search form, comment form, and comments to output valid HTML5.
		add_theme_support( 'html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption') );
		
		// WooCommerce Support
		add_theme_support( 'woocommerce' );
		
		// Editor custom stylesheet - for user
		add_editor_style( array_merge(
			array(
				'css/editor-style.css',
				laundrycity_get_file_url('css/fontello/css/fontello-embedded.css')
			),
			laundrycity_theme_fonts_for_editor()
			)
		);	
	
		// Register navigation menu
		register_nav_menus(array(
			'menu_main' => esc_html__('Main Menu', 'laundrycity'),
			'menu_mobile' => esc_html__('Mobile Menu', 'laundrycity')
			)
		);

		// Excerpt filters
		add_filter( 'excerpt_length',						'laundrycity_excerpt_length' );
		add_filter( 'excerpt_more',							'laundrycity_excerpt_more' );
		
		// Add required meta tags in the head
		add_action('wp_head',		 						'laundrycity_wp_head', 1);
		
		// Add custom inline styles
		add_action('wp_footer',		 						'laundrycity_wp_footer');
		add_action('admin_footer',	 						'laundrycity_wp_footer');

		// Enqueue scripts and styles for frontend
		add_action('wp_enqueue_scripts', 					'laundrycity_wp_scripts', 1000);			//priority 1000 - load styles before the plugin's support custom styles (priority 1100)
		add_action('wp_footer',		 						'laundrycity_localize_scripts');
		add_action('wp_enqueue_scripts', 					'laundrycity_wp_scripts_responsive', 2000);	//priority 2000 - load responsive after all other styles
		
		// Add body classes
		add_filter( 'body_class',							'laundrycity_add_body_classes' );

		// Register sidebars
		add_action('widgets_init',							'laundrycity_register_sidebars');

		// Set options for importer (before other plugins)
		add_filter( 'trx_addons_filter_importer_options',	'laundrycity_importer_set_options', 9 );
	}

}


//-------------------------------------------------------
//-- Thumb sizes
//-------------------------------------------------------
if ( !function_exists('laundrycity_image_sizes') ) {
	add_filter( 'image_size_names_choose', 'laundrycity_image_sizes' );
	function laundrycity_image_sizes( $sizes ) {
		$thumb_sizes = apply_filters('laundrycity_filter_add_thumb_sizes', array(
			'laundrycity-thumb-huge'		=> esc_html__( 'Fullsize image', 'laundrycity' ),
			'laundrycity-thumb-big'			=> esc_html__( 'Large image', 'laundrycity' ),
			'laundrycity-thumb-med'			=> esc_html__( 'Medium image', 'laundrycity' ),
			'laundrycity-thumb-tiny'		=> esc_html__( 'Small square avatar', 'laundrycity' ),
			'laundrycity-thumb-masonry-big'	=> esc_html__( 'Masonry Large (scaled)', 'laundrycity' ),
			'laundrycity-thumb-masonry'		=> esc_html__( 'Masonry (scaled)', 'laundrycity' ),
			)
		);
		$mult = laundrycity_get_theme_option('retina_ready', 1);
		foreach($thumb_sizes as $k=>$v) {
			$sizes[$k] = $v;
			if ($mult > 1) $sizes[$k.'-@retina'] = $v.' '.esc_html__('@2x', 'laundrycity' );
		}
		return $sizes;
	}
}


//-------------------------------------------------------
//-- Theme scripts and styles
//-------------------------------------------------------

// Load frontend scripts
if ( !function_exists( 'laundrycity_wp_scripts' ) ) {
	//Handler of the add_action('wp_enqueue_scripts', 'laundrycity_wp_scripts', 1000);
	function laundrycity_wp_scripts() {
		
		// Enqueue styles
		//------------------------
		
		// Links to selected fonts
		$links = laundrycity_theme_fonts_links();
		if (count($links) > 0) {
			foreach ($links as $slug => $link) {
				wp_enqueue_style( sprintf('laundrycity-font-%s', $slug), $link );
			}
		}
		
		// Fontello styles must be loaded before main stylesheet
		// This style NEED the theme prefix, because style 'fontello' in some plugin contain different set of characters
		// and can't be used instead this style!
		wp_enqueue_style( 'fontello-style',  laundrycity_get_file_url('css/fontello/css/fontello-embedded.css') );

		// Load main stylesheet
		$main_stylesheet = get_template_directory_uri() . '/style.css';
		wp_enqueue_style( 'laundrycity-main', $main_stylesheet, array(), null );

		// Load child stylesheet (if different) after the main stylesheet and fontello icons (important!)
		$child_stylesheet = get_stylesheet_directory_uri() . '/style.css';
		if ($child_stylesheet != $main_stylesheet) {
			wp_enqueue_style( 'laundrycity-child', $child_stylesheet, array('laundrycity-main'), null );
		}

		// Add custom bg image for the body_style == 'boxed'
		if ( laundrycity_get_theme_option('body_style') == 'boxed' && ($bg_image = laundrycity_get_theme_option('boxed_bg_image')) != '' )
			wp_add_inline_style( 'laundrycity-main', '.body_style_boxed { background-image:url('.esc_url($bg_image).') }' );

		// Merged styles
		if ( laundrycity_is_off(laundrycity_get_theme_option('debug_mode')) )
			wp_enqueue_style( 'laundrycity-styles', laundrycity_get_file_url('css/__styles.css') );

		// Custom colors
		if ( !is_customize_preview() && !isset($_GET['color_scheme']) && laundrycity_is_off(laundrycity_get_theme_option('debug_mode')) )
			wp_enqueue_style( 'laundrycity-colors', laundrycity_get_file_url('css/__colors.css') );
		else
			wp_add_inline_style( 'laundrycity-main', laundrycity_customizer_get_css() );

		// Add post nav background
		laundrycity_add_bg_in_post_nav();

		// Disable loading JQuery UI CSS
		wp_deregister_style('jquery_ui');
		wp_deregister_style('date-picker-css');


		// Enqueue scripts	
		//------------------------
		
		// Modernizr will load in head before other scripts and styles
		if ( in_array(substr(laundrycity_get_theme_option('blog_style'), 0, 7), array('gallery', 'portfol', 'masonry')) )
			wp_enqueue_script( 'modernizr', laundrycity_get_file_url('js/theme.gallery/modernizr.min.js'), array(), null, false );

		// Superfish Menu
		// Attention! To prevent duplicate this script in the plugin and in the menu, don't merge it!
		wp_enqueue_script( 'superfish', laundrycity_get_file_url('js/superfish.js'), array('jquery'), null, true );
		
		// Merged scripts
		if ( laundrycity_is_off(laundrycity_get_theme_option('debug_mode')) )
			wp_enqueue_script( 'laundrycity-init', laundrycity_get_file_url('js/__scripts.js'), array('jquery'), null, true );
		else {
			// Skip link focus
			wp_enqueue_script( 'skip-link-focus-fix', laundrycity_get_file_url('js/skip-link-focus-fix.js'), null, true );
			// Background video
			$header_video = laundrycity_get_header_video();
			if (!empty($header_video) && !laundrycity_is_inherit($header_video))
				wp_enqueue_script( 'bideo', laundrycity_get_file_url('js/bideo.js'), array(), null, true );
			// Theme scripts
			wp_enqueue_script( 'laundrycity-utils', laundrycity_get_file_url('js/_utils.js'), array('jquery'), null, true );
			wp_enqueue_script( 'laundrycity-init', laundrycity_get_file_url('js/_init.js'), array('jquery'), null, true );	
		}
		
		// Comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

		// Media elements library	
		if (laundrycity_get_theme_setting('use_mediaelements')) {
			wp_enqueue_style ( 'mediaelement' );
			wp_enqueue_style ( 'wp-mediaelement' );
			wp_enqueue_script( 'mediaelement' );
			wp_enqueue_script( 'wp-mediaelement' );
		}
	}
}

// Add variables to the scripts in the frontend
if ( !function_exists( 'laundrycity_localize_scripts' ) ) {
	//Handler of the add_action('wp_footer', 'laundrycity_localize_scripts');
	function laundrycity_localize_scripts() {

		$video = laundrycity_get_header_video();

		wp_localize_script( 'laundrycity-init', 'LAUNDRYCITY_STORAGE', apply_filters( 'laundrycity_filter_localize_script', array(
			// AJAX parameters
			'ajax_url' => esc_url(admin_url('admin-ajax.php')),
			'ajax_nonce' => esc_attr(wp_create_nonce(admin_url('admin-ajax.php'))),
			
			// Site base url
			'site_url' => get_site_url(),
						
			// Site color scheme
			'site_scheme' => sprintf('scheme_%s', laundrycity_get_theme_option('color_scheme')),
			
			// User logged in
			'user_logged_in' => is_user_logged_in() ? true : false,
			
			// Window width to switch the site header to the mobile layout
			'mobile_layout_width' => 767,
						
			// Sidemenu options
			'menu_side_stretch' => laundrycity_get_theme_option('menu_side_stretch') > 0 ? true : false,
			'menu_side_icons' => laundrycity_get_theme_option('menu_side_icons') > 0 ? true : false,

			// Video background
			'background_video' => laundrycity_is_from_uploads($video) ? $video : '',

			// Video and Audio tag wrapper
			'use_mediaelements' => laundrycity_get_theme_setting('use_mediaelements') ? true : false,

			// Messages max length
			'message_maxlength'	=> intval(laundrycity_get_theme_setting('message_maxlength')),

			
			// Internal vars - do not change it!
			
			// Flag for review mechanism
			'admin_mode' => false,

			// E-mail mask
			'email_mask' => '^([a-zA-Z0-9_\\-]+\\.)*[a-zA-Z0-9_\\-]+@[a-z0-9_\\-]+(\\.[a-z0-9_\\-]+)*\\.[a-z]{2,6}$',
			
			// Strings for translation
			'strings' => array(
					'ajax_error'		=> esc_html__('Invalid server answer!', 'laundrycity'),
					'error_global'		=> esc_html__('Error data validation!', 'laundrycity'),
					'name_empty' 		=> esc_html__("The name can't be empty", 'laundrycity'),
					'name_long'			=> esc_html__('Too long name', 'laundrycity'),
					'email_empty'		=> esc_html__('Too short (or empty) email address', 'laundrycity'),
					'email_long'		=> esc_html__('Too long email address', 'laundrycity'),
					'email_not_valid'	=> esc_html__('Invalid email address', 'laundrycity'),
					'text_empty'		=> esc_html__("The message text can't be empty", 'laundrycity'),
					'text_long'			=> esc_html__('Too long message text', 'laundrycity')
					)
			))
		);
	}
}

// Load responsive styles (priority 2000 - load it after main styles and plugins custom styles)
if ( !function_exists( 'laundrycity_wp_scripts_responsive' ) ) {
	//Handler of the add_action('wp_enqueue_scripts', 'laundrycity_wp_scripts_responsive', 2000);
	function laundrycity_wp_scripts_responsive() {
		wp_enqueue_style( 'laundrycity-responsive', laundrycity_get_file_url('css/responsive.css') );
	}
}

//  Add meta tags and inline scripts in the header for frontend
if (!function_exists('laundrycity_wp_head')) {
	//Handler of the add_action('wp_head',	'laundrycity_wp_head', 1);
	function laundrycity_wp_head() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<meta name="format-detection" content="telephone=no">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php
	}
}

// Add theme specified classes to the body
if ( !function_exists('laundrycity_add_body_classes') ) {
	//Handler of the add_filter( 'body_class', 'laundrycity_add_body_classes' );
	function laundrycity_add_body_classes( $classes ) {
		$classes[] = 'body_tag';	// Need for the .scheme_self
		$classes[] = 'scheme_' . esc_attr(laundrycity_get_theme_option('color_scheme'));

		$blog_mode = laundrycity_storage_get('blog_mode');
		$classes[] = 'blog_mode_' . esc_attr($blog_mode);
		$classes[] = 'body_style_' . esc_attr(laundrycity_get_theme_option('body_style'));

		if (in_array($blog_mode, array('post', 'page'))) {
			$classes[] = 'is_single';
		} else {
			$classes[] = ' is_stream';
			$classes[] = 'blog_style_'.esc_attr(laundrycity_get_theme_option('blog_style'));
			if (laundrycity_storage_get('blog_template') > 0)
				$classes[] = 'blog_template';
		}
		
		if (laundrycity_sidebar_present()) {
			$classes[] = 'sidebar_show sidebar_' . esc_attr(laundrycity_get_theme_option('sidebar_position')) ;
		} else {
			$classes[] = 'sidebar_hide';
			if (laundrycity_is_on(laundrycity_get_theme_option('expand_content')))
				 $classes[] = 'expand_content';
		}
		
		if (laundrycity_is_on(laundrycity_get_theme_option('remove_margins')))
			 $classes[] = 'remove_margins';

		$classes[] = 'header_style_' . esc_attr(laundrycity_get_theme_option("header_style"));
		$classes[] = 'header_position_' . esc_attr(laundrycity_get_theme_option("header_position"));

		$menu_style= laundrycity_get_theme_option("menu_style");
		$classes[] = 'menu_style_' . esc_attr($menu_style) . (in_array($menu_style, array('left', 'right'))	? ' menu_style_side' : '');
		$classes[] = 'no_layout';
		
		return $classes;
	}
}
	
// Load inline styles
if ( !function_exists( 'laundrycity_wp_footer' ) ) {
	//Handler of the add_action('wp_footer', 'laundrycity_wp_footer');
	//and add_action('admin_footer', 'laundrycity_wp_footer');
	function laundrycity_wp_footer() {
		// Get inline styles from storage
		if (($css = laundrycity_storage_get('inline_styles')) != '') {
			wp_enqueue_style(  'laundrycity-inline-styles',  laundrycity_get_file_url('css/__inline.css') );
			wp_add_inline_style( 'laundrycity-inline-styles', $css );
		}
	}
}


//-------------------------------------------------------
//-- Sidebars and widgets
//-------------------------------------------------------

// Register widgetized areas
if ( !function_exists('laundrycity_register_sidebars') ) {
	// Handler of the add_action('widgets_init', 'laundrycity_register_sidebars');
	function laundrycity_register_sidebars() {
		$sidebars = laundrycity_get_sidebars();
		if (is_array($sidebars) && count($sidebars) > 0) {
			foreach ($sidebars as $id=>$sb) {
				register_sidebar( array(
										'name'          => $sb['name'],
										'description'   => $sb['description'],
										'id'            => $id,
										'before_widget' => '<aside id="%1$s" class="widget %2$s">',
										'after_widget'  => '</aside>',
										'before_title'  => '<h5 class="widget_title">',
										'after_title'   => '</h5>'
										)
								);
			}
		}
	}
}

// Return theme specific widgetized areas
if ( !function_exists('laundrycity_get_sidebars') ) {
	function laundrycity_get_sidebars() {
		$list = apply_filters('laundrycity_filter_list_sidebars', array(
			'sidebar_widgets'		=> array(
											'name' => esc_html__('Sidebar Widgets', 'laundrycity'),
											'description' => esc_html__('Widgets to be shown on the main sidebar', 'laundrycity')
											),
			'header_widgets'		=> array(
											'name' => esc_html__('Header Widgets', 'laundrycity'),
											'description' => esc_html__('Widgets to be shown at the top of the page (in the page header area)', 'laundrycity')
											),
			'above_page_widgets'	=> array(
											'name' => esc_html__('Above Page Widgets', 'laundrycity'),
											'description' => esc_html__('Widgets to be shown below the header, but above the content and sidebar', 'laundrycity')
											),
			'above_content_widgets' => array(
											'name' => esc_html__('Above Content Widgets', 'laundrycity'),
											'description' => esc_html__('Widgets to be shown above the content, near the sidebar', 'laundrycity')
											),
			'below_content_widgets' => array(
											'name' => esc_html__('Below Content Widgets', 'laundrycity'),
											'description' => esc_html__('Widgets to be shown below the content, near the sidebar', 'laundrycity')
											),
			'below_page_widgets' 	=> array(
											'name' => esc_html__('Below Page Widgets', 'laundrycity'),
											'description' => esc_html__('Widgets to be shown below the content and sidebar, but above the footer', 'laundrycity')
											),
			'footer_widgets'		=> array(
											'name' => esc_html__('Footer Widgets', 'laundrycity'),
											'description' => esc_html__('Widgets to be shown at the bottom of the page (in the page footer area)', 'laundrycity')
											)
			)
		);
		return $list;
	}
}


//-------------------------------------------------------
//-- Theme fonts
//-------------------------------------------------------

// Return links for all theme fonts
if ( !function_exists('laundrycity_theme_fonts_links') ) {
	function laundrycity_theme_fonts_links() {
		$links = array();
		
		/*
		Translators: If there are characters in your language that are not supported
		by chosen font(s), translate this to 'off'. Do not translate into your own language.
		*/
		$google_fonts_enabled = ( 'off' !== esc_html_x( 'on', 'Google fonts: on or off', 'laundrycity' ) );
		$custom_fonts_enabled = ( 'off' !== esc_html_x( 'on', 'Custom fonts (included in the theme): on or off', 'laundrycity' ) );
		
		if ( ($google_fonts_enabled || $custom_fonts_enabled) && !laundrycity_storage_empty('load_fonts') ) {
			$load_fonts = laundrycity_storage_get('load_fonts');
			if (count($load_fonts) > 0) {
				$google_fonts = '';
				foreach ($load_fonts as $font) {
					$slug = laundrycity_get_load_fonts_slug($font['name']);
					$url  = laundrycity_get_file_url( sprintf('css/font-face/%s/stylesheet.css', $slug));
					if ($url != '') {
						if ($custom_fonts_enabled) {
							$links[$slug] = $url;
						}
					} else {
						if ($google_fonts_enabled) {
							$google_fonts .= ($google_fonts ? '|' : '') 
											. str_replace(' ', '+', $font['name'])
											. ':' 
											. (empty($font['styles']) ? '400,400italic,700,700italic' : $font['styles']);
						}
					}
				}
				if ($google_fonts && $google_fonts_enabled) {
					$links['google_fonts'] = sprintf('%s://fonts.googleapis.com/css?family=%s&subset=%s', laundrycity_get_protocol(), $google_fonts, laundrycity_get_theme_option('load_fonts_subset'));
				}
			}
		}
		return $links;
	}
}

// Return links for WP Editor
if ( !function_exists('laundrycity_theme_fonts_for_editor') ) {
	function laundrycity_theme_fonts_for_editor() {
		$links = array_values(laundrycity_theme_fonts_links());
		if (is_array($links) && count($links) > 0) {
			for ($i=0; $i<count($links); $i++) {
				$links[$i] = str_replace(',', '%2C', $links[$i]);
			}
		}
		return $links;
	}
}


//-------------------------------------------------------
//-- The Excerpt
//-------------------------------------------------------
if ( !function_exists('laundrycity_excerpt_length') ) {
	function laundrycity_excerpt_length( $length ) {
		return max(1, laundrycity_get_theme_setting('max_excerpt_length'));
	}
}

if ( !function_exists('laundrycity_excerpt_more') ) {
	function laundrycity_excerpt_more( $more ) {
		return '&hellip;';
	}
}


//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( !function_exists( 'laundrycity_importer_set_options' ) ) {
	//Handler of the add_filter( 'trx_addons_filter_importer_options',	'laundrycity_importer_set_options', 9 );
	function laundrycity_importer_set_options($options=array()) {
		if (is_array($options)) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Prepare demo data
			$options['demo_url'] = esc_url(laundrycity_get_protocol() . '://demofiles.axiomthemes.com/laundry/');
			// Required plugins
			$options['required_plugins'] = laundrycity_storage_get('required_plugins');
			// Default demo
			$options['files']['default']['title'] = esc_html__('Laundry City Demo', 'laundrycity');
			$options['files']['default']['domain_dev'] = 'https://laundry.axiomthemes.com';		// Developers domain
			$options['files']['default']['domain_demo']= 'https://laundry.axiomthemes.com';		// Demo-site domain
			// If theme need more demo - just copy 'default' and change required parameter
		}
		return $options;
	}
}


//-------------------------------------------------------
//-- Include theme (or child) PHP-files
//-------------------------------------------------------

require_once trailingslashit( get_template_directory() ) . 'includes/utils.php';
require_once trailingslashit( get_template_directory() ) . 'includes/storage.php';
require_once trailingslashit( get_template_directory() ) . 'includes/lists.php';
require_once trailingslashit( get_template_directory() ) . 'includes/wp.php';

if (is_admin()) {
	require_once trailingslashit( get_template_directory() ) . 'includes/tgmpa/class-tgm-plugin-activation.php';
	require_once trailingslashit( get_template_directory() ) . 'includes/admin.php';
}

require_once trailingslashit( get_template_directory() ) . 'theme-options/theme.customizer.php';

require_once trailingslashit( get_template_directory() ) . 'theme-specific/trx_addons.php';

require_once trailingslashit( get_template_directory() ) . 'includes/theme.tags.php';
require_once trailingslashit( get_template_directory() ) . 'includes/theme.hovers/theme.hovers.php';


// Plugins support
if (is_array($LAUNDRYCITY_STORAGE['required_plugins']) && count($LAUNDRYCITY_STORAGE['required_plugins']) > 0) {
	foreach ($LAUNDRYCITY_STORAGE['required_plugins'] as $plugin_slug) {
		$plugin_slug = laundrycity_esc($plugin_slug);
		$plugin_path = trailingslashit( get_template_directory() ) . sprintf('plugins/%s/%s.php', $plugin_slug, $plugin_slug);
		if (file_exists($plugin_path)) { require_once $plugin_path; }
	}
}

// Return template for the single field in the comments
if ( ! function_exists( 'laundrycity_single_comments_field' ) ) {
	function laundrycity_single_comments_field( $args ) {
		$path_height = 'path' == $args['form_style']
			? ( 'text' == $args['field_type'] ? 75 : 190 )
			: 0;
		$html = '<div class="comments_field comments_' . esc_attr( $args['field_name'] ) . '">'
			. ( 'default' == $args['form_style'] && 'checkbox' != $args['field_type']
				? '<label for="' . esc_attr( $args['field_name'] ) . '" class="' . esc_attr( $args['field_req'] ? 'required' : 'optional' ) . '">' . esc_html( $args['field_title'] ) . '</label>'
				: ''
			)
			. '<span class="sc_form_field_wrap">';
		if ( 'text' == $args['field_type'] ) {
			$html .= '<input id="' . esc_attr( $args['field_name'] ) . '" name="' . esc_attr( $args['field_name'] ) . '" type="text"' . ( 'default' == $args['form_style'] ? ' placeholder="' . esc_attr( $args['field_placeholder'] ) . ( $args['field_req'] ? ' *' : '' ) . '"' : '' ) . ' value="' . esc_attr( $args['field_value'] ) . '"' . ( $args['field_req'] ? ' aria-required="true"' : '' ) . ' />';
		} elseif ( 'checkbox' == $args['field_type'] ) {
			$html .= '<input id="' . esc_attr( $args['field_name'] ) . '" name="' . esc_attr( $args['field_name'] ) . '" type="checkbox" value="' . esc_attr( $args['field_value'] ) . '"' . ( $args['field_req'] ? ' aria-required="true"' : '' ) . ' />'
				. ' <label for="' . esc_attr( $args['field_name'] ) . '" class="' . esc_attr( $args['field_req'] ? 'required' : 'optional' ) . '">' . wp_kses_post( $args['field_title'] ) . '</label>';
		} else {
			$html .= '<textarea id="' . esc_attr( $args['field_name'] ) . '" name="' . esc_attr( $args['field_name'] ) . '"' . ( 'default' == $args['form_style'] ? ' placeholder="' . esc_attr( $args['field_placeholder'] ) . ( $args['field_req'] ? ' *' : '' ) . '"' : '' ) . ( $args['field_req'] ? ' aria-required="true"' : '' ) . '></textarea>';
		}
		if ( 'default' != $args['form_style'] ) {
			$html .= '<span class="sc_form_field_hover">'
				. ( 'path' == $args['form_style']
					? '<svg class="sc_form_field_graphic" preserveAspectRatio="none" viewBox="0 0 520 ' . intval( $path_height ) . '" height="100%" width="100%"><path d="m0,0l520,0l0,' . intval( $path_height ) . 'l-520,0l0,-' . intval( $path_height ) . 'z"></svg>'
					: ''
				)
				. ( 'iconed' == $args['form_style']
					? '<i class="sc_form_field_icon ' . esc_attr( $args['field_icon'] ) . '"></i>'
					: ''
				)
				. '<span class="sc_form_field_content" data-content="' . esc_attr( $args['field_title'] ) . '">' . wp_kses_post( $args['field_title'] ) . '</span>'
				. '</span>';
		}
		$html .= '</span></div>';
		return $html;
	}
}

?>