<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

$laundrycity_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$laundrycity_post_format = get_post_format();
$laundrycity_post_format = empty($laundrycity_post_format) ? 'standard' : str_replace('post-format-', '', $laundrycity_post_format);
$laundrycity_animation = laundrycity_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($laundrycity_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($laundrycity_post_format) ); ?>
	<?php echo (!laundrycity_is_off($laundrycity_animation) ? ' data-animation="'.esc_attr(laundrycity_get_animation_classes($laundrycity_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	laundrycity_show_post_featured(array(
		'thumb_size' => laundrycity_get_thumb_size($laundrycity_columns==1 ? 'big' : ($laundrycity_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			laundrycity_show_post_meta();
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>