<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

$laundrycity_blog_style = explode('_', laundrycity_get_theme_option('blog_style'));
$laundrycity_columns = empty($laundrycity_blog_style[1]) ? 2 : max(2, $laundrycity_blog_style[1]);
$laundrycity_post_format = get_post_format();
$laundrycity_post_format = empty($laundrycity_post_format) ? 'standard' : str_replace('post-format-', '', $laundrycity_post_format);
$laundrycity_animation = laundrycity_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($laundrycity_columns).' post_format_'.esc_attr($laundrycity_post_format) ); ?>
	<?php echo (!laundrycity_is_off($laundrycity_animation) ? ' data-animation="'.esc_attr(laundrycity_get_animation_classes($laundrycity_animation)).'"' : ''); ?>
	>

	<?php
	$laundrycity_image_hover = laundrycity_get_theme_option('image_hover');
	// Featured image
	laundrycity_show_post_featured(array(
		'thumb_size' => laundrycity_get_thumb_size(strpos(laundrycity_get_theme_option('body_style'), 'full')!==false || $laundrycity_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $laundrycity_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $laundrycity_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>