<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

$laundrycity_blog_style = explode('_', laundrycity_get_theme_option('blog_style'));
$laundrycity_columns = empty($laundrycity_blog_style[1]) ? 2 : max(2, $laundrycity_blog_style[1]);
$laundrycity_post_format = get_post_format();
$laundrycity_post_format = empty($laundrycity_post_format) ? 'standard' : str_replace('post-format-', '', $laundrycity_post_format);
$laundrycity_animation = laundrycity_get_theme_option('blog_animation');
$laundrycity_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($laundrycity_columns).' post_format_'.esc_attr($laundrycity_post_format) ); ?>
	<?php echo (!laundrycity_is_off($laundrycity_animation) ? ' data-animation="'.esc_attr(laundrycity_get_animation_classes($laundrycity_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($laundrycity_image[1]) && !empty($laundrycity_image[2])) echo intval($laundrycity_image[1]) .'x' . intval($laundrycity_image[2]); ?>"
	data-src="<?php if (!empty($laundrycity_image[0])) echo esc_url($laundrycity_image[0]); ?>"
	>

	<?php
	$laundrycity_image_hover = 'icon';
	if (in_array($laundrycity_image_hover, array('icons', 'zoom'))) $laundrycity_image_hover = 'dots';
	// Featured image
	laundrycity_show_post_featured(array(
		'hover' => $laundrycity_image_hover,
		'thumb_size' => laundrycity_get_thumb_size( strpos(laundrycity_get_theme_option('body_style'), 'full')!==false || $laundrycity_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. laundrycity_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => false,
									'seo' => false,
									'share' => true,
									'counters' => 'comments',
									'echo' => false
									))
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'laundrycity') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>