<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

$laundrycity_post_format = get_post_format();
$laundrycity_post_format = empty($laundrycity_post_format) ? 'standard' : str_replace('post-format-', '', $laundrycity_post_format);
$laundrycity_full_content = laundrycity_get_theme_option('blog_content') != 'excerpt' || in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote'));
$laundrycity_animation = laundrycity_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($laundrycity_post_format) ); ?>
	<?php echo (!laundrycity_is_off($laundrycity_animation) ? ' data-animation="'.esc_attr(laundrycity_get_animation_classes($laundrycity_animation)).'"' : ''); ?>
	><?php

	// Featured image
	laundrycity_show_post_featured(array( 'thumb_size' => laundrycity_get_thumb_size( strpos(laundrycity_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));

	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php
			do_action('laundrycity_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

			do_action('laundrycity_action_before_post_meta'); 

			// Post meta
			laundrycity_show_post_meta(array(
				'categories' => true,
				'date' => true,
				'edit' => true,
				'seo' => false,
				'share' => false,
				'counters' => 'comments'	//comments,likes,views - comma separated in any combination
				)
			);
			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if ($laundrycity_full_content) {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'laundrycity' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'laundrycity' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$laundrycity_show_learn_more = !in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote'))) {
					the_content();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
			// More button
			if ( $laundrycity_show_learn_more ) {
				?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><span><?php esc_html_e('View more', 'laundrycity'); ?></span></a></p><?php
			}

		}
	?></div><!-- .entry-content -->
</article>